/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.lang.Application;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.util.logging.FilePublisherSettings;
import com.kumbasoft.core.util.logging.StreamPublisher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class FilePublisher
extends StreamPublisher<FilePublisherSettings, FileOutputStream> {
    private Object THREAD_LOCK = new Object();
    private FileOutputStreamHelper fout;
    private File currentFile;

    private void createDefaultSettings() {
        FilePublisherSettings filePublisherSettings = new FilePublisherSettings();
        filePublisherSettings.setMaximumSize(1024000);
        filePublisherSettings.setDirectoryName("./logs/");
        this.setPublisherSettings(filePublisherSettings);
        File file = new File(this.getCurrentFileName());
        file.getParentFile().mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String message) {
        Logger logger = Application.getApplication().getApplicationLogger();
        if (this.publisherSettings == null) {
            if (logger != null) {
                logger.finer("(message): Creating default settings.");
            }
            this.createDefaultSettings();
        }
        String currentFileName = this.currentFile == null ? "" : this.currentFile.getAbsolutePath();
        boolean currentFileExists = this.currentFile == null ? false : this.currentFile.exists();
        long currentFileLength = this.currentFile == null ? 0L : this.currentFile.length();
        long maximumSize = ((FilePublisherSettings)this.publisherSettings).getMaximumSize();
        if (logger != null) {
            logger.finer(() -> LMG.log("(message): Log File '%s' exists? %b, It's length is: %d, The max size is %d", () -> currentFileName, () -> currentFileExists, () -> currentFileLength, () -> maximumSize));
        }
        Object object = this.THREAD_LOCK;
        synchronized (object) {
            if (this.fout != null && currentFileExists && currentFileLength >= maximumSize) {
                if (logger != null) {
                    logger.finer(() -> LMG.log("(message): Closing Log File '%s'. It's length %d exceeds the max size of %d", () -> currentFileName, () -> currentFileLength, () -> maximumSize));
                }
                this.fout.close();
                this.fout = null;
            }
            if (this.fout == null) {
                String directoryName = ((FilePublisherSettings)this.publisherSettings).getDirectoryName();
                String nextFileName = this.getCurrentFileName();
                this.currentFile = new File(directoryName, nextFileName);
                if (logger != null) {
                    logger.finer(() -> LMG.log("(message): Opening file '%s'.", () -> this.currentFile.getAbsolutePath()));
                }
                this.fout = new FileOutputStreamHelper(this.currentFile);
                OutputStream stream = this.fout.open();
                if (stream == null) {
                    IOException e = this.fout.getException();
                    e.printStackTrace();
                }
            }
            try {
                if (logger != null) {
                    logger.finer("(message): Writing message.");
                }
                ((OutputStream)this.fout.getStream()).write(message.getBytes());
                this.fout.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getCurrentFileName() {
        long currentTime = System.currentTimeMillis();
        String fileName = String.format("Audit-%d.log", currentTime);
        return fileName;
    }
}

