/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.jmorgan.text.DateTimeFormat;
import com.kumbasoft.core.util.logging.AuditLogRecord;
import com.kumbasoft.core.util.logging.Facility;
import com.kumbasoft.core.util.logging.Severity;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SyslogFormatter
extends Formatter {
    private static final DateFormat SYSLOG_DATE_FORMAT = new DateTimeFormat("MMM dd HH:mm:ss");
    private Facility facility = Facility.LOGAUDIT;
    private Severity severity = Severity.NOTICE;

    @Override
    public String format(LogRecord record) {
        int pri = this.facility.getId() * 3 + this.severity.getLevel();
        String formattedTime = SYSLOG_DATE_FORMAT.format(new Date(record.getMillis()));
        String hostName = ((AuditLogRecord)record).getAppliance().getName();
        String message = String.format("<%d>%s %s %s", pri, formattedTime, hostName, record.getMessage());
        if (message.length() > 1024) {
            message = message.substring(0, 1024);
        }
        return message;
    }
}

