/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.jmorgan.beans.JMBean;
import com.jmorgan.text.DateTimeFormat;
import com.kumbasoft.core.util.logging.Facility;
import com.kumbasoft.core.util.logging.Severity;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;

public class SyslogRecord
extends JMBean {
    private static final DateFormat SYSLOG_DATE_FORMAT = new DateTimeFormat("MMM dd HH:mm:ss");
    private Facility facility;
    private Severity severity;
    private long timeStamp;
    private String hostName;
    private String message;

    public SyslogRecord() {
    }

    public SyslogRecord(Facility facility, Level severity, long timeStamp, String hostName, String message) {
        this.setFacility(facility);
        this.setSeverity(severity);
        this.setTimeStamp(timeStamp);
        this.setHostName(hostName);
        this.setMessage(message);
    }

    public SyslogRecord(Facility facility, Severity severity, long timeStamp, String hostName, String message) {
        this.setFacility(facility);
        this.setSeverity(severity);
        this.setTimeStamp(timeStamp);
        this.setHostName(hostName);
        this.setMessage(message);
    }

    public String getSyslogMessage() {
        int pri = this.facility.getId() * 3 + this.severity.getLevel();
        String formattedTime = SYSLOG_DATE_FORMAT.format(new Date(this.timeStamp));
        String message = String.format("<%d>%s %s %s", pri, formattedTime, this.hostName, this.message);
        if (message.length() > 1024) {
            message = message.substring(0, 1024);
        }
        return message;
    }

    public Facility getFacility() {
        return this.facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Level javaLogLevel) {
        switch (javaLogLevel.intValue()) {
            case 1000: {
                this.severity = Severity.ALERT;
                break;
            }
            case 900: {
                this.severity = Severity.CRITICAL;
                break;
            }
            case 800: {
                this.severity = Severity.ERROR;
                break;
            }
            case 700: {
                this.severity = Severity.WARNING;
                break;
            }
            case 500: {
                this.severity = Severity.NOTICE;
                break;
            }
            case 400: {
                this.severity = Severity.INFO;
                break;
            }
            case 300: {
                this.severity = Severity.DEBUG;
            }
        }
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int compareTo(SyslogRecord that) {
        return this.compareTo(that, "timestamp", "hostName", "facility", "severity", "message");
    }

    public boolean equals(Object that) {
        return this.equals(that, "timestamp", "hostName", "facility", "severity", "message");
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.timeStamp, this.hostName, this.facility, this.severity, this.message});
    }

    @Override
    public String toString() {
        return this.toString("timestamp", "hostName", "facility", "severity", "message");
    }
}

