/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.kumbasoft.core.util.logging.AbstractSocketSender;
import com.kumbasoft.core.util.logging.SyslogRecord;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;

class TcpSender
extends AbstractSocketSender {
    private Socket socket;
    private OutputStream os;

    public TcpSender(String hostName, int port, BlockingQueue<SyslogRecord> blockingQueue) {
        super(hostName, port, blockingQueue);
    }

    @Override
    protected boolean initialize() {
        try {
            if (this.os == null) {
                this.socket = new Socket(this.hostName, this.port);
                this.os = this.socket.getOutputStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void sendMessage(SyslogRecord record) throws IOException, Throwable {
        String syslogMessage = record.getSyslogMessage();
        this.os.write(syslogMessage.getBytes(), 0, syslogMessage.length());
        this.os.write(10);
    }

    @Override
    protected void cleanup() {
        try {
            if (this.socket != null) {
                this.os.flush();
                this.os.close();
                this.socket.close();
            }
        }
        catch (Throwable t) {
            this.socket = null;
        }
    }
}

