/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.security;

import com.jmorgan.beans.JMBean;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.lang.StackTrace;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Pair;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.PrincipalInformation;
import com.kumbasoft.core.util.security.LicenseManager;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;

public class LicenseInformation
extends JMBean {
    private CertificateInformation license;
    private PrincipalInformation subjectInfo;

    public LicenseInformation() {
        this(LicenseManager.LICENSE);
    }

    public LicenseInformation(X509Certificate certificate) {
        this.license = new CertificateInformation(null, null, null, certificate);
        this.subjectInfo = this.license.getSubjectPrincipal();
    }

    public String getEntitlements() {
        return this.getMarkedOU("ae:");
    }

    public boolean isEntitledTo(String appName) {
        String entitlements = this.getEntitlements();
        return entitlements.contains(appName);
    }

    public String getEntitlementType() {
        return "EE";
    }

    public int getCommunityEditionValidityPeriod() {
        String cevp = this.getMarkedOU("cevp:");
        return Integer.parseInt(cevp);
    }

    public int getVersionToken() {
        return Integer.parseInt(this.getMarkedOU("vk:"));
    }

    public String getLicenseKey() {
        return this.getMarkedOU("license:");
    }

    public String getPasswordSalt() {
        return this.getMarkedOU("pws:");
    }

    private String getMarkedOU(String mark) {
        ArrayList<String> orgUnits = this.subjectInfo.getOrganizationalUnits();
        for (String orgUnit : orgUnits) {
            if (!orgUnit.startsWith(mark)) continue;
            return orgUnit.substring(mark.length());
        }
        return null;
    }

    public String getCN() {
        return this.subjectInfo.getCommonName();
    }

    public String getOrganization() {
        return this.subjectInfo.getOrganization();
    }

    public String getCountry() {
        return this.subjectInfo.getCountry();
    }

    public String getLocality() {
        return this.subjectInfo.getLocality();
    }

    public String getState() {
        return this.subjectInfo.getState();
    }

    public String getUserID() {
        String userID = "";
        ArrayList<Pair<String, String>> otherProperties = this.subjectInfo.getOtherProperties();
        for (Pair<String, String> otherProperty : otherProperties) {
            if (!((String)otherProperty.first).equals("UID")) continue;
            userID = (String)otherProperty.second;
            break;
        }
        return userID;
    }

    public DateTime getNotBefore() {
        return this.license.getNotBefore();
    }

    public DateTime getNotAfter() {
        return this.license.getNotAfter();
    }

    public String getLicenseForEmail() {
        String encoded = null;
        try {
            ASCFileReader fileReader = new ASCFileReader("./configs/License.txt");
            encoded = fileReader.readAll();
        }
        catch (IOException e) {
            String error = StackTrace.getStackTrace(e);
            byte[] base64Encoded = Base64.getEncoder().encode(error.getBytes());
            encoded = new String(base64Encoded);
        }
        return encoded;
    }

    public String getLicenseHTML() {
        DateTime notBefore = this.license.getNotBefore();
        DateTime notAfter = this.license.getNotAfter();
        String licenseKey = this.getLicenseKey();
        String organization = this.subjectInfo.getOrganization();
        String country = this.subjectInfo.getCountry();
        String city = this.subjectInfo.getLocality();
        String state = this.subjectInfo.getState();
        String postal = "";
        ArrayList<String> orgUnits = this.subjectInfo.getOrganizationalUnits();
        for (String ou : orgUnits) {
            if (!ou.matches("\\d\\d\\d\\d\\d.*")) continue;
            postal = ou;
            break;
        }
        String userID = this.getUserID();
        String licenseTag = String.format("<p class=\"small\">License: %s<br/>Issued to: %s @ %s<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;%s, %s %s - %s<br/>Issued: %s<br/>Good until: %s</p><br/>", licenseKey, userID, organization, city, state, postal, country, notBefore.toString(), notAfter.toString());
        return licenseTag;
    }
}

