/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.AttributeChangeListener;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.event.ChangeEventInvoker;
import com.jmorgan.swing.menu.EditMenu;
import com.jmorgan.swing.menu.EditMenuBar;
import com.jmorgan.swing.menu.FileMenu;
import com.jmorgan.swing.menu.HelpMenu;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.MenuItemProperties;
import com.jmorgan.swing.menu.OptionsMenu;
import com.jmorgan.swing.menu.SearchMenu;
import com.jmorgan.swing.menu.WindowMenu;
import com.jmorgan.swing.tabbedpane.TabPlacementDNDController;
import com.jmorgan.swing.util.GUIServices;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.ui.KumbaCoreFrame;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.preferences.PreferencesPane;
import com.kumbasoft.core.ui.panel.logs.DisplayLogPanel;
import com.kumbasoft.dpaa.app.DPAAApplicationParameters;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import com.kumbasoft.dpaa.ui.dialogs.DPAALogsDialog;
import com.kumbasoft.dpaa.ui.dialogs.initWizard.InitWizardFinalPage;
import com.kumbasoft.dpaa.ui.dialogs.initWizard.InitWizardPreferencesPage;
import com.kumbasoft.dpaa.ui.dialogs.wizards.StandardWizardWelcomePage;
import com.kumbasoft.dpaa.ui.panels.AdministrationPanel;
import com.kumbasoft.dpaa.ui.panels.Testing.TestingPanel;
import com.kumbasoft.dpaa.ui.panels.configurations.ConfigurationsPanel;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageCertificatesPanel;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageIPPanel;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageObjectsPanel;
import com.kumbasoft.dpaa.ui.panels.files.CleanupFilesPanel;
import com.kumbasoft.dpaa.ui.panels.files.FileUploadPanel;
import com.kumbasoft.dpaa.ui.panels.files.ManageFilesPanel;
import com.kumbasoft.dpaa.ui.panels.status.DataPowerStatusProviderListPanel;
import com.kumbasoft.dpaa.ui.panels.systemControl.SystemControlPanel;
import com.kumbasoft.dpaa.ui.panels.troubleshooting.TroubleShootingPanel;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class DPAAFrame
extends KumbaCoreFrame
implements AttributeChangeListener {
    public DPAAFrame() {
        super("Kumba Software LLC - DPAA\u00ae");
        GUIApplication.getGUIApplication().addAttributeChangeListener(this);
        GUIServices.maximizeWindow(this);
    }

    @Override
    public Container buildGUI() {
        Container mainPanel = super.buildGUI();
        mainPanel.add((Component)this.getApplianceDomainListPanel(), "West");
        mainPanel.add((Component)this.getTabbedPane(), "Center");
        return mainPanel;
    }

    @Override
    public JMenuBar buildMenuBar() {
        EditMenuBar editMenuBar = new EditMenuBar();
        EditMenu editMenu = editMenuBar.getEditMenu();
        JMMenuItem undoMenuItem = editMenu.getEditUndo();
        editMenu.remove(undoMenuItem);
        JMMenuItem redoMenuItem = editMenu.getEditRedo();
        editMenu.remove(redoMenuItem);
        JMMenuItem cutMenuItem = editMenu.getEditCut();
        editMenu.remove(cutMenuItem);
        MenuItemProperties moveMenuItem = new MenuItemProperties("&Move", KumbaCoreUIConstants.MOVE_ICON, 145, KeyStroke.getKeyStroke(77, 128));
        JMMenuItem moveMenu = new JMMenuItem(moveMenuItem);
        moveMenu.setToolTipText("Move");
        editMenu.add((Component)moveMenu, 2);
        editMenu.add(new JSeparator());
        MenuItemProperties changeCredsMenuItem = new MenuItemProperties("Change Credentials", (ImageIcon)KumbaCoreUIConstants.CHANGECREDS_ICON, 88000);
        JMMenuItem changeCredsMenu = new JMMenuItem(changeCredsMenuItem);
        changeCredsMenu.setToolTipText("Change DPAA\u00ae Credentials");
        editMenu.add(changeCredsMenu);
        MenuItemProperties preferencesMenuItem = new MenuItemProperties("Preferences...", null, 146);
        editMenu.add(new JSeparator());
        editMenu.add(new JMMenuItem(preferencesMenuItem));
        SearchMenu searchMenu = editMenuBar.getSearchMenu();
        JMMenuItem replaceMenuItem = searchMenu.getSearchReplace();
        searchMenu.remove(replaceMenuItem);
        searchMenu.addSeparator();
        MenuItemProperties searchFilterItem = new MenuItemProperties("Fil&ters", KumbaCoreUIConstants.FILTER_ICON, 45, KeyStroke.getKeyStroke(84, 128));
        JMMenuItem filtersMenu = new JMMenuItem(searchFilterItem);
        filtersMenu.setToolTipText("Filter");
        searchMenu.add(filtersMenu);
        OptionsMenu optionsMenu = editMenuBar.getOptionsMenu();
        WindowMenu windowMenu = editMenuBar.getWindowMenu();
        editMenuBar.remove(optionsMenu);
        editMenuBar.remove(windowMenu);
        FileMenu fileMenuBar = editMenuBar.getFileMenu();
        MenuItemProperties runMenuItem = new MenuItemProperties("&Run", KumbaCoreUIConstants.RUN_ICON, 55, KeyStroke.getKeyStroke(82, 128));
        JMMenuItem runMenu = new JMMenuItem(runMenuItem);
        runMenu.setToolTipText("Run");
        MenuItemProperties importMenuItem = new MenuItemProperties("&Import", KumbaCoreUIConstants.IMPORT_ICON, 56, KeyStroke.getKeyStroke(73, 128));
        JMMenuItem importMenu = new JMMenuItem(importMenuItem);
        importMenu.setToolTipText("Import");
        MenuItemProperties uploadMenuItem = new MenuItemProperties("&Upload", KumbaCoreUIConstants.UPLOAD_ICON, 57, KeyStroke.getKeyStroke(85, 128));
        JMMenuItem uploadMenu = new JMMenuItem(uploadMenuItem);
        uploadMenu.setToolTipText("Upload");
        fileMenuBar.add((Component)runMenu, 6);
        fileMenuBar.add((Component)new JSeparator(0), 6);
        fileMenuBar.add((Component)uploadMenu, 8);
        fileMenuBar.add((Component)importMenu, 8);
        fileMenuBar.add((Component)new JSeparator(0), 8);
        HelpMenu helpMenu = editMenuBar.getHelpMenu();
        MenuItemProperties licenseMenuItem = new MenuItemProperties("&License Info", KumbaCoreUIConstants.LICENSE_ICON, 89000, KeyStroke.getKeyStroke(76, 128));
        JMMenuItem licenseMenu = new JMMenuItem(licenseMenuItem);
        licenseMenu.setToolTipText("View DPAA\u00ae License");
        MenuItemProperties dpaaLogsItem = new MenuItemProperties("&DPAA\u00ae Logs", KumbaCoreUIConstants.LOGS_ICON, 89010, KeyStroke.getKeyStroke(68, 128));
        JMMenuItem logsMenu = new JMMenuItem(dpaaLogsItem);
        logsMenu.setToolTipText("View  DPAA\u00ae Logs");
        helpMenu.add((Component)licenseMenu, -1);
        helpMenu.add((Component)logsMenu, -1);
        return editMenuBar;
    }

    @Reflected
    private void editPreferences() {
        Logger logger = Application.getApplication().getApplicationLogger();
        logger.finer("(): Starting");
        PreferencesPane preferencesPane = new PreferencesPane(this);
        logger.finer("(): Created preferences pane.  Opening in dialog.");
        GenericDialog preferencesDialog = new GenericDialog(preferencesPane);
        preferencesDialog.setSize(985, 600);
        preferencesDialog.setVisible(true);
        logger.finer("(): Done");
    }

    @Reflected
    private void helpDPAALogs() {
        new DPAALogsDialog(this);
    }

    private JMTabbedPane getTabbedPane() {
        JMTabbedPane tabbedPane = new JMTabbedPane();
        tabbedPane.setTabLayoutPolicy(1);
        tabbedPane.addTab("Find", this.getFindPane());
        tabbedPane.addTab("Status", DPAAFrame.getStatusMenu());
        tabbedPane.addTab("Logs", new DisplayLogPanel());
        tabbedPane.addTab("Configurations", new ConfigurationsPanel());
        tabbedPane.addTab("Files", this.getFileManagementPane());
        tabbedPane.addTab("Administration", new AdministrationPanel());
        tabbedPane.addTab("Troubleshooting", new TroubleShootingPanel());
        tabbedPane.addTab("System Control", new SystemControlPanel());
        DPAAApplicationParameters parameters = (DPAAApplicationParameters)Application.getApplication().getApplicationParametersBean();
        if (parameters.isTestingMode()) {
            tabbedPane.addTab("Testing", new TestingPanel());
        }
        new ChangeEventInvoker(tabbedPane, this.getStatusBar(), "setMessage", "");
        new TabPlacementDNDController(tabbedPane);
        return tabbedPane;
    }

    private JMTabbedPane getFindPane() {
        JMTabbedPane findTabs = new JMTabbedPane(2);
        findTabs.setTabLayoutPolicy(1);
        findTabs.addTab("Objects", new ManageObjectsPanel());
        findTabs.addTab("Certificates", new ManageCertificatesPanel());
        findTabs.addTab("IPs", new ManageIPPanel());
        new ChangeEventInvoker(findTabs, this.getStatusBar(), "setMessage", "");
        new TabPlacementDNDController(findTabs);
        return findTabs;
    }

    private static DataPowerStatusProviderListPanel getStatusMenu() {
        DataPowerStatusProviderListPanel statusProviderContainer = new DataPowerStatusProviderListPanel();
        return statusProviderContainer;
    }

    private JMTabbedPane getFileManagementPane() {
        JMTabbedPane filesTabs = new JMTabbedPane(2);
        filesTabs.setTabLayoutPolicy(1);
        ManageFilesPanel manageFilesPanel = new ManageFilesPanel();
        filesTabs.addTab("Manage Files", manageFilesPanel);
        filesTabs.addTab("Upload Files", new FileUploadPanel(manageFilesPanel));
        filesTabs.addTab("Clean Up Files", new CleanupFilesPanel());
        new ChangeEventInvoker(filesTabs, this.getStatusBar(), "setMessage", "");
        new TabPlacementDNDController(filesTabs);
        return filesTabs;
    }

    @Override
    public void attributeAdded(Object key, Object value) {
        this.handleAttribute(key, value);
    }

    @Override
    public void attributeChanged(Object key, Object oldValue, Object newValue) {
        this.handleAttribute(key, newValue);
    }

    @Override
    public void attributeRemoved(Object key, Object value) {
        this.handleAttribute(key, value);
    }

    private void handleAttribute(Object key, Object value) {
        switch ((String)key) {
            case "Appliance Groups": {
                ArrayList applianceGroups = (ArrayList)value;
                this.applianceDomainListPanel.setApplianceGroups(applianceGroups);
                break;
            }
            case "Domain Groups": {
                new AsynchMethodInvoker((Object)this.applianceDomainListPanel, "applianceSelectionChanged", KumbaCoreConstants.THREAD_WAIT);
            }
        }
    }

    public void invokeInitializationWizard() {
        WizardDialog<DPAAApplicationProperties> initDialog = new WizardDialog<DPAAApplicationProperties>((JFrame)this, "Initialize DPAA\u00ae");
        DPAAApplicationProperties applicationProperties = (DPAAApplicationProperties)Application.getApplication().getApplicationProperties();
        initDialog.addWizardPage(new StandardWizardWelcomePage<DPAAApplicationProperties>(applicationProperties, "InitWizardWelcomePage", "InitWizardWelcomePage_centerControl"), "welcome");
        initDialog.addWizardPage(new InitWizardPreferencesPage(applicationProperties), "preferences");
        initDialog.addWizardPage(new InitWizardFinalPage(applicationProperties), "review");
        initDialog.setSize(850, 600);
        initDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            System.exit(-10);
        }
    }
}

