/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.components.lists;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.AttributeChangeListener;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.list.MappedListCellValueRenderer;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import java.awt.Component;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ListModel;

public class ConfigObjectListPanel
extends AbstractPanel
implements AttributeChangeListener {
    private static HashMap<String, String> configTypeDisplayMap;
    private static HashMap<String, String> displayToConfigTypeMap;
    private static boolean listModelCreated;
    private JMListModel<String> configObjectListModel = new JMListModel();
    private JMList<String> configObjectList;
    private JMListCellRenderer<String> configObjectListCellRenderer;

    public ConfigObjectListPanel() {
        GUIApplication.getGUIApplication().addAttributeChangeListener(this);
        this.configObjectList = new JMList<String>((ListModel<String>)this.configObjectListModel);
        String configTypeNameMapFile = ((DPAAApplicationProperties)Application.getApplication().getApplicationProperties()).getConfigNameMapFile();
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        configTypeDisplayMap = (HashMap)FileUtility.readObject(configTypeNameMapFile, (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            new JMMessageBox(null, "Failed to read configuration display map file.", "Error reading configuration type display map file.");
        }
        MappedListCellValueRenderer<String> listCellValueRenderer = new MappedListCellValueRenderer<String>(configTypeDisplayMap);
        this.configObjectListCellRenderer = new JMListCellRenderer(listCellValueRenderer);
        this.configObjectList.setCellRenderer(this.configObjectListCellRenderer);
        JMScrollPane scrollPanel = KumbaCoreUIConstants.createScrollPane(this.configObjectList);
        LabeledComponent listLabel = new LabeledComponent("Object Types:", (Component)scrollPanel, 1);
        this.add((Component)listLabel, "West");
        new AsynchMethodInvoker((Object)this, "createDisplayToConfigTypeMap");
    }

    @Reflected
    public void createDisplayToConfigTypeMap() {
        displayToConfigTypeMap = new HashMap(configTypeDisplayMap.size());
        for (String configType : configTypeDisplayMap.keySet()) {
            String displayValue = configTypeDisplayMap.get(configType);
            displayToConfigTypeMap.put(displayValue, configType);
        }
    }

    @Override
    public void updateUI() {
        if (this.configObjectListCellRenderer != null) {
            KumbaCoreUIConstants.setupRenderer(this.configObjectListCellRenderer);
        }
        super.updateUI();
    }

    public String getObjectTypeSearchPattern(boolean performUserChecks) {
        logger.finer("(): Starting");
        if (performUserChecks && !this.continueAction("Search", "search", true)) {
            return null;
        }
        String objectTypeExpression = null;
        if (this.isSelectionEmpty()) {
            if (performUserChecks && !this.continueAction("Search All Object Types?", "You didn't select any object types.  Do you want to continue?")) {
                return null;
            }
            objectTypeExpression = ".*";
        } else {
            objectTypeExpression = StringUtility.getRegexMatchExpression(this.getSelectedValuesList());
        }
        logger.finer("(): Done.  Returning.");
        return objectTypeExpression.toString();
    }

    public List<String> getAllValues() {
        return (ArrayList)this.configObjectListModel.getAll();
    }

    public boolean isSelectionEmpty() {
        return this.configObjectList.isSelectionEmpty();
    }

    public List<String> getSelectedValuesList() {
        List selectedValues = this.configObjectList.getSelectedValuesList();
        ArrayList<String> selectedTypes = new ArrayList<String>(selectedValues.size());
        for (String selectedValue : selectedValues) {
            String configType = displayToConfigTypeMap.get(selectedValue);
            selectedTypes.add(configType);
        }
        return selectedTypes;
    }

    public void addListSelectionInvocation(Object target, String methodName) {
        new ListSelectionEventInvoker(this.configObjectList, target, methodName);
    }

    private void loadObjectTypes() {
        AbstractPanel.logger.finer("(): Starting");
        if (listModelCreated) {
            AbstractPanel.logger.finer("(): List model already created.  Returning.");
            return;
        }
        listModelCreated = true;
        AbstractPanel.logger.finer("(): Getting config object names.");
        List<String> configTypeNames = ConfigurationManager.getConfigTypes();
        ArrayList<String> objectTypeDisplayValues = new ArrayList<String>(configTypeNames.size());
        for (String configTypeName : configTypeNames) {
            String objectTypeDisplayValue = configTypeDisplayMap.get(configTypeName);
            if (objectTypeDisplayValue == null) {
                objectTypeDisplayValue = StringUtility.capitalize(configTypeName);
            }
            String otdv = objectTypeDisplayValue;
            AbstractPanel.logger.finer(() -> LMG.log("(): Config type '%s' will display as '%s'.", () -> configTypeName, () -> otdv));
            objectTypeDisplayValues.add(objectTypeDisplayValue);
        }
        Collections.sort(objectTypeDisplayValues);
        AbstractPanel.logger.finer("(): Invoking add all.");
        new AsynchMethodInvoker(this.configObjectListModel, "addAll", objectTypeDisplayValues);
        AbstractPanel.logger.finer("(): Done");
    }

    @Override
    public void attributeAdded(Object key, Object value) {
        if (key.equals("Appliance Groups") && !listModelCreated) {
            this.loadObjectTypes();
        }
    }

    @Override
    public void attributeChanged(Object key, Object oldValue, Object newValue) {
    }

    @Override
    public void attributeRemoved(Object key, Object value) {
    }
}

