/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.util.WindowCloser;
import com.kumbasoft.core.beans.CertificateSearchFilter;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Component;
import javax.swing.JFrame;

public class CertificateSearchFiltersDialog
extends JMDialog {
    private static boolean wasCancelled;
    private CertificateSearchFilter certificateSearchFilter;
    private JMCheckBox cbxIgnoreErrorCertificates;
    private JMCheckBox cbxIgnoreExpirationDates;
    private JMCheckBox cbxIgnoreExpiredCertificates;
    private JMCheckBox cbxIncludeSharedCerts;
    private JMCheckBox cbxIncludePublicCerts;
    private JMCheckBox cbxSelfSignedOnly;
    private NumberField nfDaysToExpiry;
    private NumberSpinner nsDaysToExpiry;

    public static final boolean wasCancelled() {
        return wasCancelled;
    }

    public CertificateSearchFiltersDialog(JFrame owner, Object ... arguments) {
        super(owner, "Certificate Search Filters", true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        wasCancelled = false;
        this.certificateSearchFilter = (CertificateSearchFilter)arguments[0];
        JMPanel controlsPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        this.cbxIgnoreExpirationDates = new JMCheckBox("Ignore Expiration Dates", this.certificateSearchFilter.isIgnoreExpirationDates());
        new ItemEventInvoker(this.cbxIgnoreExpirationDates, this, "ignoreExpirationDatesClicked");
        this.cbxIgnoreExpiredCertificates = new JMCheckBox("Ignore Expired Certificates", this.certificateSearchFilter.isIgnoreExpiredCerts());
        this.cbxIgnoreErrorCertificates = new JMCheckBox("Ignore Certificates with Errors", this.certificateSearchFilter.isIgnoreErrorCerts());
        this.cbxIncludeSharedCerts = new JMCheckBox("Include Certificates Contained Within the sharedcert:// Directory", this.certificateSearchFilter.isIncludeSharedCerts());
        this.cbxIncludePublicCerts = new JMCheckBox("Include Certificates Contained Within the pubcert:// Directory", this.certificateSearchFilter.isIncludePublicCerts());
        this.cbxSelfSignedOnly = new JMCheckBox("Show Self-Signed Certificates Only", this.certificateSearchFilter.isSelfSignedOnly());
        this.nfDaysToExpiry = new NumberField((double)this.certificateSearchFilter.getDaysToExpiration());
        this.nfDaysToExpiry.setWidth(70);
        this.nsDaysToExpiry = new NumberSpinner(this.nfDaysToExpiry, 1.0, 0.0, 2.147483647E9);
        this.nsDaysToExpiry.setEnabled(!this.certificateSearchFilter.isIgnoreExpirationDates());
        LabeledComponent lc = new LabeledComponent("Only Show Certificates Expiring Within Designated Days: ", (Component)this.nsDaysToExpiry);
        JMPanel buttonPanel = new JMPanel();
        JMButton btnOK = ComponentFactory.createButton(null, "OK", "Set the certificate filters and close", true, this, "okClicked", new Object[0]);
        JMButton btnCancel = ComponentFactory.createButton(null, "Cancel", "Close the dialog without changing the certificate filters.", true, this, "cancelClicked", new Object[0]);
        buttonPanel.addAll(ComponentFactory.createSpacer(210, 10), btnOK, btnCancel);
        controlsPanel.addAll(this.cbxIgnoreExpirationDates, lc, this.cbxIgnoreExpiredCertificates, this.cbxIgnoreErrorCertificates, this.cbxIncludePublicCerts, this.cbxIncludeSharedCerts, this.cbxSelfSignedOnly, ComponentFactory.createSpacer(1, 20), buttonPanel);
        this.getContentPane().add(controlsPanel);
    }

    @Reflected
    private void ignoreExpirationDatesClicked() {
        this.nsDaysToExpiry.setEnabled(!this.cbxIgnoreExpirationDates.isSelected());
    }

    @Reflected
    private void okClicked() {
        this.certificateSearchFilter.setDaysToExpiration((int)this.nfDaysToExpiry.getNumber());
        this.certificateSearchFilter.setIgnoreErrorCerts(this.cbxIgnoreErrorCertificates.isSelected());
        this.certificateSearchFilter.setIgnoreExpirationDates(this.cbxIgnoreExpirationDates.isSelected());
        this.certificateSearchFilter.setIgnoreExpiredCerts(this.cbxIgnoreExpiredCertificates.isSelected());
        this.certificateSearchFilter.setIncludePublicCerts(this.cbxIncludePublicCerts.isSelected());
        this.certificateSearchFilter.setIncludeSharedCerts(this.cbxIncludeSharedCerts.isSelected());
        this.certificateSearchFilter.setSelfSignedOnly(this.cbxSelfSignedOnly.isSelected());
        WindowCloser.closeWindow(this, 0, false);
    }

    @Reflected
    private void cancelClicked() {
        wasCancelled = true;
        WindowCloser.closeWindow(this, 0, false);
    }
}

