/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.app.DPAA;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JScrollBar;

public class DPAALogsDialog
extends JMDialog {
    private static File logsDirectory;
    private static BeanComparator<File> logFileSorter;
    private static String lastDirectory;
    private JMButton btnRefresh = ComponentFactory.createButton(KumbaCoreUIConstants.REFRESH_ICON, null, "Refresh the logs", true, this, "readLogs", new Object[0]);
    private JMButton btnSaveAs = ComponentFactory.createButton(KumbaCoreUIConstants.SAVEAS_ICON, null, "Save the logs to send to KumbaSoft technical support", false, this, "fileSaveAs", new Object[0]);
    private JMTextArea taLogs;
    private JMScrollPane spLogs;

    static {
        DPAAApplicationProperties appProps = (DPAAApplicationProperties)DPAA.getApplication().getApplicationProperties();
        String logsDirectoryName = appProps.getLogsDirectory();
        logsDirectory = new File(logsDirectoryName);
        logFileSorter = new BeanComparator();
        logFileSorter.addCompareProperty("lastModified");
    }

    public DPAALogsDialog(JFrame owner) {
        super(owner, "DPAA Logs", false);
        JMPanel toolBar = new JMPanel(new FlowLayout(0));
        toolBar.addAll(this.btnRefresh, this.btnSaveAs);
        this.taLogs = new JMTextArea();
        this.getContentPane().add((Component)toolBar, "North");
        this.spLogs = new JMScrollPane(this.taLogs);
        this.getContentPane().add(this.spLogs);
        this.setSize(800, 600);
        GUIServices.centerWindow(this);
        new AsynchMethodInvoker((Object)this, "readLogs");
    }

    @Reflected
    private void readLogs() {
        File[] logFiles = logsDirectory.listFiles();
        Arrays.sort(logFiles, logFileSorter);
        this.taLogs.setText("");
        File[] fileArray = logFiles;
        int n = logFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File logFile = fileArray[n2];
            try {
                ASCFileReader reader = new ASCFileReader(logFile);
                String fileText = reader.readAll();
                if (!StringUtility.isEmpty(fileText)) {
                    this.taLogs.append(fileText);
                }
            }
            catch (IOException e) {
                Application.getApplication().getApplicationLogger().severe(String.format("Error reading log file %s", logFile.getName()));
            }
            ++n2;
        }
        JScrollBar vScrollBar = this.spLogs.getVerticalScrollBar();
        new AsynchMethodInvoker((Object)vScrollBar, "setValue", (Object)vScrollBar.getMaximum(), KumbaCoreConstants.THREAD_WAIT);
        this.btnSaveAs.setEnabled(!StringUtility.isEmpty(this.taLogs.getText()));
    }

    @Reflected
    private void fileSaveAs() {
        System.out.printf("DPAALogsDialog.fileSaveAs()\n", new Object[0]);
        File saveAsFile = GUIServices.fileSaveDialog(lastDirectory);
        if (saveAsFile == null) {
            return;
        }
        lastDirectory = saveAsFile.getParentFile().getAbsolutePath();
        String allLogs = this.taLogs.getText();
        try {
            new ASCFileWriter(saveAsFile, allLogs);
        }
        catch (IOException e) {
            Application.getApplication().getApplicationLogger().severe(String.format("Error writing log file %s", saveAsFile.getName()));
            e.printStackTrace();
        }
    }
}

