/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.BinaryFileReader;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.event.ContainerEventInvoker;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.util.ScrollSynchronizer;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.files.FileEditorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class DataPowerFileDialog
extends JMDialog
implements DocumentListener,
FocusListener,
CaretListener {
    private static Logger logger;
    private static final String[] IMAGE_EXTENSIONS;
    private boolean addingFile = false;
    private boolean internalChanging = false;
    private boolean synchronizingEdits = false;
    private JMCheckBox cbxSynchronizeEdits;
    private JMButton btnFormatAll;
    private JMButton btnRevertAll;
    private JMButton btnSaveAll;
    private ScrollablePanel comparisonPanel;
    private ArrayList<FileEditorPanel> editorPanels;
    private ScrollSynchronizer scrollSynchronizer;
    private JEditorPane editorWithFocus;
    private ContainerEventInvoker editorPanelRemovalEventInvoker;
    private Boolean isEditable;
    private long startingAddFileWaitTime;

    static {
        IMAGE_EXTENSIONS = new String[]{"png", "jpg", "jpeg", "ico", "gif"};
        logger = Application.getApplication().getApplicationLogger();
    }

    public DataPowerFileDialog(JFrame owner, Object ... arguments) {
        super(owner, "Compare/Edit DataPower Files", false, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.isEditable = true;
        if (arguments.length > 0) {
            int arg = 0;
            while (arg < arguments.length) {
                Object argument = arguments[arg];
                if (argument instanceof Boolean) {
                    Boolean editable;
                    this.isEditable = editable = (Boolean)argument;
                }
                ++arg;
            }
        }
        if (this.isEditable.booleanValue()) {
            JMPanel controlsPanel = new JMPanel(new FlowLayout(0));
            this.cbxSynchronizeEdits = new JMCheckBox("Synchronize Edits");
            this.cbxSynchronizeEdits.setVisible(false);
            MethodInvoker isSelectedMethod = new MethodInvoker((Object)this.cbxSynchronizeEdits, "isSelected", new Object[0]);
            new ItemEventInvoker(this.cbxSynchronizeEdits, this, "setEditSynchronization", isSelectedMethod);
            this.btnFormatAll = ComponentFactory.createButton(KumbaCoreUIConstants.FORMAT_ALL_ICON, null, "Format all files.", true, this, "editFormatAll", new Object[0]);
            this.btnFormatAll.setVisible(false);
            this.btnRevertAll = ComponentFactory.createButton(KumbaCoreUIConstants.UNDO_ICON, null, "Revert all files.", true, this, "editUndoAll", new Object[0]);
            this.btnRevertAll.setVisible(false);
            this.btnSaveAll = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ALL_ICON, null, "Save all modified files.", true, this, "fileSaveAll", new Object[0]);
            this.btnSaveAll.setVisible(false);
            controlsPanel.addAll(this.cbxSynchronizeEdits, ComponentFactory.createSpacer(20, 10), this.btnFormatAll, this.btnRevertAll, this.btnSaveAll);
            this.add((Component)controlsPanel, "North");
        }
        this.comparisonPanel = new ScrollablePanel(new GridLayout(1, 0));
        this.editorPanelRemovalEventInvoker = new ContainerEventInvoker(this.comparisonPanel, 2, (Object)this, "recomputeSize");
        new ComponentEventInvoker(this, 8, (Object)this, "recomputeSize");
        this.add(new JMScrollPane(this.comparisonPanel));
        Dimension minimumSize = new Dimension(800, 800);
        this.setSize(minimumSize);
        this.setPreferredSize(minimumSize);
        this.setMinimumSize(minimumSize);
        this.setDefaultCloseOperation(2);
        this.editorPanels = new ArrayList();
    }

    @Override
    protected boolean getInitialVisibility() {
        return false;
    }

    @Reflected
    private void setEditSynchronization(boolean shouldSynchronize) {
        this.synchronizingEdits = shouldSynchronize;
        for (FileEditorPanel editorPanel : this.editorPanels) {
            if (this.synchronizingEdits) {
                editorPanel.addDocumentListener(this);
                editorPanel.addCaretListener(this);
                continue;
            }
            editorPanel.removeDocumentListener(this);
            editorPanel.removeCaretListener(this);
        }
    }

    @Reflected
    private void editFormatAll() {
        for (FileEditorPanel editorPanel : this.editorPanels) {
            editorPanel.editFormat();
        }
    }

    @Reflected
    private void editUndoAll() {
        for (FileEditorPanel editorPanel : this.editorPanels) {
            editorPanel.editUndo();
        }
    }

    @Reflected
    private void fileSaveAll() {
        for (FileEditorPanel editorPanel : this.editorPanels) {
            if (!editorPanel.isDirty()) continue;
            editorPanel.fileSave();
        }
    }

    public void addDataPowerFile(DataPowerFileInfo dataPowerFile) {
        String loggerPrefix = String.format("(DataPowerFileInfo=%s/%s/%s): ", dataPowerFile.getAppliance().getName(), dataPowerFile.getSourceDomain().getName(), dataPowerFile.getAbsolutePath());
        logger.finer(() -> LMG.log("%sStarting", () -> loggerPrefix));
        if (this.addingFile) {
            if (System.currentTimeMillis() - this.startingAddFileWaitTime > KumbaCoreConstants.FILE_READ_TIMEOUT) {
                logger.info(() -> LMG.log("%sTimed out waiting for previous add file operation to complete.  Skpping", () -> loggerPrefix));
                return;
            }
            logger.info(() -> LMG.log("%sWaiting for previous add file operation to complete..", () -> loggerPrefix));
            new AsynchMethodInvoker((Object)this, "addDataPowerFile", (Object)dataPowerFile, KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        boolean isImage = this.prepareAddFile(dataPowerFile.getName());
        if (isImage) {
            logger.finer(() -> LMG.log("%sFile is image.", () -> loggerPrefix));
            this.createImageContent(dataPowerFile.getFileData());
        } else {
            logger.finer(() -> LMG.log("%sFile is not image.", () -> loggerPrefix));
            this.setTitleBasedOnContent(dataPowerFile.getAbsolutePath());
            logger.finer(() -> LMG.log("%sCreating editor panel.", () -> loggerPrefix));
            FileEditorPanel fileEditorPanel = new FileEditorPanel(dataPowerFile, (boolean)this.isEditable);
            logger.finer(() -> LMG.log("%sWaiting for file editor panel to be ready.", () -> loggerPrefix));
            while (!fileEditorPanel.isReady()) {
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            logger.finer(() -> LMG.log("%sSetting up notifications.", () -> loggerPrefix));
            this.setupNotifications(fileEditorPanel);
        }
        logger.finer(() -> LMG.log("%sFinalizing UI.", () -> loggerPrefix));
        this.finalizeAddFile();
        logger.finer(() -> LMG.log("%sDone", () -> loggerPrefix));
    }

    public void addExternalFile(File externalFile) {
        String loggerPrefix = String.format("(externalFile=%s): ", externalFile.getAbsolutePath());
        logger.finer(() -> LMG.log("%sStarting", () -> loggerPrefix));
        if (this.addingFile) {
            if (System.currentTimeMillis() - this.startingAddFileWaitTime > KumbaCoreConstants.FILE_READ_TIMEOUT) {
                logger.info(() -> LMG.log("%sTimed out waiting for previous add file operation to complete.  Skpping", () -> loggerPrefix));
                return;
            }
            logger.info(() -> LMG.log("%sWaiting for previous add file operation to complete..", () -> loggerPrefix));
            new AsynchMethodInvoker((Object)this, "addExternalFile", (Object)externalFile, KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        boolean isImage = this.prepareAddFile(externalFile.getName());
        if (isImage) {
            logger.finer(() -> LMG.log("%sFile is image.", () -> loggerPrefix));
            try {
                BinaryFileReader reader = new BinaryFileReader(externalFile);
                byte[] data = reader.getData();
                this.createImageContent(data);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        } else {
            logger.finer(() -> LMG.log("%sFile is not image.", () -> loggerPrefix));
            this.setTitleBasedOnContent(externalFile.getAbsolutePath());
            logger.finer(() -> LMG.log("%sCreating editor panel.", () -> loggerPrefix));
            FileEditorPanel fileEditorPanel = new FileEditorPanel(externalFile);
            logger.finer(() -> LMG.log("%sSetting up notifications.", () -> loggerPrefix));
            this.setupNotifications(fileEditorPanel);
        }
        logger.finer(() -> LMG.log("%sFinalizing UI.", () -> loggerPrefix));
        this.finalizeAddFile();
        logger.finer(() -> LMG.log("%sDone", () -> loggerPrefix));
    }

    private boolean prepareAddFile(String fileName) {
        this.addingFile = true;
        String loggerPrefix = String.format("(fileName=%s): ", fileName);
        logger.finer(() -> LMG.log("%sStarting.  Turned on addingFile flag", () -> loggerPrefix));
        this.startingAddFileWaitTime = System.currentTimeMillis();
        String fileExtension = StringUtility.getNthOfDelimited(fileName, ".").toLowerCase();
        boolean isImage = Comparison.isIn(fileExtension, IMAGE_EXTENSIONS);
        logger.finer(() -> LMG.log("%sDone.  Is Image: %b", () -> loggerPrefix, () -> isImage));
        return isImage;
    }

    private void createImageContent(byte[] imageData) {
        logger.finer("(imageData): Starting");
        this.setTitle("View Image");
        logger.finer("(imageData): Creating image content");
        ImageIcon icon = new ImageIcon(imageData);
        PictureControl pictureControl = new PictureControl(icon.getImage());
        this.comparisonPanel.add(pictureControl);
        logger.finer("(imageData): Starting");
    }

    private void setTitleBasedOnContent(String fileName) {
        if (this.editorPanels.size() == 0) {
            if (this.isEditable.booleanValue()) {
                this.setTitle("Edit File " + fileName);
            } else {
                this.setTitle("Viewing File " + fileName);
            }
        } else {
            this.setTitle("Compare Files");
        }
    }

    private void setupNotifications(FileEditorPanel fileEditorPanel) {
        logger.finer("(FileEditorPanel): Starting.  Adding scroll synchronization.");
        if (this.scrollSynchronizer == null) {
            this.scrollSynchronizer = new ScrollSynchronizer();
        }
        this.scrollSynchronizer.addScrollPane(fileEditorPanel.getScrollPane());
        logger.finer("(FileEditorPanel): Adding file editor to comparison panel.");
        this.comparisonPanel.add(fileEditorPanel);
        this.editorPanels.add(fileEditorPanel);
        logger.finer("(FileEditorPanel): Adding focus listener.");
        fileEditorPanel.addFocusListener(this);
        logger.finer("(FileEditorPanel): Done");
    }

    private void finalizeAddFile() {
        logger.finer("(): Starting");
        boolean areAnyEditable = false;
        logger.finer("(): Checking for anything being editable.");
        for (FileEditorPanel editorPanel : this.editorPanels) {
            if (!editorPanel.isEditable()) continue;
            logger.finer("(): At least one panel is editable.");
            areAnyEditable = true;
            break;
        }
        if (areAnyEditable && this.editorPanels.size() > 1) {
            logger.finer("(): Showing editable controls.");
            this.cbxSynchronizeEdits.setVisible(true);
            this.btnFormatAll.setVisible(true);
            this.btnRevertAll.setVisible(true);
            this.btnSaveAll.setVisible(true);
        }
        logger.finer("(): Recomputing size.");
        this.recomputeSize();
        logger.finer("(): Turning off addingFile flag.");
        this.addingFile = false;
        logger.finer("(): Done");
    }

    @Reflected
    private void recomputeSize() {
        logger.finest("():  Starting");
        ContainerEvent removalEvent = (ContainerEvent)this.editorPanelRemovalEventInvoker.getEvent();
        if (removalEvent != null && removalEvent.getID() == 301) {
            FileEditorPanel editorRemoved = (FileEditorPanel)removalEvent.getChild();
            this.editorPanels.remove(editorRemoved);
            logger.fine("():  Removing Editor");
        }
        Dimension comparisonPanelSize = this.comparisonPanel.getSize();
        int comparisonPanelHeight = comparisonPanelSize.height;
        int comparisonPanelWidth = comparisonPanelSize.width;
        logger.finest(() -> LMG.log("():  Comparison Panel Size: (%d, %d)", () -> dimension.width, () -> dimension.height));
        Dimension dialogSize = this.getSize();
        logger.finest(() -> LMG.log("():  Dialog Size: (%d, %d)", () -> dimension.width, () -> dimension.height));
        comparisonPanelWidth = dialogSize.width - 20;
        comparisonPanelHeight = dialogSize.height - 80;
        Dimension newSize = new Dimension(comparisonPanelWidth, comparisonPanelHeight);
        logger.finest(() -> LMG.log("(): New Comparison Panel Size: (%d, %d)", () -> dimension.width, () -> dimension.height));
        this.comparisonPanel.setSize(newSize);
        this.comparisonPanel.setPreferredSize(newSize);
        Component[] components = this.comparisonPanel.getComponents();
        int componentCount = components.length == 0 ? 1 : components.length;
        int componentWidth = comparisonPanelWidth / componentCount - componentCount;
        Dimension componentSize = new Dimension(componentWidth, comparisonPanelHeight - 5);
        logger.finest(() -> LMG.log("(): New Component Panel Size: (%d, %d)", () -> dimension.width, () -> dimension.height));
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setSize(componentSize);
            component.setPreferredSize(componentSize);
            ++n2;
        }
        this.comparisonPanel.invalidate();
        this.comparisonPanel.repaint();
        logger.finest("():  Done");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e, EDIT_TYPE.INSERT);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e, EDIT_TYPE.DELETE);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e, EDIT_TYPE.CHANGE);
    }

    private void handleDocumentEvent(DocumentEvent e, EDIT_TYPE editType) {
        Document focusedDocument;
        if (this.editorWithFocus == null) {
            return;
        }
        Document document = e.getDocument();
        if (document != (focusedDocument = this.editorWithFocus.getDocument())) {
            return;
        }
        int offset = e.getOffset();
        int length = e.getLength();
        Position startPosition = document.getStartPosition();
        Position endPosition = document.getEndPosition();
        int documentLength = document.getLength();
        logger.finer(() -> LMG.log("(e, EDIT_TYPE=%s): startPosition=%d, endPosition=%d, documentLength=%d, offset=%d, length=%d", () -> editType, () -> startPosition.getOffset(), () -> endPosition.getOffset(), () -> document.getLength(), () -> e.getOffset(), () -> e.getLength()));
        if (documentLength == 0 && length > 0) {
            return;
        }
        try {
            String changedText = editType == EDIT_TYPE.INSERT ? document.getText(offset, length) : "";
            logger.fine(() -> LMG.log("(e, EDIT_TYPE=%s): offset=%d, length=%d, changed text='%s'", () -> editType, () -> e.getOffset(), () -> e.getLength(), () -> changedText));
            for (FileEditorPanel editorPanel : this.editorPanels) {
                JEditorPane editor = editorPanel.getFileDataEditor();
                Document target = editor.getDocument();
                if (target == document) continue;
                switch (editType) {
                    case INSERT: {
                        target.insertString(offset, changedText, null);
                        break;
                    }
                    case DELETE: {
                        target.remove(offset, length);
                        break;
                    }
                }
            }
        }
        catch (BadLocationException e1) {
            logger.severe(() -> LMG.log("(e, EDIT_TYPE=%s): BadLocationException:  startPosition=%d, endPosition=%d, documentLength=%d, offset=%d, length=%d", () -> editType, () -> startPosition.getOffset(), () -> endPosition.getOffset(), () -> document.getLength(), () -> e.getOffset(), () -> e.getLength()));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.editorWithFocus = (JEditorPane)e.getComponent();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.internalChanging) {
            return;
        }
        JEditorPane source = (JEditorPane)e.getSource();
        if (source != this.editorWithFocus) {
            return;
        }
        logger.finest("(CaretEvent e):  Starting");
        this.internalChanging = true;
        int caretPosition = e.getDot();
        int selectionStart = e.getMark();
        int min = Math.min(caretPosition, selectionStart);
        int max = Math.max(caretPosition, selectionStart);
        int selectionLength = max - min;
        logger.finest(() -> LMG.log("(CaretEvent e):  Source: %s = %d, Caret Location: %d, Selection Start: %d, Selection Length: %d", () -> source.getClass().getSimpleName(), () -> source.hashCode(), () -> e.getDot(), () -> e.getMark(), () -> selectionLength));
        for (FileEditorPanel fileEditorPanel : this.editorPanels) {
            JEditorPane editor = fileEditorPanel.getFileDataEditor();
            if (editor == source) continue;
            int textLength = editor.getDocument().getLength();
            logger.finest(() -> LMG.log("(CaretEvent e):  %d:  Length in editor: %d", () -> editor.hashCode(), () -> textLength));
            if (caretPosition < textLength) {
                editor.setCaretPosition(caretPosition);
            }
            if (selectionLength <= 0 || min >= textLength) continue;
            if (max >= textLength) {
                max = textLength;
            }
            int minimum = min;
            int maximum = max;
            logger.finest(() -> LMG.log("(CaretEvent e):  %d:  Selection Start: %d, Selection End: %d", () -> editor.hashCode(), () -> minimum, () -> maximum));
            editor.setSelectionStart(min);
            editor.setSelectionEnd(max);
        }
        new AsynchMethodInvoker((Object)this, "cancelInternalChanging", 100);
        logger.finest("(CaretEvent e):  Done");
    }

    @Reflected
    private void cancelInternalChanging() {
        this.internalChanging = false;
    }

    private static enum EDIT_TYPE {
        INSERT,
        DELETE,
        CHANGE;

    }
}

