/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.component.FileSelectorComponent;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;

public class ExportOptionsDialog
extends JMDialog {
    private static ExportOptions exportOptions = new ExportOptions();
    private ArrayList<StatusObjectStatus> deploymentPolicies;
    private FileSelectorComponent outputDirSelector;
    private JMTextField tfuserComment;
    private ListComboBox cbxExportFormat;
    private ListComboBox cbxDeploymentPolicies;
    private JMCheckBox cbxExportFiles;
    private JMCheckBox cbxExportObjects;
    private JMCheckBox cbxExportDebug;
    private JMButton btnOK;
    private JMButton btnCancel;

    public static ExportOptions getExportOptions() {
        return exportOptions;
    }

    public ExportOptionsDialog(JFrame owner, Object ... arguments) {
        super(owner, "Export Options", true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        exportOptions.setCancelled(false);
        this.deploymentPolicies = new ArrayList();
        JMPanel panel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(3);
        this.outputDirSelector = new FileSelectorComponent("Output Directory:", "...");
        this.outputDirSelector.setPreferredSize(600, 25);
        this.outputDirSelector.hideActionButton();
        this.outputDirSelector.setFileNameFilter(KumbaCoreUIConstants.DIRECTORY_FILE_FILTER);
        this.cbxDeploymentPolicies = new ListComboBox();
        this.cbxDeploymentPolicies.setPreferredDropDownComponentSize(0, 100);
        LabeledComponent lblDeploymentPolicy = new LabeledComponent("Deployment Policy:", (Component)this.cbxDeploymentPolicies);
        this.cbxDeploymentPolicies.addItem("");
        new AsynchMethodInvoker((Object)this, "buildDeploymentPolicyItems");
        this.cbxExportFormat = new ListComboBox(DPEnumerations.EXPORT_FORMAT);
        LabeledComponent lblExport = new LabeledComponent("Format:", (Component)this.cbxExportFormat);
        this.tfuserComment = ComponentFactory.createTextField("", 300, 25, null, null, new Object[0]);
        LabeledComponent lblComment = new LabeledComponent("Comment:", (Component)this.tfuserComment);
        this.cbxExportFiles = ComponentFactory.createCheckbox(null, "Export Files", "Exports files referenced by the objects exported", true, true, null, null, new Object[0]);
        this.cbxExportObjects = ComponentFactory.createCheckbox(null, "Export Referenced Objects", "Exports objects referenced by the objects exported.", true, true, null, null, new Object[0]);
        this.cbxExportDebug = ComponentFactory.createCheckbox(null, "Export Probe Data", "Exports any probe data associated with this object.", false, true, null, null, new Object[0]);
        JMPanel buttonPanel = new JMPanel();
        this.btnOK = ComponentFactory.createButton(null, "OK", "Perform the export with the selected options", true, this, "okClicked", new Object[0]);
        this.btnCancel = ComponentFactory.createButton(null, "Cancel", "Cancel and don't export.", true, this, "cancelClicked", new Object[0]);
        buttonPanel.addAll(this.btnOK, this.btnCancel);
        panel.addAll(lblExport, lblComment, lblDeploymentPolicy, this.cbxExportObjects, this.cbxExportFiles, this.cbxExportDebug, this.outputDirSelector, buttonPanel);
        this.contentPane.add((Component)panel, "Center");
    }

    @Reflected
    private void buildDeploymentPolicyItems() {
        Index<Appliance, Domain> queriedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.deploymentPolicies = configurationManager.listObjects(queriedDomains, "ConfigDeploymentPolicy", ".*");
        UniqueArrayList<String> deploymentPolicyNames = new UniqueArrayList<String>();
        for (StatusObjectStatus deploymentPolicy : this.deploymentPolicies) {
            deploymentPolicyNames.add(deploymentPolicy.getName());
        }
        deploymentPolicyNames.sort();
        for (String deploymentPolicyName : deploymentPolicyNames) {
            this.cbxDeploymentPolicies.addItem(deploymentPolicyName);
        }
    }

    @Reflected
    private void okClicked() {
        StatusObjectStatus selectedDeploymentPolicy = null;
        String deploymentPolicyName = (String)this.cbxDeploymentPolicies.getSelectedValue();
        if (!StringUtility.isEmpty(deploymentPolicyName)) {
            for (StatusObjectStatus deploymentPolicy : this.deploymentPolicies) {
                if (!deploymentPolicy.getName().equals(deploymentPolicyName)) continue;
                selectedDeploymentPolicy = deploymentPolicy;
                break;
            }
        }
        exportOptions.setCancelled(false);
        exportOptions.setExportFiles(this.cbxExportFiles.isSelected());
        exportOptions.setExportObjects(this.cbxExportObjects.isSelected());
        exportOptions.setExportDebug(this.cbxExportDebug.isSelected());
        exportOptions.setUserComment(this.tfuserComment.getText());
        exportOptions.setDeploymentPolicy(selectedDeploymentPolicy);
        exportOptions.setExportFormat((String)this.cbxExportFormat.getSelectedValue());
        exportOptions.setOutputDirectory(this.outputDirSelector.getSelectedFile());
        WindowCloser.closeWindow(this, 0, false);
    }

    @Reflected
    private void cancelClicked() {
        exportOptions.setCancelled(true);
        WindowCloser.closeWindow(this, 0, false);
    }
}

