/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.copymoveWizard;

import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.list.SimpleBeanListCellValueRenderer;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.BeanComparator;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.CopyMoveActionBean;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;

public class CopyMoveAppliancesPage
extends KumbaCoreWizardPage<CopyMoveActionBean> {
    private JMListModel<ApplianceGroupObject> applianceListModel;
    private JMList<ApplianceGroupObject> applianceList;

    public CopyMoveAppliancesPage(CopyMoveActionBean model) {
        super(model);
    }

    public CopyMoveAppliancesPage(CopyMoveActionBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    protected void saveDataToModel() {
        ((CopyMoveActionBean)this.model).clearDestinationAppliances();
        UniqueArrayList<Appliance> selectedAppliances = new UniqueArrayList<Appliance>();
        List selection = this.applianceList.getSelectedValuesList();
        for (ApplianceGroupObject ago : selection) {
            ArrayList<Appliance> appliances = ago.getAppliances();
            selectedAppliances.addAll(appliances);
        }
        for (Appliance appliance : selectedAppliances) {
            ((CopyMoveActionBean)this.model).addDestinationAppliance(appliance);
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        ArrayList allAppliances = (ArrayList)Application.getApplication().getAttribute("Appliance Groups");
        ArrayList<ApplianceGroupObject> appliances = new ArrayList<ApplianceGroupObject>();
        for (ApplianceGroupObject ago : allAppliances) {
            if (ago.getGroupName().equals("All") || !ago.isConnected()) continue;
            appliances.add(ago);
        }
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMLabel label = new JMLabel("Destination Appliances");
        panel.add((Component)label, "North");
        BeanComparator sorter = new BeanComparator("groupName");
        Collections.sort(appliances, sorter);
        this.applianceListModel = new JMListModel(appliances);
        this.applianceList = new JMList<ApplianceGroupObject>((ListModel<ApplianceGroupObject>)this.applianceListModel);
        this.applianceList.setCellRenderer(new JMListCellRenderer(new SimpleBeanListCellValueRenderer("groupName")));
        this.applianceList.setSelectionMode(2);
        panel.add((Component)new JMScrollPane(this.applianceList), "Center");
        return panel;
    }
}

