/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.combobox.JMComboBoxModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.AbstractCryptoObjectWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.LoadCryptoObjectData;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;

abstract class AbstractCryptoObjectFromExternalSourceWizardPage
extends AbstractCryptoObjectWizardPage {
    protected JMComboBoxModel<String> cbxModel;
    protected JMComboBox<String> cbxDataPowerDirectories;
    protected JMTextField tfDPFileName;

    public AbstractCryptoObjectFromExternalSourceWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        if (!super.isDataValid()) {
            return false;
        }
        String dpfileName = this.tfDPFileName.getText();
        if (StringUtility.isEmpty(dpfileName)) {
            new JMMessageBox((JDialog)this.parentDialog, "File name is required", "The file name is required.");
            return false;
        }
        boolean needsPassword = this.cbxNeedsPassword.isSelected();
        String password = this.tfPassword.getText();
        if (needsPassword && StringUtility.isEmpty(password)) {
            new JMMessageBox((JDialog)this.parentDialog, "Password is required", "You've indecated you needs a password but didn't provide one...");
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        super.saveDataToModel();
        String directoryName = (String)this.cbxDataPowerDirectories.getSelectedItem();
        String fileName = this.tfDPFileName.getText();
        String dpFile = String.format("%s/%s", directoryName, fileName);
        dpFile = StringUtility.coalesce(dpFile, "/");
        ((DynamicBean)this.model).setProperty("localFile", dpFile);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.cbxModel = new JMComboBoxModel();
        this.cbxDataPowerDirectories = new JMComboBox<String>((ComboBoxModel<String>)this.cbxModel);
        LabeledComponent directoryLabel = new LabeledComponent("Upload Directory:", this.cbxDataPowerDirectories);
        directoryLabel.setPreferredSize(100, 25);
        this.tfDPFileName = new JMTextField();
        LabeledComponent fileNameLabel = new LabeledComponent("DP File Name:", (Component)this.tfDPFileName);
        fileNameLabel.setPreferredSize(100, 25);
        panel.addAll(0, directoryLabel, fileNameLabel);
        new AsynchMethodInvoker((Object)this, "waitForDirectories");
        return panel;
    }

    @Reflected
    private void waitForDirectories() {
        logger.finer("(): Starting");
        LoadCryptoObjectData lcd = (LoadCryptoObjectData)((DynamicBean)this.model).getProperty("dataLoader");
        Index<String, DataPowerFileInfo> dataDirectories = lcd.getDataPowerDirectories();
        while (dataDirectories == null) {
            logger.finer("():  No DataPower Directories Yet.");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            dataDirectories = lcd.getDataPowerDirectories();
        }
        logger.finer("():  Got the datapower directories.");
        ArrayList directoryNames = (ArrayList)dataDirectories.getKeys();
        UniqueArrayList<String> fixedDirectoryNames = new UniqueArrayList<String>();
        String certDirectory = null;
        for (String directoryName : directoryNames) {
            if (directoryName.endsWith("/")) {
                directoryName.substring(0, directoryName.length() - 1);
            }
            if (directoryName.equals("cert:")) {
                certDirectory = directoryName;
            }
            fixedDirectoryNames.add(directoryName);
        }
        fixedDirectoryNames.sort();
        logger.finer(() -> LMG.log("():  Adding %d directories to the combo box model.", () -> fixedDirectoryNames.size()));
        this.cbxModel.addAll(fixedDirectoryNames);
        this.cbxDataPowerDirectories.setSelectedItem(certDirectory);
        logger.finer("(): Done");
    }
}

