/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractUpdateConfiguration;
import com.kumbasoft.core.tools.CreatePasswordAlias;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.GetCertificatesFromURL;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.LoadCryptoObjectData;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractUpdateCryptoConfig
extends AbstractUpdateConfiguration {
    public AbstractUpdateCryptoConfig(DynamicBean model) {
        super(model);
    }

    protected File fetchFileFromURL(String url) {
        GetCertificatesFromURL certsFromURL = new GetCertificatesFromURL(url);
        Object[] certificateFiles = certsFromURL.getExportFiles();
        if (ArrayUtility.isEmpty(certificateFiles)) {
            logger.severe(() -> LMG.log("(url=%s): Error retrieving certificate from URL", () -> url));
            return null;
        }
        return certificateFiles[0];
    }

    protected void uploadFile(File externalFile, String localFile) {
        String baseDirectory = StringUtility.substringBefore(localFile, "/");
        String fileName = StringUtility.substringAfter(localFile, "/");
        LoadCryptoObjectData lcd = (LoadCryptoObjectData)this.model.getProperty("dataLoader");
        ArrayList<ConfigCrypto> cryptoObjects = lcd.getCryptoObjects();
        Index<Appliance, Domain> affectedDomains = new Index<Appliance, Domain>();
        for (ConfigCrypto cid : cryptoObjects) {
            Domain domain;
            Appliance appliance = cid.getAppliance();
            if (affectedDomains.containsValue(appliance, domain = cid.getSourceDomain())) continue;
            affectedDomains.put(appliance, domain);
        }
        ArrayList<DataPowerFileInfo> filesToUpload = new ArrayList<DataPowerFileInfo>();
        Date today = new Date();
        for (Appliance appliance : affectedDomains.getKeys()) {
            for (Domain domain : affectedDomains.get(appliance)) {
                DataPowerFileInfo fileInfo = new DataPowerFileInfo(appliance, domain, today.toString(), externalFile.length(), baseDirectory, fileName);
                fileInfo.setLocalFile(externalFile);
                filesToUpload.add(fileInfo);
            }
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        FileUploader.upload(filesToUpload, mtil);
        FileUploader.addCommandSubscribers(this.managementCommandSubscribers);
        ThreadManager.monitorAsynchThreadLifeCycle("UpdateCryptoIDCredentials.uploadFile(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
    }

    protected void updateObjects(ArrayList<? extends ConfigCrypto> objects, String localFile, MultiThreadInvocationListener invocationListener) {
        for (ConfigCrypto configCrypto : objects) {
            ModifyProperty<String> modifyFileName = new ModifyProperty<String>(configCrypto.getStatus(), "Filename", localFile);
            invocationListener.addThread(modifyFileName.getProcessThread());
            modifyFileName.setCommandDescription(String.format("Change file name of '%s' to '%s'", configCrypto.getName(), localFile));
            this.addManagementCommandSubscribers(modifyFileName);
        }
    }

    protected void updatePassword(ArrayList<? extends ConfigCrypto> objects, MultiThreadInvocationListener mtil) {
        boolean needsPassword = (Boolean)this.model.getProperty("needsPassword");
        String password = (String)this.model.getProperty("password");
        for (ConfigCrypto configCrypto : objects) {
            if (!needsPassword) continue;
            ObjectReference alias = (ObjectReference)BeanService.getPropertyValue(configCrypto, "alias");
            if (alias == null) {
                ThreadManager.monitorAsynchThreadLifeCycle("UpdateCryptoIDCred.updateObjects(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
                StatusObjectStatus objectStatus = configCrypto.getStatus();
                ModifyProperty<String> modifyPassword = new ModifyProperty<String>(objectStatus, "Password", password);
                mtil.addThread(modifyPassword.getProcessThread());
                modifyPassword.setCommandDescription(String.format("Set password of '%s'.", configCrypto.getName()));
                this.addManagementCommandSubscribers(modifyPassword);
                continue;
            }
            String passwordAliasName = alias.getName();
            CreatePasswordAlias createPasswordAlias = new CreatePasswordAlias(configCrypto.getAppliance(), configCrypto.getSourceDomain(), passwordAliasName, password);
            createPasswordAlias.setCommandDescription(String.format("Set password of password alias '%s'", passwordAliasName));
            createPasswordAlias.addManagementCommandSubscriber(this.managementCommandSubscribers);
            mtil.addThread(createPasswordAlias.getProcessThread());
        }
    }
}

