/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;

public class GenerateSecretKeyFileTypePage
extends KumbaCoreWizardPage<DynamicBean> {
    final int[] bitLengths = new int[]{32, 40, 48, 56, 64, 96, 128, 168, 192, 224, 256, 384, 512, 1024, 2048, 4096};
    private JMComboBox<Integer> cbxAlgorithm;
    private JMRadioButton rbReplaceFile;
    private JMRadioButton rbCreateNewFile;

    public GenerateSecretKeyFileTypePage(DynamicBean model) {
        super(model);
    }

    @Override
    protected void saveDataToModel() {
        int bitLength = (Integer)this.cbxAlgorithm.getSelectedItem();
        ((DynamicBean)this.model).setProperty("keyLength", bitLength);
        if (this.rbReplaceFile.isSelected()) {
            ((DynamicBean)this.model).setProperty("replaceExistingFile", true);
            ((DynamicBean)this.model).setProperty("createNewFile", false);
        } else {
            ((DynamicBean)this.model).setProperty("replaceExistingFile", false);
            ((DynamicBean)this.model).setProperty("createNewFile", true);
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        Integer firstSelectedValue = null;
        Integer[] values = new Integer[this.bitLengths.length];
        int i = 0;
        while (i < this.bitLengths.length) {
            values[i] = this.bitLengths[i];
            if (this.bitLengths[i] == 256) {
                firstSelectedValue = values[i];
            }
            ++i;
        }
        this.cbxAlgorithm = new JMComboBox<Integer>((ItemType[])values);
        this.cbxAlgorithm.setSelectedItem(firstSelectedValue);
        LabeledComponent lblCBXAlgorithm = new LabeledComponent("Key Bit Length:", this.cbxAlgorithm);
        this.rbReplaceFile = new JMRadioButton("Replace Existing File", true);
        this.rbCreateNewFile = new JMRadioButton("Create a New File");
        new JMButtonGroup(this.rbReplaceFile, this.rbCreateNewFile);
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        panel.addAll(lblCBXAlgorithm, ComponentFactory.createSpacer(20, 50), this.rbReplaceFile, this.rbCreateNewFile);
        return panel;
    }

    @Override
    protected WizardDialog discoverParent() {
        WizardDialog parent = super.discoverParent();
        if (parent != null) {
            new ItemEventInvoker(this.rbReplaceFile, this.parentDialog, "manageButtonState");
            new ItemEventInvoker(this.rbCreateNewFile, this.parentDialog, "manageButtonState");
        }
        return parent;
    }

    @Override
    public boolean isFinalPage() {
        return this.rbReplaceFile.isSelected();
    }
}

