/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.util.Index;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoIdentCred;
import com.kumbasoft.core.beans.config.ConfigCryptoKey;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.LoadCryptoObjectData;
import java.util.ArrayList;

public class LoadCredentialsData
extends LoadCryptoObjectData {
    private ArrayList<ConfigCryptoIdentCred> cryptoIDCreds;
    private ArrayList<ConfigCryptoCertificate> cryptoCertificates;
    private ArrayList<ConfigCryptoKey> cryptoKeys;

    public LoadCredentialsData(DynamicBean model) {
        super(model);
    }

    public ArrayList<ConfigCryptoIdentCred> getCryptoIDCreds() {
        return this.cryptoIDCreds;
    }

    public ArrayList<ConfigCryptoCertificate> getCryptoCertificates() {
        return this.cryptoCertificates;
    }

    public ArrayList<ConfigCryptoKey> getCryptoKeys() {
        return this.cryptoKeys;
    }

    @Override
    @Reflected
    protected void loadCryptoObjects() {
        ConfigurationManager configurationManager = new ConfigurationManager();
        logger.finer("(): Loading crypto id cred objects.");
        ArrayList<DataPowerConfig> configs = configurationManager.getObjects(this.selectedObjects);
        this.cryptoIDCreds = new ArrayList(configs.size());
        Index<Appliance, Domain> objectDomains = new Index<Appliance, Domain>();
        logger.finer(() -> LMG.log("(): Loaded %d Crypto ID Cred Objects", () -> configs.size()));
        StringBuilder certNameExpression = new StringBuilder("(^");
        StringBuilder keyNameExpression = new StringBuilder("(^");
        for (DataPowerConfig config : configs) {
            ConfigCryptoIdentCred cryptoIdCred = (ConfigCryptoIdentCred)config;
            Appliance appliance = cryptoIdCred.getAppliance();
            Domain domain = cryptoIdCred.getSourceDomain();
            objectDomains.put(appliance, domain);
            this.cryptoIDCreds.add(cryptoIdCred);
            ObjectReference<ConfigCryptoCertificate> cert = cryptoIdCred.getCertificate();
            String certName = cert.getName();
            if (certNameExpression.length() > 2) {
                certNameExpression.append("|^");
            }
            certNameExpression.append(certName);
            certNameExpression.append("$");
            ObjectReference<ConfigCryptoKey> key = cryptoIdCred.getKey();
            String keyName = key.getName();
            if (keyNameExpression.length() > 2) {
                keyNameExpression.append("|^");
            }
            keyNameExpression.append(keyName);
            keyNameExpression.append("$");
        }
        certNameExpression.append(")");
        keyNameExpression.append(")");
        logger.finer("(): Loading cert and key object configurations.");
        logger.finer(() -> LMG.log("(): certNameExpression: '%s'.", () -> certNameExpression.toString()));
        logger.finer(() -> LMG.log("(): keyNameExpression: '%s'.", () -> keyNameExpression.toString()));
        this.cryptoCertificates = configurationManager.getObjects(objectDomains, ConfigCryptoCertificate.class, certNameExpression.toString());
        this.cryptoKeys = configurationManager.getObjects(objectDomains, ConfigCryptoKey.class, keyNameExpression.toString());
        this.cryptoObjects = new ArrayList<ConfigCryptoCertificate>(this.cryptoCertificates);
        this.cryptoObjects.addAll(this.cryptoKeys);
        logger.finer(() -> LMG.log("(): Loaded %d Crypto Cert Objects", () -> this.cryptoCertificates.size()));
        logger.finer(() -> LMG.log("(): Loaded %d Crypto Key Objects", () -> this.cryptoKeys.size()));
        logger.finer("(): Done");
    }
}

