/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.DateTime;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.GetCertificatesFromURL;
import com.kumbasoft.core.util.CertificateReader;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class UpdateCertificateFromURLFinalPage
extends AbstractTableWizardPage {
    private static final String URL_FETCH_ERROR = "** Error retrieving certificate from URL **";
    private static final DateTime URL_ERROR_VALIDATION_DATE = new DateTime("Jan 1, 1970 00:00:01 am");
    private ArrayList<CertificateInformation> selectedCertificates;

    public UpdateCertificateFromURLFinalPage(DynamicBean model) {
        super(model);
        this.selectedCertificates = (ArrayList)model.getProperty("certificatesToUpdate");
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        for (CertificateInformation certInfo : this.selectedCertificates) {
            Appliance appliance = certInfo.getAppliance();
            Domain domain = certInfo.getDomain();
            String certificateObjectName = certInfo.getCertificateObjectName();
            String fileName = certInfo.getFileName();
            DynamicBean row = new DynamicBean();
            row.setProperty("appliance", appliance);
            row.setProperty("domain", domain);
            row.setProperty("certificateObjectName", certificateObjectName);
            row.setProperty("onBoardFileName", fileName);
            row.setProperty("URL", "");
            row.setProperty("newCertificateInfo", null);
            row.setProperty("notBeforeDate", new DateTime());
            row.setProperty("notAfterDate", new DateTime());
            row.setProperty("sAN", "");
            tableModel.addRow(row);
        }
        tableModel.addComputedExpression("appliance", "name");
        tableModel.addComputedExpression("domain", "name");
        return tableModel;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        columnModel.setColumnOrder("appliance", "domain", "certificateObjectName", "URL", "notBeforeDate", "notAfterDate", "sAN");
        columnModel.hideColumn("onBoardFileName");
        columnModel.hideColumn("newCertificateInfo");
        columnModel.hideColumn("onBoardFileName");
        columnModel.setColumnTitle("notBeforeDate", "New Not Before Date");
        columnModel.setColumnTitle("notAfterDate", "New Not After Date");
        columnModel.setColumnTitle("sAN", "New SANs");
        return columnModel;
    }

    @Override
    protected void updateControls() {
        ArrayList tableData = (ArrayList)((DynamicBean)this.model).getProperty("updateCertificatesFromURLSetupData");
        CertificateReader certificateReader = new CertificateReader();
        for (DynamicBean row : tableData) {
            Appliance appliance = (Appliance)row.getProperty("appliance");
            Domain domain = (Domain)row.getProperty("domain");
            String certificateObjectName = (String)row.getProperty("certificateObjectName");
            String onBoardFileName = (String)row.getProperty("onBoardFileName");
            String url = (String)row.getProperty("URL");
            String SANs = "";
            DateTime notBeforeDate = null;
            DateTime notAfterDate = null;
            CertificateInformation sourceCertInfo = null;
            GetCertificatesFromURL certsFromURL = new GetCertificatesFromURL(url);
            if (certsFromURL.hasException()) {
                SANs = URL_FETCH_ERROR;
            } else {
                File[] exportFiles = certsFromURL.getExportFiles();
                File certificateFile = exportFiles[0];
                X509Certificate sourceCertificate = (X509Certificate)certificateReader.readCertificate(certificateFile);
                sourceCertInfo = new CertificateInformation(appliance, domain, certificateFile.getAbsolutePath(), sourceCertificate);
                sourceCertInfo.setCertificateObjectName(certificateObjectName);
            }
            notBeforeDate = sourceCertInfo == null ? URL_ERROR_VALIDATION_DATE : sourceCertInfo.getNotBefore();
            notAfterDate = sourceCertInfo == null ? URL_ERROR_VALIDATION_DATE : sourceCertInfo.getNotAfter();
            SANs = sourceCertInfo == null ? URL_FETCH_ERROR : sourceCertInfo.getSubjectAlternativeNames();
            row.setProperty("onBoardFileName", onBoardFileName);
            row.setProperty("notBeforeDate", notBeforeDate);
            row.setProperty("notAfterDate", notAfterDate);
            row.setProperty("sAN", SANs);
            row.setProperty("newCertificateInfo", sourceCertInfo);
        }
        this.tableModel.reset();
        this.tableModel.addAll(tableData);
        super.updateControls();
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        ArrayList<DynamicBean> tableData = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("updateCertificatesFromURLFinalData", tableData);
    }
}

