/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class UpdateCertificateFromURLSetupPage
extends AbstractTableWizardPage
implements TableModelListener {
    private JMCheckBox cbxSynchronizeChanges;
    private boolean suppressChangeEvents;
    private ArrayList<CertificateInformation> selectedCertificates;

    public UpdateCertificateFromURLSetupPage(DynamicBean model) {
        super(model);
        this.selectedCertificates = (ArrayList)model.getProperty("certificatesToUpdate");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        ExtendedTableModelEvent ee = (ExtendedTableModelEvent)e;
        if (!this.cbxSynchronizeChanges.isSelected() || this.suppressChangeEvents || ee.getNewValue().equals(ee.getOldValue())) {
            return;
        }
        this.suppressChangeEvents = true;
        int changedRow = e.getFirstRow();
        DynamicBean changedValue = this.tableModel.getValue(changedRow);
        String certificateObjectName = (String)changedValue.getProperty("certificateObjectName");
        String url = (String)changedValue.getProperty("URL");
        int rowCount = this.tableModel.getRowCount();
        int row = 0;
        while (row < rowCount) {
            DynamicBean value;
            String vCVertificateObjectName;
            if (row != changedRow && certificateObjectName.equals(vCVertificateObjectName = (String)(value = this.tableModel.getValue(row)).getProperty("certificateObjectName"))) {
                value.setProperty("URL", url);
            }
            ++row;
        }
        this.suppressChangeEvents = false;
        this.table.repaint();
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize Changes", true);
        panel.add((Component)this.cbxSynchronizeChanges, "North");
        this.tableModel.addTableModelListener(this);
        return panel;
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        for (CertificateInformation certInfo : this.selectedCertificates) {
            Appliance appliance = certInfo.getAppliance();
            Domain domain = certInfo.getDomain();
            String certificateObjectName = certInfo.getCertificateObjectName();
            String fileName = certInfo.getFileName();
            String sans = certInfo.getSubjectAlternativeNames();
            String subjectDN = certInfo.getSubjectDN();
            String mostLogicalSAN = this.getMostLocialSAN(sans);
            String SAN = mostLogicalSAN == null ? this.getSANFromSubjectDN(subjectDN) : mostLogicalSAN;
            String defaultURL = String.format("https://%s", SAN.trim());
            DynamicBean row = new DynamicBean();
            row.setProperty("appliance", appliance);
            row.setProperty("domain", domain);
            row.setProperty("certificateObjectName", certificateObjectName);
            row.setProperty("onBoardFileName", fileName);
            row.setProperty("URL", defaultURL);
            tableModel.addRow(row);
        }
        tableModel.addComputedExpression("appliance", "name");
        tableModel.addComputedExpression("domain", "name");
        tableModel.setEditableColumns("URL");
        return tableModel;
    }

    private String getSANFromSubjectDN(String subjectDN) {
        if (StringUtility.isEmpty(subjectDN)) {
            return null;
        }
        if (!subjectDN.contains(",")) {
            return subjectDN;
        }
        String[] elements = subjectDN.split(",");
        String CN = null;
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String san = stringArray[n2];
            if (san.startsWith("CN=")) {
                CN = san.replace("CN=", "");
            }
            ++n2;
        }
        String SAN = CN == null ? elements[0].trim().replace("CN=", "").replace("O=", "") : CN;
        return SAN;
    }

    protected String getMostLocialSAN(String SANs) {
        if (StringUtility.isEmpty(SANs)) {
            return null;
        }
        if (SANs.contains(",")) {
            String[] sanArray = SANs.split(",");
            int likelySAN = -1;
            int i = 0;
            while (i < sanArray.length) {
                String san = sanArray[i];
                if (san.startsWith("*")) {
                    return san.replace("*", "www");
                }
                int dotCount = StringUtility.getCountOf(san, ".");
                if (dotCount != 0) {
                    likelySAN = i;
                }
                ++i;
            }
            return likelySAN == -1 ? null : sanArray[likelySAN];
        }
        return SANs.startsWith("*") ? null : SANs;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        columnModel.setColumnOrder("appliance", "domain", "certificateObjectName", "URL");
        columnModel.hideColumn("onBoardFileName");
        return columnModel;
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        ArrayList<DynamicBean> tableData = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("updateCertificatesFromURLSetupData", tableData);
    }
}

