/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.ThreadUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.AbstractUpdateCryptoConfig;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.LoadCryptoObjectData;
import java.io.File;
import java.util.ArrayList;

public class UpdateCryptoObject
extends AbstractUpdateCryptoConfig {
    public UpdateCryptoObject(DynamicBean model) {
        super(model);
    }

    @Override
    protected void updateConfigurations() {
        LoadCryptoObjectData dataLoader = (LoadCryptoObjectData)this.model.getProperty("dataLoader");
        ArrayList<ConfigCrypto> cryptoObjects = dataLoader.getCryptoObjects();
        while (cryptoObjects == null) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            cryptoObjects = dataLoader.getCryptoObjects();
        }
        String localFile = this.model.getProperty("localFile", null);
        File externalFile = this.model.getProperty("externalFile", null);
        String url = this.model.getProperty("URL", null);
        if (externalFile != null) {
            this.uploadFile(externalFile, localFile);
        } else if (url != null) {
            File urlFile = this.fetchFileFromURL(url);
            if (urlFile == null) {
                String errorMessage = String.format("(): No file fetched from URL: %s", url);
                logger.severe(errorMessage);
                Appliance appliance = new Appliance("N/A");
                Domain domain = new Domain("N/A");
                ManagementCommandError error = new ManagementCommandError(appliance, domain, "Unable to fetch from URL", this, errorMessage);
                this.notifyManagementCommandSubscribers(error);
                return;
            }
            this.uploadFile(urlFile, localFile);
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        this.updateObjects(cryptoObjects, localFile, mtil);
        int objectType = (Integer)this.model.getProperty("objectType");
        if (objectType == 0 || objectType == 1) {
            this.updatePassword(cryptoObjects, mtil);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("UpdateCryptoIDCred.updateConfigurations", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
    }
}

