/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.deleteWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteObjectException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;

class DeleteObjectExceptionManagementPanel
extends AbstractTablePanel<DeleteObjectException> {
    private JMButton btnAdd = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, null, "Add a new exception", true, this, "fileNew", new Object[0]);
    private JMButton btnDelete = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, null, "Delete the selected exceptions", true, this, "editDelete", new Object[0]);
    private JMButton btnSave = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, null, "Save all changes", true, this, "writeObjectDeleteExceptions", new Object[0]);

    public DeleteObjectExceptionManagementPanel() {
        super(DeleteObjectException.class);
        JMPanel leftButtons = new JMPanel(new FlowLayout(0));
        leftButtons.addAll(this.btnAdd, this.btnDelete);
        JMPanel rightButtons = new JMPanel(new FlowLayout(2));
        rightButtons.addAll(this.btnSave);
        JMPanel topPanel = new JMPanel(new BorderLayout());
        topPanel.add((Component)leftButtons, "Center");
        topPanel.add((Component)rightButtons, "East");
        this.add((Component)topPanel, "North");
        this.readObjectDeleteExceptions();
    }

    @Reflected
    private void fileNew() {
        DeleteObjectException newException = new DeleteObjectException();
        this.tableModel.addRow(newException);
        this.displayTable.repaint();
    }

    @Reflected
    private void editDelete() {
        this.displayTable.commitEdits();
        this.displayTable.removeEditor();
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            return;
        }
        this.tableModel.deleteAll(selectedRows);
        this.displayTable.repaint();
    }

    @Override
    protected JMPanel createLeftPanel() {
        return null;
    }

    @Override
    public BeanTableModel<DeleteObjectException> getTableModel() {
        BeanTableModel<DeleteObjectException> model = super.getTableModel();
        model.setEditable();
        return model;
    }

    @Override
    protected BeanColumnModel<DeleteObjectException> getColumnModel() {
        BeanColumnModel<DeleteObjectException> model = super.getColumnModel();
        model.setColumnOrder("applianceExpression", "domainExpression", "objectTypeExpressoin", "objectNameExpression");
        return model;
    }

    void readObjectDeleteExceptions() {
        Application application = Application.getApplication();
        KumbaCoreApplicationProperties appProperties = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        String deleteExceptionsFileName = appProperties.getDeleteExceptionsFile().substring(1);
        File deleteExceptionsFile = new File(deleteExceptionsFileName);
        if (deleteExceptionsFile.exists()) {
            ArrayList exceptionModel = (ArrayList)FileUtility.readObject(deleteExceptionsFile, true);
            this.tableModel.reset();
            this.tableModel.addAll(exceptionModel);
            this.displayTable.repaint();
        }
    }

    @Reflected
    void writeObjectDeleteExceptions() {
        this.displayTable.commitEdits();
        ArrayList exceptionModel = this.tableModel.getModelData();
        if (CollectionUtility.isEmpty(exceptionModel)) {
            return;
        }
        Application application = Application.getApplication();
        KumbaCoreApplicationProperties appProperties = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        String deleteExceptionsFileName = appProperties.getDeleteExceptionsFile().substring(1);
        File deleteExceptionsFile = new File(deleteExceptionsFileName);
        FileUtility.writeObject(deleteExceptionsFile, exceptionModel, true);
    }
}

