/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.fileWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.DeleteFilesBean;
import java.awt.Component;
import java.util.ArrayList;

public class DeleteFilesWizardPage
extends KumbaCoreWizardPage<DeleteFilesBean> {
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable table;

    public DeleteFilesWizardPage(DeleteFilesBean model) {
        super(model);
    }

    public DeleteFilesWizardPage(DeleteFilesBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        ArrayList<DynamicBean> deleteChoices = this.tableModel.getModelData();
        for (DynamicBean deleteChoice : deleteChoices) {
            boolean delete = (Boolean)deleteChoice.getProperty("delete");
            if (delete) continue;
            DataPowerFileInfo file = (DataPowerFileInfo)deleteChoice.getProperty("file");
            ((DeleteFilesBean)this.model).remove(file);
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        ArrayList<DataPowerFileInfo> files = ((DeleteFilesBean)this.model).getFiles();
        ArrayList<DynamicBean> deleteBeans = new ArrayList<DynamicBean>(files.size());
        for (DataPowerFileInfo file : files) {
            DynamicBean db = new DynamicBean();
            db.setProperty("delete", true);
            db.setProperty("appliance", file.getAppliance().getName());
            db.setProperty("domain", file.getSourceDomain().getName());
            db.setProperty("fileName", file.getAbsolutePath());
            db.setProperty("file", file);
            deleteBeans.add(db);
        }
        this.tableModel = new DynamicBeanTableModel();
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.tableModel.addAll(deleteBeans);
        this.tableModel.setEditableColumns("delete");
        this.columnModel.hideColumn("file");
        this.columnModel.setColumnOrder("delete", "appliance", "domain", "fileName");
        this.table = new JMTable(this.tableModel, this.columnModel);
        this.table.optimizeColumnWidths();
        panel.add((Component)new JMLabel("Files:"), "North");
        panel.add(new JMScrollPane(this.table));
        return panel;
    }
}

