/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.fileWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.DataPowerFileUtility;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.ListModel;

public class NewFileWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private JMListModel<String> directoryListModel;
    private JMList<String> directoryList;
    private JMTextField tfNewDirectory;
    private JMTextField tfFileName;

    public NewFileWizardPage(DynamicBean model) {
        super(model);
    }

    public NewFileWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        int selectedIndex = this.directoryList.getSelectedIndex();
        if (selectedIndex < 0) {
            new JMMessageBox((JDialog)this.parentDialog, "No Directory Selected", "Please select a Destination Directory.");
            return false;
        }
        String fileName = this.tfFileName.getText();
        if (StringUtility.isEmpty(fileName)) {
            new JMMessageBox((JDialog)this.parentDialog, "No File Name Provided", "Please provide a name for the new file.");
            return false;
        }
        if (!DataPowerFileUtility.isFileNameValid(fileName)) {
            new JMMessageBox((JDialog)this.parentDialog, "Invalid File Name Provided", "The file name entered is not valid.  Valid characters are A-Z, a-z, 0-9, - (dash), _ (underscore) or . (period).  The file name cannot contain two consecutive periods.  The length of the name cannot exceed 128 characters.");
            return false;
        }
        String newDirectory = this.tfNewDirectory.getText();
        if (StringUtility.isNotEmpty(newDirectory)) {
            if (newDirectory.contains("/")) {
                String[] dirNames;
                String[] stringArray = dirNames = newDirectory.split("/");
                int n = dirNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String dirName = stringArray[n2];
                    if (!DataPowerFileUtility.isFileNameValid(dirName)) {
                        new JMMessageBox((JDialog)this.parentDialog, "Invalid Directory Name Provided", "The directory name entered is not valid.  Valid characters are A-Z, a-z, 0-9, - (dash), _ (underscore) or . (period).  The directory name cannot contain two consecutive periods.  The length of the name cannot exceed 128 characters.");
                        return false;
                    }
                    ++n2;
                }
            } else if (!DataPowerFileUtility.isFileNameValid(newDirectory)) {
                new JMMessageBox((JDialog)this.parentDialog, "Invalid Directory Name Provided", "The directory name entered is not valid.  Valid characters are A-Z, a-z, 0-9, - (dash), _ (underscore) or . (period).  The directory name cannot contain two consecutive periods.  The length of the name cannot exceed 128 characters.");
                return false;
            }
            String selectedDirectory = (String)this.directoryList.getSelectedValue();
            String newBaseDirectory = StringUtility.coalesce(selectedDirectory + newDirectory + "/", "/");
            if (this.directoryListModel.contains(newBaseDirectory)) {
                new JMMessageBox((JDialog)this.parentDialog, "New Directory Exists", "The new directory you entered already exists.  Please check the directory list and select the desired destination directory or enter a new directory name.");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        String selectedDirectory = this.directoryList.getSelectedItem();
        String newDirectory = this.tfNewDirectory.getText();
        if (selectedDirectory.endsWith("cert:")) {
            newDirectory = "";
        }
        String newFileName = this.tfFileName.getText();
        ((DynamicBean)this.model).setProperty("selectedDirectory", selectedDirectory);
        ((DynamicBean)this.model).setProperty("newDirectory", newDirectory);
        ((DynamicBean)this.model).setProperty("newFileName", newFileName);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        Collection directories = (Collection)((DynamicBean)this.model).getProperty("directories");
        this.directoryListModel = new JMListModel(directories);
        this.directoryList = new JMList<String>((ListModel<String>)this.directoryListModel);
        this.directoryList.setSelectionMode(0);
        new ListSelectionEventInvoker(this.directoryList, this, "directorySelectionChanged");
        LabeledComponent lblDirectoryList = new LabeledComponent("Directories:", (Component)new JMScrollPane(this.directoryList), 1);
        this.tfNewDirectory = new JMTextField();
        LabeledComponent lblNewDirectory = new LabeledComponent("New Directory:", (Component)this.tfNewDirectory, 1, 200, 300);
        this.tfFileName = new JMTextField();
        LabeledComponent lblFileName = new LabeledComponent("New File Name:", (Component)this.tfFileName, 1, 200, 300);
        JMPanel fieldPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        fieldPanel.addAll(lblNewDirectory, lblFileName);
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        panel.add((Component)lblDirectoryList, "West");
        panel.add((Component)fieldPanel, "Center");
        return panel;
    }

    @Reflected
    private void directorySelectionChanged() {
        String selectedDirectory = this.directoryList.getSelectedItem();
        boolean certDir = selectedDirectory.endsWith("cert:");
        this.tfNewDirectory.setEnabled(!certDir);
    }
}

