/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.initWizard;

import com.jmorgan.beans.persistence.FilePersistenceDelegate;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import java.awt.Component;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.util.ArrayList;

public class InitWizardFinalPage
extends KumbaCoreWizardPage<DPAAApplicationProperties> {
    private ArrayList<JMLabel> contentLabels;

    public InitWizardFinalPage(DPAAApplicationProperties model) {
        super(model);
    }

    @Override
    protected void saveDataToModel() {
        File preferencesFile = new File("./configs/DPAAProperties.xml");
        FileOutputStreamHelper fout = new FileOutputStreamHelper(preferencesFile);
        BufferedOutputStream bout = (BufferedOutputStream)fout.open();
        XMLEncoder encoder = new XMLEncoder(bout);
        encoder.setPersistenceDelegate(File.class, new FilePersistenceDelegate());
        encoder.writeObject(this.model);
        encoder.flush();
        encoder.close();
        fout.close();
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.contentLabels = new ArrayList();
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(new VerticalFlowLayout(0));
        panel.addAll(this.createComponent("Log Files:", ((DPAAApplicationProperties)this.model).getLogsDirectory()), this.createComponent("Certificate Files:", ((DPAAApplicationProperties)this.model).getCertificateFileDirectory()), this.createComponent("Snapshots:", ((DPAAApplicationProperties)this.model).getSnapShotsDirectory()), this.createComponent("CLI Scripts", ((DPAAApplicationProperties)this.model).getCliScriptsDirectory()), this.createComponent("Configuration Exports:", ((DPAAApplicationProperties)this.model).getConfigExportsDirectory()), this.createComponent("Domain Backups:", ((DPAAApplicationProperties)this.model).getDomainBackupsDirectory()), this.createComponent("File Backups:", ((DPAAApplicationProperties)this.model).getFileBackupDirectory()), this.createComponent("Packet Captures:", ((DPAAApplicationProperties)this.model).getPacketCaptureDirectory()), this.createComponent("Error Reports:", ((DPAAApplicationProperties)this.model).getErrorReportsDirectory()));
        return panel;
    }

    private LabeledComponent createComponent(String label, String preference) {
        JMLabel pref = new JMLabel(preference);
        this.contentLabels.add(pref);
        LabeledComponent lbl = new LabeledComponent(label, (Component)pref);
        return lbl;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void updateControls() {
        int i = 0;
        while (i < this.contentLabels.size()) {
            JMLabel label = this.contentLabels.get(i);
            switch (i) {
                case 0: {
                    label.setText(((DPAAApplicationProperties)this.model).getLogsDirectory());
                    break;
                }
                case 1: {
                    label.setText(((DPAAApplicationProperties)this.model).getCertificateFileDirectory());
                    break;
                }
                case 2: {
                    label.setText(((DPAAApplicationProperties)this.model).getSnapShotsDirectory());
                    break;
                }
                case 3: {
                    label.setText(((DPAAApplicationProperties)this.model).getCliScriptsDirectory());
                    break;
                }
                case 4: {
                    label.setText(((DPAAApplicationProperties)this.model).getConfigExportsDirectory());
                    break;
                }
                case 5: {
                    label.setText(((DPAAApplicationProperties)this.model).getDomainBackupsDirectory());
                    break;
                }
                case 6: {
                    label.setText(((DPAAApplicationProperties)this.model).getFileBackupDirectory());
                    break;
                }
                case 7: {
                    label.setText(((DPAAApplicationProperties)this.model).getPacketCaptureDirectory());
                    break;
                }
                case 8: {
                    label.setText(((DPAAApplicationProperties)this.model).getErrorReportsDirectory());
                }
            }
            ++i;
        }
    }
}

