/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.util.Index;
import com.jmorgan.util.ThreadUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.AddIPInterfaceListPanel;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.AddIPNewIPWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.AddIPPreviewWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.AddIPTypeWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.wizards.StandardWizardWelcomePage;
import java.util.ArrayList;
import javax.swing.JFrame;

public class AddIPWizardDialog
extends WizardDialog<DynamicBean> {
    public AddIPWizardDialog(JFrame owner, DynamicBean model) {
        super(owner, "Add IP Addresses");
        model.setProperty("allIPs", null);
        model.setProperty("isEthernet", true);
        model.setProperty("isLinkAggregation", false);
        model.setProperty("isVLAN", false);
        model.setProperty("isStandby", false);
        model.setProperty("isPrimary", false);
        model.setProperty("isSecondary", true);
        model.setProperty("ethernetInterface", null);
        model.setProperty("linkAggInterface", null);
        model.setProperty("vlanInterface", null);
        model.setProperty("newIPs", null);
        model.setProperty("createHostAliases", false);
        model.setProperty("hostAliases", null);
        model.setProperty("selectedInterfaces", null);
        new AsynchMethodInvoker((Object)this, "loadAllIPs", (Object)model);
        this.addWizardPage(new StandardWizardWelcomePage<DynamicBean>(model, "AddIPWelcomePage", "AddIPWelcomePage_centerControl"), "welcome");
        this.addWizardPage(new AddIPTypeWizardPage(model), "interfaceType");
        this.addWizardPage(new AddIPInterfaceListPanel(model), "interfaceList");
        this.addWizardPage(new AddIPNewIPWizardPage(model), "allIPs");
        this.addWizardPage(new AddIPPreviewWizardPage(model), "review");
        this.setSize(800, 600);
        this.startWizard();
    }

    @Reflected
    private void loadAllIPs(DynamicBean model) {
        ArrayList appliances = (ArrayList)Application.getApplication().getAttribute("Appliances");
        DataPowerStatusCache ipAddressStatus = new DataPowerStatusCache();
        for (Appliance appliance : appliances) {
            if (!appliance.isConnected()) continue;
            DataPowerStatusMonitor statusMonitor = new DataPowerStatusMonitor(appliance, appliance.getDomain("default"), "IPAddressStatus", 0L);
            statusMonitor.addStatusListener(ipAddressStatus);
        }
        while (!ipAddressStatus.isComplete()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        ArrayList ipAddresses = ipAddressStatus.getStatusCache();
        BeanIndexer indexer = new BeanIndexer(ipAddresses);
        Index ipIndex = indexer.getIndexOf("iP", null);
        model.setProperty("allIPs", ipIndex);
    }
}

