/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.config.ConfigIPInterface;
import com.kumbasoft.core.beans.types.StaticRoute;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JDialog;

public class AssignIPsToInterfacePage
extends KumbaCoreWizardPage<DynamicBean> {
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable table;
    private String action;

    public AssignIPsToInterfacePage(DynamicBean model) {
        super(model);
    }

    public AssignIPsToInterfacePage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void updateControls() {
        this.tableModel.reset();
        ArrayList<DynamicBean> tableData = this.prepareTableData();
        this.tableModel.addAll(tableData);
        this.table.optimizeColumnWidths();
    }

    @Override
    public boolean isDataValid() {
        this.table.commitEdits();
        int rowCount = this.tableModel.getRowCount();
        Index<Appliance, DynamicBean> applianceIndex = new Index<Appliance, DynamicBean>();
        int r = 0;
        while (r < rowCount) {
            DynamicBean rowValue = this.tableModel.getValue(r);
            Appliance appliance = (Appliance)rowValue.getProperty("destinationAppliance");
            applianceIndex.put(appliance, rowValue);
            ++r;
        }
        for (Appliance appliance : applianceIndex.getKeys()) {
            int numMainPrimaries = 0;
            int numVirtualPrimaries = 0;
            int numDefaultGateways = 0;
            for (DynamicBean rowValue : applianceIndex.get(appliance)) {
                String ipAddress = (String)rowValue.getProperty("ipAddress");
                String interfaceType = (String)rowValue.getProperty("destinationInterfaceType");
                String interfaceName = (String)rowValue.getProperty("destinationInterfaceName");
                boolean isPrimary = (Boolean)rowValue.getProperty("isPrimary");
                boolean isVirtual = (Boolean)rowValue.getProperty("isVirtual");
                boolean isDefaultGateway = (Boolean)rowValue.getProperty("isDefaultGateway");
                boolean isSecondary = (Boolean)rowValue.getProperty("isSecondary");
                boolean isSecondaryVirtual = (Boolean)rowValue.getProperty("isVirtualSecondary");
                int checksSelected = 0;
                if (isPrimary) {
                    ++checksSelected;
                    ++numMainPrimaries;
                }
                if (isVirtual) {
                    ++checksSelected;
                    ++numVirtualPrimaries;
                }
                if (isDefaultGateway) {
                    ++checksSelected;
                    ++numDefaultGateways;
                }
                if (isSecondary) {
                    ++checksSelected;
                }
                if (isSecondaryVirtual) {
                    ++checksSelected;
                }
                if (checksSelected > 1) {
                    new JMMessageBox((JDialog)this.parentDialog, "IP Conflict Error", LabelUtility.wrapInHTML(String.format("You cannot copy %s to more than one interface setting within %s's interfaces.<br/>Please correct your selections to ensure only one destination location is selected for each IP.", ipAddress, appliance.getName())));
                    return false;
                }
                if (!isPrimary && !isSecondary || ipAddress.contains("/")) continue;
                String ipType = isPrimary ? "Primary" : "Secondary";
                new JMMessageBox((JDialog)this.parentDialog, "IP Format Error", LabelUtility.wrapInHTML(String.format("<The format of %s for %s's %s %s %s.<br/>Please ensure the IP address conains the correct network mask.", ipAddress, appliance.getName(), ipType, interfaceType, interfaceName)));
                return false;
            }
            if (numMainPrimaries > 1 || numVirtualPrimaries > 1) {
                new JMMessageBox((JDialog)this.parentDialog, "IP Conflict Warning", LabelUtility.wrapInHTML(String.format("There is more than one value set to Main Primary or Standby Primary for %s.<br/>This will result in an invalid configuration.<br/>Please correct your settings ensuring there is no more than one IP for main and standby primary IPs.", appliance.getName())));
                return false;
            }
            if (numDefaultGateways <= true) continue;
            new JMMessageBox((JDialog)this.parentDialog, "IP Conflict Warning", LabelUtility.wrapInHTML(String.format("There is more than one value set as the default gateway for %s.<br/>This will result in an invalid configuration.<br/>Plese correct your settings ensuring there there is no more than one IP selected for default gateway.", appliance.getName())));
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        ArrayList<DynamicBean> finalData = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("finalData", finalData);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.action = (String)((DynamicBean)this.model).getProperty("action");
        this.tableModel = new DynamicBeanTableModel();
        this.tableModel.setEditableColumns("ipAddress", "isPrimary", "isSecondary", "isDefaultGateway", "isVirtual", "isVirtualSecondary");
        this.tableModel.addComputedExpression("sourceAppliance", "name");
        this.tableModel.addComputedExpression("destinationAppliance", "name");
        String srcTitle = this.action.equals("copy") ? "Copy From" : "Move From";
        String destTitle = this.action.equals("copy") ? "Copy To" : "Move To";
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.columnModel.setColumnOrder("sourceAppliance", "sourceInterfaceType", "sourceInterfaceName", "destinationAppliance", "destinationInterfaceType", "destinationInterfaceName", "ipAddress", "isPrimary", "isSecondary", "isVirtual", "isVirtualSecondary", "isDefaultGateway");
        this.columnModel.setColumnTitle("sourceAppliance", "From Appliance");
        this.columnModel.setColumnTitle("sourceInterfaceType", "Type");
        this.columnModel.setColumnTitle("sourceInterfaceName", srcTitle);
        this.columnModel.setColumnTitle("destinationAppliance", "To Appliance");
        this.columnModel.setColumnTitle("destinationInterfaceType", "Type");
        this.columnModel.setColumnTitle("destinationInterfaceName", destTitle);
        this.columnModel.setColumnTitle("isPrimary", "Main Primary");
        this.columnModel.setColumnTitle("isSecondary", "Main Secondary");
        this.columnModel.setColumnTitle("isVirtual", "Standby Primary");
        this.columnModel.setColumnTitle("isVirtualSecondary", "Standby Secondary");
        this.columnModel.setColumnTitle("isDefaultGateway", "Default Gateway");
        this.table = new JMTable(this.tableModel, this.columnModel);
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        panel.add((Component)new JMLabel("Assign IPs to Interface Properties:"), "North");
        panel.add((Component)new JMScrollPane(this.table), "Center");
        return panel;
    }

    private ArrayList<DynamicBean> prepareTableData() {
        ArrayList<DynamicBean> tableData = new ArrayList<DynamicBean>();
        ArrayList ethernetInterfaces = (ArrayList)((DynamicBean)this.model).getProperty("ethernetInterfaces");
        ArrayList linkAggInterfaces = (ArrayList)((DynamicBean)this.model).getProperty("linkAggregationInterfaces");
        ArrayList vlanInterfaces = (ArrayList)((DynamicBean)this.model).getProperty("vlanInterfaces");
        UniqueArrayList destinationAppliances = (UniqueArrayList)((DynamicBean)this.model).getProperty("destinationAppliances");
        ArrayList ipsToDelete = (ArrayList)((DynamicBean)this.model).getProperty("ipsToCopy");
        boolean isLinkAgg = (Boolean)((DynamicBean)this.model).getProperty("isLinkAggregation");
        boolean isVLAN = (Boolean)((DynamicBean)this.model).getProperty("isVLAN");
        String ethernetInterfaceName = (String)((DynamicBean)this.model).getProperty("destEthernetInterface");
        String linkAggInterfaceName = (String)((DynamicBean)this.model).getProperty("destLinkAggInterface");
        String vlanInterfaceName = (String)((DynamicBean)this.model).getProperty("destVlanInterface");
        String destinationInterfaceType = "EthernetInterface";
        String destinationInterfaceName = ethernetInterfaceName;
        if (isLinkAgg) {
            destinationInterfaceName = linkAggInterfaceName;
            destinationInterfaceType = "LinkAggInterface";
        } else if (isVLAN) {
            destinationInterfaceName = vlanInterfaceName;
            destinationInterfaceType = "VLANInterface";
        }
        for (DynamicBean ipToDelete : ipsToDelete) {
            Appliance sourceAppliance = (Appliance)ipToDelete.getProperty("appliance");
            String ipAddress = (String)ipToDelete.getProperty("ipAddress");
            String sourceInterfaceName = (String)ipToDelete.getProperty("sourceObjectName");
            String sourceInterfaceType = (String)ipToDelete.getProperty("sourceObjectType");
            ConfigIPInterface sourceInterface = null;
            sourceInterface = sourceInterfaceType.equals("EthernetInterface") ? AssignIPsToInterfacePage.getInterfaceOf(sourceAppliance, ethernetInterfaces, sourceInterfaceName) : (sourceInterfaceType.equals("LingAggInterface") ? AssignIPsToInterfacePage.getInterfaceOf(sourceAppliance, linkAggInterfaces, sourceInterfaceName) : AssignIPsToInterfacePage.getInterfaceOf(sourceAppliance, vlanInterfaces, sourceInterfaceName));
            boolean isPrimary = false;
            boolean isSecondary = false;
            boolean isVirtual = false;
            boolean isVirtualSecondary = false;
            boolean isDefaultGateway = false;
            boolean isStaticRouteDestination = false;
            boolean isStaticRouteNextHopRouter = false;
            String siIPAddress = sourceInterface.getIPAddress();
            String siDefaultGateway = sourceInterface.getDefaultGateway();
            String siVirtualIP = sourceInterface.getVirtualIP();
            if (!StringUtility.isEmpty(siIPAddress) && siIPAddress.startsWith(ipAddress)) {
                isPrimary = true;
            } else if (!StringUtility.isEmpty(siVirtualIP) && siVirtualIP.equals(ipAddress)) {
                isVirtual = true;
            } else if (!StringUtility.isEmpty(siDefaultGateway) && siDefaultGateway.equals(ipAddress)) {
                isDefaultGateway = true;
            } else if (CollectionUtility.containsElementStartingWith(sourceInterface.getSecondaryAddress(), ipAddress)) {
                isSecondary = true;
            } else if (CollectionUtility.containsElementStartingWith(sourceInterface.getSecondaryVirtualIP(), ipAddress)) {
                isVirtualSecondary = true;
            } else if (AssignIPsToInterfacePage.isStaticRouteDestination(sourceInterface.getStaticRoutes(), ipAddress)) {
                isStaticRouteDestination = true;
            } else if (AssignIPsToInterfacePage.isStaticRouteNextHopRouter(sourceInterface.getStaticRoutes(), ipAddress)) {
                isStaticRouteNextHopRouter = true;
            }
            if (isStaticRouteDestination || isStaticRouteNextHopRouter) continue;
            for (Appliance appliance : destinationAppliances) {
                DynamicBean destinationInfo = new DynamicBean();
                destinationInfo.setProperty("sourceAppliance", sourceAppliance);
                destinationInfo.setProperty("sourceInterfaceName", sourceInterfaceName);
                destinationInfo.setProperty("sourceInterfaceType", sourceInterfaceType);
                destinationInfo.setProperty("destinationAppliance", appliance);
                destinationInfo.setProperty("destinationInterfaceType", destinationInterfaceType);
                destinationInfo.setProperty("destinationInterfaceName", destinationInterfaceName);
                destinationInfo.setProperty("ipAddress", ipAddress);
                destinationInfo.setProperty("isPrimary", isPrimary);
                destinationInfo.setProperty("isSecondary", isSecondary);
                destinationInfo.setProperty("isVirtual", isVirtual);
                destinationInfo.setProperty("isVirtualSecondary", isVirtualSecondary);
                destinationInfo.setProperty("isDefaultGateway", isDefaultGateway);
                tableData.add(destinationInfo);
            }
        }
        return tableData;
    }

    private static boolean isStaticRouteDestination(ArrayList<StaticRoute> staticRouteList, String ipToFind) {
        if (CollectionUtility.isEmpty(staticRouteList)) {
            return false;
        }
        for (StaticRoute staticRoute : staticRouteList) {
            String destination = staticRoute.getDestination();
            if (!destination.startsWith(ipToFind)) continue;
            return true;
        }
        return false;
    }

    private static boolean isStaticRouteNextHopRouter(ArrayList<StaticRoute> staticRouteList, String ipToFind) {
        if (CollectionUtility.isEmpty(staticRouteList)) {
            return false;
        }
        for (StaticRoute staticRoute : staticRouteList) {
            String destination = staticRoute.getGateway();
            if (!destination.equals(ipToFind)) continue;
            return true;
        }
        return false;
    }

    private static ConfigIPInterface getInterfaceOf(Appliance appliance, ArrayList<? extends ConfigIPInterface> interfaces, String interfaceName) {
        if (interfaceName.endsWith("-vip")) {
            interfaceName = StringUtility.substringBefore(interfaceName, "-vip");
        }
        for (ConfigIPInterface configIPInterface : interfaces) {
            if (!configIPInterface.getAppliance().equals(appliance) || !configIPInterface.getName().equals(interfaceName)) continue;
            return configIPInterface;
        }
        return null;
    }
}

