/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.config.ConfigEthernetInterface;
import com.kumbasoft.core.beans.config.ConfigLinkAggregation;
import com.kumbasoft.core.beans.config.ConfigVLANInterface;
import com.kumbasoft.dpaa.ui.dialogs.ipWizard.AbstractIPInterfaceListPanel;
import java.util.ArrayList;

public class CopyMoveIPInterfaceListPanel
extends AbstractIPInterfaceListPanel {
    public CopyMoveIPInterfaceListPanel(DynamicBean model) {
        super(model);
    }

    public CopyMoveIPInterfaceListPanel(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    protected String getListModelEthernetInterfacesPropertyName() {
        return "destEthernetInterfaces";
    }

    @Override
    protected String getListModelLinkAggInterfacesPropertyName() {
        return "destLinkAggInterfaces";
    }

    @Override
    protected String getListModelVLANInterfacePropertyName() {
        return "destVlanInterfaces";
    }

    @Override
    protected void getSelectedInterfaceType() {
        super.getSelectedInterfaceType();
        this.loadInterfaces();
    }

    @Reflected
    private void loadInterfaces() {
        ArrayList destinationAppliances = (ArrayList)((DynamicBean)this.model).getProperty("destinationAppliances");
        Class interfaceTypeClass = null;
        String propertyName = null;
        if (this.isEthernet) {
            interfaceTypeClass = ConfigEthernetInterface.class;
            propertyName = this.getListModelEthernetInterfacesPropertyName();
        } else if (this.isLinkAgg) {
            interfaceTypeClass = ConfigLinkAggregation.class;
            propertyName = this.getListModelLinkAggInterfacesPropertyName();
        } else {
            interfaceTypeClass = ConfigVLANInterface.class;
            propertyName = this.getListModelVLANInterfacePropertyName();
        }
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<ConfigEthernetInterface> interfaces = configurationManager.getObjects(destinationAppliances, interfaceTypeClass, ".*");
        ((DynamicBean)this.model).setProperty(propertyName, interfaces);
    }

    @Override
    protected String getSavedEthernetInterfaceModelPropertyName() {
        return "destEthernetInterface";
    }

    @Override
    protected String getSavedLinkAggInterfaceModelPropertyName() {
        return "destLinkAggInterface";
    }

    @Override
    protected String getSavedVLANInterfaceModelPropertyName() {
        return "destVlanInterface";
    }
}

