/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.list.SimpleBeanListCellValueRenderer;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.ListModel;

public class DestinationApplianceSelectionPage
extends KumbaCoreWizardPage<DynamicBean> {
    private JMListModel<ApplianceGroupObject> applianceListModel;
    private JMList<ApplianceGroupObject> applianceList;

    public DestinationApplianceSelectionPage(DynamicBean model) {
        super(model);
    }

    public DestinationApplianceSelectionPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        int[] selectedRows = this.applianceList.getSelectedIndices();
        if (ArrayUtility.isEmpty(selectedRows)) {
            new JMMessageBox((JDialog)this.parentDialog, "Missing Selection", "You must select at least one destination appliance or group");
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        UniqueArrayList<Appliance> selectedAppliances = new UniqueArrayList<Appliance>();
        List selection = this.applianceList.getSelectedValuesList();
        for (ApplianceGroupObject ago : selection) {
            ArrayList<Appliance> appliances = ago.getAppliances();
            for (Appliance appliance : appliances) {
                if (!appliance.isConnected()) continue;
                selectedAppliances.addAll(appliances);
            }
        }
        ((DynamicBean)this.model).setProperty("destinationAppliances", selectedAppliances);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        ArrayList allAppliances = (ArrayList)Application.getApplication().getAttribute("Appliance Groups");
        ArrayList<ApplianceGroupObject> appliances = new ArrayList<ApplianceGroupObject>();
        for (ApplianceGroupObject ago : allAppliances) {
            if (ago.getGroupName().equals("All") || !ago.isConnected()) continue;
            appliances.add(ago);
        }
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMLabel label = new JMLabel("Destination Appliances");
        panel.add((Component)label, "North");
        this.applianceListModel = new JMListModel(appliances);
        this.applianceList = new JMList<ApplianceGroupObject>((ListModel<ApplianceGroupObject>)this.applianceListModel);
        this.applianceList.setCellRenderer(new JMListCellRenderer(new SimpleBeanListCellValueRenderer("groupName")));
        this.applianceList.setSelectionMode(2);
        panel.add((Component)new JMScrollPane(this.applianceList), "Center");
        return panel;
    }
}

