/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.config.ConfigHostAlias;
import com.kumbasoft.core.beans.config.ConfigIPInterface;
import com.kumbasoft.core.tools.AbstractUpdateConfiguration;
import com.kumbasoft.core.tools.AddIP;
import com.kumbasoft.core.tools.ConfigTool;
import java.util.ArrayList;

public class UpdateInterfaceIPs
extends AbstractUpdateConfiguration {
    private MultiThreadInvocationListener invocationListener;

    public UpdateInterfaceIPs(DynamicBean model, MultiThreadInvocationListener invocationListener) {
        super(model);
        this.invocationListener = invocationListener;
    }

    @Override
    @Reflected
    protected void updateConfigurations() {
        ArrayList selectedInterfaces = (ArrayList)this.model.getProperty("selectedInterfaces");
        UniqueArrayList selectedAppliances = (UniqueArrayList)this.model.getProperty("appliances");
        boolean isStandby = (Boolean)this.model.getProperty("isStandby");
        boolean isPrimary = (Boolean)this.model.getProperty("isPrimary");
        boolean isSecondary = (Boolean)this.model.getProperty("isSecondary");
        ArrayList newIPs = (ArrayList)this.model.getProperty("newIPs");
        boolean createHAs = (Boolean)this.model.getProperty("createHostAliases");
        ArrayList newHAs = (ArrayList)this.model.getProperty("hostAliases");
        for (Appliance appliance : selectedAppliances) {
            Domain domain = appliance.getDomain("default");
            ConfigIPInterface matchingInterface = UpdateInterfaceIPs.getInterfaceOfAppliance(appliance, selectedInterfaces);
            AddIP addIP = new AddIP(appliance, matchingInterface, newIPs, isPrimary, isSecondary, isStandby);
            addIP.addManagementCommandSubscriber(this.managementCommandSubscribers);
            String createTime = new DateTime().toString();
            if (!createHAs) continue;
            int i = 0;
            while (i < newIPs.size()) {
                String ipAddress = (String)newIPs.get(i);
                if (ipAddress.contains("/")) {
                    // empty if block
                }
                ipAddress = StringUtility.substringBefore(ipAddress, "/");
                String hostAlias = (String)newHAs.get(i);
                ConfigHostAlias newHA = new ConfigHostAlias();
                newHA.setAppliance(appliance);
                newHA.setAdminState("enabled");
                newHA.setUserSummary(String.format("Created by DPAA on %s", createTime));
                newHA.setIPAddress(ipAddress);
                newHA.setName(hostAlias);
                ConfigTool configTool = new ConfigTool(appliance, domain, newHA);
                this.invocationListener.addThread(configTool.getProcessThread());
                configTool.addManagementCommandSubscriber(this.managementCommandSubscribers);
                ++i;
            }
        }
    }

    private static ConfigIPInterface getInterfaceOfAppliance(Appliance appliance, ArrayList<ConfigIPInterface> interfaces) {
        for (ConfigIPInterface i : interfaces) {
            if (!i.getAppliance().equals(appliance)) continue;
            return i;
        }
        return null;
    }
}

