/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.manageListMembersWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MutableInteger;
import com.jmorgan.lang.MutableString;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.table.ComboBoxTableCellEditor;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionPropertySelector;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.ColumnEditorInfo;
import com.kumbasoft.core.ui.beans.ListPropertyTableEditorInfo;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.ui.editors.DPEnumerationTableCellEditor;
import com.kumbasoft.core.ui.editors.DPObjectListTableCellEditor;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.ui.dialogs.manageListMembersWizard.validators.Validator;
import java.awt.Component;
import java.beans.ExceptionListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ManageListPropertiesEditPage
extends KumbaCoreWizardPage<DynamicBean>
implements TableModelListener {
    private ListPropertyTableEditorInfo listPropertyTableEditorInfo;
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable containedTypeElementTable;
    private ArrayList<String> containingObjectNames;
    private JMCheckBox cbxSynchToSameServer;
    private JMButton btnAddNewElement;
    private JMButton btnSave;
    private JMButton btnOpen;
    private JMButton btnSelectAll;
    private JMButton btnSelectNone;
    private JMCheckBox cbxAppendList;
    private JMButton btnRenumber;
    private NumberField nfRenumberGap;
    private ArrayList<Integer> newRows;

    public ManageListPropertiesEditPage(DynamicBean model, String leftHelpFileName) {
        super(model, leftHelpFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Reflected
    private void getObjectConfigurations() {
        logger.finer("(): Starting");
        ArrayList selectedObjectList = (ArrayList)((DynamicBean)this.model).getProperty("selectedObjects");
        logger.finer(() -> LMG.log("(): Getting %d selected object configurations", () -> selectedObjectList.size()));
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> containingObjects = configurationManager.getObjects(selectedObjectList);
        logger.finer(() -> LMG.log("(): Got %d object configurations", () -> containingObjects.size()));
        ListPropertyTableEditorInfo listPropertyTableEditorInfo = (ListPropertyTableEditorInfo)((DynamicBean)this.model).getProperty("tableEditorInfo");
        String identityPropertyName = listPropertyTableEditorInfo.getIdentificationProperty();
        String containingType = listPropertyTableEditorInfo.getContainingType();
        logger.finer(() -> LMG.log("(): Sorting by: %s -> sourceDomain -> appliance", () -> identityPropertyName));
        BeanComparator sorter = new BeanComparator();
        sorter.addCompareProperties(identityPropertyName, "sourceDomain", "appliance");
        Collections.sort(containingObjects, sorter);
        ((DynamicBean)this.model).setProperty(containingType, containingObjects);
        logger.finer("(): Finished");
    }

    @Reflected
    private void fileNew() {
        logger.finer("(): Starting");
        this.containedTypeElementTable.commitEdits();
        if (this.newRows == null) {
            this.newRows = new ArrayList();
        } else {
            this.newRows.clear();
        }
        Index domains = (Index)((DynamicBean)this.model).getProperty("domains");
        try {
            Class<Object> containedType = this.listPropertyTableEditorInfo.getContainedTypeClass();
            if (containedType.equals(String.class)) {
                containedType = MutableString.class;
            }
            ArrayList<ColumnEditorInfo> columnEditorInfoList = this.listPropertyTableEditorInfo.getColumnInfo();
            Object newMember = this.listPropertyTableEditorInfo.createContainedTypeObject();
            for (ColumnEditorInfo columnEditorInfo : columnEditorInfoList) {
                String propertyName = columnEditorInfo.getPropertyName();
                String columnType = columnEditorInfo.getColumnType();
                String dataPowerType = columnEditorInfo.getDataPowerType();
                Object defaultValue = null;
                if (columnType.endsWith("ObjectReference")) {
                    try {
                        Object object = BeanService.getBean(dataPowerType);
                        ObjectReference<Object> objectReference = new ObjectReference<Object>();
                        objectReference.setClassName(StringUtility.getNthOfDelimited(dataPowerType, "."));
                        objectReference.setName(columnEditorInfo.getDefaultValue());
                        objectReference.setReferencedObject(object);
                        defaultValue = objectReference;
                    }
                    catch (ClassNotFoundException e) {
                        logger.severe(() -> LMG.log("Class %s for object reference not found.", () -> dataPowerType));
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        logger.severe(() -> LMG.log("Cannot create instance of %s for object reference.", () -> dataPowerType));
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        logger.severe(() -> LMG.log("Access forbidden trying to create instance of %s for object reference.", () -> dataPowerType));
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        logger.severe(() -> LMG.log("Illegal argument provided trying to create instance of %s for object reference.", () -> dataPowerType));
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        logger.severe(() -> LMG.log("Other error trying to create instance of %s for object reference.", () -> dataPowerType));
                        e.printStackTrace();
                    }
                } else {
                    defaultValue = columnEditorInfo.getDefaultValue();
                }
                if (defaultValue == null) continue;
                BeanService.setPropertyValue(newMember, propertyName, defaultValue);
            }
            for (Appliance appliance : domains.getKeys()) {
                for (Domain domain : domains.get(appliance)) {
                    for (String containerName : this.containingObjectNames) {
                        DynamicBean rowData = this.getListMemberRowData(newMember, appliance.getName(), domain.getName(), containerName, 1);
                        if (containedType.equals(MutableString.class)) {
                            rowData.removeProperty("bytes");
                            rowData.removeProperty("empty");
                            rowData.removeProperty("intern");
                            rowData.removeProperty("length");
                            rowData.removeProperty("toCharArray");
                            rowData.removeProperty("toLowerCase");
                            rowData.removeProperty("toUpperCase");
                            rowData.removeProperty("trim");
                        }
                        this.tableModel.addRow(rowData);
                    }
                }
            }
        }
        catch (PropertyNotFoundException | NullPointerException e) {
            e.printStackTrace();
        }
        this.containedTypeElementTable.optimizeColumnWidths();
        logger.finer("(): Done");
    }

    @Reflected
    private void fileOpen() {
        File inputFile = GUIServices.fileOpenDialog(null);
        if (inputFile == null) {
            return;
        }
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        DynamicBean inputData = (DynamicBean)FileUtility.readObject(inputFile, (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            new JMMessageBox(null, "Failed to read saved element set", "Error Reading Element Set");
        }
        if (inputData == null) {
            return;
        }
        ListPropertyTableEditorInfo inputEditorInfo = (ListPropertyTableEditorInfo)inputData.getProperty("elementInfo");
        ArrayList elementData = (ArrayList)inputData.getProperty("elementData");
        if (!inputEditorInfo.equals(this.listPropertyTableEditorInfo)) {
            String inputTitle = inputEditorInfo.getIdentificationTitle();
            String inputPropertyName = inputEditorInfo.getContainerPropertyName();
            inputPropertyName = StringUtility.getDisplayableTitle(inputPropertyName);
            inputPropertyName = StringUtility.pluralize(inputPropertyName);
            String thisTitle = this.listPropertyTableEditorInfo.getIdentificationTitle();
            String thisPropertyName = this.listPropertyTableEditorInfo.getContainerPropertyName();
            thisPropertyName = StringUtility.getDisplayableTitle(thisPropertyName);
            thisPropertyName = StringUtility.pluralize(thisPropertyName);
            String errorMessage = String.format("You opened a set of %s %s which is not\nthe same as this list of %s %s.\n\nPlease be sure to open element sets of the same type.", inputTitle, inputPropertyName, thisTitle, thisPropertyName);
            new JMMessageBox((JFrame)GUIApplication.getGUIApplication().getApplicationFrame(), "Incompatible Element Set", LabelUtility.wrapInHTML(errorMessage));
            return;
        }
        ArrayList selectedObjects = (ArrayList)((DynamicBean)this.model).getProperty("selectedObjects");
        Collection objectNameList = CollectionUtility.getPropertyValues(selectedObjects, "name");
        HashSet objectNames = new HashSet(objectNameList);
        String identificationModelProperty = this.listPropertyTableEditorInfo.getIdentificationModelProperty();
        for (DynamicBean element : elementData) {
            element.removeProperty("appliance");
            element.removeProperty("domain");
            element.removeProperty(identificationModelProperty);
        }
        List elementSet = elementData.stream().distinct().collect(Collectors.toList());
        Index domains = (Index)((DynamicBean)this.model).getProperty("domains");
        ArrayList<DynamicBean> newElementData = new ArrayList<DynamicBean>();
        for (Appliance appliance : domains.getKeys()) {
            for (Domain domain : domains.get(appliance)) {
                for (String objectName : objectNames) {
                    for (DynamicBean element : elementSet) {
                        DynamicBean newElement = BeanService.getClone(element);
                        newElement.setProperty("appliance", appliance.getName());
                        newElement.setProperty("domain", domain.getName());
                        newElement.setProperty(identificationModelProperty, objectName);
                        newElementData.add(newElement);
                    }
                }
            }
        }
        boolean append = this.cbxAppendList.isSelected();
        if (!append) {
            this.tableModel.reset();
        }
        this.tableModel.addAll(newElementData);
        this.containedTypeElementTable.optimizeColumnWidths();
    }

    @Reflected
    private void fileSave() {
        int rowCount = this.containedTypeElementTable.getRowCount();
        if (rowCount == 0) {
            return;
        }
        File outputFile = GUIServices.fileSaveDialog(null);
        if (outputFile == null) {
            return;
        }
        int[] selectedRows = this.containedTypeElementTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            selectedRows = new int[rowCount];
            int r = 0;
            while (r < rowCount) {
                selectedRows[r] = r;
                ++r;
            }
        }
        ArrayList<DynamicBean> elementData = new ArrayList<DynamicBean>(selectedRows.length);
        int r = 0;
        while (r < selectedRows.length) {
            DynamicBean rowData = this.tableModel.getValue(selectedRows[r]);
            elementData.add(rowData);
            ++r;
        }
        DynamicBean outputData = new DynamicBean();
        outputData.setProperty("elementInfo", this.listPropertyTableEditorInfo);
        outputData.setProperty("elementData", elementData);
        FileUtility.writeObject(outputFile, (Object)outputData);
    }

    @Reflected
    private void renumberElements() {
        ArrayList<DynamicBean> elements = null;
        int[] selectedRows = this.containedTypeElementTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            int rowCount = this.containedTypeElementTable.getRowCount();
            elements = new ArrayList(rowCount);
            int row = 0;
            while (row < rowCount) {
                elements.add(this.tableModel.getValue(row));
                ++row;
            }
        } else {
            elements = this.tableModel.getValues(selectedRows);
        }
        String identityPropertyName = this.listPropertyTableEditorInfo.getIdentificationModelProperty();
        HashMap renumberingMap = new HashMap();
        int numberGap = (int)this.nfRenumberGap.getNumber();
        for (DynamicBean element : elements) {
            String appliance = (String)element.getProperty("appliance");
            String domain = (String)element.getProperty("domain");
            String name = (String)element.getProperty(identityPropertyName);
            ArrayList<String> key = new ArrayList<String>(3);
            key.add(appliance);
            key.add(domain);
            key.add(name);
            MutableInteger currentNumber = (MutableInteger)renumberingMap.get(key);
            if (currentNumber == null) {
                currentNumber = new MutableInteger(numberGap);
                renumberingMap.put(key, currentNumber);
            } else {
                currentNumber.increment(numberGap);
            }
            element.setProperty("order", currentNumber.getValue());
        }
        this.containedTypeElementTable.repaint();
    }

    @Override
    public boolean isDataValid() {
        this.containedTypeElementTable.commitEdits();
        ArrayList<ColumnEditorInfo> columnEditorInfoList = this.listPropertyTableEditorInfo.getColumnInfo();
        String fieldName = "";
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            DynamicBean rowData = this.tableModel.getValue(i);
            boolean deleted = (Boolean)rowData.getProperty("delete");
            if (!deleted) {
                String message;
                String title;
                boolean fieldsRequired = false;
                boolean fieldsValid = true;
                for (ColumnEditorInfo cei : columnEditorInfoList) {
                    if (cei.isHidden()) continue;
                    boolean isRequired = cei.isRequired();
                    String propertyName = cei.getPropertyName();
                    Object value = rowData.getProperty(propertyName);
                    fieldName = cei.getColumnTitle();
                    String sValue = String.valueOf(value);
                    if (isRequired && (value == null || StringUtility.isEmpty(sValue))) {
                        fieldsRequired = true;
                        break;
                    }
                    String validator = cei.getValidator();
                    if (!StringUtility.isNotEmpty(validator)) continue;
                    if (validator.startsWith("com.kumbasoft")) {
                        try {
                            Validator validatorInstance = (Validator)BeanService.getBean(validator);
                            if (validatorInstance.isValid(this.tableModel, rowData, propertyName, sValue)) continue;
                            fieldsValid = false;
                            break;
                        }
                        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (sValue.matches(validator)) continue;
                    fieldsValid = false;
                    break;
                }
                if (fieldsRequired) {
                    title = String.format("All %s must be provided", StringUtility.pluralize(fieldName));
                    message = String.format("Missing %s", fieldName);
                    new JMMessageBox((JDialog)this.parentDialog, title, message);
                    return false;
                }
                if (!fieldsValid) {
                    title = String.format("%s is not valid", StringUtility.pluralize(fieldName));
                    message = String.format("%s is present but not valid.  Please correct the value and try again.", fieldName);
                    new JMMessageBox((JDialog)this.parentDialog, title, message);
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void updateControls() {
        logger.finer("(): Starting");
        ArrayList containingObjects = null;
        String containingType = this.listPropertyTableEditorInfo.getContainingType();
        String containerPropertyName = this.listPropertyTableEditorInfo.getContainerPropertyName();
        String identityPropertyName = this.listPropertyTableEditorInfo.getIdentificationProperty();
        logger.finer(() -> LMG.log("(): Containing Type: %s, Container Property Name: %s, Identity Property Name=%s", () -> containingType, () -> containerPropertyName, () -> identityPropertyName));
        containingObjects = (ArrayList)((DynamicBean)this.model).getProperty(containingType);
        while (containingObjects == null) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            containingObjects = (ArrayList)((DynamicBean)this.model).getProperty(containingType);
        }
        int containedObjectCount = containingObjects.size();
        logger.finer(() -> LMG.log("(): Obtained %d containing (selected) objects", () -> containedObjectCount));
        if (this.containingObjectNames == null) {
            CollectionPropertySelector containerIdentitySelector = new CollectionPropertySelector(containingObjects);
            Collection<String> containingObjectNameList = containerIdentitySelector.get(identityPropertyName, String.class);
            this.containingObjectNames = new UniqueArrayList<String>(containingObjectNameList);
        }
        logger.finer("(): Building table data.");
        ArrayList<DynamicBean> tableData = new ArrayList<DynamicBean>();
        for (DataPowerConfig containingObject : containingObjects) {
            String applianceName = containingObject.getAppliance().getName();
            String domainName = containingObject.getSourceDomain().getName();
            String identityName = (String)BeanService.getPropertyValue(containingObject, identityPropertyName);
            logger.finer(() -> LMG.log("(): Getting %s from %s from %s and %s", () -> containerPropertyName, () -> identityName, () -> applianceName, () -> domainName));
            ArrayList listElements = (ArrayList)BeanService.getPropertyValue(containingObject, containerPropertyName);
            if (CollectionUtility.isEmpty(listElements)) {
                logger.fine(() -> LMG.log("(): No elements of %s from %s from %s and %s", () -> containerPropertyName, () -> identityName, () -> applianceName, () -> domainName));
                continue;
            }
            logger.finer(() -> LMG.log("(): Got %d elements of %s from %s from %s and %s", () -> listElements.size(), () -> containerPropertyName, () -> identityName, () -> applianceName, () -> domainName));
            int elementOrder = 0;
            for (Object listMember : listElements) {
                DynamicBean rowData = this.getListMemberRowData(listMember, applianceName, domainName, identityName, ++elementOrder);
                tableData.add(rowData);
            }
        }
        this.tableModel.addAll(tableData);
        this.containedTypeElementTable.optimizeColumnWidths();
        this.tableModel.addTableModelListener(this);
        logger.finer("(): Done");
    }

    private DynamicBean getListMemberRowData(Object listMember, String applianceName, String domainName, String identityName, int elementOrder) {
        ArrayList<ColumnEditorInfo> columnEditorInfoList = this.listPropertyTableEditorInfo.getColumnInfo();
        String identificationModelProperty = this.listPropertyTableEditorInfo.getIdentificationModelProperty();
        boolean areElementsOrdered = this.listPropertyTableEditorInfo.isAreRowsOrdered();
        DynamicBean rowData = new DynamicBean(listMember);
        for (ColumnEditorInfo columnEditorInfo : columnEditorInfoList) {
            String columnPropertyName;
            ObjectReference referencedObject;
            boolean isHidden = columnEditorInfo.isHidden();
            if (isHidden) {
                String propertyName = columnEditorInfo.getPropertyName();
                rowData.removeProperty(propertyName);
                continue;
            }
            String columnType = columnEditorInfo.getColumnType();
            if (!columnType.endsWith("ObjectReference") || (referencedObject = (ObjectReference)rowData.getProperty(columnPropertyName = columnEditorInfo.getPropertyName())) == null) continue;
            String referencedObjectName = referencedObject.getName();
            rowData.setProperty(columnPropertyName, referencedObjectName);
        }
        rowData.setProperty("appliance", applianceName);
        rowData.setProperty("domain", domainName);
        rowData.setProperty(identificationModelProperty, identityName);
        if (areElementsOrdered) {
            rowData.setProperty("order", elementOrder);
        }
        rowData.setProperty("delete", false);
        return rowData;
    }

    @Override
    protected void saveDataToModel() {
        this.containedTypeElementTable.commitEdits();
        String containingType = this.listPropertyTableEditorInfo.getContainingType();
        String containerPropertyName = this.listPropertyTableEditorInfo.getContainerPropertyName();
        String addMethodName = String.format("add%s", StringUtility.capitalize(containerPropertyName));
        String identificationModelProperty = this.listPropertyTableEditorInfo.getIdentificationModelProperty();
        boolean areElementsOrdered = this.listPropertyTableEditorInfo.isAreRowsOrdered();
        ArrayList containingObjects = (ArrayList)((DynamicBean)this.model).getProperty(containingType);
        for (DataPowerConfig containingObject : containingObjects) {
            BeanService.setPropertyValue(containingObject, containerPropertyName, null);
        }
        ArrayList<String> orderBy = new ArrayList<String>();
        if (areElementsOrdered) {
            orderBy.add("order");
        }
        orderBy.add(identificationModelProperty);
        BeanComparator dataSorter = new BeanComparator(orderBy);
        ArrayList<DynamicBean> tableData = this.tableModel.getModelData();
        Collections.sort(tableData, dataSorter);
        for (DynamicBean rowData : tableData) {
            Object element;
            boolean isDeleted = (Boolean)rowData.getProperty("delete");
            if (isDeleted || (element = this.listPropertyTableEditorInfo.createContainedTypeObject()) == null) continue;
            if (element instanceof MutableString) {
                element = new String((String)rowData.getProperty("string"));
            } else if (element instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)element;
                String referenceName = (String)rowData.getProperty("name");
                String className = (String)rowData.getProperty("className");
                objectReference.setClassName(className);
                objectReference.setName(referenceName);
            } else {
                ArrayList<String> elementPropertyNames = BeanService.getPropertyNames(element);
                for (String elementPropertyName : elementPropertyNames) {
                    Method accessor = BeanService.getPropertyAccessor(element, elementPropertyName);
                    XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
                    String javaType = xmlInfo.javaType();
                    ColumnEditorInfo cei = this.listPropertyTableEditorInfo.getMatchingColumnEditorInfo(elementPropertyName);
                    if (!javaType.startsWith("ObjectReference")) continue;
                    ObjectReference objectReference = new ObjectReference();
                    String name = (String)rowData.getProperty(elementPropertyName);
                    String dataPowerType = cei.getDataPowerType();
                    String baseType = StringUtility.getNthOfDelimited(dataPowerType, ".");
                    if (baseType.startsWith("Config")) {
                        baseType = baseType.substring(6);
                    }
                    objectReference.setName(name);
                    objectReference.setClassName(baseType);
                    rowData.setProperty(elementPropertyName, objectReference);
                }
                rowData.toObject(element);
            }
            String applianceName = (String)rowData.getProperty("appliance");
            String domainName = (String)rowData.getProperty("domain");
            String identityProperty = (String)rowData.getProperty(identificationModelProperty);
            for (DataPowerConfig containingObject : containingObjects) {
                if (!containingObject.getAppliance().getName().equals(applianceName) || !containingObject.getSourceDomain().getName().equals(domainName) || !containingObject.getName().equals(identityProperty)) continue;
                MethodInvoker mi = new MethodInvoker((Object)containingObject, addMethodName, element);
                mi.invoke();
            }
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        new AsynchMethodInvoker((Object)this, "getObjectConfigurations");
        Index userSelectedDomains = (Index)((DynamicBean)this.model).getProperty("domains");
        this.listPropertyTableEditorInfo = (ListPropertyTableEditorInfo)((DynamicBean)this.model).getProperty("tableEditorInfo");
        boolean areElementsOrdered = this.listPropertyTableEditorInfo.isAreRowsOrdered();
        KumbaCoreWizardPanel tablePanel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMPanel topPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        this.cbxSynchToSameServer = new JMCheckBox("Synchronize changes to same named elements", true);
        this.btnAddNewElement = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, "", "Add a new entry to the table", true, this, "fileNew", new Object[0]);
        String containerPropertyName = this.listPropertyTableEditorInfo.getContainerPropertyName();
        containerPropertyName = StringUtility.getDisplayableTitle(containerPropertyName);
        containerPropertyName = StringUtility.pluralize(containerPropertyName);
        String appendToolTip = String.format("If selected, when loading elements from a saved set,\nappends the list with the %s %s loaded.\n\nIf not selected, the current list will be replaced\nwith the loaded elements.", this.listPropertyTableEditorInfo.getIdentificationTitle(), containerPropertyName);
        this.cbxAppendList = ComponentFactory.createCheckbox(null, "Append", LabelUtility.wrapInHTML(appendToolTip), false, true, null, null, new Object[0]);
        this.btnOpen = ComponentFactory.createButton(KumbaCoreUIConstants.OPEN_ICON, "", "Load elements from a previously saved set.", true, this, "fileOpen", new Object[0]);
        this.btnSave = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, "", "Save all or the selected elements to a named set.", true, this, "fileSave", new Object[0]);
        this.btnSelectAll = ComponentFactory.createButton(KumbaCoreUIConstants.SELECT_ALL_ICON, "", "Select All Elements", true, null, null, new Object[0]);
        this.btnSelectNone = ComponentFactory.createButton(KumbaCoreUIConstants.SELECT_NONE_ICON, "", "De-select All Elements", true, null, null, new Object[0]);
        if (areElementsOrdered) {
            this.btnRenumber = ComponentFactory.createButton(null, "Renumber", "Renumber the elements by the renumber gap", true, this, "renumberElements", new Object[0]);
            this.nfRenumberGap = new NumberField(10.0);
            NumberSpinner nsRenumberGap = new NumberSpinner(this.nfRenumberGap, 10.0, 1.0, 100.0);
            topPanel.addAll(this.btnAddNewElement, ComponentFactory.createSpacer(20, 25), this.btnSelectAll, this.btnSelectNone, ComponentFactory.createSpacer(20, 25), this.cbxAppendList, this.btnOpen, this.btnSave, ComponentFactory.createSpacer(20, 25), nsRenumberGap, this.btnRenumber, ComponentFactory.createSpacer(20, 25), this.cbxSynchToSameServer);
        } else {
            topPanel.addAll(this.btnAddNewElement, ComponentFactory.createSpacer(20, 25), this.btnSelectAll, this.btnSelectNone, ComponentFactory.createSpacer(20, 25), this.cbxAppendList, this.btnOpen, this.btnSave, ComponentFactory.createSpacer(20, 25), this.cbxSynchToSameServer);
        }
        tablePanel.add((Component)topPanel, "North");
        this.tableModel = new DynamicBeanTableModel();
        String containedType = this.listPropertyTableEditorInfo.getContainedType();
        ArrayList<ColumnEditorInfo> columnEditorInfoList = this.listPropertyTableEditorInfo.getColumnInfo();
        ArrayList<String> editableColumns = new ArrayList<String>();
        ArrayList<String> columnsInOrder = new ArrayList<String>();
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        BeanComparator sorter = new BeanComparator();
        sorter.addCompareProperties("columnOrder");
        Collections.sort(columnEditorInfoList, sorter);
        String identificationTitle = this.listPropertyTableEditorInfo.getIdentificationTitle();
        String identificationModelProperty = this.listPropertyTableEditorInfo.getIdentificationModelProperty();
        columnsInOrder.add("appliance");
        columnsInOrder.add("domain");
        columnsInOrder.add(identificationModelProperty);
        for (ColumnEditorInfo columnEditorInfo : columnEditorInfoList) {
            String columnName = columnEditorInfo.getPropertyName();
            boolean hidden = columnEditorInfo.isHidden();
            if (hidden) {
                hiddenColumns.add(columnName);
                continue;
            }
            boolean editable = columnEditorInfo.isEditable();
            if (editable) {
                editableColumns.add(columnName);
            }
            columnsInOrder.add(columnName);
        }
        if (areElementsOrdered) {
            columnsInOrder.add("order");
            editableColumns.add("order");
        }
        columnsInOrder.add("delete");
        editableColumns.add("delete");
        this.tableModel.setEditableColumns(editableColumns);
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.columnModel.hideColumns(hiddenColumns);
        this.columnModel.setColumnOrder(columnsInOrder);
        this.columnModel.setColumnTitle("appliance", "Appliance");
        this.columnModel.setColumnTitle("domain", "Domain");
        this.columnModel.setColumnTitle(identificationModelProperty, identificationTitle);
        if (containedType.equals("com.kumbasoft.core.beans.ObjectReference")) {
            BeanIndexer<ColumnEditorInfo> columnEditorIndexer = new BeanIndexer<ColumnEditorInfo>(columnEditorInfoList);
            HashMap<String, ColumnEditorInfo> columnEditorMap = columnEditorIndexer.getMapOf("propertyName", "");
            ColumnEditorInfo nameEditorInfo = columnEditorMap.get("name");
            String nameTitle = nameEditorInfo.getColumnTitle();
            this.columnModel.setColumnTitle("name", nameTitle);
            String objectType = nameEditorInfo.getDataPowerType();
            DPObjectListTableCellEditor nameCellEditor = new DPObjectListTableCellEditor(userSelectedDomains, objectType, "name", nameEditorInfo.isRequired());
            nameCellEditor.setFilterProperty("dataPowerClass");
            this.columnModel.setEditor("name", nameCellEditor);
            ColumnEditorInfo classNameEditorInfo = columnEditorMap.get("className");
            String classNameTitle = classNameEditorInfo.getColumnTitle();
            this.columnModel.setColumnTitle("className", classNameTitle);
            boolean classNameEditable = classNameEditorInfo.isEditable();
            if (classNameEditable) {
                DPObjectListTableCellEditor cellEditor = new DPObjectListTableCellEditor(userSelectedDomains, objectType, "dataPowerClass", nameEditorInfo.isRequired());
                this.columnModel.setEditor("className", cellEditor);
                classNameEditorInfo.setCellEditor(cellEditor);
            }
        } else {
            for (ColumnEditorInfo columnEditorInfo : columnEditorInfoList) {
                String dataPowerType;
                ComboBoxTableCellEditor cellEditor;
                if (columnEditorInfo.isHidden()) continue;
                String propertyName = columnEditorInfo.getPropertyName();
                String columnTitle = columnEditorInfo.getColumnTitle();
                this.columnModel.setColumnTitle(propertyName, columnTitle);
                boolean isEnumeration = columnEditorInfo.isEnumeration();
                if (isEnumeration) {
                    String enumerationName = columnEditorInfo.getEnumerationPropertyName();
                    cellEditor = new DPEnumerationTableCellEditor(enumerationName);
                    this.columnModel.setEditor(propertyName, cellEditor);
                }
                if (!(dataPowerType = columnEditorInfo.getDataPowerType()).startsWith("com.kumbasoft.core.beans.config.Config")) continue;
                cellEditor = new DPObjectListTableCellEditor(userSelectedDomains, dataPowerType, "name", columnEditorInfo.isRequired());
                this.columnModel.setEditor(propertyName, cellEditor);
                columnEditorInfo.setCellEditor((DPObjectListTableCellEditor)cellEditor);
            }
        }
        if (areElementsOrdered) {
            this.columnModel.setColumnTitle("order", "Order");
        }
        this.columnModel.setColumnTitle("delete", "Delete?");
        this.containedTypeElementTable = new JMTable(this.tableModel, this.columnModel);
        tablePanel.add(new JMScrollPane(this.containedTypeElementTable));
        new ActionEventInvoker(this.btnSelectAll, this.containedTypeElementTable, "selectAll");
        new ActionEventInvoker(this.btnSelectNone, this.containedTypeElementTable, "clearSelection");
        return tablePanel;
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (!this.cbxSynchToSameServer.isSelected()) {
            return;
        }
        ExtendedTableModelEvent tableModelEvent = (ExtendedTableModelEvent)evt;
        if (tableModelEvent.getType() == 1) {
            int row = tableModelEvent.getFirstRow();
            if (this.newRows == null) {
                this.newRows = new ArrayList();
            }
            this.newRows.add(row);
            return;
        }
        if (tableModelEvent.getType() == 0) {
            int row = tableModelEvent.getFirstRow();
            Object oldValue = tableModelEvent.getOldValue();
            if (row == -1) {
                return;
            }
            int column = tableModelEvent.getColumn();
            String columnName = this.tableModel.getColumnName(column);
            boolean isNewRow = this.newRows == null ? false : this.newRows.contains(row);
            String identificationModelProperty = this.listPropertyTableEditorInfo.getIdentificationModelProperty();
            String containedType = this.listPropertyTableEditorInfo.getContainedType();
            boolean isObjectReference = containedType.equals("com.kumbasoft.core.beans.ObjectReference");
            ArrayList<String> columnIdentificationProperties = this.listPropertyTableEditorInfo.getContainedIdentificationPropertiesList();
            int initialSize = columnIdentificationProperties == null ? 0 : columnIdentificationProperties.size();
            HashMap<String, CallSite> columnIdentificationPropertyValues = new HashMap<String, CallSite>(initialSize);
            DynamicBean rowData = this.tableModel.getValue(row);
            if (columnIdentificationProperties != null) {
                for (String columnIdentificationProperty : columnIdentificationProperties) {
                    String propertyValue = columnName.equals(columnIdentificationProperty) ? String.valueOf(oldValue) : rowData.getProperty(columnIdentificationProperty);
                    columnIdentificationPropertyValues.put(columnIdentificationProperty, (CallSite)((Object)propertyValue));
                }
            }
            Object value = rowData.getProperty(columnName);
            String containingObjectName = (String)rowData.getProperty(identificationModelProperty);
            int r = 0;
            while (r < this.tableModel.getRowCount()) {
                DynamicBean rData;
                String containedObjectName;
                if (r != row && (!isNewRow || this.newRows.contains(r)) && (containedObjectName = (String)(rData = this.tableModel.getValue(r)).getProperty(identificationModelProperty)).equals(containingObjectName)) {
                    boolean isMatching = true;
                    if (CollectionUtility.isNotEmpty(columnIdentificationProperties)) {
                        for (String columnIdentificationProperty : columnIdentificationProperties) {
                            String sValue;
                            Object rValue = rData.getProperty(columnIdentificationProperty);
                            Object idValue = columnIdentificationPropertyValues.get(columnIdentificationProperty);
                            if (rValue instanceof String && StringUtility.isEmpty(sValue = (String)rValue) || rValue == null || rValue.equals(idValue)) continue;
                            isMatching = false;
                            break;
                        }
                    }
                    if (isMatching) {
                        logger.fine(() -> LMG.log("(TableModelEvent e): Synchronizing Property: %s=%s", () -> columnName, () -> value));
                        rData.setProperty(columnName, value);
                    }
                }
                ++r;
            }
            if (isObjectReference && columnName.equals("className")) {
                logger.finest(() -> LMG.log("(TableModelEvent e): Setting class filter to %s", () -> value.toString()));
                DPObjectListTableCellEditor cellEditor = (DPObjectListTableCellEditor)this.columnModel.getEditor("name");
                cellEditor.setFilterPropertyValue(value.toString());
                ArrayList<String> displayedElements = cellEditor.getDisplayedElements();
                int nameColumn = this.tableModel.getColumnIndex("name");
                this.tableModel.setValueAt(displayedElements.get(0), row, nameColumn);
            }
            this.containedTypeElementTable.repaint();
        }
    }
}

