/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.migrateWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationRelationship;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoProfile;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MigrateProxyProfileFinalWizardPage
extends AbstractTableWizardPage
implements TableModelListener {
    private HashMap<StatusObjectStatus, ConfigurationRelationship> relationshipMap;
    private HashMap<StatusObjectStatus, SingleThreadInvocationListener> relationshipThreads;
    private boolean nextButtonEnabled = false;

    public MigrateProxyProfileFinalWizardPage(DynamicBean model) {
        super(model);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        new AsynchMethodInvoker((Object)this, "getProxyProfileReferences");
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.tableModel.addTableModelListener(this);
        return panel;
    }

    @Reflected
    private void getProxyProfileReferences() {
        ArrayList proxyProfiles = (ArrayList)((DynamicBean)this.model).getProperty("proxyProfiles");
        this.relationshipMap = new HashMap();
        this.relationshipThreads = new HashMap();
        for (StatusObjectStatus proxyProfile : proxyProfiles) {
            SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
            ConfigurationRelationship cr = new ConfigurationRelationship(proxyProfile, ConfigurationRelationshipType.CHILD_UP);
            cr.getSetupThread().addInvocationListener(stil);
            this.relationshipMap.put(proxyProfile, cr);
            this.relationshipThreads.put(proxyProfile, stil);
        }
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        Appliance appliance = new Appliance();
        appliance.setName(" ".repeat(20));
        Domain domain = new Domain();
        domain.setName(" ".repeat(20));
        DynamicBean row = new DynamicBean();
        row.setProperty("appliance", appliance);
        row.setProperty("domain", domain);
        row.setProperty("objectType", " ".repeat(20));
        row.setProperty("objectName", " ".repeat(20));
        row.setProperty("action", 0);
        row.setProperty("description", " ".repeat(80));
        tableModel.addRow(row);
        tableModel.addComputedExpression("appliance", "name");
        tableModel.addComputedExpression("domain", "name");
        return tableModel;
    }

    private <ObjectType> ObjectType getExistingObject(Appliance appliance, Domain domain, String name, HashMap<Appliance, Index<Domain, ObjectType>> objectMap) {
        Index<Domain, ObjectType> objectsByAppliance = objectMap.get(appliance);
        if (CollectionUtility.isEmpty(objectsByAppliance)) {
            return null;
        }
        Collection<ObjectType> objectsByDomain = objectsByAppliance.get(domain);
        if (CollectionUtility.isEmpty(objectsByDomain)) {
            return null;
        }
        PropertyValueSelector<ObjectType> nameSelector = new PropertyValueSelector<ObjectType>(objectsByDomain);
        nameSelector.addPropertyValueMap("name", name);
        Collection objectsByName = nameSelector.getSelectedElements();
        if (CollectionUtility.isEmpty(objectsByName)) {
            return null;
        }
        Object object = CollectionUtility.get(objectsByName, 0);
        return (ObjectType)object;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel model = super.createColumnModel();
        model.hideColumn("action");
        model.setColumnOrder("appliance", "domain", "objectType", "objectName", "description");
        return model;
    }

    @Override
    protected void updateControls() {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.tableModel.reset();
        this.table.repaint();
        new AsynchMethodInvoker((Object)this, "createAllData");
    }

    @Reflected
    private void createAllData() {
        ArrayList proxyProfileConfigurations = (ArrayList)((DynamicBean)this.model).getProperty("proxyProfileConfigs");
        HashMap proxyProfileConfigMap = DataStructureUtility.mapByApplianceDomain(proxyProfileConfigurations);
        HashMap clientProfileMap = (HashMap)((DynamicBean)this.model).getProperty("clientProfiles");
        HashMap serverProfileMap = (HashMap)((DynamicBean)this.model).getProperty("serverProfiles");
        ArrayList refactorData = (ArrayList)((DynamicBean)this.model).getProperty("refactorData");
        boolean removeProxyProfiles = (Boolean)((DynamicBean)this.model).getProperty("removeProxyProfiles");
        for (DynamicBean refactorInfo : refactorData) {
            boolean completedOnTime;
            Appliance appliance = (Appliance)refactorInfo.getProperty("appliance");
            Domain domain = (Domain)refactorInfo.getProperty("domain");
            String sslProxyProfileName = (String)refactorInfo.getProperty("objectName");
            String serverProfileName = (String)refactorInfo.getProperty("serverProfile");
            String clientProfileName = (String)refactorInfo.getProperty("clientProfile");
            ConfigSSLProxyProfile proxyProfile = (ConfigSSLProxyProfile)this.getExistingObject(appliance, domain, sslProxyProfileName, proxyProfileConfigMap);
            String proxyProfileDirection = proxyProfile.getDirection();
            StatusObjectStatus proxyProfileStatus = proxyProfile.getStatus();
            SingleThreadInvocationListener stil = this.relationshipThreads.get(proxyProfileStatus);
            if (!stil.invocationComplete() && !(completedOnTime = stil.waitForCompletion(KumbaCoreConstants.SOMA_READ_TIMEOUT))) {
                logger.warning(() -> LMG.log("(): Refactoring discovery thread did not complete on time for Proxy Profile '%s' in the '%s' domain of '%s'. Continuing though refactor may not complete propertly.", () -> proxyProfileStatus.getName(), () -> proxyProfileStatus.getSourceDomain().getName(), () -> proxyProfileStatus.getAppliance().getName()));
            }
            ConfigurationRelationship cr = this.relationshipMap.get(proxyProfileStatus);
            ArrayList<ConfigurationRelationship> proxyProfileReferences = cr.getReferences();
            ObjectReference<ConfigCryptoProfile> forwardCryptoProfile = proxyProfile.getForwardCryptoProfile();
            String forwardCryptoProfileName = forwardCryptoProfile == null ? null : forwardCryptoProfile.getName();
            ObjectReference<ConfigCryptoProfile> reverseCryptoProfile = proxyProfile.getReverseCryptoProfile();
            String reverseCryptoProfileName = reverseCryptoProfile == null ? null : reverseCryptoProfile.getName();
            ConfigSSLServerProfile serverProfile = (ConfigSSLServerProfile)this.getExistingObject(appliance, domain, serverProfileName, serverProfileMap);
            ConfigSSLClientProfile clientProfile = (ConfigSSLClientProfile)this.getExistingObject(appliance, domain, clientProfileName, clientProfileMap);
            boolean isReverse = proxyProfileDirection.equals("two-way") || proxyProfileDirection.equals("reverse");
            boolean isForward = proxyProfileDirection.equals("two-way") || proxyProfileDirection.equals("forward");
            DynamicBean row = new DynamicBean();
            row.setProperty("proxyProfile", proxyProfile);
            String description = "";
            if (isReverse && serverProfile == null) {
                row.setProperty("appliance", appliance);
                row.setProperty("domain", domain);
                row.setProperty("objectType", "SSLServerProfile");
                row.setProperty("objectName", serverProfileName);
                row.setProperty("action", 0);
                description = String.format("Create TLS Server Profile '%s'", serverProfileName);
                row.setProperty("description", description);
                this.tableModel.addRow(row);
            }
            if (isForward && clientProfile == null) {
                row = new DynamicBean();
                row.setProperty("proxyProfile", proxyProfile);
                row.setProperty("appliance", appliance);
                row.setProperty("domain", domain);
                row.setProperty("objectType", "SSLClientProfile");
                row.setProperty("objectName", clientProfileName);
                row.setProperty("action", 0);
                description = String.format("Create TLS Client Profile '%s'", clientProfileName);
                row.setProperty("description", description);
                this.tableModel.addRow(row);
            }
            HashSet<DataPowerConfig> refactoredObjects = new HashSet<DataPowerConfig>();
            for (ConfigurationRelationship parentRelationship : proxyProfileReferences) {
                DataPowerConfig parentObject = parentRelationship.getObjectInFocus();
                if (refactoredObjects.contains(parentObject)) continue;
                row = new DynamicBean();
                row.setProperty("proxyProfile", proxyProfile);
                row.setProperty("appliance", appliance);
                row.setProperty("domain", domain);
                row.setProperty("objectType", parentObject.getConfigObjectType());
                row.setProperty("objectName", parentObject.getName());
                row.setProperty("action", 1);
                description = String.format("Refactor reference from '%s'", parentObject.getName());
                row.setProperty("description", description);
                this.tableModel.addRow(row);
                refactoredObjects.add(parentObject);
            }
            if (!removeProxyProfiles) continue;
            row = new DynamicBean();
            row.setProperty("proxyProfile", proxyProfile);
            row.setProperty("appliance", appliance);
            row.setProperty("domain", domain);
            row.setProperty("objectType", proxyProfile.getConfigObjectType());
            row.setProperty("objectName", proxyProfile.getName());
            row.setProperty("action", 2);
            description = String.format("Delete proxy profile '%s'", proxyProfile.getName());
            row.setProperty("description", description);
            this.tableModel.addRow(row);
            if (isReverse) {
                row = new DynamicBean();
                row.setProperty("proxyProfile", proxyProfile);
                row.setProperty("appliance", appliance);
                row.setProperty("domain", domain);
                row.setProperty("objectType", reverseCryptoProfile.getClassName());
                row.setProperty("objectName", reverseCryptoProfileName);
                row.setProperty("action", 2);
                description = String.format("Delete crypto profile '%s'", reverseCryptoProfileName);
                row.setProperty("description", description);
                this.tableModel.addRow(row);
            }
            if (!isForward) continue;
            row = new DynamicBean();
            row.setProperty("proxyProfile", proxyProfile);
            row.setProperty("appliance", appliance);
            row.setProperty("domain", domain);
            row.setProperty("objectType", forwardCryptoProfile.getClassName());
            row.setProperty("objectName", forwardCryptoProfileName);
            row.setProperty("action", 2);
            description = String.format("Delete crypto profile '%s'", forwardCryptoProfileName);
            row.setProperty("description", description);
            this.tableModel.addRow(row);
        }
        super.updateControls();
        this.nextButtonEnabled = true;
        this.parentDialog.manageButtonState();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public boolean isNextButtonEnabled() {
        return this.nextButtonEnabled;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        ArrayList<DynamicBean> refactorData = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("newData", refactorData);
    }
}

