/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.TableCellRenderingHelper;
import com.kumbasoft.core.beans.probe.Variable;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.codec.binary.Base64;

public class ProbeVariableValueTableCellRenderer
extends JMLabel
implements TableCellRenderer {
    private Font standardFont;
    private Font italicsFont;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.standardFont == null) {
            this.standardFont = table.getFont();
            this.italicsFont = this.standardFont.deriveFont(2);
        }
        this.setFont(this.standardFont);
        if (value == null) {
            this.setText("");
            return this;
        }
        BeanTableModel tableModel = (BeanTableModel)table.getModel();
        Variable valueToRender = (Variable)tableModel.getValue(table.convertRowIndexToModel(row));
        String type = valueToRender.getType();
        String variableValue = (String)value;
        if (type.equals("node-set")) {
            this.setText("     {Select the row to see the node set at right.}");
            this.setFont(this.italicsFont);
        } else if (type.equals("number")) {
            this.setText(variableValue);
        } else {
            byte[] decodedValue = Base64.decodeBase64(variableValue);
            if (decodedValue == null) {
                this.setText("");
            } else {
                this.setText(new String(decodedValue));
            }
        }
        TableCellRenderingHelper.renderComponent(this, isSelected, row);
        return this;
    }
}

