/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.statusGraphWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.StatusProviderGraphDefinition;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.ListModel;

public class CreateStatusGraphPage
extends KumbaCoreWizardPage<DynamicBean> {
    private JMListModel<String> propertiesListModel;
    private JMList<String> propertiesList;
    private HashMap<String, String> propertyDisplayMap;
    private JMTextField tfGraphName;

    public CreateStatusGraphPage(DynamicBean model) {
        super(model);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        String graphName = this.tfGraphName.getText();
        List selectedProperties = this.propertiesList.getSelectedValuesList();
        StatusProviderGraphDefinition statusProviderGraphDefinition = new StatusProviderGraphDefinition(graphName);
        for (String property : selectedProperties) {
            statusProviderGraphDefinition.addValueProperty(this.propertyDisplayMap.get(property));
        }
        ((DynamicBean)this.model).setProperty("graphDefinition", statusProviderGraphDefinition);
    }

    @Override
    public boolean isDataValid() {
        String graphName = this.tfGraphName.getText();
        if (graphName.trim().length() == 0) {
            new JMMessageBox((JDialog)this.parentDialog, "Graph Name Required", "Please provide a name for the graph");
            return false;
        }
        if (this.propertiesList.getSelectedValuesList().size() == 0) {
            new JMMessageBox((JDialog)this.parentDialog, "No Properties Selected", "Please select at least one property to graph");
            return false;
        }
        return true;
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        this.propertiesListModel = new JMListModel<String>(this.getGraphableProperties());
        this.propertiesList = new JMList<String>((ListModel<String>)this.propertiesListModel);
        new ListSelectionEventInvoker(this.propertiesList, this, "setTitleFromSelectedProperty");
        LabeledComponent lblList = new LabeledComponent("Properties:", (Component)new JMScrollPane(this.propertiesList), 1);
        panel.add((Component)lblList, "West");
        JMPanel rightPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        rightPanel.add(new JMLabel("Graph Name:"));
        this.tfGraphName = new JMTextField(20);
        rightPanel.add(this.tfGraphName);
        panel.add((Component)rightPanel, "Center");
        return panel;
    }

    private ArrayList<String> getGraphableProperties() {
        StatusProviderInfo statusProviderInfo = (StatusProviderInfo)((DynamicBean)this.model).getProperty("statusProviderInfo");
        ArrayList<String> graphableProperties = statusProviderInfo.getGraphableProperties();
        if (CollectionUtility.isEmpty(graphableProperties)) {
            return new ArrayList<String>();
        }
        ArrayList<String> displayProperties = new ArrayList<String>(graphableProperties.size());
        this.propertyDisplayMap = new HashMap(graphableProperties.size());
        for (String graphableProperty : graphableProperties) {
            String displayProperty = StringUtility.getDisplayableTitle(graphableProperty);
            displayProperties.add(displayProperty);
            this.propertyDisplayMap.put(displayProperty, graphableProperty);
        }
        Collections.sort(displayProperties);
        return displayProperties;
    }

    @Reflected
    private void setTitleFromSelectedProperty() {
        List selectedValues = this.propertiesList.getSelectedValuesList();
        if (selectedValues.size() == 0 || selectedValues.size() > 1) {
            return;
        }
        String currentTitle = this.tfGraphName.getText().trim();
        String selectedValue = (String)selectedValues.get(0);
        if (StringUtility.isEmpty(currentTitle)) {
            this.tfGraphName.setText(selectedValue);
            return;
        }
        for (String displayValue : this.propertyDisplayMap.keySet()) {
            if (selectedValue.equals(displayValue) || !currentTitle.equals(displayValue)) continue;
            this.tfGraphName.setText(selectedValue);
            break;
        }
    }
}

