/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.statusGraphWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.ListModel;

public class StatusDiffHistorySelectWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private JMListModel<DateTime> historyListModel;
    private JMList<DateTime> historyList;
    private Index<DateTime, File> statusCaptureHistory;

    public StatusDiffHistorySelectWizardPage(DynamicBean model) {
        super(model);
    }

    public StatusDiffHistorySelectWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        if (this.historyList.getSelectedIndex() == -1) {
            new JMMessageBox((JDialog)this.parentDialog, "Nothing Selected", "You must selected a historical capture date");
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        DateTime selectedCaptureTime = this.historyList.getSelectedItem();
        ((DynamicBean)this.model).setProperty("selectedCaptureTime", selectedCaptureTime);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.statusCaptureHistory = this.getStatusCaptureHistory();
        UniqueArrayList<DateTime> captureDates = new UniqueArrayList<DateTime>(this.statusCaptureHistory.getKeys());
        captureDates.sort();
        this.historyListModel = new JMListModel<DateTime>(captureDates);
        this.historyList = new JMList<DateTime>((ListModel<DateTime>)this.historyListModel);
        this.historyList.setSelectionMode(0);
        KumbaCoreWizardPanel controlsPanel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMLabel label = new JMLabel("Past Captures");
        controlsPanel.add((Component)label, "North");
        controlsPanel.add((Component)new JMScrollPane(this.historyList), "Center");
        return controlsPanel;
    }

    private Index<DateTime, File> getStatusCaptureHistory() {
        Index<DateTime, File> statusCaptureHistory = new Index<DateTime, File>();
        StatusProviderInfo statusProviderInfo = (StatusProviderInfo)((DynamicBean)this.model).getProperty("statusProviderInfo");
        String statusProviderName = statusProviderInfo.getName();
        String applicableDomain = statusProviderInfo.getApplicableDomain();
        Index domains = (Index)((DynamicBean)this.model).getProperty("domains");
        ArrayList<String> applianceNames = new ArrayList<String>();
        Index<String, String> domainNamesByAppliance = new Index<String, String>();
        for (Appliance appliance : domains.getKeys()) {
            String applianceName = appliance.getName();
            applianceNames.add(applianceName);
            if (applicableDomain.equals("default")) {
                domainNamesByAppliance.put(applianceName, "default");
                continue;
            }
            ArrayList domainsByAppliance = (ArrayList)domains.get(appliance);
            for (Domain domain : domainsByAppliance) {
                String domainName = domain.getName();
                domainNamesByAppliance.put(applianceName, domainName);
            }
        }
        KumbaCoreApplicationProperties appProps = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        String statusCapturesDirectoryName = appProps.getStatusCaptureDirectory();
        File statusCapturesDirectory = new File(statusCapturesDirectoryName);
        Object[] statusProviderDirectories = statusCapturesDirectory.listFiles();
        if (!ArrayUtility.isEmpty(statusProviderDirectories)) {
            Object[] objectArray = statusProviderDirectories;
            int n = statusProviderDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] applianceDirectories;
                Object statusProviderDirectory = objectArray[n2];
                if (((File)statusProviderDirectory).isDirectory() && ((File)statusProviderDirectory).getName().equals(statusProviderName) && !ArrayUtility.isEmpty(applianceDirectories = ((File)statusProviderDirectory).listFiles())) {
                    Object[] objectArray2 = applianceDirectories;
                    int n3 = applianceDirectories.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object applianceDirectory = objectArray2[n4];
                        if (((File)applianceDirectory).isDirectory() && Comparison.isIn(((File)applianceDirectory).getName(), applianceNames)) {
                            String applianceName = ((File)applianceDirectory).getName();
                            ArrayList domainNames = (ArrayList)domainNamesByAppliance.get(applianceName);
                            Object[] domainDirectories = ((File)applianceDirectory).listFiles();
                            if (!ArrayUtility.isEmpty(domainDirectories)) {
                                Object[] objectArray3 = domainDirectories;
                                int n5 = domainDirectories.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    Object domainDirectory = objectArray3[n6];
                                    if (((File)domainDirectory).isDirectory() && Comparison.isIn(((File)domainDirectory).getName(), domainNames)) {
                                        File[] captureDirectories;
                                        File[] fileArray = captureDirectories = ((File)domainDirectory).listFiles();
                                        int n7 = captureDirectories.length;
                                        int n8 = 0;
                                        while (n8 < n7) {
                                            String catureDirectoryName;
                                            File captureDirectory = fileArray[n8];
                                            if (captureDirectory.isDirectory() && NumberUtility.isNumber(catureDirectoryName = captureDirectory.getName())) {
                                                long captureDate = Long.parseLong(catureDirectoryName);
                                                DateTime captureTime = new DateTime(captureDate);
                                                statusCaptureHistory.put(captureTime, captureDirectory);
                                            }
                                            ++n8;
                                        }
                                    }
                                    ++n6;
                                }
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        ((DynamicBean)this.model).setProperty("statusCaptureHistory", statusCaptureHistory);
        return statusCaptureHistory;
    }
}

