/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cacheManagement;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.cacheManagement.AbstractCacheManagementPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.swing.ListModel;

abstract class AbstractObjectCacheManagementPanel<ConfigType extends DataPowerConfig>
extends AbstractCacheManagementPanel {
    private JMListModel<String> objectListModel = new JMListModel();
    private JMList<String> objectList = new JMList<String>((ListModel<String>)this.objectListModel);
    private Collection<String> selectedObjects;
    private Index<String, String> objectIndex;
    private String subscriberName;

    public AbstractObjectCacheManagementPanel() {
        JMScrollPane scrollPane = KumbaCoreUIConstants.createScrollPane(this.objectList);
        LabeledComponent lbl = new LabeledComponent(this.getListNameLabel(), (Component)scrollPane, 1, 250, 250);
        this.add((Component)lbl, "West");
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
        this.rightPanel.add(ComponentFactory.createSpacer(10, 40));
    }

    @Override
    protected int getButtonLeftMargin() {
        return 10;
    }

    protected abstract String getListNameLabel();

    protected Index<String, String> getObjectIndex() {
        return this.objectIndex;
    }

    protected Collection<String> getSelectedObjects() {
        if (this.selectedObjects == null) {
            this.selectedObjects = this.objectList.getSelectedValuesList();
        }
        if (this.selectedObjects.contains("All")) {
            this.selectedObjects = this.objectListModel.getAll();
            this.selectedObjects.remove("All");
        }
        return this.selectedObjects;
    }

    protected void clearSelectionList() {
        if (this.selectedObjects != null) {
            this.selectedObjects.clear();
            this.selectedObjects = null;
        }
    }

    protected void clearCache(String subscriberName) {
        this.subscriberName = subscriberName;
        this.clearSelectionList();
        this.getSelectedObjects();
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "clearObjectCache", false);
    }

    @Reflected
    private void clearObjectCache(Appliance appliance, Domain domain) {
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, domain=%s): Starting", () -> appliance.getName(), () -> domain.getName()));
        Collection<String> objectsByApplianceDomain = this.getObjectIndex().get(AbstractObjectCacheManagementPanel.getObjectIndex(appliance, domain));
        if (CollectionUtility.isEmpty(objectsByApplianceDomain)) {
            AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, domain=%s): No objects found for appliance and domain.  Returning.", () -> appliance.getName(), () -> domain.getName()));
            return;
        }
        for (String selectedObject : this.getSelectedObjects()) {
            if (!objectsByApplianceDomain.contains(selectedObject)) continue;
            AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, domain=%s): Invoking %s for %s.", () -> appliance.getName(), () -> domain.getName(), () -> this.subscriberName, () -> selectedObject));
            MethodInvoker mi = new MethodInvoker((Object)this, this.subscriberName, appliance, domain, selectedObject);
            mi.invoke();
        }
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, domain=%s): Done", () -> appliance.getName(), () -> domain.getName()));
    }

    @Reflected
    private void domainsChanged(Index<Appliance, Domain> domains) {
        AbstractPanel.logger.finer("(Index<Appliance, Domain> domains): Starting");
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.setClearCacheButtonEnabled(false);
        this.prepareIndexAndModel();
        String objectType = this.getObjectType();
        AbstractPanel.logger.finer(() -> LMG.log("(Index<Appliance, Domain> domains): Object type is %s.", () -> objectType));
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> objects = configurationManager.listObjects(domains, objectType, ".*");
        for (StatusObjectStatus object : objects) {
            String objectName = object.getName();
            AbstractPanel.logger.finer(() -> LMG.log("(Index<Appliance, Domain> domains): Processing %s.", () -> object.getFQON()));
            String indexKey = AbstractObjectCacheManagementPanel.getObjectIndex(object.getAppliance(), object.getSourceDomain());
            try {
                this.objectIndex.put(indexKey, objectName);
                if (!this.objectListModel.contains(objectName)) {
                    AbstractPanel.logger.finer(() -> LMG.log("(Index<Appliance, Domain> domains): Adding %s to list model.", () -> objectName));
                    this.objectListModel.addElement(objectName);
                }
            }
            catch (ConcurrentModificationException cModException) {
                AbstractPanel.logger.warning(() -> LMG.log("(Index<Appliance, Domain> domains): Concurrent Modification Exception processing object of type %s.  How?", () -> objectType));
            }
            this.setClearCacheButtonEnabled(true);
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        this.sortAndSelectList();
        AbstractPanel.logger.finer("(Index<Appliance, Domain> domains): DOne");
    }

    protected abstract String getObjectType();

    protected static String getObjectIndex(Appliance appliance, Domain domain) {
        return String.format("%s-%s", appliance.getName(), domain.getName());
    }

    protected static JMPanel getCheckboxFieldPanel(JMCheckBox cbx, JMTextField tf) {
        JMPanel panel = new JMPanel(new BorderLayout(10, 1));
        Dimension cbxSize = cbx.getPreferredSize();
        Dimension tfSize = tf.getPreferredSize();
        cbx.setPreferredSize(new Dimension(AbstractObjectCacheManagementPanel.getPreferredChecboxWidth(), (int)cbxSize.getHeight()));
        tf.setPreferredSize(new Dimension(AbstractObjectCacheManagementPanel.getPreferredTextFieldWidth(), (int)tfSize.getHeight()));
        panel.add((Component)cbx, "West");
        panel.add((Component)tf, "Center");
        tf.setEnabled(false);
        MethodInvoker isSelectedMethodInvoker = new MethodInvoker((Object)cbx, "isSelected", new Object[0]);
        new ItemEventInvoker(cbx, tf, "setEnabled", isSelectedMethodInvoker);
        return panel;
    }

    protected static int getPreferredChecboxWidth() {
        return 175;
    }

    protected static int getPreferredTextFieldWidth() {
        return 300;
    }

    protected void prepareIndexAndModel() {
        if (this.objectIndex != null) {
            this.objectIndex.clear();
        } else {
            this.objectIndex = new Index();
        }
        this.objectList.clearSelection();
        this.objectListModel.clear();
        this.objectListModel.addElement("All");
    }

    private void sortAndSelectList() {
        if (this.objectListModel.getSize() > 1) {
            this.objectListModel.setOrdered(true);
            this.objectListModel.order();
            this.objectList.setSelectedValue("All", true);
        }
    }
}

