/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cacheManagement;

import com.jmorgan.annotations.Reflected;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionFlushNSSCache;
import com.kumbasoft.core.beans.config.ConfigZosNSSClient;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.dpaa.ui.panels.cacheManagement.AbstractObjectCacheManagementPanel;

public class NSSCacheManagmentPanel
extends AbstractObjectCacheManagementPanel<ConfigZosNSSClient> {
    @Override
    protected String getListNameLabel() {
        return "ZOS Clients";
    }

    @Override
    protected String getObjectType() {
        return "ZosNSSClient";
    }

    @Override
    protected String getButtonText() {
        return "Clear ZOS NSS Cache";
    }

    @Override
    protected String getButtonToolTip() {
        return "Clears the NSS Cache for all selected ZOS NSS Clients";
    }

    @Override
    protected int getVerticalSpacingForClearButton() {
        return 0;
    }

    @Override
    protected String getActionEventMethod() {
        return "clearNSSCache";
    }

    @Reflected
    private void clearNSSCache() {
        this.openResultsDialogAndSetWaitCursor("Clear ZOS NSS Cache");
        this.clearCache("clearNSSCache");
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void clearNSSCache(Appliance appliance, Domain domain, String nssClient) {
        ActionFlushNSSCache flushNSSCache = new ActionFlushNSSCache();
        ObjectReference<ConfigZosNSSClient> or = new ObjectReference<ConfigZosNSSClient>();
        or.setClassName("ZosNSSClient");
        or.setName(nssClient);
        flushNSSCache.setZosNSSClient(or);
        ActionTool actionTool = new ActionTool(appliance, domain, flushNSSCache);
        actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
    }
}

