/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cli;

import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.SystemClipboard;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.util.DataPowerSSHClient;
import com.kumbasoft.core.util.DataPowerSSHOutputListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;

public class DataPowerSSHPanel
extends AbstractPanel
implements DataPowerSSHOutputListener {
    private Appliance appliance;
    private JEditorPane sshConsole;
    private Document sshDocument;
    private DataPowerSSHClient sshClient;
    private boolean runningCommand;

    public DataPowerSSHPanel(Appliance appliance) {
        super(new BorderLayout());
        logger.finer(() -> LMG.log("(appliance=%s): Starting", () -> appliance.getName()));
        this.appliance = appliance;
        this.sshConsole = new JEditorPane();
        this.sshConsole.setContentType("text/plain");
        this.sshConsole.setEditable(false);
        this.sshConsole.setAutoscrolls(true);
        this.sshDocument = this.sshConsole.getDocument();
        DefaultCaret caret = (DefaultCaret)this.sshConsole.getCaret();
        caret.setUpdatePolicy(2);
        this.add((Component)new JMScrollPane(this.sshConsole), "Center");
        logger.finer(() -> LMG.log("(appliance=%s): Done", () -> appliance.getName()));
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public boolean isRunningCommand() {
        logger.finer(() -> LMG.log("(): Reached for %s:  Is running: %b", () -> this.appliance.getName(), () -> this.runningCommand));
        return this.runningCommand;
    }

    public boolean isClientConnected() {
        logger.finer(() -> LMG.log("(): Starting for %s", () -> this.appliance.getName()));
        if (this.sshClient == null) {
            logger.finer(() -> LMG.log("(): Client is null for %s.  Returning false.", () -> this.appliance.getName()));
            return false;
        }
        logger.finer(() -> LMG.log("(): Done for %s.  Client is connected? %b.", () -> this.appliance.getName(), () -> this.sshClient.isConnected()));
        return this.sshClient.isConnected();
    }

    public void sendCLICommand(String cliCommand) {
        logger.finer(() -> LMG.log("(cliCommand='%s'): Starting on %s", () -> cliCommand, () -> this.appliance.getName()));
        while (this.runningCommand) {
            logger.finer(() -> LMG.log("(cliCommand='%s'): Command is currently running on %s.  Waiting.", () -> cliCommand, () -> this.appliance.getName()));
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        this.runningCommand = true;
        String commandToSend = cliCommand;
        if (cliCommand.trim().toLowerCase().startsWith("echo ")) {
            logger.finer(() -> LMG.log("(cliCommand='%s'): Echoing user designated output for %s.", () -> cliCommand, () -> this.appliance.getName()));
            String echoString = cliCommand.substring(4);
            this.appendToConsole(echoString);
            commandToSend = "\n";
        }
        if (cliCommand.trim().toLowerCase().startsWith("sleep ")) {
            String sleepAmount = StringUtility.removeAll(cliCommand.substring(6), "\n\r");
            if (!NumberUtility.isInteger(sleepAmount)) {
                logger.severe(() -> LMG.log("(cliCommand='%s'): The value for sleep must be an integer and is not.  Ignoring.", () -> cliCommand));
                new JMMessageBox((JFrame)frame, "Invalid sleep command", LabelUtility.wrapInHTML("The value following 'sleep' must be an integer.\nPlease try again."));
                this.runningCommand = false;
                return;
            }
            logger.finer(() -> LMG.log("(cliCommand='%s'): Sleeping for %sms on %s.", () -> cliCommand, () -> sleepAmount, () -> this.appliance.getName()));
            this.appendToConsole(" " + cliCommand);
            int sleep = Integer.parseInt(sleepAmount);
            ThreadUtility.sleep(sleep);
            logger.finer(() -> LMG.log("(cliCommand='%s'): Done Sleeping for %sms on %s.", () -> cliCommand, () -> sleepAmount, () -> this.appliance.getName()));
            commandToSend = "\n";
        }
        logger.finer(() -> LMG.log("(cliCommand='%s'): Running on %s", () -> cliCommand, () -> this.appliance.getName()));
        if (this.sshClient == null) {
            logger.finer(() -> LMG.log("(cliCommand=%s):  Creating SSH client for %s", () -> cliCommand, () -> this.appliance.getName()));
            this.sshConsole.setText("");
            this.sshClient = new DataPowerSSHClient(this.appliance);
            this.sshClient.addSSHOutputListener(this);
            boolean connectionSuccessful = this.sshClient.connect();
            if (!connectionSuccessful) {
                logger.severe(() -> LMG.log("(cliCommand=%s):  SSH connection to %s not successful.", () -> cliCommand, () -> this.appliance.getName()));
                String message = String.format("The SSH connection to %s was not successful.\nThis could be caused by many things.\nPlease try again.\n\nIf the issue persists, please check the SSH service on the appliance.", this.appliance.getName());
                new JMMessageBox((JFrame)frame, "SSH Connection Failed", LabelUtility.wrapInHTML(message));
                this.runningCommand = false;
                return;
            }
            logger.finer(() -> LMG.log("(cliCommand=%s):  Connection to %s successful.", () -> cliCommand, () -> this.appliance.getName()));
        }
        try {
            logger.finer(() -> LMG.log("(cliCommand=%s):  Sending command to %s", () -> cliCommand, () -> this.appliance.getName()));
            this.sshClient.sendToDataPower(commandToSend);
            if (cliCommand.contains("write memory")) {
                logger.finer(() -> LMG.log("(cliCommand=%s):  Waiting for 'Yes/No .y/n.:' from %s", () -> cliCommand, () -> this.appliance.getName()));
                this.sshClient.waitFor("((.+?Yes.No .y/n.:)|" + this.sshClient.getPromptString() + ")");
            } else if (cliCommand.startsWith("copy ")) {
                logger.finer(() -> LMG.log("(cliCommand=%s):  Possibly includes a 'Password:' prompt from %s.", () -> cliCommand, () -> this.appliance.getName()));
                this.sshClient.waitFor("(Password:|" + this.sshClient.getPromptString() + ")");
            } else {
                logger.finer(() -> LMG.log("(cliCommand=%s):  Waiting for prompt from %s", () -> cliCommand, () -> this.appliance.getName()));
                this.sshClient.waitForPrompt();
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
            logger.severe(() -> LMG.log("(cliCommand=%s): IOException processing command on %s:\n\t%s", () -> cliCommand, () -> this.appliance.getName(), () -> iox.getMessage()));
        }
        this.runningCommand = false;
        logger.finer(() -> LMG.log("(cliCommand='%s'): Done for %s", () -> cliCommand, () -> this.appliance.getName()));
    }

    public void appendToConsole(String string) {
        logger.finer(() -> LMG.log("(string=%s):  Starting", () -> string));
        int endOfDocument = this.sshDocument.getLength();
        try {
            this.sshDocument.insertString(endOfDocument, string, null);
        }
        catch (BadLocationException e) {
            logger.severe(() -> LMG.log("(string=%s):  Error appending string to ssh console.", () -> string));
            e.printStackTrace();
        }
        logger.finer(() -> LMG.log("(string=%s):  Done", () -> string));
    }

    @Override
    public void receiveChar(char ch) {
        String chString = Character.toString(ch);
        logger.finer(() -> LMG.log("(char=%s):  Starting.", () -> chString));
        this.appendToConsole(chString);
        logger.finer(() -> LMG.log("(char=%s):  Done.", () -> chString));
    }

    public void disConnect() {
        logger.finer(() -> LMG.log("(): Started for %s", () -> this.appliance.getName()));
        if (this.sshClient != null) {
            this.sshClient.disconnect();
        } else {
            logger.info(() -> LMG.log("(): SSH Client is null for %s", () -> this.appliance.getName()));
        }
        this.runningCommand = false;
        logger.finer(() -> LMG.log("(): Done for %s", () -> this.appliance.getName()));
    }

    String getConsoleText() {
        return this.sshConsole.getText();
    }

    public void clearScreen() {
        String consoleText = this.sshConsole.getText();
        if (StringUtility.isEmpty(consoleText)) {
            return;
        }
        String[] consoleLines = consoleText.split("\n");
        int i = consoleLines.length - 1;
        while (i >= 0) {
            if (!StringUtility.isEmpty(consoleLines[i])) {
                this.sshConsole.setText(consoleLines[i]);
                break;
            }
            --i;
        }
    }

    public void editCopy() {
        SystemClipboard.setContents(this.sshConsole.getText());
    }

    public void editDelete() {
        this.sshConsole.setText("");
        this.sshConsole.repaint();
    }
}

