/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.CellFocusEvent;
import com.jmorgan.swing.table.CellFocusListener;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.SystemClipboard;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.dialogs.CompareObjectsDialog;
import com.kumbasoft.dpaa.ui.dialogs.DataPowerFileDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractSnapshotDiffPane<DeltaType>
extends AbstractPanel
implements CellFocusListener,
PopupMenuController {
    protected String sourceDate;
    protected String targetDate;
    protected BeanTableModel<DeltaType> tableModel;
    protected BeanColumnModel<DeltaType> columnModel;
    protected JMTable table;
    protected HashMap<Appliance, HashMap<Domain, Index<String, DeltaType>>> deltaData;

    public AbstractSnapshotDiffPane(String sourceDate, String targetDate) {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.sourceDate = sourceDate;
        this.targetDate = targetDate;
        this.tableModel = this.createTableModel();
        this.columnModel = this.createColumnModel();
        this.table = new JMTable(this.tableModel, this.columnModel);
        this.table.setSelectionMode(0);
        BeanRowSorter<DeltaType> rowSorter = new BeanRowSorter<DeltaType>(this.tableModel);
        this.table.setRowSorter(rowSorter);
        this.table.setAutoResizeMode(0);
        this.table.addCellFocusListener(this);
        this.add((Component)new JMScrollPane(this.table), "Center");
        this.createPopupMenu();
        JMPanel hamburgerPanel = new JMPanel(new FlowLayout(2));
        hamburgerPanel.add(this.getPopupMenuButton());
        this.add((Component)hamburgerPanel, "North");
    }

    protected void fileCompare() {
        logger.finer("(): Starting");
        int row = this.table.getSelectedRow();
        DeltaType selectedItem = this.tableModel.getValue(this.table.convertRowIndexToModel(row));
        Appliance appliance = (Appliance)BeanService.getPropertyValue(selectedItem, "appliance");
        Domain domain = this.getDomain(selectedItem);
        String objectType = selectedItem.getClass().getSimpleName();
        String nameField = this.getNameFieldName();
        String objectName = (String)BeanService.getPropertyValue(selectedItem, nameField);
        logger.finer(() -> LMG.log("(): Delta Item: Appliance: '%s', Domain: '%s', Type: '%s', Name: '%s'", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
        HashMap<Domain, Index<String, DeltaType>> applianceData = this.deltaData.get(appliance);
        Index<String, DeltaType> domainData = applianceData.get(domain);
        ArrayList objectsByType = (ArrayList)domainData.get(objectType);
        PropertyValueSelector nameSelector = new PropertyValueSelector(objectsByType);
        nameSelector.addPropertyValueMap(nameField, objectName);
        ArrayList objectsToCompare = (ArrayList)nameSelector.getSelectedElements();
        int objectCount = objectsToCompare.size();
        logger.finer(() -> LMG.log("(): Delta Item: Appliance: '%s', Domain: '%s', Type: '%s', Name: '%s'.  Number of objects in delta map: %d", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName, () -> objectCount));
        if (objectCount != 2) {
            logger.severe(() -> LMG.log("(): Delta Item: Appliance: '%s', Domain: '%s', Type: '%s', Name: '%s'.  Number of objects in delta map is not 2.  How?", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName, () -> objectCount));
        }
        Object source = objectsToCompare.get(0);
        Object target = objectCount < 2 ? this.createNullItemFromClone(source) : objectsToCompare.get(1);
        Object sourceObject = BeanService.getClone(source);
        Object targetObject = BeanService.getClone(target);
        BeanService.setPropertyValue(sourceObject, nameField, String.format("%s (%s)", objectName, StringUtility.getNthOfDelimited(this.sourceDate, File.separator)));
        BeanService.setPropertyValue(targetObject, nameField, String.format("%s (%s)", objectName, StringUtility.getNthOfDelimited(this.targetDate, File.separator)));
        ArrayList newObjectsToCompare = new ArrayList();
        newObjectsToCompare.add(sourceObject);
        newObjectsToCompare.add(targetObject);
        this.showCompareDialog(objectType, newObjectsToCompare);
        logger.finer("(): Done");
    }

    protected String getNameFieldName() {
        return "name";
    }

    protected void showCompareDialog(String objectType, ArrayList<DeltaType> objectsToCompare) {
        switch (objectType) {
            case "CertificateInformation": {
                CompareObjectsDialog compareCertsDialog = new CompareObjectsDialog(GUIServices.getFrame(this), "Compare Certificates", objectsToCompare);
                compareCertsDialog.dispose();
                break;
            }
            case "DataPowerFileInfo": {
                DataPowerFileDialog compareFilesDialog = new DataPowerFileDialog(GUIServices.getFrame(this), new Object[]{false, objectsToCompare.size()});
                for (DeltaType object : objectsToCompare) {
                    DataPowerFileInfo fileInfo = (DataPowerFileInfo)object;
                    compareFilesDialog.addDataPowerFile(fileInfo);
                }
                compareFilesDialog.setVisible(true);
                break;
            }
            default: {
                DynamicBean args = new DynamicBean();
                args.setProperty("editable", false);
                new CompareObjectsDialog(GUIServices.getFrame(this), "Compare Object Configurations", args, objectsToCompare);
            }
        }
    }

    @Override
    protected void createPopupMenu() {
        super.getPopupMenu(this.table);
        this.popupMenu.setPopupController(this);
        this.popupMenu.addMenuItem("Show Comparison...", (Object)this, "fileCompare");
    }

    @Override
    public boolean isPopupReady() {
        return this.table.getSelectedRowCount() > 0;
    }

    @Override
    public void cellFocusChange(CellFocusEvent event) {
        int cell;
        int row = event.getNewRow();
        Object value = this.table.getValueAt(row, cell = event.getNewCell());
        String strValue = value == null ? "" : value.toString();
        SystemClipboard.setContents(strValue);
    }

    public void addDeltaPair(DeltaType source, DeltaType target) {
        AbstractPanel.logger.finer("(source, target): Starting.");
        if (source == null && target == null) {
            AbstractPanel.logger.severe("(source, target): Both source and target are null.  How can that be?");
            return;
        }
        if (this.deltaData == null) {
            AbstractPanel.logger.fine("(source, target): this.deltaData is null.  Creating.");
            this.deltaData = new HashMap();
        }
        DeltaType itemToDisplay = source == null ? target : source;
        this.tableModel.addRow(itemToDisplay);
        if (source == null) {
            AbstractPanel.logger.fine("(source, target): Source is null.  Creating null clone of target.");
            source = this.createNullItemFromClone(target);
        }
        if (target == null) {
            AbstractPanel.logger.fine("(source, target): Target is null.  Creating null clone of source.");
            target = this.createNullItemFromClone(source);
        }
        AbstractPanel.logger.finer("(source, target): Adding source and target to delta data.");
        this.addDeltaData(source);
        this.addDeltaData(target);
        AbstractPanel.logger.finer("(source, target): Done.");
    }

    protected abstract DeltaType createNullItemFromClone(DeltaType var1);

    private void addDeltaData(DeltaType item) {
        logger.finer("(item): Starting");
        Appliance appliance = (Appliance)BeanService.getPropertyValue(item, "appliance");
        Domain domain = this.getDomain(item);
        String objectType = item.getClass().getSimpleName();
        logger.finer(() -> LMG.log("(item): Item type is '%s' located in the '%s' domain of '%s'.", () -> objectType, () -> domain.getName(), () -> appliance.getName()));
        if (this.deltaData.containsKey(appliance)) {
            logger.finer(() -> LMG.log("(item): Appliance '%s' is already in the delta data.", () -> appliance.getName()));
            HashMap<Domain, Index<String, DeltaType>> domainData = this.deltaData.get(appliance);
            if (domainData.containsKey(domain)) {
                logger.finer(() -> LMG.log("(item): Domain '%s' already exists in the delta data for appliance '%s'.", () -> domain.getName(), () -> appliance.getName()));
                Index<String, DeltaType> typeData = domainData.get(domain);
                if (!typeData.containsValue(objectType, item)) {
                    typeData.put(objectType, item);
                }
            } else {
                logger.finer(() -> LMG.log("(item): Adding new delta item to Domain '%s' of appliance '%s'.", () -> domain.getName(), () -> appliance.getName()));
                Index<String, DeltaType> typeData = new Index<String, DeltaType>();
                typeData.put(objectType, item);
                domainData.put(domain, typeData);
            }
        } else {
            logger.finer(() -> LMG.log("(item): Adding new delta data to Appliance '%s'.", () -> appliance.getName()));
            Index<String, DeltaType> typeData = new Index<String, DeltaType>();
            typeData.put(objectType, item);
            HashMap<Domain, Index<String, DeltaType>> domainData = new HashMap<Domain, Index<String, DeltaType>>();
            domainData.put(domain, typeData);
            this.deltaData.put(appliance, domainData);
        }
        logger.finer("(item): Done");
    }

    protected Domain getDomain(DeltaType item) {
        return (Domain)BeanService.getPropertyValue(item, "sourceDomain");
    }

    protected abstract BeanTableModel<DeltaType> createTableModel();

    protected abstract BeanColumnModel<DeltaType> createColumnModel();

    void optimizeView() {
        this.table.optimizeColumnWidths();
    }
}

