/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.combobox.JMComboBoxModel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.component.PreferredSizeComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.CreatePasswordAlias;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.PasswordVerificationController;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;

public class CreatePasswordAliasPanel
extends AbstractPanel {
    private static final int LABEL_WIDTH = 150;
    private static final int COMPONENT_WIDTH = 400;
    private JMComboBoxModel<String> passwordMapModel;
    private JMComboBox<String> passwordMaps;
    private JMPasswordField tfPassword;
    private JMPasswordField tfPasswordConfirm;
    private JMButton btnCreate;

    public CreatePasswordAliasPanel() {
        super(new VerticalFlowLayout(0));
        this.setInsets(InsetsFactory.createFixedInsets(10));
        this.passwordMapModel = new JMComboBoxModel();
        this.passwordMaps = new JMComboBox<String>((ComboBoxModel<String>)this.passwordMapModel);
        this.passwordMaps.setEditable(true);
        this.tfPassword = new JMPasswordField();
        this.tfPassword.setName("CreatePasswordAliasPanel.password");
        this.tfPasswordConfirm = new JMPasswordField();
        this.tfPasswordConfirm.setName("CreatePasswordAliasPanel.confirmPassword");
        new PasswordVerificationController(this.tfPassword, this.tfPasswordConfirm);
        this.btnCreate = new JMButton("Create");
        new ActionEventInvoker(this.btnCreate, this, "createPasswordMapAlias");
        this.addAll(new LabeledComponent("Password Alias:", this.passwordMaps, 150, 400), new LabeledComponent("Password:", (Component)this.tfPassword, 150, 400), new LabeledComponent("Verify Password:", (Component)this.tfPasswordConfirm, 150, 400), ComponentFactory.createSpacer(2, 20), new PreferredSizeComponent(this.btnCreate));
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    @Reflected
    private void createPasswordMapAlias() {
        String verifyPassword;
        String name = (String)this.passwordMaps.getEditor().getItem();
        int existingIndex = this.passwordMapModel.getIndexOf(name);
        logger.finest(() -> LMG.log("():  Name=%s, Existing Index=:%d\n", () -> name, () -> existingIndex));
        if (!ConfigurationManager.isObjectNameValid(name)) {
            this.showMessage("Invalid Password Alias Object Name", "The name you provided contains invalid characters.  Do not use spaces or any of the following:   !@#$%^&*()+=`~[]{};:'\"/\\|?,<>");
            return;
        }
        String password = this.tfPassword.getText();
        if (!password.equals(verifyPassword = this.tfPasswordConfirm.getText())) {
            this.showMessage("Passwords do not match", "The passwords you provided do not match.");
            return;
        }
        String titlePrefix = existingIndex == -1 ? "Create" : "Modify";
        this.openResultsDialogAndSetWaitCursor(String.format("%s Password Map Alias", titlePrefix));
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "createPasswordMapAlias", false);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void createPasswordMapAlias(Appliance appliance, Domain domain) {
        String name = (String)this.passwordMaps.getEditor().getItem();
        String password = this.tfPassword.getText();
        CreatePasswordAlias createPasswordAlias = new CreatePasswordAlias(appliance, domain, name, password);
        createPasswordAlias.addManagementCommandSubscriber(this.commandResultsDialog);
    }

    @Reflected
    private void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        logger.entering(this.getClass().getName(), "domainsChanged");
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.passwordMapModel.removeAllElements();
        logger.finer(() -> LMG.log("(selectedDomains): Looking for existing password maps", new Supplier[0]));
        try {
            ConfigurationManager configurationManager = new ConfigurationManager();
            ArrayList<StatusObjectStatus> passMapAliases = configurationManager.listObjects(selectedDomains, "^PasswordAlias$", ".*");
            logger.finer(() -> LMG.log("(selectedDomains):  Received %d objects.  Sorting", () -> passMapAliases.size()));
            BeanComparator sorter = new BeanComparator();
            sorter.addCompareProperty("name");
            Collections.sort(passMapAliases, sorter);
            logger.finer(() -> LMG.log("(selectedDomains):  Sorted.  Extracting names and adding to list", new Supplier[0]));
            UniqueArrayList<String> tempModel = new UniqueArrayList<String>();
            for (StatusObjectStatus logTarget : passMapAliases) {
                String name = logTarget.getName();
                tempModel.add(name);
            }
            logger.finer(() -> LMG.log("(selectedDomains):  Setting temp model elements to model", new Supplier[0]));
            this.passwordMapModel.addAll(tempModel);
        }
        catch (Exception e) {
            logger.config(e.toString());
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.exiting(this.getClass().getName(), "domainsChanged");
    }
}

