/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.util.InsetsFactory;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.swing.BorderFactory;

public class DisplayCertificateInfoPanel
extends JMPanel {
    private CertificateInformation certificateInformation;
    private ScrollablePanel fieldPanel;
    private JMScrollPane scrollPane;

    public DisplayCertificateInfoPanel(CertificateInformation certificateInformation) {
        super(new BorderLayout());
        this.setInsets(InsetsFactory.createFixedInsets(5));
        this.setBorder(BorderFactory.createLineBorder(KumbaCoreUIConstants.FOREGROUND));
        this.fieldPanel = new ScrollablePanel(new GridLayout(0, 1));
        this.certificateInformation = certificateInformation;
        Appliance appliance = certificateInformation.getAppliance();
        Domain domain = certificateInformation.getDomain();
        String applianceName = appliance != null ? appliance.getName() : "-- Not on an appliance --";
        String domainName = domain != null ? domain.getName() : "-- Not in a domain --";
        String subjectDN = DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getSubjectDN());
        String issuerDN = DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getIssuerDN());
        this.addField("Appliance:", applianceName);
        this.addField("Domain:", domainName);
        this.addField("File Name:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getFileName()));
        this.addField("Serial Number:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getSerialNumber()));
        this.addField("FingerPrint:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getFingerPrint()));
        this.addField("Subject DN:", subjectDN);
        this.addField("Issued By:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getIssuer()));
        this.addField("Issuer DN:", issuerDN);
        this.addField("Not Before:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getNotBefore()));
        this.addField("Not After:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getNotAfter()));
        this.addField("Certificate Type:", subjectDN.equals(issuerDN) ? "Self-Signed" : "X.509");
        this.addField("Public Key Algorithm:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getPublicKeyAlgorithm()));
        this.addField("Public Key Format:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getPublicKeyFormat()));
        this.addField("Signature Algorithm:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getSignatureAlgoritm()));
        this.addField("Signature:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getSignature()));
        this.addField("Issuer Path Length:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getBasicConstraints()));
        this.addField("Subject Alternative Names:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getSubjectAlternativeNames()));
        this.addField("Issuer Alternative Names:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getIssuerAlternativeNames()));
        this.addField("Extended Key Usage:", DisplayCertificateInfoPanel.getPropertyDisplayValue(this.certificateInformation.getExtendedKeyUsage()));
        X509Certificate x509Certificate = this.certificateInformation.getCertificate();
        if (x509Certificate != null) {
            boolean[] keyUsage = x509Certificate.getKeyUsage();
            if (keyUsage != null) {
                this.addField("Key Usage:", "");
                int i = 0;
                while (i < keyUsage.length) {
                    if (keyUsage[i]) {
                        switch (i) {
                            case 0: {
                                this.addField("", "Digital Signatures");
                                break;
                            }
                            case 1: {
                                this.addField("", "Non Repudiation");
                                break;
                            }
                            case 2: {
                                this.addField("", "Key Enchiperment");
                                break;
                            }
                            case 3: {
                                this.addField("", "Data Encipherment");
                                break;
                            }
                            case 4: {
                                this.addField("", "Key Agreement");
                                break;
                            }
                            case 5: {
                                this.addField("", "Certificate Signing");
                                break;
                            }
                            case 6: {
                                this.addField("", "CRL Signing");
                                break;
                            }
                            case 7: {
                                this.addField("", "Encipher Only");
                                break;
                            }
                            case 8: {
                                this.addField("", "Decipher Only");
                            }
                        }
                    }
                    ++i;
                }
            }
            this.addField("Critical Extension OIDs:", "");
            Set<String> cExtensionOIDs = x509Certificate.getCriticalExtensionOIDs();
            if (cExtensionOIDs != null) {
                for (String oid : cExtensionOIDs) {
                    this.addField("     oid:", oid);
                }
            }
            this.addField("Non-Critical Extension OIDs:", "");
            Set<String> ncExtensionOIDs = x509Certificate.getNonCriticalExtensionOIDs();
            if (ncExtensionOIDs != null) {
                for (String oid : ncExtensionOIDs) {
                    this.addField("     oid:", oid);
                }
            }
        }
        this.setPreferredSize(500, this.fieldPanel.getComponentCount() * 18);
        this.scrollPane = new JMScrollPane(this.fieldPanel);
        this.add(this.scrollPane);
    }

    public JMScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private static String getPropertyDisplayValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private void addField(String title, String value) {
        LabeledComponent lc = new LabeledComponent(title, (Component)new JMLabel(value), 175, 500);
        this.fieldPanel.add(lc);
    }
}

