/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.DirectoryFileChooser;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.CertificateSearchFilter;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.CreateCertificateFromURLBean;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoValCred;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.CertificateExportSubscriber;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.CreateCertificatesFromExternalFiles;
import com.kumbasoft.core.tools.DeleteObjectConfiguration;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.GetCertificatesFromURL;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.tools.UploadCertificate;
import com.kumbasoft.core.tools.ViewCertificateDetails;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.CommandResultsDialog;
import com.kumbasoft.core.util.CertificateReader;
import com.kumbasoft.core.util.DataPowerFileUtility;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.RegexUtility;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import com.kumbasoft.dpaa.ui.dialogs.CertificateSearchFiltersDialog;
import com.kumbasoft.dpaa.ui.dialogs.CompareObjectsDialog;
import com.kumbasoft.dpaa.ui.dialogs.ConfigurationRelationshipDialog;
import com.kumbasoft.dpaa.ui.dialogs.createValCredWizard.NewCertificateFromFilesWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.createValCredWizard.NewCertificateFromURLsWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.createValCredWizard.NewValcredFromCertsReviewWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.createValCredWizard.NewValcredFromCertsWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.UpdateCertificateFromURLFinalPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.UpdateCertificateFromURLSetupPage;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteExceptionsWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteObjectCasadeChoiceWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteObjectFinalWizardPage;
import com.kumbasoft.dpaa.ui.models.CertificateInformationColumnModel;
import com.kumbasoft.dpaa.ui.models.CertificateInformationTableModel;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageCertificatesPopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ManageCertificatesPanel
extends AbstractTablePanel<CertificateInformation>
implements CertificateExportSubscriber,
ManagementCommandSubscriber {
    private static final int ACTION_SEARCH = 1;
    private static final int ACTION_DELETE = 10;
    private static final String CERT_DIRECTORY;
    private static final String PREFERENCES_FILENAME;
    private static final String MODEL_ROW_TO_DELETE = "modelRowToDelete";
    private static final String OBJECT_TYPE_PROPERTY = "objectType";
    private static final String OBJECT_NAME_PROPERTY = "objectName";
    private JMPanel optionsPanel;
    private JMTextField searchField;
    private JMButton btnSearch;
    private JMButton btnCaseSensitiveSearch;
    private JMButton btnSearchFilters;
    private JMLabel lblSearchInfo;
    private String certificateSearchPattern;
    private CertificateSearchFilter certificateSearchFilter;
    private ArrayList<ConfigCryptoCertificate> displayedObjects;
    private HashMap<Appliance, Index<Domain, ConfigCryptoCertificate>> displayedObjectMap;
    private int action;
    private boolean useCaseSensitiveSearch;

    static {
        Application application = Application.getApplication();
        DPAAApplicationProperties appProps = (DPAAApplicationProperties)application.getApplicationProperties();
        CERT_DIRECTORY = appProps.getCertificateFileDirectory();
        String configsDirectory = appProps.getConfigsDirectory();
        PREFERENCES_FILENAME = String.format(".%sCertificateFilters.xgn", configsDirectory);
    }

    public ManageCertificatesPanel() {
        super(CertificateInformation.class);
        this.loadCertificateSearchFilters();
        this.createPopupMenu();
        this.add((Component)this.getOptionsPanel(), "North");
        this.lblSearchInfo = new JMLabel();
        this.add((Component)this.lblSearchInfo, "South");
    }

    @Override
    protected void createPopupMenu() {
        logger.finer("(): Starting");
        if (this.displayTable == null) {
            logger.severe("(): Display Table is NULL.  Timing issue?");
        }
        this.popupMenu = this.getPopupMenu();
        logger.finer("(): Done.");
    }

    @Override
    public boolean isPopupReady() {
        return ((ManageCertificatesPopupMenu)this.popupMenu).isPopupReady();
    }

    @Override
    protected JMPopupMenu getPopupMenu() {
        return new ManageCertificatesPopupMenu(this, this.displayTable);
    }

    private JMPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JMPanel(new BorderLayout());
            JMPanel leftPanel = new JMPanel(new FlowLayout(0));
            JMPanel searchPanel = new JMPanel();
            this.searchField = new JMTextField();
            this.searchField.setPreferredSize(400, 25);
            ComponentService.addHelpIcon(this.searchField, this.getSearchHelpText());
            ComponentService.addClearIcon(this.searchField, "Clear the contents of the search field.");
            LabeledComponent slc = new LabeledComponent("Search Pattern:", (Component)this.searchField, 100, 400);
            this.btnSearch = new JMButton(KumbaCoreUIConstants.SEARCH_ICON);
            new ActionEventInvoker(this.btnSearch, this, "fileSearch");
            searchPanel.addAll(slc, this.btnSearch);
            this.btnCaseSensitiveSearch = ComponentFactory.createButton(KumbaCoreUIConstants.CASE_SENSITIVITY_OFF_ICON, null, "Toggle Case Sensitivity", true, this, "toggleCaseSensitivity", new Object[0]);
            this.btnSearchFilters = ComponentFactory.createButton(KumbaCoreUIConstants.FILTER_ICON, null, "Open the certificate search filters dialog", true, this, "openFilterDialog", new Object[0]);
            leftPanel.addAll(searchPanel, this.btnCaseSensitiveSearch, this.btnSearchFilters);
            JMPanel menuPanel = new JMPanel(new FlowLayout(2));
            JMButton popupMenuButton = this.getPopupMenuButton();
            menuPanel.add(popupMenuButton);
            this.optionsPanel.add((Component)leftPanel, "West");
            this.optionsPanel.add((Component)menuPanel, "Center");
        }
        return this.optionsPanel;
    }

    @Reflected
    private void toggleCaseSensitivity() {
        if (this.useCaseSensitiveSearch) {
            this.useCaseSensitiveSearch = false;
            this.btnCaseSensitiveSearch.setIcon(KumbaCoreUIConstants.CASE_SENSITIVITY_OFF_ICON);
        } else {
            this.useCaseSensitiveSearch = true;
            this.btnCaseSensitiveSearch.setIcon(KumbaCoreUIConstants.CASE_SENSITIVITY_ON_ICON);
        }
    }

    @Reflected
    private void openFilterDialog() {
        CertificateSearchFiltersDialog dlg = new CertificateSearchFiltersDialog((JFrame)frame, this.certificateSearchFilter);
        if (!CertificateSearchFiltersDialog.wasCancelled()) {
            FileUtility.writeObject(PREFERENCES_FILENAME, (Object)this.certificateSearchFilter, true);
        }
        dlg.dispose();
    }

    private void loadCertificateSearchFilters() {
        this.certificateSearchFilter = (CertificateSearchFilter)FileUtility.readObject(PREFERENCES_FILENAME, true);
        if (this.certificateSearchFilter == null) {
            this.certificateSearchFilter = new CertificateSearchFilter();
        }
    }

    protected String getSearchHelpText() {
        return this.getHelpFile("searchField", "Enter a regular expression to match to the subject, filename or issuer of the certificate.");
    }

    @Override
    protected BeanColumnModel<CertificateInformation> getColumnModel() {
        CertificateInformationColumnModel columnModel = new CertificateInformationColumnModel((CertificateInformationTableModel)this.tableModel);
        return columnModel;
    }

    @Override
    public BeanTableModel<CertificateInformation> getTableModel() {
        CertificateInformationTableModel tableModel = new CertificateInformationTableModel();
        return tableModel;
    }

    @Reflected
    private void fileSearch() {
        AbstractPanel.logger.finer("():  Starting");
        this.action = 1;
        this.btnSearch.setEnabled(false);
        this.popupMenu.setEnabled(false);
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.resetTableData();
        if (this.displayedObjects != null) {
            this.displayedObjects.clear();
            this.displayedObjectMap.clear();
            this.displayedObjects = null;
            this.displayedObjectMap = null;
        }
        this.displayedObjects = new ArrayList();
        this.certificateSearchPattern = RegexUtility.normalizeRegex(this.searchField.getText(), this.useCaseSensitiveSearch);
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        AbstractPanel.logger.finer("():  Getting Certificates from selected appliance(s) and domain(s)");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : selectedDomains.getKeys()) {
            Collection<Domain> domains = selectedDomains.get(appliance);
            for (Domain domain : domains) {
                AbstractPanel.logger.finer(() -> LMG.log("():  Creating thread for appliance '%s' and domain '%s'", () -> appliance.getName(), () -> domain.getName()));
                AsynchMethodInvoker applianceDomainThread = new AsynchMethodInvoker((Object)this, "getCertificatesFor", new Object[]{appliance, domain});
                mtil.addThread(applianceDomainThread);
            }
        }
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ManageCertificatesPanel.fileSearch()", mtil, KumbaCoreConstants.STARTUP_DELAY * 2, 0);
        if (!completedOnTime) {
            AbstractPanel.logger.warning("():  Getting Certificates from selected appliance(s) and domain(s) did not complete on time.  This may not be a problem, but could have unexepcted results.");
        }
        AbstractPanel.logger.finer("():  Cleaning up UI.");
        this.btnSearch.setEnabled(true);
        this.popupMenu.setEnabled(this.tableModel.getRowCount() > 0);
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        this.displayedObjectMap = DataStructureUtility.mapByApplianceDomain(this.displayedObjects);
        AbstractPanel.logger.finer("():  Done");
    }

    @Reflected
    private void getCertificatesFor(Appliance appliance, Domain domain) {
        String loggerPrefix = String.format("(Appliance appliance=%s, Domain domain=%s):", appliance.getName(), domain.getName());
        AbstractPanel.logger.finer(() -> LMG.log("%s Starting", () -> loggerPrefix));
        String firmwareVersion = appliance.getFirmwareVersion();
        AbstractPanel.logger.finer(() -> LMG.log("%s  Appliance firmware version: %s.", () -> loggerPrefix, () -> firmwareVersion));
        try {
            MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
            ConfigurationManager configurationManager = new ConfigurationManager();
            ArrayList<DataPowerConfig> certificateConfigs = configurationManager.getObjects(appliance, domain, "CryptoCertificate", ".*");
            AbstractPanel.logger.fine(() -> LMG.log("%s  Received %d Certificates from selected appliance(s) and domain(s)", () -> loggerPrefix, () -> certificateConfigs.size()));
            if (certificateConfigs.size() == 0) {
                AbstractPanel.logger.fine(() -> LMG.log("%s  No certificates to process.  Returning.", () -> loggerPrefix, () -> certificateConfigs.size()));
                return;
            }
            ArrayList<ConfigCryptoCertificate> matchingCerts = new ArrayList<ConfigCryptoCertificate>();
            ArrayList<ConfigCryptoCertificate> unreadableCerts = new ArrayList<ConfigCryptoCertificate>();
            ArrayList<ConfigCryptoCertificate> expiredCerts = new ArrayList<ConfigCryptoCertificate>();
            ArrayList<ConfigCryptoCertificate> firmware_10_5_Certs = new ArrayList<ConfigCryptoCertificate>();
            HashSet<String> expiredFilesDirectoryNames = new HashSet<String>();
            StringBuilder expiredCertFileMatchPattern = new StringBuilder("(");
            boolean includeDefaultDomain = false;
            for (DataPowerConfig configObject : certificateConfigs) {
                ConfigCryptoCertificate cryptoCertificate = (ConfigCryptoCertificate)configObject;
                String certificateObjectName = cryptoCertificate.getName();
                if (certificateObjectName.isEmpty()) {
                    AbstractPanel.logger.warning(() -> LMG.log("%s  The certificate object name is null for %s", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                    continue;
                }
                String fileName = cryptoCertificate.getFilename();
                if (StringUtility.isEmpty(fileName)) {
                    AbstractPanel.logger.warning(() -> LMG.log("%s  The certificate file name is null for %s", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                    unreadableCerts.add(cryptoCertificate);
                    continue;
                }
                AbstractPanel.logger.fine(() -> LMG.log("%s  Processing cert: %s -> %s", () -> loggerPrefix, () -> cryptoCertificate.getName(), () -> cryptoCertificate.getFilename()));
                if (!this.certificateSearchFilter.isIncludePublicCerts() && fileName.startsWith("pubcert:")) {
                    AbstractPanel.logger.fine(() -> LMG.log("%s  Ignoring %s since it is a pubcert and include public certs is off.", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                    continue;
                }
                if (!this.certificateSearchFilter.isIncludeSharedCerts() && fileName.startsWith("sharedcert:")) {
                    AbstractPanel.logger.fine(() -> LMG.log("%s  Ignoring %s since it is a sharedcert and include shared certs is off.", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                    continue;
                }
                StatusObjectStatus certificateStatus = cryptoCertificate.getStatus();
                String eventCode = certificateStatus.getEventCode();
                if (StringUtility.isNotEmpty(eventCode)) {
                    if (eventCode.equals("0x00f30002") || eventCode.equals("0x00f30003")) {
                        unreadableCerts.add(cryptoCertificate);
                        AbstractPanel.logger.fine(() -> LMG.log("%s  Bypassing %s since it's status is unreadable.", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                        continue;
                    }
                    if (eventCode.equals("0x00f30008")) {
                        String directoryName = StringUtility.substringBefore(fileName, ":") + ":";
                        if (!includeDefaultDomain && Comparison.startsWith(directoryName, DataPowerFileUtility.DEFAULT_DOMAIN_FILESTORES)) {
                            includeDefaultDomain = true;
                        }
                        expiredFilesDirectoryNames.add(directoryName);
                        String delimiter = fileName.contains("/") ? "/" : ":";
                        String dpFileName = StringUtility.getNthOfDelimited(fileName, delimiter);
                        if (expiredCertFileMatchPattern.length() > 1) {
                            expiredCertFileMatchPattern.append("|");
                        }
                        expiredCertFileMatchPattern.append(dpFileName);
                        expiredCerts.add(cryptoCertificate);
                        AbstractPanel.logger.fine(() -> LMG.log("%s  Fast-processing %s since it's status is expired.", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                        continue;
                    }
                }
                if (firmwareVersion.contains("10.5.")) {
                    String password = cryptoCertificate.getPassword();
                    ObjectReference<ConfigPasswordAlias> alias = cryptoCertificate.getAlias();
                    if (StringUtility.isNotEmpty(password) && alias == null) {
                        AbstractPanel.logger.finer(() -> LMG.log("%s  %s is possibly broken in FW 10.5.x.x.  Isolating.", () -> loggerPrefix, () -> certificateObjectName));
                        firmware_10_5_Certs.add(cryptoCertificate);
                        continue;
                    }
                }
                matchingCerts.add(cryptoCertificate);
            }
            expiredCertFileMatchPattern.append(")");
            Index<Appliance, Domain> storeLocations = new Index<Appliance, Domain>();
            if (includeDefaultDomain) {
                storeLocations.put(appliance, appliance.getDomain("default"));
            }
            storeLocations.put(appliance, domain);
            AbstractPanel.logger.finer(() -> LMG.log("%s  Listing files to check for existence.", () -> loggerPrefix));
            ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
            ListFiles.list(storeLocations, expiredFilesDirectoryNames, expiredCertFileMatchPattern.toString(), mtil);
            ListFiles.addConfigObjectSubscriber(fileCache);
            boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ManageCertificatesPanel.getCertificatesFor" + loggerPrefix, mtil, matchingCerts.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
            if (!completedOnTime) {
                AbstractPanel.logger.warning(() -> LMG.log("%s Timeout waiting for files to list.  This could result in no certificates listing for appliance/domain.", () -> loggerPrefix));
            }
            Vector<DataPowerFileInfo> files = fileCache.getObjectCache();
            BeanIndexer<DataPowerFileInfo> nameIndexer = new BeanIndexer<DataPowerFileInfo>(files);
            Index<String, DataPowerFileInfo> filesByName = nameIndexer.getIndexOf("name", "");
            for (ConfigCryptoCertificate expiredCert : expiredCerts) {
                String fileName = StringUtility.coalesce(expiredCert.getFilename(), "/");
                if (filesByName.containsKey(fileName)) {
                    matchingCerts.add(expiredCert);
                    continue;
                }
                StatusObjectStatus status = expiredCert.getStatus();
                status.setErrorCode("*** Error:  File Not Found");
                status.setEventCode("0xffffffffffffff0");
                unreadableCerts.add(expiredCert);
                AbstractPanel.logger.info(() -> LMG.log("%s  Marking %s as unreadable since its status is expired but in reality, the file does not exist.", () -> loggerPrefix, () -> expiredCert.getFQON()));
            }
            new AsynchMethodInvoker((Object)this, "processUnreadableCertificates", unreadableCerts);
            if (firmware_10_5_Certs.size() > 0) {
                AbstractPanel.logger.finer(() -> LMG.log("%s  Getting certificate details for %d possibly broken certs due to firmware 10.5.x.x.", () -> loggerPrefix, () -> firmware_10_5_Certs.size()));
                for (ConfigCryptoCertificate cert : firmware_10_5_Certs) {
                    ViewCertificateDetails viewCertificateDetails = new ViewCertificateDetails(appliance, domain, cert);
                    viewCertificateDetails.addCertificateExportSubscriber(this);
                    viewCertificateDetails.addManagementCommandSubscriber(this);
                    viewCertificateDetails.addAdditionalCommandInfo("10.5", cert);
                    viewCertificateDetails.addAdditionalCommandInfo(OBJECT_TYPE_PROPERTY, cert.getConfigObjectType());
                    viewCertificateDetails.addAdditionalCommandInfo(OBJECT_NAME_PROPERTY, cert.getName());
                    mtil.addThread(viewCertificateDetails.getProcessThread());
                }
            }
            if (matchingCerts.size() > 0) {
                AbstractPanel.logger.finer(() -> LMG.log("%s  Getting certificate details for %d certs.", () -> loggerPrefix, () -> matchingCerts.size()));
                ViewCertificateDetails viewCertificateDetails = new ViewCertificateDetails(matchingCerts, mtil);
                viewCertificateDetails.addCertificateExportSubscriber(this);
                viewCertificateDetails.addManagementCommandSubscriber(this);
                completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ManageCertificatesPanel.getCertificatesFor" + loggerPrefix, mtil, matchingCerts.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
                if (!completedOnTime) {
                    AbstractPanel.logger.warning(() -> LMG.log("%s Timeout waiting for certificates to list.  Some may still come, but continuing on.", () -> loggerPrefix));
                }
            } else {
                AbstractPanel.logger.fine(() -> LMG.log("%s No certificates to process.  Continuing.", () -> loggerPrefix));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractPanel.logger.severe(e.getMessage());
        }
        AbstractPanel.logger.finer(() -> LMG.log("%s Done", () -> loggerPrefix));
    }

    @Reflected
    private void processUnreadableCertificates(ArrayList<ConfigCryptoCertificate> unreadableCerts) {
        if (CollectionUtility.isEmpty(unreadableCerts)) {
            return;
        }
        for (ConfigCryptoCertificate cert : unreadableCerts) {
            this.processCertificate(cert.getAppliance(), cert.getSourceDomain(), cert, null);
        }
    }

    @Override
    public void processCertificate(Appliance appliance, Domain domain, ConfigCryptoCertificate certificateObject, Certificate certificate) {
        boolean sanMatched;
        String dataPowerFileName = certificateObject.getFilename();
        CertificateInformation certificateInformation = new CertificateInformation(appliance, domain, dataPowerFileName, (X509Certificate)certificate);
        certificateInformation.setCertificateObjectName(certificateObject.getName());
        StatusObjectStatus status = certificateObject.getStatus();
        if (status.getEventCode().equals("0xfffffffffffffff")) {
            certificateInformation.setSubjectDN(status.getErrorCode());
        }
        int daysUntilExpiration = certificateInformation.getDaysUntilExpiration();
        if (!this.certificateSearchFilter.isIgnoreExpirationDates() && daysUntilExpiration > this.certificateSearchFilter.getDaysToExpiration()) {
            return;
        }
        if (this.certificateSearchFilter.isIgnoreExpiredCerts() && daysUntilExpiration < 0) {
            return;
        }
        String subjectDN = certificateInformation.getSubjectDN();
        if (subjectDN.contains("*** Error") && this.certificateSearchFilter.isIgnoreErrorCerts()) {
            return;
        }
        boolean selfSigned = subjectDN.equals(certificateInformation.getIssuerDN());
        if (!selfSigned && this.certificateSearchFilter.isSelfSignedOnly()) {
            return;
        }
        String fileName = certificateInformation.getFileName();
        boolean fileNameMatched = StringUtility.isNotEmpty(fileName) && fileName.matches(this.certificateSearchPattern);
        String certificateObjectName = certificateInformation.getCertificateObjectName();
        boolean objectNameMatched = StringUtility.isNotEmpty(certificateObjectName) && certificateObjectName.matches(this.certificateSearchPattern);
        boolean certCNMatched = StringUtility.isNotEmpty(subjectDN) && subjectDN.matches(this.certificateSearchPattern);
        String issuerDN = certificateInformation.getIssuerDN();
        boolean issuerMatched = StringUtility.isNotEmpty(issuerDN) && issuerDN.matches(this.certificateSearchPattern);
        String SANS = certificateInformation.getSubjectAlternativeNames();
        boolean bl = sanMatched = StringUtility.isNotEmpty(SANS) && SANS.matches(this.certificateSearchPattern);
        if (objectNameMatched || fileNameMatched || certCNMatched || issuerMatched || sanMatched) {
            this.displayedObjects.add(certificateObject);
            this.addRow(certificateInformation);
        }
    }

    @Reflected
    private void showReferencedBy() {
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        ArrayList<StatusObjectStatus> certificateObjects = new ArrayList<StatusObjectStatus>();
        for (CertificateInformation certificateInformation : selectedCertificates) {
            StatusObjectStatus certStatus = new StatusObjectStatus();
            certStatus.setAppliance(certificateInformation.getAppliance());
            certStatus.setSourceDomain(certificateInformation.getDomain());
            certStatus.setDataPowerClass("CryptoCertificate");
            certStatus.setName(certificateInformation.getCertificateObjectName());
            certStatus.setAdminState("enabled");
            certificateObjects.add(certStatus);
        }
        new ConfigurationRelationshipDialog((JFrame)AbstractPanel.frame, new Object[]{certificateObjects, ConfigurationRelationshipType.CHILD_UP});
    }

    @Reflected
    private void fileSaveAs() {
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        this.openResultsDialogAndSetWaitCursor("Save Certificates");
        DirectoryFileChooser dfc = new DirectoryFileChooser(null);
        int choice = dfc.showOpenDialog(AbstractPanel.frame);
        if (choice == 1) {
            return;
        }
        File baseDirectory = dfc.getSelectedFile();
        for (CertificateInformation certInfo : selectedCertificates) {
            if (certInfo.getFingerPrint() == null) continue;
            String applianceName = certInfo.getAppliance().getName();
            String domainName = certInfo.getDomain().getName();
            String certificateObjectName = certInfo.getCertificateObjectName();
            String outputDirectory = String.format("%s%s%s%s%s%s", CERT_DIRECTORY, File.separator, applianceName, File.separator, domainName, File.separator);
            File certDirectory = new File(outputDirectory);
            if (!certDirectory.exists()) {
                certDirectory.mkdirs();
            }
            com.jmorgan.io.File localCertificateFile = new com.jmorgan.io.File(certDirectory, String.format("%s.cer", certificateObjectName));
            String destinationFileName = String.format("%s%s%s%s%s.cer", applianceName, File.separator, domainName, File.separator, certificateObjectName);
            File destinationFile = new File(baseDirectory, destinationFileName);
            File destinationParent = destinationFile.getParentFile();
            if (!destinationParent.exists()) {
                destinationParent.mkdirs();
            }
            try {
                localCertificateFile.copyTo(destinationFile);
                String statusMessage = String.format("Save %s to %s", certificateObjectName, destinationFile.getAbsolutePath());
                ManagementCommandStatus status = new ManagementCommandStatus(certInfo.getAppliance(), certInfo.getDomain(), statusMessage, null, "OK");
                this.commandResultsDialog.commandSucceeded(status);
            }
            catch (IOException e) {
                String statusMessage = String.format("Error saving %s to %s", certificateObjectName, destinationFile.getAbsolutePath());
                ManagementCommandError error = new ManagementCommandError(certInfo.getAppliance(), certInfo.getDomain(), statusMessage, null, "Save Failed");
                this.commandResultsDialog.commandFailed(error);
                e.printStackTrace();
            }
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void fileCreateValCredFromCerts() {
        ArrayList<CertificateInformation> goodCertificates = this.getGoodCertificates();
        if (goodCertificates.size() > 0) {
            DynamicBean model = ManageCertificatesPanel.initializeCreateValCredModel();
            model.setProperty("certificates", goodCertificates);
            model.setProperty("certsByAppliance", null);
            NewValcredFromCertsWizardPage wizardPage = new NewValcredFromCertsWizardPage(model);
            NewValcredFromCertsReviewWizardPage reviewPage = new NewValcredFromCertsReviewWizardPage(model);
            WizardDialog<DynamicBean> createValCredWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Create Validation Credential from Certificates");
            createValCredWizard.addWizardPage(wizardPage, "createValCred");
            createValCredWizard.addWizardPage(reviewPage, "review");
            createValCredWizard.setSize(1000, 620);
            createValCredWizard.startWizard();
            if (WizardDialog.wasCancelled()) {
                return;
            }
            this.openResultsDialogAndSetWaitCursor("Create Validation Credential from Certificates");
            HashMap certsByAppliance = (HashMap)model.getProperty("certsByAppliance");
            for (Appliance appliance : certsByAppliance.keySet()) {
                Index certsByDomain = (Index)certsByAppliance.get(appliance);
                for (Domain domain : certsByDomain.getKeys()) {
                    ConfigCryptoValCred valCred = this.createValidationCredential(appliance, domain, model);
                    ConfigTool configTool = new ConfigTool(appliance, domain, valCred);
                    configTool.addManagementCommandSubscriber(this.commandResultsDialog);
                }
            }
            this.waitForResultsDialogToCloseAndResetCursor();
        } else {
            this.showMessage("No valid certificates selected for new validation credential", "There are no valid certificates selected useful for creating a validation credential.  Please select one or more valid certificates..");
        }
    }

    @Reflected
    private void fileCreateCertsFromExternalFiles() {
        DynamicBean model = new DynamicBean();
        model.setProperty("selectedDomains", ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
        NewCertificateFromFilesWizardPage wizardPage = new NewCertificateFromFilesWizardPage(model);
        WizardDialog<DynamicBean> createCertificatesFromFilesWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Create Certificates from External Files");
        createCertificatesFromFilesWizard.addWizardPage(wizardPage, "createCerts");
        createCertificatesFromFilesWizard.setSize(1000, 620);
        createCertificatesFromFilesWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Create Certificates from External Files");
        CreateCertificatesFromExternalFiles createCerts = new CreateCertificatesFromExternalFiles((Index)model.getProperty("selectedDomains"), (ArrayList)model.getProperty("certificateData"));
        createCerts.addManagementCommandSubscriber(this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void fileCreateCertsFromURLs() {
        DynamicBean model = new DynamicBean();
        model.setProperty("selectedDomains", ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
        NewCertificateFromURLsWizardPage wizardPage = new NewCertificateFromURLsWizardPage(model);
        WizardDialog<DynamicBean> createCertificatesFromURLsWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Create Certificates from URLs");
        createCertificatesFromURLsWizard.addWizardPage(wizardPage, "createCerts");
        createCertificatesFromURLsWizard.setSize(1000, 620);
        createCertificatesFromURLsWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Create Certificates from URLs");
        Collection certificateData = (Collection)model.getProperty("certificateData");
        Appliance appliance = new Appliance("All");
        Domain domain = new Domain("All");
        for (CreateCertificateFromURLBean bean : certificateData) {
            String URL2 = bean.getURL();
            GetCertificatesFromURL certsFromURL = new GetCertificatesFromURL(URL2);
            Object[] certificates = certsFromURL.getCertificates();
            if (!ArrayUtility.isEmpty(certificates)) {
                File[] exportFiles = certsFromURL.getExportFiles();
                AbstractPanel.logger.finer(() -> LMG.log("(): Found certificate for %s", () -> URL2));
                bean.setLocalFile(exportFiles[0]);
                continue;
            }
            String errorMessage = String.format("Unable to retrieve certificate from %s", URL2);
            ManagementCommandError error = new ManagementCommandError(appliance, domain, "Create Certificates from URLs", certsFromURL, errorMessage);
            AbstractPanel.logger.info(() -> LMG.log("(): %s", () -> errorMessage));
            this.commandResultsDialog.commandFailed(error);
        }
        CreateCertificatesFromExternalFiles createCerts = new CreateCertificatesFromExternalFiles((Index)model.getProperty("selectedDomains"), (ArrayList)model.getProperty("certificateData"));
        createCerts.addManagementCommandSubscriber(this.commandResultsDialog);
    }

    private static DynamicBean initializeCreateValCredModel() {
        DynamicBean model = new DynamicBean();
        model.setProperty("valCredName", "");
        model.setProperty("validationMode", DPEnumerations.CRYPTO_VAL_CRED_CERT_VALIDATION_MODE[0]);
        model.setProperty("useCRL", "on");
        model.setProperty("requireCRL", "off");
        model.setProperty("crlDistroHandling", DPEnumerations.CRLDPHANDLING[0]);
        model.setProperty("checkDates", "on");
        model.setProperty("selectedDomains", ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
        model.setProperty("certsByAppliance", null);
        return model;
    }

    private ConfigCryptoValCred createValidationCredential(Appliance appliance, Domain domain, DynamicBean model) {
        String valCredName = (String)model.getProperty("valCredName");
        String validationMode = (String)model.getProperty("validationMode");
        String useCRL = (String)model.getProperty("useCRL");
        String requireCRL = (String)model.getProperty("requireCRL");
        String crlDistroHandling = (String)model.getProperty("crlDistroHandling");
        String checkDates = (String)model.getProperty("checkDates");
        ConfigCryptoValCred valCred = new ConfigCryptoValCred();
        valCred.setAdminState("enabled");
        valCred.setName(valCredName);
        valCred.setAppliance(appliance);
        valCred.setSourceDomain(domain);
        valCred.setCertValidationMode(validationMode);
        valCred.setCheckDates(checkDates);
        valCred.setCRLDPHandling(crlDistroHandling);
        valCred.setRequireCRL(requireCRL);
        valCred.setUseCRL(useCRL);
        HashMap certsByAppliance = (HashMap)model.getProperty("certsByAppliance");
        Index certsByDomain = (Index)certsByAppliance.get(appliance);
        ArrayList certs = (ArrayList)certsByDomain.get(domain);
        ArrayList<ObjectReference<ConfigCryptoCertificate>> certReferences = new ArrayList<ObjectReference<ConfigCryptoCertificate>>(certs.size());
        for (CertificateInformation cert : certs) {
            ObjectReference certReference = new ObjectReference();
            certReference.setClassName("CryptoCertificate");
            certReference.setName(cert.getCertificateObjectName());
            certReferences.add(certReference);
        }
        valCred.setCertificate(certReferences);
        return valCred;
    }

    @Reflected
    private void compareSelected() {
        ArrayList<CertificateInformation> goodCertificates = this.getGoodCertificates();
        if (goodCertificates.size() > 0) {
            CompareObjectsDialog dialog = new CompareObjectsDialog((JFrame)AbstractPanel.frame, "Compare Certificates", goodCertificates);
            dialog.dispose();
        } else {
            this.showMessage("No valid certificates to compare", "There are no valid certificates selected to compare.  Please select one or more valid certificates for comparison.");
        }
    }

    @Reflected
    private void compareWithLocalFile() {
        File inputFile = GUIServices.fileOpenDialog(null);
        if (inputFile == null) {
            return;
        }
        CertificateReader cr = new CertificateReader(inputFile);
        Certificate certificate = cr.readCertificate();
        if (certificate == null) {
            String message = String.format("Could not process %s as a certificate.  Select a valid certificate file and try again.", inputFile.getAbsolutePath());
            this.showMessage("Compare with local file error", message);
            return;
        }
        CertificateInformation certInfo = new CertificateInformation(null, null, inputFile.getAbsolutePath(), (X509Certificate)certificate);
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        selectedCertificates.add(certInfo);
        new CompareObjectsDialog((JFrame)AbstractPanel.frame, "Compare Certificates with Local File", selectedCertificates);
    }

    @Reflected
    private void compareWithURL() {
        Certificate[] certificates;
        String url = (String)JOptionPane.showInputDialog(this, "URL:", "Compare with Certificate at a URL", -1, KumbaCoreUIConstants.URL_ICON, null, null);
        if (StringUtility.isEmpty(url)) {
            return;
        }
        GetCertificatesFromURL certsFromURL = new GetCertificatesFromURL(url);
        if (certsFromURL.hasException()) {
            this.showMessage("Error reading URL", "Could not get certificates from the URL provided. Please check the URL and try again.");
            return;
        }
        Certificate[] certificateArray = certificates = certsFromURL.getCertificates();
        if (certificates.length != 0) {
            Certificate cert = certificateArray[0];
            CertificateInformation certInfo = new CertificateInformation(null, null, url, (X509Certificate)cert);
            ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
            selectedCertificates.add(certInfo);
            new CompareObjectsDialog((JFrame)AbstractPanel.frame, "Compare Certificates with URL", selectedCertificates);
        }
    }

    @Reflected
    private void replaceWithLocal() {
        if (!this.continueAction("Replace Certificates", "Are you sure you want to replace all selected certificates?")) {
            return;
        }
        File inputFile = GUIServices.fileOpenDialog(null);
        if (inputFile == null) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Replace Certificate(s) with local file certificate");
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        for (CertificateInformation certInfo : selectedCertificates) {
            this.uploadCert(certInfo, inputFile);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void replaceWithURL() {
        logger.finer("(): Starting");
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        DynamicBean model = new DynamicBean();
        model.setProperty("certificatesToUpdate", selectedCertificates);
        WizardDialog<DynamicBean> updateFromURLWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Update Certificates From URL");
        UpdateCertificateFromURLSetupPage setupPage = new UpdateCertificateFromURLSetupPage(model);
        UpdateCertificateFromURLFinalPage finalPage = new UpdateCertificateFromURLFinalPage(model);
        updateFromURLWizard.addWizardPage(setupPage, "setup");
        updateFromURLWizard.addWizardPage(finalPage, "final");
        updateFromURLWizard.setSize(800, 600);
        updateFromURLWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            logger.finer("(): User Cancelled Wizard.  Returning.");
            return;
        }
        logger.finer("(): Initiating Process");
        this.openResultsDialogAndSetWaitCursor("Replace Certificate(s) with certificate from URL");
        UploadCertificate uploadCertificateTool = new UploadCertificate(this.displayedObjectMap, this.commandResultsDialog);
        ArrayList tableData = (ArrayList)model.getProperty("updateCertificatesFromURLFinalData");
        for (DynamicBean row : tableData) {
            CertificateInformation certInfo = (CertificateInformation)row.getProperty("newCertificateInfo");
            File downloadedCertificateFile = new File(certInfo.getFileName());
            String onBoardFileName = (String)row.getProperty("onBoardFileName");
            certInfo.setFileName(onBoardFileName);
            uploadCertificateTool.uploadCert(certInfo, downloadedCertificateFile);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        logger.finer("(): Done");
    }

    private void uploadCert(CertificateInformation certInfo, File localFile) {
        String fileName;
        Domain uploadDomain;
        Appliance uploadAppliance = certInfo.getAppliance();
        Domain certDomain = uploadDomain = certInfo.getDomain();
        String certificateObjectName = certInfo.getCertificateObjectName();
        AbstractPanel.logger.finer(() -> LMG.log("(certInfo, localFileName=%s):  Starting for %s->%s->%s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> certDomain.getName(), () -> certificateObjectName));
        String fullFileName = StringUtility.coalesce(certInfo.getFileName(), "/");
        int colon = fullFileName.indexOf(58) + 1;
        String baseDirectory = fullFileName.substring(0, colon);
        String fileName1F = fileName = fullFileName.substring(colon + 1);
        AbstractPanel.logger.fine(() -> LMG.log("(certInfo, localFileName=%s):  Base Directory for %s->%s->%s is %s, and file name is %s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> certDomain.getName(), () -> certificateObjectName, () -> baseDirectory, () -> fileName1F));
        if (StringUtility.isEmpty(fileName)) {
            fileName = String.format("dpaa_%s.cer", certificateObjectName);
            ModifyProperty<String> modifyProperty = new ModifyProperty<String>(certInfo.getAppliance(), certInfo.getDomain(), "CryptoCertificate", certInfo.getCertificateObjectName(), "Filename", fileName);
            modifyProperty.addManagementCommandSubscriber(this.commandResultsDialog);
            String fileName2F = fileName;
            AbstractPanel.logger.fine(() -> LMG.log("(certInfo, localFileName=%s):  Dynamically created file name for %s->%s->%s, Base Directory is %s, and file name is %s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> certDomain.getName(), () -> certificateObjectName, () -> baseDirectory, () -> fileName2F));
        }
        if (Comparison.isIn(baseDirectory, DataPowerFileUtility.DEFAULT_DOMAIN_FILESTORES)) {
            uploadDomain = uploadAppliance.getDomain("default");
        }
        String uploadDomainName = uploadDomain.getName();
        String finalUploadFileName = fileName;
        AbstractPanel.logger.config(() -> LMG.log("(certInfo, localFileName=%s):  Uploading Certificate file to %s->%s->%s->%s->%s", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> uploadDomainName, () -> certificateObjectName, () -> baseDirectory, () -> finalUploadFileName));
        DataPowerFileInfo dpFileInfo = new DataPowerFileInfo(uploadAppliance, uploadDomain, null, localFile.length(), baseDirectory, fileName);
        dpFileInfo.setLocalFile(localFile);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        FileUploader.upload(CollectionUtility.createListFrom(dpFileInfo), mtil);
        FileUploader.addCommandSubscriber(this.commandResultsDialog);
        ThreadManager.monitorAsynchThreadLifeCycle("ManageCertificatesPanel.uploadCert(...)", mtil, KumbaCoreConstants.THREAD_WAIT, 0);
        AbstractPanel.logger.finer(() -> LMG.log("(certInfo, localFileName=%s):  Certificate file upload complete %s->%s->%s->%s->%s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> uploadDomainName, () -> certificateObjectName, () -> baseDirectory, () -> finalUploadFileName));
        Index<Domain, ConfigCryptoCertificate> certsByAppliance = this.displayedObjectMap.get(uploadAppliance);
        Collection<ConfigCryptoCertificate> certsByDomain = certsByAppliance.get(certDomain);
        BeanIndexer<ConfigCryptoCertificate> certsByNameIndexer = new BeanIndexer<ConfigCryptoCertificate>(certsByDomain);
        HashMap<String, ConfigCryptoCertificate> certsByName = certsByNameIndexer.getMapOf("name", "");
        ConfigCryptoCertificate certObject = certsByName.get(certificateObjectName);
        String adminState = certObject.getAdminState();
        String inverseAdminState = adminState.equals("enabled") ? "disabled" : "enabled";
        AbstractPanel.logger.fine(() -> LMG.log("(certInfo, localFileName=%s):  Toggling Admin State for %s->%s->%s.", () -> localFile.getAbsolutePath(), () -> uploadAppliance.getName(), () -> uploadDomainName, () -> certificateObjectName));
        ManageCertificatesPanel.setAdminState(certInfo, inverseAdminState, this.commandResultsDialog);
        ManageCertificatesPanel.setAdminState(certInfo, adminState, this.commandResultsDialog);
        AbstractPanel.logger.finer(() -> LMG.log("(certInfo, localFileName=%s):  Done for %s->%s->%s.", () -> localFile.getAbsolutePath(), () -> certInfo.getAppliance().getName(), () -> certInfo.getDomain().getName(), () -> certInfo.getCertificateObjectName()));
    }

    @Reflected
    private void editDisable() {
        if (!this.continueAction("Disable Certificates", "Are you sure you want to disable all selected certificates?")) {
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        CommandResultsDialog commandResultsDialog = new CommandResultsDialog((JFrame)frame, "Disable selected certificate objects");
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        for (CertificateInformation certInfo : selectedCertificates) {
            ManageCertificatesPanel.setAdminState(certInfo, "disabled", commandResultsDialog);
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void editEnable() {
        if (!this.continueAction("Enable Certificates", "Are you sure you want to enable all selected certificates?")) {
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        CommandResultsDialog commandResultsDialog = new CommandResultsDialog((JFrame)frame, "Enable selected certificate objects");
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        for (CertificateInformation certInfo : selectedCertificates) {
            ManageCertificatesPanel.setAdminState(certInfo, "enabled", commandResultsDialog);
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    private static void setAdminState(CertificateInformation certInfo, String adminState, CommandResultsDialog commandResultsDialog) {
        ModifyProperty<String> modifyProperty = new ModifyProperty<String>(certInfo.getAppliance(), certInfo.getDomain(), "CryptoCertificate", certInfo.getCertificateObjectName(), "mAdminState", adminState);
        modifyProperty.addManagementCommandSubscriber(commandResultsDialog);
    }

    @Reflected
    private void editDelete() {
        AbstractPanel.logger.finer("():  Starting");
        this.action = 10;
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (selectedRows.length == 0) {
            AbstractPanel.logger.info("():  No certificates selected.  Returning.");
            return;
        }
        AbstractPanel.logger.finer(() -> LMG.log("():  %d certificates selected. Opening Wizard.", () -> selectedRows.length));
        Index<Appliance, Domain> domains = new Index<Appliance, Domain>();
        ArrayList<StatusObjectStatus> selectedCertificates = new ArrayList<StatusObjectStatus>();
        int r = 0;
        while (r < selectedRows.length) {
            CertificateInformation selectedCertificate = (CertificateInformation)this.tableModel.getValue(selectedRows[r]);
            Appliance appliance = selectedCertificate.getAppliance();
            Domain domain = selectedCertificate.getDomain();
            domains.put(appliance, domain);
            StatusObjectStatus objectStatus = new StatusObjectStatus();
            objectStatus.setAppliance(appliance);
            objectStatus.setSourceDomain(domain);
            objectStatus.setDataPowerClass("CryptoCertificate");
            objectStatus.setName(selectedCertificate.getCertificateObjectName());
            objectStatus.setAdminState("enabled");
            selectedCertificates.add(objectStatus);
            ++r;
        }
        DynamicBean selectedObjects = new DynamicBean();
        selectedObjects.setProperty("domains", domains);
        selectedObjects.setProperty("selectedObjects", selectedCertificates);
        WizardDialog<DynamicBean> wizardDialog = new WizardDialog<DynamicBean>((JFrame)frame, "Delete Objects");
        wizardDialog.addWizardPage(new DeleteObjectCasadeChoiceWizardPage(selectedObjects), "cascadeChoice");
        wizardDialog.addWizardPage(new DeleteExceptionsWizardPage(selectedObjects), "deleteExceptions");
        wizardDialog.addWizardPage(new DeleteObjectFinalWizardPage(selectedObjects), "finalPage");
        wizardDialog.setSize(1000, 700);
        wizardDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            AbstractPanel.logger.info("():  Wizard cancelled.  Returning.");
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Delete Certificate Configurations");
        ArrayList deleteData = (ArrayList)selectedObjects.getProperty("deleteData");
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        int nDeleted = 0;
        this.showProgressBar(deleteData.size());
        AbstractPanel.logger.finer("():  Processing delete queue");
        int selectedRowCount = selectedRows.length;
        for (DynamicBean bean : deleteData) {
            stil.clearCompletionStatus();
            Appliance appliance = (Appliance)bean.getProperty("appliance");
            Domain domain = (Domain)bean.getProperty("domain");
            String objectType = (String)bean.getProperty(OBJECT_TYPE_PROPERTY);
            String objectName = (String)bean.getProperty(OBJECT_NAME_PROPERTY);
            AbstractPanel.logger.fine(() -> LMG.log("(): Deleting %s->%s->%s->%s[%d]", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName, () -> bean.getProperty("deleteOrder")));
            if (objectType.equals("File")) {
                ActionDeleteFile actionDeleteFile = new ActionDeleteFile();
                actionDeleteFile.setFile(objectName);
                ActionTool fileDeleter = new ActionTool(appliance, domain, actionDeleteFile);
                fileDeleter.getProcessThread().addInvocationListener(stil);
                fileDeleter.setCommandDescription(String.format("Delete file %s in %s domain of %s", objectName, domain.getName(), appliance.getName()));
                fileDeleter.addManagementCommandSubscriber(this.commandResultsDialog);
                fileDeleter.addAdditionalCommandInfo(OBJECT_TYPE_PROPERTY, objectType);
                fileDeleter.addAdditionalCommandInfo(OBJECT_NAME_PROPERTY, objectName);
            } else {
                int modelRowToDelete = -1;
                if (objectType.equals("CryptoCertificate")) {
                    int r2 = 0;
                    while (r2 < selectedRowCount) {
                        String tableCertObjectName;
                        Domain tableCertDomain;
                        CertificateInformation selectedCertificate = (CertificateInformation)this.tableModel.getValue(selectedRows[r2]);
                        Appliance tableCertAppliance = selectedCertificate.getAppliance();
                        if (appliance.equals(tableCertAppliance) && domain.equals(tableCertDomain = selectedCertificate.getDomain()) && (tableCertObjectName = selectedCertificate.getCertificateObjectName()).equals(objectName)) {
                            modelRowToDelete = selectedRows[r2];
                        }
                        ++r2;
                    }
                }
                DeleteObjectConfiguration deleteObjectConfiguration = new DeleteObjectConfiguration(appliance, domain, objectType, objectName);
                AsynchMethodInvoker<?> processThread = deleteObjectConfiguration.getProcessThread();
                processThread.addInvocationListener(stil);
                deleteObjectConfiguration.addManagementCommandSubscriber(this.commandResultsDialog);
                deleteObjectConfiguration.addManagementCommandSubscriber(this);
                deleteObjectConfiguration.addAdditionalCommandInfo(OBJECT_TYPE_PROPERTY, objectType);
                deleteObjectConfiguration.addAdditionalCommandInfo(OBJECT_NAME_PROPERTY, objectName);
                if (modelRowToDelete != -1) {
                    deleteObjectConfiguration.addAdditionalCommandInfo(MODEL_ROW_TO_DELETE, modelRowToDelete);
                }
                --selectedRowCount;
            }
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            this.updateProgressBar(++nDeleted);
        }
        AbstractPanel.logger.finer("():  Cleaning up UI.");
        this.displayTable.repaint();
        this.waitForResultsDialogToCloseAndResetCursor();
        this.hideProgressBar();
        AbstractPanel.logger.finer("():  Done.");
    }

    private ArrayList<CertificateInformation> getSelectedCertificates() {
        ArrayList<CertificateInformation> selectedCertificates = new ArrayList<CertificateInformation>();
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return selectedCertificates;
        }
        int r = 0;
        while (r < selectedRows.length) {
            CertificateInformation certInfo = (CertificateInformation)this.tableModel.getValue(selectedRows[r]);
            selectedCertificates.add(certInfo);
            ++r;
        }
        return selectedCertificates;
    }

    private ArrayList<CertificateInformation> getGoodCertificates() {
        ArrayList<CertificateInformation> selectedCertificates = this.getSelectedCertificates();
        ArrayList<CertificateInformation> goodCertificates = new ArrayList<CertificateInformation>();
        for (CertificateInformation selectedCertificate : selectedCertificates) {
            if (selectedCertificate.getFingerPrint() == null) continue;
            goodCertificates.add(selectedCertificate);
        }
        return goodCertificates;
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        Appliance appliance = commandStatus.getAppliance();
        Domain domain = commandStatus.getDomain();
        String description = commandStatus.getCommandDescription();
        String objectType = (String)commandStatus.getAdditionalCommandInfo().getProperty(OBJECT_TYPE_PROPERTY);
        String objectName = (String)commandStatus.getAdditionalCommandInfo().getProperty(OBJECT_NAME_PROPERTY);
        AbstractPanel.logger.config(() -> LMG.log("(ManagementCommandStatus commandStatus): Delete Succeeded for %s->%s->%s->%s: %s", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName, () -> description));
        if (objectType.equals("CryptoCertificate") && commandStatus.getAdditionalCommandInfo().hasProperty(MODEL_ROW_TO_DELETE)) {
            int modelRowToDelete = (Integer)commandStatus.getAdditionalCommandInfo().getProperty(MODEL_ROW_TO_DELETE);
            this.displayTable.unSelectRow(modelRowToDelete);
            this.tableModel.deleteRow(modelRowToDelete);
        }
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
        Appliance appliance = commandError.getAppliance();
        Domain domain = commandError.getDomain();
        String description = commandError.getCommandDescription();
        String objectType = (String)commandError.getAdditionalCommandInfo().getProperty(OBJECT_TYPE_PROPERTY);
        String objectName = (String)commandError.getAdditionalCommandInfo().getProperty(OBJECT_NAME_PROPERTY);
        switch (this.action) {
            case 1: {
                AbstractPanel.logger.info(() -> LMG.log("(ManagementCommandError commandError): Search failed %s->%s->%s->%s: %s", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName, () -> description));
                break;
            }
            case 10: {
                AbstractPanel.logger.info(() -> LMG.log("(ManagementCommandError commandError): Delete Failed for %s->%s->%s->%s: %s", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName, () -> description));
            }
        }
    }
}

