/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.AttributeChangeListener;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableCellRenderer;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.ColorBeanTableModelPropertyValueRule;
import com.jmorgan.swing.table.FontBeanTableModelPropertyValueRule;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.AdvancedObjectSearchOptions;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInfoCache;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.CopyMoveActionBean;
import com.kumbasoft.core.beans.CopyMoveType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.beans.actions.ActionILMTForceScan;
import com.kumbasoft.core.beans.actions.ActionServiceQuiesce;
import com.kumbasoft.core.beans.actions.ActionServiceUnquiesce;
import com.kumbasoft.core.beans.actions.ActionUndoConfig;
import com.kumbasoft.core.beans.actions.ActionUserResetFailedLogin;
import com.kumbasoft.core.beans.config.ConfigCountMonitor;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigDurationMonitor;
import com.kumbasoft.core.beans.config.ConfigLogLabel;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.beans.config.ConfigMessageMatching;
import com.kumbasoft.core.beans.config.ConfigMessageType;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.LogEvent;
import com.kumbasoft.core.beans.types.LogObject;
import com.kumbasoft.core.tools.AbstractConfigurationActionTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.ConfigurationCopyMove;
import com.kumbasoft.core.tools.ConfigurationRename;
import com.kumbasoft.core.tools.ConfigurationReplace;
import com.kumbasoft.core.tools.ConfigurationSaveAs;
import com.kumbasoft.core.tools.DeleteObjectConfiguration;
import com.kumbasoft.core.tools.ExportConfiguration;
import com.kumbasoft.core.tools.FindObject;
import com.kumbasoft.core.tools.MigrateSSLProxyProfile;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.tools.ModifyTool;
import com.kumbasoft.core.tools.SetLogTargetLogLevel;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.tools.ViewCertificateDetails;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractSearchPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.ComplexTypeTableEditorInfo;
import com.kumbasoft.core.ui.beans.ListPropertyTableEditorInfo;
import com.kumbasoft.core.ui.beans.TableEditorInfo;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.components.lists.ConfigObjectListPanel;
import com.kumbasoft.dpaa.ui.dialogs.CompareObjectsDialog;
import com.kumbasoft.dpaa.ui.dialogs.ConfigurationRelationshipDialog;
import com.kumbasoft.dpaa.ui.dialogs.ExportOptionsDialog;
import com.kumbasoft.dpaa.ui.dialogs.advancedSearch.AdvancedObjectSearchPanel;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveAppliancesPage;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveDomainsPage;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveObjectBean;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveObjectsFinalPage;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveObjectsIncludeReferences;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.DuplicateDomainsPage;
import com.kumbasoft.dpaa.ui.dialogs.createLogTargetWizard.LogTargetBasicsPage;
import com.kumbasoft.dpaa.ui.dialogs.createLogTargetWizard.LogTargetFileInfoPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.CreateCryptoIDCredWizardDialog;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.GenerateSecretKeyFileTypePage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.UpdateCryptoIDCred;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.UpdateCryptoObject;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.UpdateCryptoObjectWizardDialog;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.UpdateCryptoSSKey;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteExceptionsWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteObjectCasadeChoiceWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.deleteWizards.DeleteObjectFinalWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.NewFileWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.manageListMembersWizard.ManageComplexPropertiesEditPage;
import com.kumbasoft.dpaa.ui.dialogs.manageListMembersWizard.ManageListPropertiesEditPage;
import com.kumbasoft.dpaa.ui.dialogs.migrateWizards.MigrateProxyProfileFinalWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.migrateWizards.MigrateProxyProfileWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.passwordWizards.ChangePasswordsWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.passwordWizards.MigratePasswordsWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.passwordWizards.MigratePlaintextPasswords;
import com.kumbasoft.dpaa.ui.dialogs.probe.ProbeViewDialog;
import com.kumbasoft.dpaa.ui.dialogs.renameWizard.RenameWarningPage;
import com.kumbasoft.dpaa.ui.dialogs.renameWizard.RenameWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.replaceWizard.ReplaceWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.saveAsWizard.SaveAsWizardPage;
import com.kumbasoft.dpaa.ui.panels.configurations.ManageObjectsPopupMenu;
import java.awt.Component;
import java.awt.Font;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class ManageObjectsPanel
extends AbstractSearchPanel<StatusObjectStatus>
implements AttributeChangeListener,
ManagementCommandSubscriber {
    static final ArrayList<String> DEBUG_TYPES = new ArrayList();
    private static String DEBUG_TYPES_EXPRESSION;
    static final ArrayList<String> MONITORED_TYPES;
    private static String MONITORED_TYPES_EXPRESSION;
    private JMButton btnOpenSearchOptions;
    private ConfigObjectListPanel configObjectListPanel;
    private String objectTypeExpression;
    private String objectNameExpression;
    protected static final int ACTION_TOGGLE_ADMIN = 0;
    protected static final int ACTION_TOGGLE_QUIESCE = 1;
    protected static final int ACTION_SET_PROPERTY = 2;
    protected static final int ACTION_UNDO_CONFIG = 11;
    protected static final int ACTION_COPY = 2;
    protected static final int ACTION_MOVE = 3;
    protected static final int ACTION_EXPORT = 4;
    protected static final int ACTION_DELETE = 5;
    protected static final int ACTION_SET_LOGGING_LEVEL = 6;
    protected static final int ACTION_SAVE_AS = 7;
    protected static final int ACTION_REPLACE = 8;
    protected static final int ACTION_RENAME = 9;
    protected static final int ACTION_SHOW_PROBES = 10;
    protected static final int ACTION_FORCE_ILMT_SCAN = 12;
    protected static final int CONFIG_CREATE_LOGGING_TARGET = 0;
    protected static final int CONFIG_CREATE_MONITORS = 1;
    private int action;
    ArrayList<AdvancedObjectSearchOptions> searchOptions;
    private HashMap<String, Pair<String, ArrayList<AdvancedObjectSearchOptions>>> searchesByType;
    private SingleThreadInvocationListener threadWait = new SingleThreadInvocationListener();

    static {
        MONITORED_TYPES = new ArrayList();
        String[] stringArray = DPEnumerations.CONFIG_ENUM;
        int n = DPEnumerations.CONFIG_ENUM.length;
        int n2 = 0;
        while (n2 < n) {
            String configName = stringArray[n2];
            Class<? extends DataPowerConfig> configClass = ConfigurationManager.getConfigObjectClass(configName);
            AbstractPanel.logger.finer(() -> LMG.log("<static-init> Config Class for %s is %s", () -> configName, () -> configClass.getName()));
            if (BeanService.hasProperty(configClass, "debugMode")) {
                logger.finer(() -> LMG.log("%s contains debugMode", () -> configClass.getSimpleName()));
                DEBUG_TYPES.add(configName);
            }
            DEBUG_TYPES_EXPRESSION = StringUtility.getRegexMatchExpression(DEBUG_TYPES);
            if (BeanService.hasProperty(configClass, "countMonitors")) {
                MONITORED_TYPES.add(configName);
            }
            MONITORED_TYPES_EXPRESSION = StringUtility.getRegexMatchExpression(MONITORED_TYPES);
            ++n2;
        }
    }

    public ManageObjectsPanel() {
        super(StatusObjectStatus.class);
        GUIApplication.getGUIApplication().addAttributeChangeListener(this);
    }

    @Override
    protected void createPopupMenu() {
        logger.finer("(): Starting");
        if (this.displayTable == null) {
            logger.severe("():  Display table is still null.  Timing issue!!!");
        }
        this.popupMenu = this.getPopupMenu();
        logger.finer("(): Done.");
    }

    @Override
    protected boolean isPopupReady() {
        logger.finer("(): Starting. Just returns the value from ManageObjectsPopupMenu.isPopupReady().");
        return ((ManageObjectsPopupMenu)this.popupMenu).isPopupReady();
    }

    @Override
    protected JMPopupMenu getPopupMenu() {
        logger.finer("(): Starting.  Just returns an instance of ManageObjectsPopupMenu.");
        return new ManageObjectsPopupMenu(this, this.displayTable);
    }

    @Override
    protected JMPanel createLeftPanel() {
        JMPanel leftPanel = super.createLeftPanel();
        this.configObjectListPanel = new ConfigObjectListPanel();
        this.configObjectListPanel.addListSelectionInvocation(this, "objectTypesChanged");
        leftPanel.add(this.configObjectListPanel);
        return leftPanel;
    }

    @Override
    protected int getTopLeftPanelSpacerHeight() {
        return 12;
    }

    @Override
    protected JMPanel getSearchFieldPanel() {
        JMPanel searchFieldPanel = super.getSearchFieldPanel();
        this.btnOpenSearchOptions = ComponentFactory.createButton(KumbaCoreUIConstants.FILTER_ICON, null, "Open Advanced Options Dialog", true, this, "searchFilters", new Object[0]);
        this.searchFieldPanel.add((Component)this.btnOpenSearchOptions, 3);
        return searchFieldPanel;
    }

    @Override
    protected String getTFPatternLabel() {
        return "Object Name:";
    }

    @Override
    protected TableModel getTableModelToExport() {
        return this.tableModel;
    }

    @Override
    protected String getProcessMethodName() {
        return "findObject";
    }

    @Override
    public BeanTableModel<StatusObjectStatus> getTableModel() {
        BeanTableModel<StatusObjectStatus> tableModel = super.getTableModel();
        tableModel.setValueExpression("appliance", "name");
        tableModel.setValueExpression("sourceDomain", "name");
        return tableModel;
    }

    @Override
    protected BeanColumnModel<StatusObjectStatus> getColumnModel() {
        BeanColumnModel<StatusObjectStatus> columnModel = super.getColumnModel();
        columnModel.setColumnTitle("sourceDomain", "Domain");
        columnModel.setColumnTitle("dataPowerClass", "Object Type");
        columnModel.setColumnOrder("appliance", "sourceDomain", "dataPowerClass", "name", "configState", "adminState", "opState", "eventCode", "errorCode");
        columnModel.hideColumns("statusTime", "fQON");
        ColorBeanTableModelPropertyValueRule downColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "opState", (Object)"down");
        downColor.setColor(KumbaCoreUIConstants.ERROR_COLOR);
        ColorBeanTableModelPropertyValueRule downForeColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "opState", (Object)"down");
        downForeColor.setColor(KumbaCoreUIConstants.ERROR_CONTRAST);
        ColorBeanTableModelPropertyValueRule disabledColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "adminState", (Object)"disabled");
        disabledColor.setColor(KumbaCoreUIConstants.LIGHT_BACKGROUND);
        ColorBeanTableModelPropertyValueRule externalColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "configState", (Object)"external");
        externalColor.setColor(KumbaCoreUIConstants.EXTERNAL_COLOR_UNSELECTED);
        ColorBeanTableModelPropertyValueRule externalInverseColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "configState", (Object)"external");
        externalInverseColor.setColor(KumbaCoreUIConstants.EXTERNAL_COLOR_SELECTED);
        ColorBeanTableModelPropertyValueRule modifiedForeColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "configState", (Object)"modified");
        modifiedForeColor.setColor(KumbaCoreUIConstants.BACKGROUND);
        FontBeanTableModelPropertyValueRule modifiedFontRule = new FontBeanTableModelPropertyValueRule(this.tableModel, "configState", "modified");
        Font modifiedFont = UIManager.getFont("Table.font");
        modifiedFontRule.setFont(modifiedFont.deriveFont(1));
        ColorBeanTableModelPropertyValueRule newForeColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "configState", (Object)"new");
        newForeColor.setColor(KumbaCoreUIConstants.NEW_OBJECT_FOREGROUND);
        FontBeanTableModelPropertyValueRule newFontRule = new FontBeanTableModelPropertyValueRule(this.tableModel, "configState", "new");
        Font newFont = UIManager.getFont("Table.font");
        newFontRule.setFont(newFont.deriveFont(1));
        ColorBeanTableModelPropertyValueRule quiescedForeColor = new ColorBeanTableModelPropertyValueRule(this.tableModel, "errorCode", (Object)"in quiescence");
        quiescedForeColor.setColor(KumbaCoreUIConstants.DISABLED_FOREGROUND);
        FontBeanTableModelPropertyValueRule quiescedFont = new FontBeanTableModelPropertyValueRule(this.tableModel, "errorCode", "in quiescence");
        quiescedFont.setFont(modifiedFont.deriveFont(2));
        BeanTableCellRenderer cellRenderer = new BeanTableCellRenderer();
        cellRenderer.addSelectedBackgroundColorRule(downColor);
        cellRenderer.addSelectedForegroundColorRule(downForeColor);
        cellRenderer.addUnSelectedForegroundColorRule(downColor);
        cellRenderer.addUnSelectedBackgroundColorRule(disabledColor);
        cellRenderer.addSelectedForegroundColorRule(externalInverseColor);
        cellRenderer.addUnSelectedForegroundColorRule(externalColor);
        cellRenderer.addSelectedFontRule(modifiedFontRule);
        cellRenderer.addUnSelectedFontRule(modifiedFontRule);
        cellRenderer.addSelectedForegroundColorRule(modifiedForeColor);
        cellRenderer.addSelectedFontRule(newFontRule);
        cellRenderer.addUnSelectedFontRule(newFontRule);
        cellRenderer.addSelectedForegroundColorRule(newForeColor);
        cellRenderer.addUnSelectedForegroundColorRule(newForeColor);
        cellRenderer.addSelectedFontRule(quiescedFont);
        cellRenderer.addUnSelectedFontRule(quiescedFont);
        cellRenderer.addSelectedForegroundColorRule(quiescedForeColor);
        cellRenderer.addUnSelectedForegroundColorRule(quiescedForeColor);
        this.columnModel.setRenderer(".*", cellRenderer);
        return columnModel;
    }

    @Reflected
    private void searchFilters() {
        List<String> selectedValues = this.configObjectListPanel.getSelectedValuesList();
        if (CollectionUtility.isEmpty(selectedValues)) {
            new JMMessageBox((JFrame)AbstractPanel.frame, "Set Filters for ALL types?", LabelUtility.wrapInHTML("Do you want to setup search filters\nfor ALL properties of ALL types?\n\nThis will likely not produce the results you seek."), 12);
            if (JMMessageBox.getSelection() == 8) {
                return;
            }
            selectedValues = this.configObjectListPanel.getAllValues();
        }
        AdvancedObjectSearchPanel panel = new AdvancedObjectSearchPanel(selectedValues, this.searchOptions);
        GenericDialog searchFiltersDialog = new GenericDialog(GUIServices.getFrame(this), "Advanced Search Options", (DialogPanel)panel);
        searchFiltersDialog.setSize(900, 520);
        searchFiltersDialog.setModal(true);
        searchFiltersDialog.setVisible(true);
        this.searchOptions = AdvancedObjectSearchPanel.searchOptions;
        this.setSearchOptionIcon();
    }

    @Reflected
    private void objectTypesChanged() {
        if (this.searchesByType != null) {
            String type = this.configObjectListPanel.getObjectTypeSearchPattern(false);
            Pair<String, ArrayList<AdvancedObjectSearchOptions>> optionsByType = this.searchesByType.get(type);
            if (optionsByType == null) {
                this.searchOptions = null;
            } else {
                String nameSearch = (String)optionsByType.first;
                if (StringUtility.isEmpty(nameSearch)) {
                    nameSearch = "";
                }
                this.tfSearchPattern.setText(nameSearch);
                this.searchOptions = (ArrayList)optionsByType.second;
            }
        } else {
            this.searchOptions = null;
        }
        this.setSearchOptionIcon();
    }

    private void setSearchOptionIcon() {
        if (CollectionUtility.isEmpty(this.searchOptions)) {
            this.btnOpenSearchOptions.setIcon(KumbaCoreUIConstants.FILTER_ICON);
        } else {
            this.btnOpenSearchOptions.setIcon(KumbaCoreUIConstants.FILTER_CLEAR_ICON);
        }
    }

    @Reflected
    private void findObject() {
        logger.finer("(): Starting");
        this.objectTypeExpression = this.configObjectListPanel.getObjectTypeSearchPattern(true);
        if (this.objectTypeExpression == null) {
            logger.info("(): No object types.  Returning.");
            this.resetUI();
            return;
        }
        String userEnteredSearch = this.tfSearchPattern.getText();
        if (StringUtility.isEmpty(userEnteredSearch)) {
            userEnteredSearch = "";
        }
        this.objectNameExpression = this.getMatchPattern();
        if (this.searchesByType == null) {
            this.searchesByType = new HashMap();
        }
        Pair<String, ArrayList<AdvancedObjectSearchOptions>> searchByType = new Pair<String, ArrayList<AdvancedObjectSearchOptions>>(userEnteredSearch, this.searchOptions);
        this.searchesByType.put(this.objectTypeExpression, searchByType);
        if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage(String.format("Listing object types matching '%s' having names matching '%s'", this.objectTypeExpression, this.objectNameExpression));
        }
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        logger.finer(() -> LMG.log("(): Getting configurations for object types matching '%s' with names matching '%s'", () -> this.objectTypeExpression, () -> this.objectNameExpression));
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> objectStatus = configurationManager.listObjects(selectedDomains, this.objectTypeExpression, this.objectNameExpression, this.useCaseSensitiveSearch);
        int objectCount = objectStatus.size();
        logger.finer(() -> LMG.log("(): Found %d configurations for object types matching '%s' with names matching '%s'", () -> objectCount, () -> this.objectTypeExpression, () -> this.objectNameExpression));
        if (CollectionUtility.isNotEmpty(objectStatus) && CollectionUtility.isNotEmpty(this.searchOptions)) {
            logger.finer(() -> LMG.log("(): Applying advanced search on %d configurations for object types matching '%s' with names matching '%s'", () -> objectCount, () -> this.objectTypeExpression, () -> this.objectNameExpression));
            FindObject findObject = new FindObject(objectStatus, this.searchOptions);
            objectStatus = findObject.getMatchingStatus();
            int advancedObjectCount = objectStatus.size();
            logger.finer(() -> LMG.log("(): %d configurations matched on advanced search for object types matching '%s' with names matching '%s'", () -> advancedObjectCount, () -> this.objectTypeExpression, () -> this.objectNameExpression));
        }
        if (objectStatus.size() > 0) {
            for (StatusObjectStatus s : objectStatus) {
                String eventCode = s.getEventCode();
                if (StringUtility.isEmpty(eventCode)) {
                    s.setEventCode("");
                    continue;
                }
                if (!eventCode.equals("0x00000000")) continue;
                s.setEventCode("");
            }
            int addObjectCount = objectStatus.size();
            logger.finer(() -> LMG.log("(): Adding %d objects.", () -> addObjectCount));
            this.tableModel.addAll(objectStatus);
        }
        if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage(String.format("Found %d objects matching '%s' having names matching '%s'", objectStatus.size(), this.objectTypeExpression, this.objectNameExpression));
        }
        this.popupMenu.setEnabled(this.tableModel.getRowCount() > 0);
        this.displayTable.optimizeColumnWidths();
        this.resetUI();
        logger.finer("(): Done");
    }

    @Reflected
    private void fileExportConfiguration() {
        AbstractPanel.logger.finer("(): Starting.");
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, 4, false, null);
        if (selectedObjectsInfo == null) {
            AbstractPanel.logger.fine("(): No objects selected for export.");
            return;
        }
        ArrayList selectedObjects = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        if (selectedObjects.size() == 0) {
            AbstractPanel.logger.fine("(): No objects selected for export.");
            return;
        }
        AbstractPanel.logger.finer("(): Opening export objects dialog.");
        new ExportOptionsDialog((JFrame)frame, new Object[0]);
        ExportOptions exportOptions = ExportOptionsDialog.getExportOptions();
        if (exportOptions.isCancelled()) {
            AbstractPanel.logger.fine("(): ExportOptions dialog was cancelled.");
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Export Configuration");
        AbstractPanel.logger.finer("(): Correcting object names prior to export.");
        ArrayList<StatusObjectStatus> objectsToExport = new ArrayList<StatusObjectStatus>(selectedObjects.size());
        for (StatusObjectStatus statusObject : selectedObjects) {
            String objectName = ConfigurationManager.getCorrectedObjectName(statusObject.getDataPowerClass(), statusObject.getName());
            statusObject.setName(objectName);
            objectsToExport.add(statusObject);
        }
        AbstractPanel.logger.finer("(): Beginning Configuration Export");
        ExportConfiguration.exportConfigurations(objectsToExport, exportOptions, this.commandResultsDialog);
        AbstractPanel.logger.finer("(): Completed export.");
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done.");
    }

    @Reflected
    private void fileSaveAs() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, -1, false, null);
        if (selectedObjectsInfo == null) {
            return;
        }
        WizardDialog saveAsDialog = this.createWizardDialog("Save Selected Object Configurations As");
        saveAsDialog.addWizardPage(new SaveAsWizardPage(selectedObjectsInfo), "saveAs");
        saveAsDialog.setSize(1000, 600);
        saveAsDialog.startWizard();
        this.finishSaveAsRename("Save As", selectedObjectsInfo, 7);
    }

    @Reflected
    private void fileReplace() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, -1, false, null);
        if (selectedObjectsInfo == null) {
            return;
        }
        WizardDialog<DynamicBean> replaceDialog = new WizardDialog<DynamicBean>((JFrame)frame, "Reference Refactoring - Replace");
        replaceDialog.addWizardPage(new ReplaceWizardPage(selectedObjectsInfo), "replace");
        replaceDialog.setSize(1000, 600);
        replaceDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Reference Refactoring - Replace");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ArrayList replaceDataList = (ArrayList)selectedObjectsInfo.getProperty("newData");
        for (DynamicBean replaceData : replaceDataList) {
            StatusObjectStatus objectStatus = new StatusObjectStatus();
            replaceData.toObject(objectStatus);
            String newObjectReference = (String)replaceData.getProperty("replaceName");
            ConfigurationReplace actionTool = new ConfigurationReplace(objectStatus, newObjectReference);
            mtil.addThread(actionTool.getProcessThread());
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ManageObjectsPanel.finishSaveAsRename(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        Index domains = (Index)selectedObjectsInfo.getProperty("domains");
        ConfigurationManager.saveConfiguration(domains, this.commandResultsDialog);
        Index<Appliance, Domain> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ConfigurationManager.clearCache(selectedAppliances);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void fileRename() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, -1, false, null);
        if (selectedObjectsInfo == null) {
            return;
        }
        WizardDialog<DynamicBean> renameDialog = new WizardDialog<DynamicBean>((JFrame)frame, "Object Refactoring - Rename");
        renameDialog.addWizardPage(new RenameWizardPage(selectedObjectsInfo), "saveAs");
        renameDialog.addWizardPage(new RenameWarningPage(selectedObjectsInfo), "warning");
        renameDialog.setSize(1000, 600);
        renameDialog.startWizard();
        this.finishSaveAsRename("Object Refactoring - Rename", selectedObjectsInfo, 9);
    }

    private void finishSaveAsRename(String commandResultsTitle, DynamicBean selectedObjectsInfo, int action) {
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor(commandResultsTitle);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ArrayList renameDataList = (ArrayList)selectedObjectsInfo.getProperty("newData");
        for (DynamicBean renameData : renameDataList) {
            StatusObjectStatus objectStatus = new StatusObjectStatus();
            renameData.toObject(objectStatus);
            String oldName = objectStatus.getName();
            String newName = (String)renameData.getProperty("newName");
            if (oldName.equals(newName)) continue;
            AbstractConfigurationActionTool actionTool = null;
            if (action == 7) {
                ConfigurationSaveAs configurationSaveAs;
                actionTool = configurationSaveAs = new ConfigurationSaveAs(objectStatus, newName);
            } else {
                boolean keepOriginal = (Boolean)selectedObjectsInfo.getProperty("keepOriginal");
                ConfigurationRename configurationRename = new ConfigurationRename(objectStatus, newName, keepOriginal);
                actionTool = configurationRename;
            }
            mtil.addThread(actionTool.getProcessThread());
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ManageObjectsPanel.finishSaveAsRename(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        Index domains = (Index)selectedObjectsInfo.getProperty("domains");
        ConfigurationManager.saveConfiguration(domains, this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        Index<Appliance, Domain> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ConfigurationManager.clearCache(selectedAppliances);
        this.searchFind();
    }

    @Reflected
    private void fileCompare() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, -1, false, null);
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjects = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        int selectedObjectsSize = selectedObjects.size();
        if (selectedObjectsSize == 0) {
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> configObjects = configurationManager.getObjects(selectedObjects);
        CompareObjectsDialog compareObjectsDialog = new CompareObjectsDialog((JFrame)frame, "Compare Object Configurations", configObjects);
        compareObjectsDialog.dispose();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void forceILMTScan() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects("ILMTScanner", 12, true, "Force ILMT Scan");
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjects = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        int selectedObjectsSize = selectedObjects.size();
        if (selectedObjectsSize == 0) {
            return;
        }
        this.showProgressBar(selectedObjectsSize);
        int objectIndex = 0;
        for (StatusObjectStatus selectedObject : selectedObjects) {
            ManagementCommandError commandError;
            String configState = selectedObject.getConfigState();
            String adminState = selectedObject.getAdminState();
            this.updateProgressBar(++objectIndex);
            if (adminState.equals("disabled")) {
                commandError = new ManagementCommandError(selectedObject.getAppliance(), selectedObject.getSourceDomain(), "Force ILMT Scan", null, "ILMT Scanner is disabled.");
                this.commandResultsDialog.commandFailed(commandError);
                continue;
            }
            if (configState.equals("deleted")) {
                commandError = new ManagementCommandError(selectedObject.getAppliance(), selectedObject.getSourceDomain(), "Force ILMT Scan", null, "ILMT Scanner is deleted.");
                this.commandResultsDialog.commandFailed(commandError);
                continue;
            }
            ActionILMTForceScan forceScanAction = new ActionILMTForceScan();
            ActionTool actionTool = new ActionTool(selectedObject, (JMBean)forceScanAction);
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
            actionTool.addManagementCommandSubscriber(this);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        this.hideProgressBar();
    }

    @Reflected
    private void undoConfig() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, 11, false, null);
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjects = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        int selectedObjectsSize = selectedObjects.size();
        if (selectedObjectsSize == 0) {
            return;
        }
        new JMMessageBox((JFrame)frame, "Undo Configuration", LabelUtility.wrapInHTML("Are you sure you want to revert the running configuration\nof all selected modified objects back to their persisted configuration?"), 12);
        if (JMMessageBox.getSelection() == 8) {
            return;
        }
        this.threadWait.clearCompletionStatus();
        this.showProgressBar(selectedObjectsSize);
        int objectIndex = 0;
        this.openResultsDialogAndSetWaitCursor("Undo Configuration");
        for (StatusObjectStatus selectedObject : selectedObjects) {
            String configState = selectedObject.getConfigState();
            this.updateProgressBar(++objectIndex);
            if (configState.equals("modified") || configState.equals("deleted")) {
                ActionUndoConfig undoConfigAction = new ActionUndoConfig();
                undoConfigAction.setDataPowerClass(selectedObject.getDataPowerClass());
                undoConfigAction.setName(selectedObject.getName());
                ActionTool actionTool = new ActionTool(selectedObject, (JMBean)undoConfigAction);
                actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
                actionTool.addManagementCommandSubscriber(this);
                actionTool.getProcessThread().addInvocationListener(this.threadWait);
                actionTool.addAdditionalCommandInfo("object", selectedObject);
                actionTool.addAdditionalCommandInfo("objectType", selectedObject.getDataPowerClass());
                actionTool.addAdditionalCommandInfo("objectName", selectedObject.getName());
            }
            this.threadWait.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            selectedObject.setConfigState("saved");
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        this.hideProgressBar();
        this.displayTable.repaint();
    }

    @Reflected
    private void resetFailedLogin() {
        DynamicBean selectionInfo = this.getUserSelectedObjects("User", -1, true, "Reset Failed Logins");
        if (selectionInfo == null) {
            return;
        }
        ArrayList selectedUsers = (ArrayList)selectionInfo.getProperty("selectedObjects");
        AbstractPanel.logger.finer(() -> LMG.log("(): %d users selected.", () -> selectedUsers.size()));
        for (StatusObjectStatus user : selectedUsers) {
            String eventCode = user.getEventCode();
            if (eventCode != null && eventCode.equals("0x02c30008")) {
                ActionUserResetFailedLogin actionInfo = new ActionUserResetFailedLogin();
                actionInfo.setUser(user.getName());
                ActionTool actionTool = new ActionTool(user.getAppliance(), user.getSourceDomain(), actionInfo);
                actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
                continue;
            }
            String message = String.format("Not resetting user '%s' due to not being locked out.", user.getName());
            ManagementCommandError commandError = new ManagementCommandError(user.getAppliance(), user.getSourceDomain(), "Reset Failed Login", null, message);
            this.commandResultsDialog.commandFailed(commandError);
            AbstractPanel.logger.info(() -> LMG.log("(): %s", () -> message));
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void showCertificateDetails() {
        DynamicBean selectionInfo = this.getUserSelectedObjects("CryptoCertificate", -1, true, null);
        if (selectionInfo == null) {
            return;
        }
        ArrayList selectedCertificates = (ArrayList)selectionInfo.getProperty("selectedObjects");
        AbstractPanel.logger.finer(() -> LMG.log("(): %d certificates selected.", () -> selectedCertificates.size()));
        ConfigurationManager configurationManager = new ConfigurationManager();
        CertificateInfoCache certificateInfoCache = new CertificateInfoCache();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (StatusObjectStatus certificateStatus : selectedCertificates) {
            ConfigCryptoCertificate certificateObject = (ConfigCryptoCertificate)configurationManager.getObject(certificateStatus);
            ViewCertificateDetails viewCertificateDetails = new ViewCertificateDetails(certificateObject.getAppliance(), certificateObject.getSourceDomain(), certificateObject);
            viewCertificateDetails.addCertificateExportSubscriber(certificateInfoCache);
            mtil.addThread(viewCertificateDetails.getProcessThread());
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ManageObjectsPanel.showCertificateDetails()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        ArrayList<CertificateInformation> certInfo = certificateInfoCache.getCache();
        AbstractPanel.logger.fine(() -> LMG.log("(): %d certificate details retrieved.", () -> certInfo.size()));
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        new CompareObjectsDialog((JFrame)AbstractPanel.frame, "Compare Certificates", certInfo);
    }

    @Reflected
    private void showReferencesDialog(ConfigurationRelationshipType relationshipType) {
        AbstractPanel.logger.finer(() -> LMG.log("(ConfigurationRelationshipType relationshipType=%s):  Starting", () -> relationshipType.toString()));
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (selectedRows.length == 0) {
            AbstractPanel.logger.info(() -> LMG.log("(relationshipType=%s):  No rows selected.", () -> relationshipType.toString()));
            return;
        }
        Arrays.sort(selectedRows);
        ArrayList<StatusObjectStatus> selectedObjects = new ArrayList<StatusObjectStatus>(selectedRows.length);
        int r = 0;
        while (r < selectedRows.length) {
            selectedObjects.add((StatusObjectStatus)this.tableModel.getValue(selectedRows[r]));
            ++r;
        }
        AbstractPanel.logger.finer(() -> LMG.log("(relationshipType=%s):  Opening ConfigurationRelationshipDialog.", () -> relationshipType.toString()));
        new ConfigurationRelationshipDialog((JFrame)AbstractPanel.frame, new Object[]{selectedObjects, relationshipType});
        AbstractPanel.logger.finer(() -> LMG.log("(ConfigurationRelationshipType relationshipType=%s):  Done", () -> relationshipType.toString()));
    }

    @Reflected
    private void changePasswordDialog() {
        AbstractPanel.logger.finer("(): Starting");
        ArrayList selectedObjects = this.getSelectedValues();
        if (selectedObjects.size() == 0) {
            AbstractPanel.logger.info("():  No rows selected.");
            return;
        }
        ArrayList<StatusObjectStatus> objectsWithPasswords = new ArrayList<StatusObjectStatus>();
        for (StatusObjectStatus object : selectedObjects) {
            String objectType = object.getDataPowerClass();
            if (!ConfigurationManager.doesObjectContainPassword(objectType)) continue;
            objectsWithPasswords.add(object);
        }
        if (objectsWithPasswords.size() == 0) {
            AbstractPanel.logger.info("():  No objects with passwords.");
            return;
        }
        DynamicBean model = new DynamicBean();
        model.setProperty("objectsWithPasswords", objectsWithPasswords);
        ChangePasswordsWizardPage wizardPage = new ChangePasswordsWizardPage(model);
        WizardDialog<DynamicBean> wizard = new WizardDialog<DynamicBean>((JFrame)AbstractPanel.frame, "Change Passwords");
        wizard.addWizardPage(wizardPage, "passwords");
        wizard.setSize(1000, 600);
        wizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Change Passwords");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList changedData = (ArrayList)model.getProperty("changedData");
        for (DynamicBean row : changedData) {
            String password = (String)row.getProperty("password");
            String newPassword = (String)row.getProperty("newPassword");
            if (!StringUtility.isNotEmpty(newPassword) || newPassword.equals(password)) continue;
            Appliance appliance = (Appliance)row.getProperty("appliance");
            Domain domain = (Domain)row.getProperty("domain");
            String dataPowerType = (String)row.getProperty("dataPowerType");
            String objectName = (String)row.getProperty("objectName");
            String propertyType = (String)row.getProperty("propertyType");
            String propertyName = (String)row.getProperty("propertyName");
            StatusObjectStatus statusObject = null;
            for (StatusObjectStatus selectedObject : objectsWithPasswords) {
                if (!selectedObject.getAppliance().equals(appliance) || !selectedObject.getSourceDomain().equals(domain) || !selectedObject.getDataPowerClass().equals(dataPowerType) || !selectedObject.getName().equals(objectName)) continue;
                statusObject = selectedObject;
                break;
            }
            if (propertyType.equals("PasswordAlias")) {
                Index<Appliance, Domain> idx = new Index<Appliance, Domain>();
                idx.put(appliance, domain);
                ArrayList<StatusObjectStatus> passMaps = configurationManager.listObjects(idx, "PasswordAlias", propertyName);
                StatusObjectStatus passMapAlias = passMaps.get(0);
                ModifyProperty<String> modifyProperty = new ModifyProperty<String>(passMapAlias, "Password", newPassword);
                modifyProperty.addManagementCommandSubscriber(this.commandResultsDialog);
                continue;
            }
            Class<? extends DataPowerConfig> type = ConfigurationManager.getConfigObjectClass(dataPowerType);
            Method method = BeanService.getPropertyAccessor(type, propertyName);
            XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(method, XMLInfo.class);
            String elementName = xmlInfo.elementName();
            ModifyProperty<String> modifyProperty = new ModifyProperty<String>(statusObject, elementName, newPassword);
            modifyProperty.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void migratePasswordDialog() {
        AbstractPanel.logger.finer("(): Starting");
        Collection<DataPowerConfig> migrationTargets = ((ManageObjectsPopupMenu)this.popupMenu).getMigrationTargets();
        if (migrationTargets == null) {
            AbstractPanel.logger.info("(): No migration targets.  **This should not be possible.");
            return;
        }
        DynamicBean model = new DynamicBean();
        model.setProperty("migrationTargets", migrationTargets);
        MigratePasswordsWizardPage wizardPage = new MigratePasswordsWizardPage(model);
        WizardDialog<DynamicBean> wizard = new WizardDialog<DynamicBean>((JFrame)AbstractPanel.frame, "Migrate Passwords");
        wizard.addWizardPage(wizardPage, "passwords");
        wizard.setSize(1000, 750);
        wizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        ArrayList migrateData = (ArrayList)model.getProperty("migrationFinalData");
        if (CollectionUtility.isEmpty(migrateData)) {
            AbstractPanel.logger.info("():  No changes detected.  Nothing to do.");
            new JMMessageBox((JFrame)AbstractPanel.frame, "Migrate Passwords", "No changes detected.  Nothing to do.");
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Migrate Passwords");
        HashMap<Appliance, Index<Domain, StatusObjectStatus>> passMapAliases = wizardPage.getPassMapAliasMap();
        new MigratePlaintextPasswords(migrationTargets, model, passMapAliases, this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void migrateProxyProfiles() {
        AbstractPanel.logger.finer("(): Starting");
        ArrayList selectedObjects = this.getSelectedValues();
        if (CollectionUtility.isEmpty(selectedObjects)) {
            AbstractPanel.logger.info("():  No rows selected.");
            return;
        }
        PropertyValueSelector proxyProfileSelector = new PropertyValueSelector(selectedObjects, "dataPowerClass", "SSLProxyProfile");
        ArrayList proxyProfiles = (ArrayList)proxyProfileSelector.getSelectedElements();
        if (CollectionUtility.isEmpty(proxyProfiles)) {
            AbstractPanel.logger.info("():  No profiles selected.");
            return;
        }
        DynamicBean model = new DynamicBean();
        model.setProperty("proxyProfiles", proxyProfiles);
        MigrateProxyProfileWizardPage setupPage = new MigrateProxyProfileWizardPage(model);
        MigrateProxyProfileFinalWizardPage finalPage = new MigrateProxyProfileFinalWizardPage(model);
        WizardDialog<DynamicBean> wizard = new WizardDialog<DynamicBean>((JFrame)AbstractPanel.frame, "Migrate Proxy Profiles");
        wizard.addWizardPage(setupPage, "setup");
        wizard.addWizardPage(finalPage, "final");
        wizard.setSize(1000, 800);
        wizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Migrate Proxy Profiles");
        new MigrateSSLProxyProfile(model, this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void editCopy() {
        this.action = 2;
        this.copyMoveObject(0);
    }

    @Reflected
    private void editMove() {
        this.action = 3;
        this.copyMoveObject(1);
    }

    private void copyMoveObject(int copyMoveMode) {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, 0, false, null);
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            return;
        }
        String crdTitle = String.format("%s Object Configurations", copyMoveMode == 0 ? "Copy" : "Move");
        CopyMoveObjectBean copyMoveObjectBean = new CopyMoveObjectBean(copyMoveMode);
        copyMoveObjectBean.setObjects(selectedObjectList);
        WizardDialog<CopyMoveActionBean> copyMoveObjectDialog = new WizardDialog<CopyMoveActionBean>((JFrame)frame, crdTitle);
        copyMoveObjectDialog.addWizardPage(new CopyMoveAppliancesPage(copyMoveObjectBean), "appliances");
        copyMoveObjectDialog.addWizardPage(new DuplicateDomainsPage(copyMoveObjectBean), "duplicateDomains");
        copyMoveObjectDialog.addWizardPage(new CopyMoveDomainsPage(copyMoveObjectBean), "domains");
        copyMoveObjectDialog.addWizardPage(new CopyMoveObjectsIncludeReferences(copyMoveObjectBean), "references");
        copyMoveObjectDialog.addWizardPage(new CopyMoveObjectsFinalPage(copyMoveObjectBean), "confirmation");
        copyMoveObjectDialog.setSize(1000, 600);
        copyMoveObjectDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        ArrayList<Pair<StatusObjectStatus, StatusObjectStatus>> s2dObjects = copyMoveObjectBean.getSourceToDestinationList();
        if (s2dObjects == null) {
            logger.config("Wizard was not cancelled but data is still null.  Why?");
            return;
        }
        this.openResultsDialogAndSetWaitCursor(crdTitle);
        long sessionStartTime = System.currentTimeMillis();
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        for (Pair<StatusObjectStatus, StatusObjectStatus> s2d : s2dObjects) {
            stil.clearCompletionStatus();
            StatusObjectStatus source = s2d.getFirst();
            StatusObjectStatus target = s2d.getSecond();
            CopyMoveType type = copyMoveMode == 0 ? CopyMoveType.COPY : CopyMoveType.MOVE;
            boolean includeReferences = copyMoveObjectBean.includeReferences();
            boolean includeFiles = copyMoveObjectBean.includeFiles();
            ConfigurationCopyMove configurationCopyMove = new ConfigurationCopyMove(type, source, target, includeReferences, includeFiles, sessionStartTime);
            configurationCopyMove.getProcessThread().addInvocationListener(stil);
            configurationCopyMove.addManagementCommandSubscriber(this.commandResultsDialog);
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void editEnableProbes() {
        this.setProbeState("on");
    }

    @Reflected
    private void editFlushProbes() {
        this.editDisableProbes();
        this.editEnableProbes();
    }

    @Reflected
    private void showProbes() {
        logger.finer("(): Starting");
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(DEBUG_TYPES_EXPRESSION, 10, false, null);
        if (selectedObjectsInfo == null) {
            logger.info("(): No debuggable selected objects. Return.");
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            logger.info("(): No selected objects. Return.");
            return;
        }
        logger.finer("(): Opening probe view dialog.");
        new ProbeViewDialog((JFrame)frame, selectedObjectList);
        logger.finer("(): Done");
    }

    @Reflected
    private void editDisableProbes() {
        this.setProbeState("off");
    }

    private void setProbeState(String state) {
        this.modifyObjectProperty("DebugMode", state, "Set debug mode to " + state);
    }

    @Reflected
    private void setProbeTransactionHistory(int history) {
        Object value = history == Integer.MAX_VALUE ? "unbounded" : "" + history;
        String propertyName = history == Integer.MAX_VALUE ? "DebugMode" : "DebugHistory";
        this.modifyObjectProperty(propertyName, (String)value, "Set debug history to " + (String)value);
    }

    private void modifyObjectProperty(String propertyName, String value, String dialogTitle) {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(DEBUG_TYPES_EXPRESSION, 0, true, dialogTitle);
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            return;
        }
        for (StatusObjectStatus object : selectedObjectList) {
            ModifyProperty<String> mp = new ModifyProperty<String>(object, propertyName, value);
            mp.addManagementCommandSubscriber(this.commandResultsDialog);
            object.setConfigState("modified");
        }
        this.displayTable.repaint();
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void toggleAdminState() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, 0, true, "Toggle Admin State");
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            return;
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (StatusObjectStatus objectStatus : selectedObjectList) {
            String adminState = objectStatus.getAdminState();
            String newAdminStateValue = adminState.equals("enabled") ? "disabled" : "enabled";
            objectStatus.setAdminState(newAdminStateValue);
            String newOpStateValue = newAdminStateValue.equals("disabled") ? "down" : "up";
            objectStatus.setOpState(newOpStateValue);
            String newEventCode = newAdminStateValue.equals("disabled") ? "0x0034000d" : "";
            objectStatus.setEventCode(newEventCode);
            String newErrorCode = newAdminStateValue.equals("disabled") ? "Object is disabled" : "";
            objectStatus.setErrorCode(newErrorCode);
            ModifyProperty<String> adminStateManager = new ModifyProperty<String>(objectStatus, "mAdminState", newAdminStateValue);
            mtil.addThread(adminStateManager.getProcessThread());
            adminStateManager.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        this.displayTable.repaint();
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void toggleQuiescence() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, 1, true, "Toggle Quiescense");
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            return;
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (StatusObjectStatus objectStatus : selectedObjectList) {
            ActionTool actionTool;
            String errorCode = objectStatus.getErrorCode();
            String dataPowerClass = objectStatus.getDataPowerClass();
            String objectName = objectStatus.getName();
            if (errorCode != null && errorCode.equals("in quiescence")) {
                ActionServiceUnquiesce actionServiceUnquiesce = new ActionServiceUnquiesce();
                actionServiceUnquiesce.setType(dataPowerClass);
                actionServiceUnquiesce.setName(objectName);
                actionTool = new ActionTool(objectStatus, (JMBean)actionServiceUnquiesce);
                mtil.addThread(actionTool.getProcessThread());
                actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
                objectStatus.setErrorCode("*** Maybe up.  Refresh the search to confirm.");
                objectStatus.setEventCode("???");
                objectStatus.setAdminState("up");
                continue;
            }
            ActionServiceQuiesce actionServiceQuiesce = new ActionServiceQuiesce();
            actionServiceQuiesce.setType(dataPowerClass);
            actionServiceQuiesce.setName(objectName);
            actionServiceQuiesce.setDelay(0);
            actionServiceQuiesce.setTimeout(60);
            actionTool = new ActionTool(objectStatus, (JMBean)actionServiceQuiesce);
            mtil.addThread(actionTool.getProcessThread());
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
            objectStatus.setErrorCode("in quiescense");
            objectStatus.setEventCode("0x0036003d");
            objectStatus.setOpState("down");
        }
        mtil.waitUntilComplete();
        this.waitForResultsDialogToCloseAndResetCursor();
        this.displayTable.invalidate();
        this.displayTable.repaint();
    }

    @Reflected
    private void editCreateLogTarget() {
        DynamicBean selectedObjectsInfo = this.getUserSelectedObjects(null, 0, false, null);
        if (selectedObjectsInfo == null) {
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjectsInfo.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            return;
        }
        DateTime now = new DateTime();
        StringBuilder userSummary = new StringBuilder("Generated by DPAA on ");
        userSummary.append(now.toString());
        userSummary.append(" for ");
        int initialUserSummaryLength = userSummary.length();
        ArrayList<LogObject> selectedObjects = new ArrayList<LogObject>(selectedObjectList.size());
        for (StatusObjectStatus object : selectedObjectList) {
            String objectName = object.getName();
            if (object.getDataPowerClass().equals("LogTarget") || userSummary.indexOf(objectName) >= 0) continue;
            LogObject logObject = new LogObject();
            logObject.setDataPowerClass(object.getDataPowerClass());
            logObject.setObject(object.getName());
            logObject.setFollowReferences("on");
            selectedObjects.add(logObject);
            if (userSummary.length() > initialUserSummaryLength) {
                userSummary.append(", ");
            }
            userSummary.append(objectName);
        }
        ConfigLogTarget configLogTarget = new ConfigLogTarget();
        configLogTarget.setAdminState("enabled");
        configLogTarget.setConfigObjectType("LogTarget");
        configLogTarget.setLogObjects(selectedObjects);
        configLogTarget.setFormat("text");
        LogEvent logEvent = new LogEvent();
        ObjectReference<ConfigLogLabel> logLabel = new ObjectReference<ConfigLogLabel>();
        logLabel.setName("all");
        logEvent.setDataPowerClass(logLabel);
        logEvent.setPriority("debug");
        configLogTarget.addLogEvents(logEvent);
        configLogTarget.setName("");
        configLogTarget.setRotate(10L);
        configLogTarget.setSize(1000L);
        configLogTarget.setType("file");
        configLogTarget.setMaxConnections(1);
        configLogTarget.setUserSummary(userSummary.toString());
        WizardDialog<ConfigLogTarget> createLogTargetDialog = new WizardDialog<ConfigLogTarget>((JFrame)frame, "Create Object Dedicated Logging Target");
        createLogTargetDialog.addWizardPage(new LogTargetBasicsPage(configLogTarget), "basics");
        createLogTargetDialog.addWizardPage(new LogTargetFileInfoPage(configLogTarget), "fileInfo");
        createLogTargetDialog.setSize(1000, 600);
        createLogTargetDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Create Dedicated Object Logging Target");
        Index selectedDomains = (Index)selectedObjectsInfo.getProperty("domains");
        for (Appliance appliance : selectedDomains.getKeys()) {
            for (Domain domain : selectedDomains.get(appliance)) {
                ConfigTool configTool = new ConfigTool(appliance, domain, configLogTarget);
                configTool.addIgnoreProperties("remotePort", "rateLimit", "connectTimeout", "idleTimeout", "activeTimeout", "identicalEventPeriod", "retryInterval", "retryAttempts", "longRetryInterval");
                configTool.addManagementCommandSubscriber(this.commandResultsDialog);
            }
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void editCreateMonitors() {
        DynamicBean selectedObjects = this.getUserSelectedObjects(MONITORED_TYPES_EXPRESSION, 1, true, "Create Simple Count/Duration Monitors");
        if (selectedObjects == null) {
            return;
        }
        ArrayList monitorableObjects = (ArrayList)selectedObjects.getProperty("selectedObjects");
        if (monitorableObjects.size() == 0) {
            return;
        }
        Index selectedDomains = (Index)selectedObjects.getProperty("domains");
        StringBuilder objectTypeExpression = new StringBuilder("(^");
        StringBuilder objectNameExpression = new StringBuilder("(^");
        for (StatusObjectStatus dpObject : monitorableObjects) {
            String dpClass = dpObject.getDataPowerClass();
            String objectName = dpObject.getName();
            ManageObjectsPanel.appendExpression(objectTypeExpression, dpClass);
            ManageObjectsPanel.appendExpression(objectNameExpression, objectName);
            String countAllName = String.format("%s_CountAll", objectName);
            String countErrorsName = String.format("%s_CountErrors", objectName);
            String durationAllName = String.format("%s_DurationAll", objectName);
            ManageObjectsPanel.appendExpression(objectNameExpression, countAllName);
            ManageObjectsPanel.appendExpression(objectNameExpression, countErrorsName);
            ManageObjectsPanel.appendExpression(objectNameExpression, durationAllName);
        }
        this.threadWait.clearCompletionStatus();
        objectTypeExpression.append("$|^MessageType$|^MessageMatching$|^CountMonitor$|^DurationMonitor$)");
        objectNameExpression.append("$|^DPAA_TypeAll$|^DPAA_MatchAll$)");
        ConfigurationManager.updateExportOptionsSessionTime();
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> configs = configurationManager.getObjects((Index<Appliance, Domain>)selectedDomains, objectTypeExpression.toString(), objectNameExpression.toString());
        BeanIndexer<DataPowerConfig> applianceIndexer = new BeanIndexer<DataPowerConfig>(configs);
        Index<Object, DataPowerConfig> applianceIndex = applianceIndexer.getIndexOf("appliance", null);
        DateTime today = new DateTime();
        String userSummary = String.format("Created by DPAA on %s", today);
        ConfigMessageMatching allMessageMatch = new ConfigMessageMatching();
        allMessageMatch.setAdminState(DPEnumerations.ADMIN_STATE[0]);
        allMessageMatch.setName("DPAA_MatchAll");
        allMessageMatch.setUserSummary(userSummary);
        allMessageMatch.setRequestURL("*");
        ObjectReference<ConfigMessageMatching> matchingRef = new ObjectReference<ConfigMessageMatching>();
        matchingRef.setClassName("MessageMatching");
        matchingRef.setName(allMessageMatch.getName());
        ConfigMessageType allMessageType = new ConfigMessageType();
        allMessageType.setAdminState(DPEnumerations.ADMIN_STATE[0]);
        allMessageType.setName("DPAA_TypeAll");
        allMessageType.setUserSummary(userSummary);
        allMessageType.addMatching(matchingRef);
        ObjectReference<ConfigMessageType> typeRef = new ObjectReference<ConfigMessageType>();
        typeRef.setClassName("MessageType");
        typeRef.setName(allMessageType.getName());
        for (Appliance appliance : applianceIndex.getKeys()) {
            Collection<DataPowerConfig> applianceObjects = applianceIndex.get(appliance);
            BeanIndexer<DataPowerConfig> domainIndexer = new BeanIndexer<DataPowerConfig>(applianceObjects);
            Index<Object, DataPowerConfig> domainIndex = domainIndexer.getIndexOf("sourceDomain", null);
            for (Domain domain : domainIndex.getKeys()) {
                Collection<DataPowerConfig> domainObjects = domainIndex.get(domain);
                PropertyValueSelector<DataPowerConfig> selector = new PropertyValueSelector<DataPowerConfig>(domainObjects);
                selector.addPropertyValueMap("configObjectType", "MessageMatching");
                selector.addPropertyValueMap("name", "DPAA_MatchAll");
                Collection messageMatchings = selector.getSelectedElements();
                selector.addPropertyValueMap("configObjectType", "MessageType");
                selector.addPropertyValueMap("name", "DPAA_TypeAll");
                Collection messageTypes = selector.getSelectedElements();
                ArrayList<DataPowerConfig> typesToCreate = new ArrayList<DataPowerConfig>();
                if (CollectionUtility.isEmpty(messageMatchings)) {
                    typesToCreate.add(allMessageMatch);
                }
                if (CollectionUtility.isEmpty(messageTypes)) {
                    typesToCreate.add(allMessageType);
                }
                if (CollectionUtility.isNotEmpty(typesToCreate)) {
                    ConfigTool configTool = new ConfigTool(appliance, domain, (Collection<DataPowerConfig>)typesToCreate);
                    configTool.setCommandDescription("Creating DPAA_MatchALL message matching and DPAA_TypeAll message type.");
                    configTool.addManagementCommandSubscriber(this.commandResultsDialog);
                    this.threadWait.clearCompletionStatus();
                    configTool.addInvocationListener(this.threadWait);
                    this.threadWait.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                    typesToCreate.clear();
                }
                ArrayList<DataPowerConfig> modifyObjects = new ArrayList<DataPowerConfig>();
                for (DataPowerConfig config : domainObjects) {
                    ArrayList serviceDurationMonitors;
                    PropertyValueSelector nameSelector;
                    Collection countAll;
                    if (!MONITORED_TYPES.contains(config.getConfigObjectType())) continue;
                    String objectName = config.getName();
                    String countAllObjectName = String.format("%s_CountAll", objectName);
                    String countErrorsObjectName = String.format("%s_CountErrors", objectName);
                    String durationAllObjectName = String.format("%s_DurationAll", objectName);
                    ConfigCountMonitor countAllMonitor = new ConfigCountMonitor();
                    countAllMonitor.setAdminState(DPEnumerations.ADMIN_STATE[0]);
                    countAllMonitor.setName(countAllObjectName);
                    countAllMonitor.setUserSummary(userSummary);
                    countAllMonitor.setMeasure(DPEnumerations.COUNT_MONITOR_TYPE[0]);
                    countAllMonitor.setSource(DPEnumerations.COUNT_MONITOR_SOURCE[0]);
                    countAllMonitor.setHeader("X-Client-IP");
                    countAllMonitor.setMaxSources(10000L);
                    countAllMonitor.setMessageType(typeRef);
                    ObjectReference countAllRef = new ObjectReference();
                    countAllRef.setClassName("CountMonitor");
                    countAllRef.setName(countAllMonitor.getName());
                    ConfigCountMonitor countErrorsMonitor = new ConfigCountMonitor();
                    countErrorsMonitor.setAdminState(DPEnumerations.ADMIN_STATE[0]);
                    countErrorsMonitor.setName(countErrorsObjectName);
                    countErrorsMonitor.setUserSummary(userSummary);
                    countErrorsMonitor.setMeasure(DPEnumerations.COUNT_MONITOR_TYPE[3]);
                    countErrorsMonitor.setSource(DPEnumerations.COUNT_MONITOR_SOURCE[0]);
                    countErrorsMonitor.setHeader("X-Client-IP");
                    countErrorsMonitor.setMaxSources(10000L);
                    countErrorsMonitor.setMessageType(typeRef);
                    ObjectReference countErrorsRef = new ObjectReference();
                    countErrorsRef.setClassName("CountMonitor");
                    countErrorsRef.setName(countErrorsMonitor.getName());
                    ConfigDurationMonitor durationAllMonitor = new ConfigDurationMonitor();
                    durationAllMonitor.setAdminState(DPEnumerations.ADMIN_STATE[0]);
                    durationAllMonitor.setName(durationAllObjectName);
                    durationAllMonitor.setUserSummary(userSummary);
                    durationAllMonitor.setMeasure(DPEnumerations.DURATION_MONITOR_TYPE[0]);
                    durationAllMonitor.setMessageType(typeRef);
                    ObjectReference durationAllRef = new ObjectReference();
                    durationAllRef.setClassName("DurationMonitor");
                    durationAllRef.setName(durationAllMonitor.getName());
                    selector.addPropertyValueMap("configObjectType", "CountMonitor");
                    selector.addPropertyValueMap("name", countAllObjectName);
                    Collection countAllMonitors = selector.getSelectedElements();
                    selector.addPropertyValueMap("name", countErrorsObjectName);
                    Collection countErrorMonitors = selector.getSelectedElements();
                    selector.addPropertyValueMap("configObjectType", "DurationMonitor");
                    selector.addPropertyValueMap("name", durationAllObjectName);
                    Collection durationMonitors = selector.getSelectedElements();
                    if (CollectionUtility.isEmpty(countAllMonitors)) {
                        typesToCreate.add(countAllMonitor);
                    }
                    if (CollectionUtility.isEmpty(countErrorMonitors)) {
                        typesToCreate.add(countErrorsMonitor);
                    }
                    if (CollectionUtility.isEmpty(durationMonitors)) {
                        typesToCreate.add(durationAllMonitor);
                    }
                    if (CollectionUtility.isNotEmpty(typesToCreate)) {
                        ConfigTool configTool = new ConfigTool(appliance, domain, (Collection<DataPowerConfig>)typesToCreate);
                        configTool.setCommandDescription("Creating Count and Duration Monitors");
                        configTool.addManagementCommandSubscriber(this.commandResultsDialog);
                        this.threadWait.clearCompletionStatus();
                        configTool.addInvocationListener(this.threadWait);
                        this.threadWait.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                    }
                    boolean isModified = false;
                    ArrayList serviceCountMonitors = (ArrayList)BeanService.getPropertyValue(config, "countMonitors");
                    if (serviceCountMonitors == null) {
                        serviceCountMonitors = new ArrayList();
                    }
                    if (CollectionUtility.isEmpty(countAll = (nameSelector = new PropertyValueSelector(serviceCountMonitors, "name", countAllObjectName)).getSelectedElements())) {
                        serviceCountMonitors.add(countAllRef);
                        isModified = true;
                    }
                    nameSelector.addPropertyValueMap("name", countErrorsObjectName);
                    Collection countErrors = nameSelector.getSelectedElements();
                    if (CollectionUtility.isEmpty(countErrors)) {
                        serviceCountMonitors.add(countErrorsRef);
                        isModified = true;
                    }
                    if ((serviceDurationMonitors = (ArrayList)BeanService.getPropertyValue(config, "durationMonitors")) == null) {
                        serviceDurationMonitors = new ArrayList();
                    }
                    nameSelector.setCollection(serviceDurationMonitors);
                    nameSelector.addPropertyValueMap("name", durationAllObjectName);
                    Collection durationAll = nameSelector.getSelectedElements();
                    if (CollectionUtility.isEmpty(durationAll)) {
                        serviceDurationMonitors.add(durationAllRef);
                        isModified = true;
                    }
                    if (!isModified) continue;
                    if (CollectionUtility.isNotEmpty(serviceCountMonitors)) {
                        BeanService.setPropertyValue(config, "countMonitors", serviceCountMonitors);
                    }
                    if (CollectionUtility.isNotEmpty(serviceDurationMonitors)) {
                        BeanService.setPropertyValue(config, "durationMonitors", serviceDurationMonitors);
                    }
                    modifyObjects.add(config);
                }
                if (CollectionUtility.isNotEmpty(modifyObjects)) {
                    ModifyTool modifyTool = new ModifyTool(appliance, domain, (Collection<DataPowerConfig>)modifyObjects);
                    modifyTool.addIgnoreProperties("userSummary");
                    modifyTool.setCommandDescription("Adding monitors");
                    modifyTool.addManagementCommandSubscriber(this.commandResultsDialog);
                    this.threadWait.clearCompletionStatus();
                    modifyTool.addInvocationListener(this.threadWait);
                    this.threadWait.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                }
                ConfigurationManager.saveConfiguration(appliance, domain, this, this.commandResultsDialog);
            }
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void editCryptoObject(int objectType, String updateType) {
        String loggerPrefix = String.format("(objectType=%d, updateType=%s)", objectType, updateType);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        String resultsDialogTitle = "Update Crypto Object";
        String objectClass = switch (objectType) {
            case 0 -> {
                resultsDialogTitle = "Update Certificate";
                yield "CryptoCertificate";
            }
            case 1 -> {
                resultsDialogTitle = "Update Crypto Key";
                yield "CryptoKey";
            }
            case 2 -> {
                resultsDialogTitle = "Update Kerberos Keytab";
                yield "CryptoKerberosKeytab";
            }
            case 3 -> {
                resultsDialogTitle = "Update Shared Secret Key";
                yield "CryptoSSKey";
            }
            default -> "";
        };
        DynamicBean selectedObjects = this.getUserSelectedObjects(objectClass, -1, false, null);
        new UpdateCryptoObjectWizardDialog((JFrame)frame, selectedObjects, objectType, updateType);
        if (WizardDialog.wasCancelled()) {
            AbstractPanel.logger.finer(() -> LMG.log("%s: User cancelled dialog.  Returning.", () -> loggerPrefix));
            return;
        }
        this.openResultsDialogAndSetWaitCursor(resultsDialogTitle);
        UpdateCryptoObject updateCryptoObject = new UpdateCryptoObject(selectedObjects);
        updateCryptoObject.addManagementCommandSubscriber(this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }

    @Reflected
    private void generateSharedSecretKey() {
        AbstractPanel.logger.finer("(): Starting)");
        DynamicBean selectedObjects = this.getUserSelectedObjects("CryptoSSKey", -1, false, null);
        ArrayList<String> directories = new ArrayList<String>();
        directories.add("cert:");
        directories.add("local:");
        selectedObjects.setProperty("directories", directories);
        WizardDialog dialog = this.createWizardDialog("Generate Shared Secret Key");
        dialog.addWizardPage(new GenerateSecretKeyFileTypePage(selectedObjects), "fileType");
        NewFileWizardPage newFileWizardPage = new NewFileWizardPage(selectedObjects, "GenerateSharedSecreteKeyNewFilePage.html");
        newFileWizardPage.setFinalPage(true);
        dialog.addWizardPage(newFileWizardPage, "newFile");
        dialog.setSize(650, 400);
        dialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Update Shared Secret Key");
        UpdateCryptoSSKey updateCryptoSSKey = new UpdateCryptoSSKey(selectedObjects);
        updateCryptoSSKey.addManagementCommandSubscriber(this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done)");
    }

    @Reflected
    private void editCryptoIDCredential(String updateType) {
        String loggerPrefix = String.format("(updateType=%s)", updateType);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        DynamicBean selectedObjects = this.getUserSelectedObjects("CryptoIdentCred", -1, false, null);
        new CreateCryptoIDCredWizardDialog((JFrame)frame, "Update Crypto ID Credential", selectedObjects, updateType);
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Update Crypto ID Credentials");
        UpdateCryptoIDCred updateCred = new UpdateCryptoIDCred(selectedObjects);
        updateCred.addManagementCommandSubscriber(this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }

    @Reflected
    private void editManageConfigMembers(ListPropertyTableEditorInfo tableEditorInfo) {
        logger.finer(() -> LMG.log("(tableEditorInfo):  Starting for the %s property of %s managing %ss of %s", () -> tableEditorInfo.getContainerPropertyName(), () -> tableEditorInfo.getContainingType(), () -> tableEditorInfo.getContainedType(), () -> tableEditorInfo.getContainedTypeClass().getSimpleName()));
        DynamicBean selectedObjects = this.setupDynamicMenuWizardData(tableEditorInfo);
        if (selectedObjects == null) {
            return;
        }
        WizardDialog wizardDialog = (WizardDialog)selectedObjects.getProperty("wizardDialog");
        wizardDialog.addWizardPage(new ManageListPropertiesEditPage(selectedObjects, (String)selectedObjects.getProperty("editPageHelpFileName")), "manageListProperties");
        this.completeDynamicModification(selectedObjects, tableEditorInfo);
        logger.finer(() -> LMG.log("(tableEditorInfo):  Done for the %s property of %s managing %ss of %s", () -> tableEditorInfo.getContainerPropertyName(), () -> tableEditorInfo.getContainingType(), () -> tableEditorInfo.getContainedType(), () -> tableEditorInfo.getContainedTypeClass().getSimpleName()));
    }

    @Reflected
    private void editManageComplexMembers(ComplexTypeTableEditorInfo tableEditorInfo) {
        logger.finer(() -> LMG.log("(tableEditorInfo):  Starting for the %s property of %s managing %ss of %s", () -> tableEditorInfo.getContainerPropertyName(), () -> tableEditorInfo.getContainingType(), () -> tableEditorInfo.getContainedType(), () -> tableEditorInfo.getContainedTypeClass().getSimpleName()));
        DynamicBean selectedObjects = this.setupDynamicMenuWizardData(tableEditorInfo);
        if (selectedObjects == null) {
            return;
        }
        WizardDialog wizardDialog = (WizardDialog)selectedObjects.getProperty("wizardDialog");
        wizardDialog.addWizardPage(new ManageComplexPropertiesEditPage(selectedObjects, (String)selectedObjects.getProperty("editPageHelpFileName")), "manageComplexProperties");
        this.completeDynamicModification(selectedObjects, tableEditorInfo);
        logger.finer(() -> LMG.log("(tableEditorInfo):  Done for the %s property of %s managing %ss of %s", () -> tableEditorInfo.getContainerPropertyName(), () -> tableEditorInfo.getContainingType(), () -> tableEditorInfo.getContainedType(), () -> tableEditorInfo.getContainedTypeClass().getSimpleName()));
    }

    private DynamicBean setupDynamicMenuWizardData(TableEditorInfo tableEditorInfo) {
        logger.finer(() -> LMG.log("(tableEditorInfo):  Starting for the %s property of %s managing %ss of %s", () -> tableEditorInfo.getContainerPropertyName(), () -> tableEditorInfo.getContainingType(), () -> tableEditorInfo.getContainedType(), () -> tableEditorInfo.getContainedTypeClass().getSimpleName()));
        String containingType = tableEditorInfo.getContainingType();
        DynamicBean selectedObjects = this.getUserSelectedObjects(containingType.substring(6), -1, true, null);
        if (selectedObjects == null) {
            AbstractPanel.logger.info(() -> LMG.log("(TableEditorInfo):  Unable to get selected objects of %s", () -> containingType));
            return null;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjects.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            AbstractPanel.logger.info(() -> LMG.log("(TableEditorInfo):  There of no selected objects of %s", () -> containingType));
            return null;
        }
        selectedObjects.setProperty("tableEditorInfo", tableEditorInfo);
        String editPageHelpFileName = tableEditorInfo.getEditPageHelpFileName();
        selectedObjects.setProperty("editPageHelpFileName", editPageHelpFileName);
        String propertyName = tableEditorInfo.getContainerPropertyName();
        selectedObjects.setProperty("containerPropertyName", propertyName);
        selectedObjects.setProperty("containingType", containingType);
        selectedObjects.setProperty(containingType, null);
        String dialogTitle = tableEditorInfo.getMenuItemText().replace("...", "");
        WizardDialog wizardDialog = new WizardDialog((JFrame)frame, dialogTitle);
        selectedObjects.setProperty("wizardDialog", wizardDialog);
        logger.finer(() -> LMG.log("(tableEditorInfo):  Starting for the %s property of %s managing %ss of %s.  Returning selected objects.", () -> tableEditorInfo.getContainerPropertyName(), () -> tableEditorInfo.getContainingType(), () -> tableEditorInfo.getContainedType(), () -> tableEditorInfo.getContainedTypeClass().getSimpleName()));
        return selectedObjects;
    }

    private void completeDynamicModification(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo) {
        logger.finer("(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo): Starting - Opening Wizard Dialog.");
        WizardDialog wizardDialog = (WizardDialog)selectedObjects.getProperty("wizardDialog");
        wizardDialog.setSize(1350, 800);
        wizardDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            logger.fine("(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo): Dialog Cancelled.  Done.");
            this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
            return;
        }
        logger.finer("(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo): Back from dialog.  Proceeding with changes.");
        String menuTitle = tableEditorInfo.getMenuItemText().replace(".", "");
        this.openResultsDialogAndSetWaitCursor(menuTitle);
        ArrayList dpObjects = (ArrayList)selectedObjects.getProperty(tableEditorInfo.getContainingType());
        HashMap modifyStructure = DataStructureUtility.mapByApplianceDomain(dpObjects);
        for (Appliance appliance : modifyStructure.keySet()) {
            Index objectsByDomain = modifyStructure.get(appliance);
            logger.finer(() -> LMG.log("(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo):  %d objects in appliance '%s'", () -> objectsByDomain.totalSize(), () -> appliance.getName()));
            for (Domain domain : objectsByDomain.getKeys()) {
                Collection objectsInDomain = objectsByDomain.get(domain);
                logger.finer(() -> LMG.log("(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo):  %d objects in the '%s' domain of appliance '%s'.  Updating Config.", () -> objectsInDomain.size(), () -> domain.getName(), () -> appliance.getName()));
                ConfigTool configTool = new ConfigTool(appliance, domain, (Collection<DataPowerConfig>)new ArrayList<DataPowerConfig>(objectsInDomain));
                configTool.addManagementCommandSubscriber(this.commandResultsDialog);
                configTool.setCommandDescription(menuTitle);
            }
        }
        logger.finer("(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo): All changes submitted.  Cleaning up.");
        Index domains = (Index)selectedObjects.getProperty("domains");
        ConfigurationManager.clearCache(domains);
        this.displayTable.repaint();
        this.waitForResultsDialogToCloseAndResetCursor();
        logger.finer("(DynamicBean selectedObjects, TableEditorInfo tableEditorInfo): Done.");
    }

    private static void appendExpression(StringBuilder expression, String value) {
        if (expression.indexOf(value) >= 0) {
            return;
        }
        if (expression.length() > 2) {
            expression.append("$|^");
        }
        expression.append(value);
    }

    @Reflected
    private void editSetLogLevel(String logLevel) {
        logger.finer(() -> LMG.log("(logLevel='%s'):  Starting.", () -> logLevel));
        DynamicBean selectedObjects = this.getUserSelectedObjects(null, 6, true, "Set Logging Level");
        if (selectedObjects == null) {
            logger.finer(() -> LMG.log("(logLevel='%s'):  No objects selected.  Nothing to do.", () -> logLevel));
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjects.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            logger.finer(() -> LMG.log("(logLevel='%s'):  No objects selected.  Nothing to do.", () -> logLevel));
            return;
        }
        for (StatusObjectStatus objectStatus : selectedObjectList) {
            logger.finer(() -> LMG.log("(logLevel='%s'):  Setting the logging level on '%s'.", () -> logLevel, () -> objectStatus.getFQON()));
            SetLogTargetLogLevel setLogTargetLogLevel = new SetLogTargetLogLevel(objectStatus, logLevel);
            setLogTargetLogLevel.addCommandSubscriber(this.commandResultsDialog);
            objectStatus.setConfigState("modified");
        }
        logger.finer(() -> LMG.log("(logLevel='%s'):  Cleaning up display.", () -> logLevel));
        this.displayTable.repaint();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.finer(() -> LMG.log("(logLevel='%s'):  Done.", () -> logLevel));
    }

    @Reflected
    private void editDelete() {
        logger.finer("(): Starting");
        DynamicBean selectedObjects = this.getUserSelectedObjects(null, 5, false, null);
        if (selectedObjects == null) {
            return;
        }
        ArrayList selectedObjectList = (ArrayList)selectedObjects.getProperty("selectedObjects");
        if (selectedObjectList.size() == 0) {
            return;
        }
        logger.finer("(): Removing all types having a debugMode property.");
        CollectionUtility.removeElementsStartingWith(DEBUG_TYPES, DEBUG_TYPES_EXPRESSION);
        logger.finer("(): Removing all externally configured types");
        PropertyValueSelector externalSelector = new PropertyValueSelector(selectedObjectList);
        externalSelector.addPropertyValueMap("configState", "external");
        ArrayList externalConfigs = (ArrayList)externalSelector.getSelectedElements();
        for (StatusObjectStatus externalObject : externalConfigs) {
            selectedObjectList.remove(externalObject);
        }
        if (selectedObjectList.size() == 0) {
            return;
        }
        logger.finer("(): Opening wizard dialog.");
        WizardDialog<DynamicBean> wizardDialog = new WizardDialog<DynamicBean>((JFrame)frame, "Delete Objects");
        wizardDialog.addWizardPage(new DeleteObjectCasadeChoiceWizardPage(selectedObjects), "cascadeChoice");
        wizardDialog.addWizardPage(new DeleteExceptionsWizardPage(selectedObjects), "deleteExceptions");
        wizardDialog.addWizardPage(new DeleteObjectFinalWizardPage(selectedObjects), "finalPage");
        wizardDialog.setSize(1000, 700);
        wizardDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            logger.finer("(): Wizard cancelled.  Returning.");
            return;
        }
        logger.finer("(): Opening results dialog and begin processing.");
        this.openResultsDialogAndSetWaitCursor("Delete Configuration");
        ArrayList deleteData = (ArrayList)selectedObjects.getProperty("deleteData");
        HashSet<Integer> deletedObjects = new HashSet<Integer>();
        int nDeleted = 0;
        this.showProgressBar(deleteData.size());
        for (DynamicBean bean : deleteData) {
            Appliance appliance = (Appliance)bean.getProperty("appliance");
            Domain domain = (Domain)bean.getProperty("domain");
            String objectType = (String)bean.getProperty("objectType");
            String objectName = (String)bean.getProperty("objectName");
            int hash = bean.hashCodeOf("appliance", "domain", "objectType", "objectName");
            if (deletedObjects.contains(hash)) {
                AbstractPanel.logger.finer(() -> LMG.log("(): Skipping %s->%s->%s->%s because it has already been removed.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
                ++nDeleted;
                continue;
            }
            deletedObjects.add(hash);
            this.threadWait.clearCompletionStatus();
            String objectToDelete = String.format("Deleting %s->%s->%s->%s[%d]", appliance.getName(), domain.getName(), objectType, objectName, bean.getProperty("deleteOrder"));
            AbstractPanel.logger.fine(objectToDelete);
            if (objectType.equals("File")) {
                ActionDeleteFile actionDeleteFile = new ActionDeleteFile();
                actionDeleteFile.setFile(objectName);
                ActionTool fileDeleter = new ActionTool(appliance, domain, actionDeleteFile);
                fileDeleter.getProcessThread().addInvocationListener(this.threadWait);
                fileDeleter.setCommandDescription(String.format("Delete file %s in %s domain of %s", objectName, domain.getName(), appliance.getName()));
                fileDeleter.addManagementCommandSubscriber(this.commandResultsDialog);
                fileDeleter.addManagementCommandSubscriber(this);
                fileDeleter.addAdditionalCommandInfo("objectType", objectType);
                fileDeleter.addAdditionalCommandInfo("objectName", objectName);
            } else {
                DeleteObjectConfiguration deleteObjectConfiguration = new DeleteObjectConfiguration(appliance, domain, objectType, objectName);
                AsynchMethodInvoker<?> processThread = deleteObjectConfiguration.getProcessThread();
                processThread.addInvocationListener(this.threadWait);
                deleteObjectConfiguration.addManagementCommandSubscriber(this.commandResultsDialog);
                deleteObjectConfiguration.addManagementCommandSubscriber(this);
                deleteObjectConfiguration.addAdditionalCommandInfo("objectType", objectType);
                deleteObjectConfiguration.addAdditionalCommandInfo("objectName", objectName);
            }
            boolean completedOnTime = this.threadWait.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            if (!completedOnTime) {
                logger.info(() -> LMG.log("(): Delete of %s->%s->%s->%s did not complete on time.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
            } else {
                logger.info(() -> LMG.log("(): %s->%s->%s->%s Deleted.", () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
            }
            this.updateProgressBar(++nDeleted);
        }
        logger.finer("(): Cleaning up display");
        this.displayTable.repaint();
        this.waitForResultsDialogToCloseAndResetCursor();
        this.hideProgressBar();
        logger.finer("(): Starting");
    }

    public DynamicBean getUserSelectedObjects(String matchingClassExpression, int actionID, boolean performUIPreliminaries, String commandResultsDialogTitle) {
        DynamicBean userSelectedObjects = new DynamicBean();
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return null;
        }
        Arrays.sort(selectedRows);
        Index<Appliance, Domain> userSelectedDomains = new Index<Appliance, Domain>();
        ArrayList<StatusObjectStatus> selectedObjects = new ArrayList<StatusObjectStatus>();
        int r = 0;
        while (r < selectedRows.length) {
            StatusObjectStatus objectStatus = (StatusObjectStatus)this.tableModel.getValue(selectedRows[r]);
            if (matchingClassExpression == null || objectStatus.getDataPowerClass().matches(matchingClassExpression)) {
                Appliance appliance = objectStatus.getAppliance();
                Domain domain = objectStatus.getSourceDomain();
                selectedObjects.add(objectStatus);
                if (!userSelectedDomains.containsValue(appliance, domain)) {
                    userSelectedDomains.put(appliance, domain);
                }
            }
            ++r;
        }
        userSelectedObjects.setProperty("domains", userSelectedDomains);
        userSelectedObjects.setProperty("selectedObjects", selectedObjects);
        if (selectedObjects.size() > 0) {
            this.action = actionID;
            if (performUIPreliminaries) {
                if (commandResultsDialogTitle == null) {
                    this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
                } else {
                    this.openResultsDialogAndSetWaitCursor(commandResultsDialogTitle);
                }
            }
        }
        return userSelectedObjects;
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        DynamicBean additionalCommandInfo = commandStatus.getAdditionalCommandInfo();
        if ((this.action == 5 || this.action == 11) && additionalCommandInfo != null) {
            Appliance appliance = commandStatus.getAppliance();
            Domain domain = commandStatus.getDomain();
            String objectType = (String)additionalCommandInfo.getProperty("objectType");
            String objectName = (String)additionalCommandInfo.getProperty("objectName");
            String actionName = this.action == 5 ? "Delete" : "Undo";
            String newConfigState = this.action == 5 ? "deleted" : "saved";
            String newOpState = this.action == 5 ? "down" : "up";
            AbstractPanel.logger.info(() -> LMG.log("(ManagementCommandStatus):  Action: %s %s -> %s -> %s -> %s\n", () -> actionName, () -> appliance.getName(), () -> domain.getName(), () -> objectType, () -> objectName));
            int[] selectedRows = this.displayTable.getSelectedRows();
            int r = 0;
            while (r < selectedRows.length) {
                StatusObjectStatus objectStatus = (StatusObjectStatus)this.tableModel.getValue(selectedRows[r]);
                if (objectStatus.getAppliance().equals(appliance) && objectStatus.getSourceDomain().equals(domain) && objectStatus.getDataPowerClass().equals(objectType) && objectStatus.getName().equals(objectName)) {
                    objectStatus.setConfigState(newConfigState);
                    objectStatus.setOpState(newOpState);
                    break;
                }
                ++r;
            }
        }
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
    }

    @Override
    public void attributeAdded(Object key, Object value) {
        String loggerPrefix = String.format("(Object key=%s, Object value=%s)", String.valueOf(key), String.valueOf(value));
        logger.finest(() -> LMG.log("%s - Starting", () -> loggerPrefix));
        if (key.equals("Appliance Groups")) {
            this.createPopupMenu();
        }
        logger.finest(() -> LMG.log("%s - Done", () -> loggerPrefix));
    }

    @Override
    public void attributeChanged(Object key, Object oldValue, Object newValue) {
    }

    @Override
    public void attributeRemoved(Object key, Object value) {
    }
}

