/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerStatusListener;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.status.StatusDomainStatus;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;

public class SaveConfigurationsPanel
extends AbstractPanel
implements DataPowerStatusListener<StatusDomainStatus>,
ManagementCommandSubscriber {
    private final Object LOCK = new Object();
    private BeanTableModel<StatusDomainStatus> domainStatusTableModel;
    private BeanColumnModel<StatusDomainStatus> domainStatusColumModel;
    private JMTable domainStatusTable;
    private JMButton updateListButton;
    private JMButton saveConfigButton;
    private HashMap<String, String> domainStatusMap = new HashMap();
    private boolean waitingToComplete;

    public SaveConfigurationsPanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.domainStatusTableModel = new BeanTableModel<StatusDomainStatus>(StatusDomainStatus.class);
        this.domainStatusTableModel.setValueExpression("appliance", "name");
        this.domainStatusColumModel = new BeanColumnModel<StatusDomainStatus>(StatusDomainStatus.class);
        this.domainStatusColumModel.hideColumns("currentCommand", "debugEnabled", "diagEnabled", "failsafeMode", "interfaceState", "probeEnabled", "quiesceState", "saveNeeded", "sourceDomain", "statusTime", "traceEnabled", "fQON");
        this.domainStatusColumModel.setColumnWidth("appliance", 150);
        this.domainStatusColumModel.setColumnWidth("domain", 150);
        this.domainStatusTable = new JMTable(this.domainStatusTableModel, this.domainStatusColumModel);
        this.add((Component)KumbaCoreUIConstants.createScrollPane(this.domainStatusTable), "Center");
        JMPanel topPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        JMLabel label = new JMLabel("Configurations Not Saved");
        topPanel.add((Component)label, "West");
        this.saveConfigButton = new JMButton(KumbaCoreUIConstants.SAVE_ICON, "Saves the selected configurations, or all if none are selected.");
        new ActionEventInvoker(this.saveConfigButton, this, "fileSave");
        this.updateListButton = new JMButton(KumbaCoreUIConstants.REFRESH_ICON, "Force refresh of the list.");
        new ActionEventInvoker(this.updateListButton, this, "getDomainStatus");
        JMPanel buttonPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        buttonPanel.addAll(ComponentFactory.createSpacer(50, 1), this.updateListButton, this.saveConfigButton);
        topPanel.add((Component)buttonPanel, "Center");
        this.add((Component)topPanel, "North");
        ApplianceDomainChangeMonitor.getInstance().addApplianceChangeSubscriber(this, "appliancesChanged");
    }

    @Reflected
    private void appliancesChanged(ArrayList<Appliance> selectedAppliances) {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.waitingToComplete = false;
        this.domainStatusTable.clearSelection();
        this.domainStatusTableModel.reset();
        this.domainStatusMap.clear();
        for (Appliance appliance : selectedAppliances) {
            if (!appliance.isConnected()) continue;
            DataPowerStatusMonitor domainStatusMonitor = new DataPowerStatusMonitor(appliance, appliance.getDomain("default"), "DomainStatus", 0L);
            domainStatusMonitor.addStatusListener(this);
        }
    }

    @Reflected
    private void getDomainStatus() {
        UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        this.appliancesChanged(selectedAppliances);
    }

    @Reflected
    private void fileSave() {
        if (!this.continueAction("Save Configurations For", "save configurations for", false)) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Save Configurations");
        int[] selectedRows = this.domainStatusTable.getSelectedRows();
        if (selectedRows.length == 0) {
            this.domainStatusTable.selectAll();
            selectedRows = this.domainStatusTable.getSelectedRows();
        }
        int r = 0;
        while (r < selectedRows.length) {
            StatusDomainStatus domainStatus = this.domainStatusTableModel.getValue(selectedRows[r]);
            Appliance statusAppliance = domainStatus.getAppliance();
            Domain statusDomain = statusAppliance.getDomain(domainStatus.getDomain());
            ConfigurationManager.saveConfiguration(statusAppliance, statusDomain, this, this.commandResultsDialog);
            ++r;
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        if (!this.waitingToComplete) {
            this.waitingToComplete = true;
            new AsynchMethodInvoker((Object)this, "waitForSaveToComplete");
        }
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
        if (!this.waitingToComplete) {
            this.waitingToComplete = true;
            new AsynchMethodInvoker((Object)this, "waitForSaveToComplete");
        }
    }

    @Reflected
    private void waitForSaveToComplete() {
        ThreadUtility.yieldTo("com.kumbasoft.core.tools.ActionTool");
        this.waitingToComplete = false;
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusEvent(StatusDomainStatus event) {
        String appDomain = event.getAppliance().getName() + event.getDomain();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.domainStatusMap.containsKey(appDomain)) {
                return;
            }
            this.domainStatusMap.put(appDomain, appDomain);
            if (event.getSaveNeeded().equals("on")) {
                this.domainStatusTableModel.addRow(event);
            }
        }
    }

    @Override
    public void statusComplete(Appliance appliance, Domain domain, String statusClass) {
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Override
    public void statusChanged(StatusDomainStatus lastEvent, StatusDomainStatus thisEvent) {
    }

    @Override
    public void error(Appliance appliance, Domain domain, String statusClass, int errorCode, StatusDomainStatus lastEvent) {
    }

    @Override
    public void noStatus(Appliance appliance, Domain domain, String statusClass, DateTime statusTime) {
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }
}

