/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.component.FileSelectorComponent;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.util.Index;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import com.kumbasoft.dpaa.ui.dialogs.snapshotWizard.SnapshotDiffSelectionWizardPage;
import com.kumbasoft.dpaa.ui.panels.configurations.SnapshotDiffPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JFrame;

public class SnapshotDiffOptionsPanel
extends AbstractPanel {
    private SnapshotDiffPanel parent;
    private FileSelectorComponent fileSelector;
    private JMCheckBox cbxObjects;
    private JMCheckBox cbxFiles;
    private JMCheckBox cbxCertificates;
    private JMButton btnCreateDiff;
    private JMLabel lblDatesSelected;

    public SnapshotDiffOptionsPanel(SnapshotDiffPanel parent) {
        super(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        this.parent = parent;
        DPAAApplicationProperties appProps = (DPAAApplicationProperties)Application.getApplication().getApplicationProperties();
        this.fileSelector = new FileSelectorComponent("SnapShot Input Directory:", "Start");
        this.fileSelector.setPreferredSize(600, 25);
        this.fileSelector.setFileName(appProps.getSnapShotsDirectory());
        this.fileSelector.setFileNameFilter(KumbaCoreUIConstants.DIRECTORY_FILE_FILTER);
        this.fileSelector.getActionButton().setVisible(false);
        this.cbxObjects = ComponentFactory.createCheckbox(null, "Objects", "Include Objects in the diff", true, true, this, "checkButtons", new Object[0]);
        this.setStandardComopnentSize(this.cbxObjects);
        this.cbxFiles = ComponentFactory.createCheckbox(null, "Files", "Include Files in the diff", true, true, this, "checkButtons", new Object[0]);
        this.setStandardComopnentSize(this.cbxFiles);
        this.cbxCertificates = ComponentFactory.createCheckbox(null, "Certificates", "Include Certificates in the diff", true, true, this, "checkButtons", new Object[0]);
        this.setStandardComopnentSize(this.cbxCertificates);
        this.btnCreateDiff = ComponentFactory.createButton(null, "Create...", "Creates deltas between two selected snapshots", true, this, "createDiff", new Object[0]);
        this.setStandardComopnentSize(this.btnCreateDiff);
        this.lblDatesSelected = new JMLabel("");
        JMPanel mainPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        mainPanel.addAll(this.cbxObjects, this.cbxFiles, this.cbxCertificates, this.btnCreateDiff);
        this.addAll(this.fileSelector, mainPanel, this.lblDatesSelected);
    }

    private void setStandardComopnentSize(Component component) {
        component.setPreferredSize(new Dimension(100, 25));
    }

    @Reflected
    private void createDiff() {
        DynamicBean model = new DynamicBean();
        File selectedFile = this.fileSelector.getSelectedFile();
        if (!selectedFile.exists() || !selectedFile.isDirectory()) {
            this.showMessage("Snapshot Directory Not Found", "The selected SnapShot directory does not exist.");
            return;
        }
        model.setProperty("snapshotDirectory", selectedFile);
        Index<Appliance, Domain> domains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        model.setProperty("selectedDomains", domains);
        WizardDialog<DynamicBean> wizard = new WizardDialog<DynamicBean>((JFrame)GUIApplication.getGUIApplication().getApplicationFrame(), "View Snapshot Delta");
        wizard.addWizardPage(new SnapshotDiffSelectionWizardPage(model), "selectDates");
        wizard.setSize(800, 400);
        wizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        boolean showObjects = this.cbxObjects.isSelected();
        boolean showFiles = this.cbxFiles.isSelected();
        boolean showCertificates = this.cbxCertificates.isSelected();
        String sourceDate = (String)model.getProperty("sourceDate");
        String targetDate = (String)model.getProperty("targetDate");
        File sourceDirectory = new File(selectedFile, sourceDate);
        File targetDirectory = new File(selectedFile, targetDate);
        String selectionLabelText = String.format("Delta from %s to %s", sourceDate, targetDate);
        this.lblDatesSelected.setText(selectionLabelText);
        this.parent.setupSnapshot(showObjects, showFiles, showCertificates, sourceDirectory.getAbsolutePath(), targetDirectory.getAbsolutePath());
    }

    @Reflected
    private void checkButtons() {
        boolean showObjects = this.cbxObjects.isSelected();
        boolean showFiles = this.cbxFiles.isSelected();
        boolean showCertificates = this.cbxCertificates.isSelected();
        this.btnCreateDiff.setEnabled(showObjects || showFiles || showCertificates);
    }
}

