/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.domainactions;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.CountAggregator;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionAggregator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.tools.ActionController;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.CreateDomainBackup;
import com.kumbasoft.core.tools.RestoreDomainBackup;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.domainactions.AbstractDomainActionTablePanel;
import com.kumbasoft.dpaa.ui.panels.domainactions.BackupInfo;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class DomainsBackupsPanel
extends AbstractDomainActionTablePanel<BackupInfo> {
    private static String BACKUPS_DIRECTORY = AbstractPanel.applicationProperties.getDomainBackupsDirectory();
    private JMButton btnCreateBackup = ComponentFactory.createButton(null, "Create Backup", "Create a backup of all selected domains.", true, this, "backupDomains", new Object[0]);
    private JMButton btnRestoreBackup;
    private JMButton btnDeleteBackups;
    private JMTextField tfRestoreFile;
    private JMButton btnRestoreBrowse;

    public DomainsBackupsPanel() {
        super(BackupInfo.class);
        this.btnCreateBackup.setPreferredSize(125, 23);
        this.btnRestoreBackup = ComponentFactory.createButton(null, "Restore Backup", "Restore the selected backup.", false, this, "restoreBackup", new Object[0]);
        this.btnRestoreBackup.setPreferredSize(125, 23);
        this.btnDeleteBackups = ComponentFactory.createButton(null, "Delete Backups", "Delete the selected backup files.", false, this, "deleteBackups", new Object[0]);
        this.btnDeleteBackups.setPreferredSize(125, 23);
        this.tfRestoreFile = new JMTextField();
        this.tfRestoreFile.setEditable(false);
        LabeledComponent lblRestore = new LabeledComponent("Restore From File:", (Component)this.tfRestoreFile, 125, 300);
        this.btnRestoreBrowse = ComponentFactory.createButton(null, "...", "Browse for backup file to restore.", true, this, "browseForBackupFile", new Object[0]);
        JMPanel restorePanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        restorePanel.addAll(lblRestore, this.btnRestoreBrowse);
        JMPanel buttonPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        buttonPanel.addAll(this.btnCreateBackup, this.btnRestoreBackup, this.btnDeleteBackups);
        this.remove(this.leftPanel);
        this.leftPanel.setLayout(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        this.add((Component)this.leftPanel, "North");
        this.leftPanel.addAll(restorePanel, buttonPanel);
    }

    @Override
    protected BeanColumnModel<BackupInfo> getColumnModel() {
        BeanColumnModel<BackupInfo> columnModel = super.getColumnModel();
        columnModel.hideColumns("file");
        columnModel.setColumnOrder("appliance", "domain", "backupDate", "backupTime");
        return columnModel;
    }

    @Reflected
    private void backupDomains() {
        if (!this.start("Backup Domains", "Backup all selected domains?")) {
            return;
        }
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        for (Appliance appliance : selectedDomains.getKeys()) {
            for (Domain domain : selectedDomains.get(appliance)) {
                CreateDomainBackup backupCreator = new CreateDomainBackup(appliance, domain);
                this.addProcessListeners(backupCreator);
            }
        }
        this.finish();
    }

    @Reflected
    private void restoreBackup() {
        String fileName = this.tfRestoreFile.getText();
        if (StringUtility.isNotEmpty(fileName)) {
            this.restoreFromFile(fileName);
        } else {
            this.restoreFromSelectedBackups();
        }
    }

    private void restoreFromFile(String fileName) {
        File restoreFile = new File(fileName);
        if (!restoreFile.exists()) {
            this.showMessage("Restore from Backup", "The restore file does not exist.  Please select a valid backup file to restore.");
            return;
        }
        String message = String.format("<html><body>Are you sure you want to restore all of the selected domains<br/>of all of the selected appliances with the backup contained within<br/>%s?", restoreFile.getAbsolutePath());
        if (!this.start("Restore Backup From Common File", message)) {
            return;
        }
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        for (Appliance appliance : selectedDomains.getKeys()) {
            for (Domain domain : selectedDomains.get(appliance)) {
                RestoreDomainBackup restoreBackup = new RestoreDomainBackup(appliance, domain, restoreFile);
                this.addProcessListeners(restoreBackup);
            }
        }
        this.finish();
    }

    private void restoreFromSelectedBackups() {
        int[] selectedRows = this.displayTable.getSelectedRows();
        ArrayList selectedBackups = this.tableModel.getValues(selectedRows);
        CountAggregator applianceCounter = new CountAggregator();
        CollectionAggregator applianceAggregator = new CollectionAggregator(selectedBackups);
        applianceAggregator.addAggregatorFunction("'the ' + domain + ' domain of ' + appliance", applianceCounter);
        applianceAggregator.aggregate();
        Map applianceCounts = applianceCounter.getCounts();
        for (String applianceDomain : applianceCounts.keySet()) {
            int count = applianceCounts.get(applianceDomain);
            if (count <= 1) continue;
            this.showMessage("Backup Restoration Collision", String.format("<html><body>You have selected %d backups to restore for %s.<br/><br/>This can cause unexpected results.<br/><br/>Please check your selection and try again.</body></html>", count, applianceDomain));
            return;
        }
        String message = "<html><body>Are you sure you want to restore all of the selected domains<br/>from the selected backups?</body></html>";
        if (!this.start("Restore Selected Backups", message)) {
            return;
        }
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        for (BackupInfo backupInfo : selectedBackups) {
            for (Appliance appliance : selectedDomains.getKeys()) {
                if (!appliance.getName().equals(backupInfo.getAppliance())) continue;
                for (Domain domain : selectedDomains.get(appliance)) {
                    if (!domain.getName().equals(backupInfo.getDomain())) continue;
                    AbstractPanel.logger.config(() -> LMG.log("(): Initiating domain restore for %s -. %s", () -> appliance.getName(), () -> domain.getName()));
                    RestoreDomainBackup restoreBackup = new RestoreDomainBackup(appliance, domain, backupInfo.getFile());
                    this.addProcessListeners(restoreBackup);
                }
            }
        }
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("DomainsBackupsPanel.restoreFromSelectedBackups()", this.mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            AbstractPanel.logger.info("(): Timed out waiting for restore to complete.  Continuing though unexpected behavior might result.");
        }
        this.mtil.resetThreadCount();
        AbstractPanel.logger.finer("(): Restore Completed, restarting domain now.  This will pick up include configs the restore does not do.");
        for (BackupInfo backupInfo : selectedBackups) {
            for (Appliance appliance : selectedDomains.getKeys()) {
                if (!appliance.getName().equals(backupInfo.getAppliance())) continue;
                for (Domain domain : selectedDomains.get(appliance)) {
                    if (!domain.getName().equals(backupInfo.getDomain())) continue;
                    AbstractPanel.logger.config(() -> LMG.log("(): Initiating restart for %s -. %s", () -> appliance.getName(), () -> domain.getName()));
                    ActionTool actionTool = ActionController.restartDomain(appliance, domain, this.commandResultsDialog);
                    this.mtil.addThread(actionTool.getProcessThread());
                }
            }
        }
        this.finish();
    }

    @Reflected
    private void deleteBackups() {
        if (!this.start("Delete Backups", "Are you sure you want to delete the selected backups?")) {
            return;
        }
        int[] selectedRows = this.displayTable.getSelectedRows();
        ArrayList selectedBackups = this.tableModel.getValues(selectedRows);
        for (BackupInfo selectedBackup : selectedBackups) {
            selectedBackup.getFile().delete();
            ManagementCommandStatus commandStatus = new ManagementCommandStatus();
            commandStatus.setActionStatus("OK");
            commandStatus.setCommandDescription(String.format("%s deleted.", selectedBackup.getFile().getName()));
            this.commandResultsDialog.commandSucceeded(commandStatus);
        }
        this.finish();
    }

    @Reflected
    private void rowFocusChanged() {
        ThreadUtility.sleep(100L);
        int[] selectedRows = this.displayTable.getSelectedRows();
        this.btnRestoreBackup.setEnabled(selectedRows.length > 0);
        this.btnDeleteBackups.setEnabled(selectedRows.length > 0);
        if (selectedRows.length > 0) {
            this.tfRestoreFile.setText("");
        }
    }

    @Override
    @Reflected
    protected void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        super.domainsChanged(selectedDomains);
        this.tfRestoreFile.setText("");
        for (Appliance appliance : selectedDomains.getKeys()) {
            for (Domain domain : selectedDomains.get(appliance)) {
                File[] files;
                String applianceName = appliance.getName();
                String domainName = domain.getName();
                String backupDir = String.format("%s%s%s%s%s", BACKUPS_DIRECTORY, File.separator, applianceName, File.separator, domainName);
                File directory = new File(backupDir);
                if (!directory.exists()) continue;
                File[] fileArray = files = directory.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    BackupInfo backupInfo = new BackupInfo(file);
                    this.tableModel.addRow(backupInfo);
                    ++n2;
                }
            }
        }
    }

    @Reflected
    private void browseForBackupFile() {
        File selectedFile = GUIServices.fileOpenDialog(null, null);
        if (selectedFile == null) {
            return;
        }
        this.tfRestoreFile.setText(selectedFile.getAbsolutePath());
    }
}

