/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.domainactions;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusDomainStatus;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ActionController;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.CreateDomain;
import com.kumbasoft.core.tools.DeleteDomain;
import com.kumbasoft.core.tools.StartDomain;
import com.kumbasoft.core.tools.StopDomain;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.panel.ApplianceDomainListPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.ImageIcon;

public class SimpleActionsPanel
extends AbstractPanel {
    private static final int BUTTON_WIDTH = 180;
    private final String DEFAULT_WARN_MESSAGE = "<html><body style=\"color: red\">(Except Default)</body></html>";
    private NumberField nfTxWaitTimeout;
    private NumberField nfDelay;
    private Component[] btnQuiesceDomain;
    private Component[] btnUnquiesceDomain;
    private Component[] btnStartDomain;
    private Component[] btnStopDomain;
    private Component[] btnRestartDomain;
    private JMButton btnCreateDomain;
    private JMTextField tfNewDomain;
    private Component[] btnResetDomain;
    private Component[] btnDeleteDomain;
    private MultiThreadInvocationListener mtil;
    private Index<Appliance, Domain> selectedDomains;

    public SimpleActionsPanel() {
        super(new VerticalFlowLayout(0, 1));
        this.buildQuiesceControls();
        this.add(ComponentFactory.createSpacer(10, 30));
        this.buildRunningControls();
        this.add(ComponentFactory.createSpacer(10, 30));
        this.buildExistenceControls();
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    private void buildQuiesceControls() {
        this.nfTxWaitTimeout = new NumberField(60.0);
        NumberSpinner nsTxWaitTimeout = new NumberSpinner(this.nfTxWaitTimeout, 1.0, 60.0, 2.147483647E9);
        LabeledComponent lcTxWaitTimeout = new LabeledComponent("Transaction Timeout:", (Component)nsTxWaitTimeout, 135, 75);
        this.nfDelay = new NumberField(0.0);
        NumberSpinner nsDelay = new NumberSpinner(this.nfDelay, 1.0, 0.0, 60.0);
        LabeledComponent lcDelay = new LabeledComponent("Delay:", (Component)nsDelay, 50, 75);
        this.btnQuiesceDomain = this.createButton(KumbaCoreUIConstants.SLEEP_ICON, "Quiesce Domains", "Quiesce Selected Domains", true, "quiesceDomains");
        JMPanel quiescePanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        quiescePanel.addAll(lcTxWaitTimeout, ComponentFactory.createSpacer(10, 10), lcDelay, this.btnQuiesceDomain[0]);
        this.btnUnquiesceDomain = this.createButton(KumbaCoreUIConstants.WAKE_ICON, "Un-Quiesce Domains", "Un-Quiesce Selected Domains", true, "unQuiesceDomains");
        this.addAll(quiescePanel, this.btnUnquiesceDomain[0]);
    }

    private void buildRunningControls() {
        this.btnStopDomain = this.createButton(KumbaCoreUIConstants.STOP_ICON, "Stop Domains", "Stop Selected Domains", true, "stopDomains");
        this.btnStartDomain = this.createButton(KumbaCoreUIConstants.START_ICON, "Start Domains", "Start Selected Domains", true, "startDomains");
        this.btnRestartDomain = this.createButton(KumbaCoreUIConstants.REFRESH_ICON, "Restart Domains", "Restart Selected Domains", true, "restartDomains");
        this.addAll(this.btnStopDomain[0], this.btnStartDomain[0], this.btnRestartDomain[0]);
    }

    private void buildExistenceControls() {
        this.tfNewDomain = new JMTextField();
        LabeledComponent lblDomainName = new LabeledComponent("Domain Name:", (Component)this.tfNewDomain, 100, 250);
        this.btnCreateDomain = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, "Create Domain", "Creates a new domain in all the selected appliances.", true, this, "createDomain", new Object[0]);
        this.btnCreateDomain.setPreferredSize(180, 23);
        JMPanel newPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        newPanel.addAll(lblDomainName, this.btnCreateDomain);
        this.btnResetDomain = this.createButton(KumbaCoreUIConstants.CLEAR_ICON, "Reset Domains", "Resets all selected domains.", true, "resetDomains");
        this.btnDeleteDomain = this.createButton(KumbaCoreUIConstants.DELETE_ICON, "Delete Domains", "Deletes all selected domains.", true, "deleteDomains");
        this.addAll(newPanel, this.btnResetDomain[0], this.btnDeleteDomain[0]);
    }

    private Component[] createButton(ImageIcon icon, String label, String toolTip, boolean enabled, String invocationMethod) {
        JMPanel panel = new JMPanel(new FlowLayout(0));
        JMButton button = ComponentFactory.createButton(icon, label, toolTip, enabled, this, invocationMethod, new Object[0]);
        button.setPreferredSize(180, 23);
        JMLabel warnLabel = new JMLabel("<html><body style=\"color: red\">(Except Default)</body></html>");
        warnLabel.setVisible(false);
        warnLabel.setPreferredSize(125, 23);
        panel.addAll(button, ComponentFactory.createSpacer(10, 23), warnLabel);
        return new Component[]{panel, button, warnLabel};
    }

    @Reflected
    private void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        this.selectedDomains = selectedDomains;
        boolean containsDefault = false;
        block0: for (Appliance appliance : selectedDomains.getKeys()) {
            for (Domain domain : selectedDomains.get(appliance)) {
                if (!domain.getName().equals("default")) continue;
                containsDefault = true;
                continue block0;
            }
        }
        this.btnQuiesceDomain[2].setVisible(containsDefault);
        this.btnUnquiesceDomain[2].setVisible(containsDefault);
        this.btnStartDomain[2].setVisible(containsDefault);
        this.btnStopDomain[2].setVisible(containsDefault);
        this.btnRestartDomain[2].setVisible(containsDefault);
        this.btnResetDomain[2].setVisible(containsDefault);
        this.btnDeleteDomain[2].setVisible(containsDefault);
    }

    @Reflected
    private void quiesceDomains() {
        if (this.performAction("Quiesce Domains", "Are you sure you want to quiesce all of the selected domains of all of the selected appliances?", "quiesceDomain", false)) {
            this.finish("quiesce");
        }
    }

    @Reflected
    private void quiesceDomain(Appliance appliance, Domain domain) {
        ActionTool actionTool = ActionController.quiesceDomain(appliance, domain, (int)this.nfTxWaitTimeout.getNumber(), (int)this.nfDelay.getNumber(), this.commandResultsDialog);
        if (actionTool != null) {
            this.mtil.addThread(actionTool.getProcessThread());
        }
    }

    @Reflected
    private void unQuiesceDomains() {
        if (this.performAction("Unquiesce Domains", "Are you sure you want to unquiesce all of the selected domains of all of the selected appliances?", "unQuiesceDomain", false)) {
            this.finish("unquiesce");
        }
    }

    @Reflected
    private void unQuiesceDomain(Appliance appliance, Domain domain) {
        ActionTool actionTool = ActionController.unquiesceDomain(appliance, domain, this.commandResultsDialog);
        if (actionTool != null) {
            this.mtil.addThread(actionTool.getProcessThread());
        }
    }

    @Reflected
    private void startDomains() {
        if (this.performAction("Start Domains", "Are you sure you want to start all of the selected domains of all of the selected appliances?", "startDomain", false)) {
            this.finish("start");
        }
    }

    @Reflected
    private void startDomain(Appliance appliance, Domain domain) {
        if (domain.getName().equals("default")) {
            return;
        }
        StartDomain startDomain = new StartDomain(appliance, domain);
        this.addProcessListeners(startDomain);
    }

    @Reflected
    private void stopDomains() {
        if (this.performAction("Stop Domains", "Are you sure you want to stop all of the selected domains of all of the selected appliances?", "stopDomain", false)) {
            this.finish("stop");
        }
    }

    @Reflected
    private void stopDomain(Appliance appliance, Domain domain) {
        if (domain.getName().equals("default")) {
            return;
        }
        StopDomain stopDomain = new StopDomain(appliance, domain);
        this.addProcessListeners(stopDomain);
    }

    @Reflected
    private void restartDomains() {
        if (this.performAction("Restart Domains", "Are you sure you want to restart all of the selected domains of all of the selected appliances?", "restartDomain", false)) {
            this.finish("restart");
        }
    }

    @Reflected
    private void restartDomain(Appliance appliance, Domain domain) {
        ActionTool actionTool = ActionController.restartDomain(appliance, domain, this.commandResultsDialog);
        if (actionTool != null) {
            this.mtil.addThread(actionTool.getProcessThread());
        }
    }

    @Reflected
    private void createDomain() {
        String newDomainName = this.tfNewDomain.getText().trim();
        if (StringUtility.isEmpty(newDomainName)) {
            this.showMessage("Invalid Domain Name", "The domain name you provided is blank.");
            return;
        }
        if (!ConfigurationManager.isObjectNameValid(newDomainName)) {
            this.showMessage("Invalid Domain Name", "The domain name you provided contains invalid characters.  Do not use spaces or any of the following:   !@#$%^&*()+=`~[]{};:'\"/\\|?,<>");
            return;
        }
        String confirmationMessage = String.format("Are you sure you want to create domain %s in all selected appliances?", newDomainName);
        if (this.performAction("Create Domain", confirmationMessage, "createDomain", true)) {
            this.finish("create");
        }
    }

    @Reflected
    private void createDomain(Appliance appliance) {
        String domainName = this.tfNewDomain.getText().trim();
        if (StringUtility.isEmpty(domainName)) {
            return;
        }
        Domain newDomain = new Domain(domainName);
        CreateDomain createDomain = new CreateDomain(appliance, newDomain);
        this.addProcessListeners(createDomain);
    }

    @Reflected
    private void resetDomains() {
        if (this.performAction("Reset Domains", "Are you sure you want to reset all of the selected domains of all of the selected appliances?", "resetDomain", false)) {
            this.finish("reset");
        }
    }

    @Reflected
    private void resetDomain(Appliance appliance, Domain domain) {
        ActionTool resetDomain = ActionController.resetDomain(appliance, domain, this.commandResultsDialog);
        if (resetDomain != null) {
            this.mtil.addThread(resetDomain.getProcessThread());
        }
    }

    @Reflected
    private void deleteDomains() {
        if (this.performAction("Delete Domains", "Are you sure you want to delete all of the selected domains of all of the selected appliances?", "deleteDomain", false)) {
            this.finish("delete");
        }
    }

    @Reflected
    private void deleteDomain(Appliance appliance, Domain domain) {
        if (domain.getName().equals("default")) {
            return;
        }
        DeleteDomain deleteDomain = new DeleteDomain(appliance, domain);
        this.addProcessListeners(deleteDomain);
    }

    private boolean performAction(String title, String message, String method, boolean appliancesOnly) {
        if ((SimpleActionsPanel.areAllAppliancesSelected() || SimpleActionsPanel.areAllDomainsSelected()) && !this.continueAction(title, title.toLowerCase(), !appliancesOnly)) {
            return false;
        }
        if (!this.continueAction(title, message)) {
            return false;
        }
        this.openResultsDialogAndSetWaitCursor(title);
        if (this.mtil == null) {
            this.mtil = new MultiThreadInvocationListener();
        } else {
            this.mtil.resetThreadCount();
        }
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, method, appliancesOnly);
        return true;
    }

    private void addProcessListeners(Object actionRunner) {
        AbstractPanel.logger.finer(() -> LMG.log("(actionRunner=%s): Starting.  Adding thread to listener and management subscriber to dialog.", () -> actionRunner.getClass().getName()));
        AsynchMethodInvoker actionThread = (AsynchMethodInvoker)new MethodInvoker(actionRunner, "getProcessThread", new Object[0]).invoke();
        this.mtil.addThread(actionThread);
        try {
            new MethodInvoker(actionRunner, "addManagementCommandSubscriber", this.commandResultsDialog).invoke();
        }
        catch (Exception e) {
            AbstractPanel.logger.severe(() -> LMG.log("(actionRunner=%s): Error invoking 'addManagementCommandSubscriber' to action runnner.", () -> actionRunner.getClass().getName()));
        }
        AbstractPanel.logger.finer(() -> LMG.log("(actionRunner=%s): Done", () -> actionRunner.getClass().getName()));
    }

    private void finish(String action) {
        logger.finer(() -> LMG.log("(action=%s): Starting.  Waiting for threads to complete.", () -> action));
        int maxWaitTimeout = action.equals("restart") ? 125000 : 0;
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("SimpleActionsPanel.finish(" + action + ")", this.mtil, KumbaCoreConstants.STARTUP_DELAY, maxWaitTimeout);
        if (!completedOnTime) {
            logger.warning(() -> LMG.log("(action=%s): Not all threads completed on time.  Continuing though unexpected results may occur.", () -> action));
        }
        UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        ApplianceDomainListPanel optionPane = frame.getApplianceDomainListPanel();
        switch (action) {
            case "create": {
                logger.finer(() -> LMG.log("(action=%s): Adding new domain to list of domains.", () -> action));
                String domainName = this.tfNewDomain.getText();
                Domain newDomain = new Domain(domainName);
                StatusDomainStatus domainStatus = new StatusDomainStatus();
                domainStatus.setDomain(domainName);
                domainStatus.setDebugEnabled("off");
                domainStatus.setDiagEnabled("off");
                domainStatus.setFailsafeMode("none");
                domainStatus.setInterfaceState("ok");
                domainStatus.setProbeEnabled("off");
                domainStatus.setQuarantineEnabled("");
                domainStatus.setQuiesceState("");
                domainStatus.setSaveNeeded("no");
                domainStatus.setTraceEnabled("off");
                domainStatus.setStatusTime(new DateTime());
                StatusObjectStatus objectStatus = new StatusObjectStatus();
                objectStatus.setName(domainName);
                objectStatus.setAdminState("enabled");
                objectStatus.setConfigState("new");
                objectStatus.setDataPowerClass("Domain");
                objectStatus.setErrorCode("");
                objectStatus.setEventCode("");
                objectStatus.setOpState("up");
                objectStatus.setStatusTime(new DateTime());
                for (Appliance appliance : selectedAppliances) {
                    domainStatus.setSourceDomain(appliance.getDomain("default"));
                    domainStatus.setAppliance(appliance);
                    objectStatus.setAppliance(appliance);
                    objectStatus.setSourceDomain(appliance.getDomain("default"));
                    newDomain.setStatusDomainStatus(domainStatus);
                    newDomain.setObjectStatus(objectStatus);
                    appliance.addDomain(newDomain);
                }
                optionPane.addDomain(newDomain);
                optionPane.setSelectedDomain(domainName);
                break;
            }
            case "delete": {
                logger.finer(() -> LMG.log("(action=%s): Removing deleted domain from list of domains.", () -> action));
                for (Appliance appliance : this.selectedDomains.getKeys()) {
                    for (Domain domain : this.selectedDomains.get(appliance)) {
                        appliance.removeDomain(domain);
                        optionPane.removeDomain(domain);
                    }
                }
                optionPane.setSelectedDomain("All");
                break;
            }
            default: {
                logger.finer(() -> LMG.log("(action=%s): Action complete.", () -> action));
            }
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        logger.finer(() -> LMG.log("(action=%s): Done", () -> action));
    }
}

