/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Vector;

public abstract class AbstractSystemActionPanel<ActionObjectType extends JMBean>
extends AbstractPanel
implements ManagementCommandSubscriber {
    protected ActionObjectType actionObject;
    protected JMButton btnPerformSystemAction;

    public AbstractSystemActionPanel(String buttonLabel) {
        super(new VerticalFlowLayout(0));
        this.btnPerformSystemAction = new JMButton(buttonLabel);
        this.btnPerformSystemAction.setPreferredSize(this.getButtonSize());
        new AsynchMethodInvoker((Object)this, "setupEventHandling", KumbaCoreConstants.THREAD_WAIT);
    }

    protected Dimension getButtonSize() {
        return new Dimension(125, 25);
    }

    @Reflected
    private void setupEventHandling() {
        this.addAll(ComponentFactory.createSpacer(1, this.getSpacerHeight()), this.getButtonControl());
        while (frame == null) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        new ActionEventInvoker(this.btnPerformSystemAction, this, "invokeSystemAction");
    }

    protected Container getButtonControl() {
        return this.btnPerformSystemAction;
    }

    protected int getSpacerHeight() {
        return 25;
    }

    @Reflected
    protected void invokeSystemAction() {
        boolean completedOnTime;
        MultiThreadInvocationListener mtil;
        AbstractPanel.logger.finer("(): Starting.");
        this.actionObject = null;
        if (!this.isUserInputValid()) {
            AbstractPanel.logger.finer("(): User input is invalid.  Returning.");
            return;
        }
        boolean invokeSynchronously = this.shouldInvokeSystemActionSyncronously();
        UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        this.openResultsDialogAndSetWaitCursor(this.getCommandResultsDialogTitle());
        AbstractPanel.logger.finer("(): Performing pre-processing.");
        if (invokeSynchronously) {
            for (Appliance appliance : selectedAppliances) {
                MethodInvoker preProcessInvoker = new MethodInvoker((Object)this, "performPreProcessing", appliance);
                boolean succeeded = (Boolean)preProcessInvoker.invoke();
                if (succeeded) continue;
                selectedAppliances.remove(appliance);
            }
        } else {
            mtil = ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "performPreProcessing", true, invokeSynchronously);
            boolean completedOnTime2 = ThreadManager.monitorAsynchThreadLifeCycle("AbstractSystemActionPanel.invokeSystemAction()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
            if (!completedOnTime2) {
                AbstractPanel.logger.warning("(): Pre-processing did not complete on time for the action.");
            }
            Vector<AsynchMethodInvoker> threads = mtil.getThreads();
            for (AsynchMethodInvoker thread : threads) {
                boolean response = (Boolean)thread.getReturnValue();
                if (response) continue;
                Object[] args = thread.getArguments();
                Appliance appliance = (Appliance)args[0];
                AbstractPanel.logger.info(() -> LMG.log("(): '%s' failed pre-processing step.  Not continuing for that appliance.", () -> appliance.getName()));
                selectedAppliances.remove(appliance);
            }
        }
        AbstractPanel.logger.finer("(): Setting up action object.");
        this.actionObject = this.setupActionObjectType();
        AbstractPanel.logger.finer(() -> LMG.log("(): Action object of type '%s' setup.  Invoking performAction for each appliance.", () -> this.actionObject.getClass().getName()));
        mtil = null;
        for (Appliance appliance : selectedAppliances) {
            if (invokeSynchronously) {
                AbstractPanel.logger.finer(() -> LMG.log("(): Invoking synchronous performAction for '%s'.", () -> appliance.getName()));
                MethodInvoker invoker = new MethodInvoker((Object)this, "performAction", appliance);
                invoker.invoke();
                continue;
            }
            AbstractPanel.logger.finer(() -> LMG.log("(): Invoking asynchronous performAction for '%s'.", () -> appliance.getName()));
            if (mtil == null) {
                mtil = new MultiThreadInvocationListener();
            }
            AsynchMethodInvoker invoker = new AsynchMethodInvoker((Object)this, "performAction", (Object)appliance);
            mtil.addThread(invoker);
        }
        if (mtil != null && !(completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("AbstractSystemActionPanel.performAction()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0))) {
            AbstractPanel.logger.warning("(): Action did not complete on time.");
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done.");
    }

    protected boolean shouldInvokeSystemActionSyncronously() {
        return false;
    }

    @Reflected
    protected boolean performPreProcessing(Appliance appliance) {
        return true;
    }

    @Reflected
    protected void performAction(Appliance appliance) {
        String loggerPrefix = String.format("(Appliance=%s)", appliance.getName());
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting.", () -> loggerPrefix));
        ActionTool actionTool = new ActionTool(appliance, (JMBean)this.actionObject);
        actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        actionTool.addManagementCommandSubscriber(this);
        if (this.autoResetCursorToNormal()) {
            new AsynchMethodInvoker((Object)this, "setCursor", (Object)KumbaCoreUIConstants.NORMAL_CURSOR, KumbaCoreConstants.THREAD_WAIT);
        }
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done.", () -> loggerPrefix));
    }

    protected boolean autoResetCursorToNormal() {
        return true;
    }

    protected abstract String getCommandResultsDialogTitle();

    protected boolean isUserInputValid() {
        return true;
    }

    protected abstract ActionObjectType setupActionObjectType();

    protected void setButtonState(boolean state) {
        this.btnPerformSystemAction.setEnabled(state);
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        this.performPostActionProcessing(commandStatus.getAppliance(), false);
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
        this.performPostActionProcessing(commandError.getAppliance(), true);
    }

    protected void performPostActionProcessing(Appliance appliance, boolean error) {
    }
}

