/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.actions.ActionQuiesceDP;
import com.kumbasoft.core.beans.actions.ActionUnquiesceDP;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSystemActionPanel;
import java.awt.Component;
import java.awt.Container;

public class QuiesceDPPanel
extends AbstractSystemActionPanel<ActionQuiesceDP> {
    private NumberField nfTimeout = new NumberField(60.0);
    private NumberField nfDelay;
    private JMButton btnUnquiesce;
    private ActionUnquiesceDP unQuiesceDPObject;

    public QuiesceDPPanel() {
        super("Quiesce");
        this.nfTimeout.setFormatString("#,##0;-#,##0");
        NumberSpinner nsTimeout = new NumberSpinner(this.nfTimeout, 1.0, 60.0, 65535.0);
        LabeledComponent lblTimeout = new LabeledComponent("Quiesce Timeout:", (Component)nsTimeout, 120, 90);
        this.nfDelay = new NumberField();
        this.nfDelay.setFormatString("#,##0;-#,##0");
        NumberSpinner nsDelay = new NumberSpinner(this.nfDelay, 1.0, 0.0, 30.0);
        LabeledComponent lblDelay = new LabeledComponent("Quiesce Delay:", (Component)nsDelay, 120, 90);
        this.btnUnquiesce = new JMButton("Un-Quiesce");
        this.btnUnquiesce.setPreferredSize(this.getButtonSize());
        new ActionEventInvoker(this.btnUnquiesce, this, "unquiesceAppliance");
        this.addAll(lblTimeout, lblDelay);
    }

    @Override
    protected Container getButtonControl() {
        JMPanel panel = new JMPanel();
        panel.addAll(this.btnPerformSystemAction, this.btnUnquiesce);
        return panel;
    }

    @Override
    protected String getCommandResultsDialogTitle() {
        return "Quiesce Appliance";
    }

    @Override
    protected ActionQuiesceDP setupActionObjectType() {
        ActionQuiesceDP quiesceDP = new ActionQuiesceDP();
        quiesceDP.setTimeout((int)this.nfTimeout.getNumber());
        quiesceDP.setDelay((int)this.nfDelay.getNumber());
        return quiesceDP;
    }

    @Reflected
    private void unquiesceAppliance() {
        this.unQuiesceDPObject = new ActionUnquiesceDP();
        this.openResultsDialogAndSetWaitCursor("Wake Up Appliance");
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "unquiesceAppliance", true);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void unquiesceAppliance(Appliance appliance) {
        ActionTool actionTool = new ActionTool(appliance, (JMBean)this.unQuiesceDPObject);
        actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
    }
}

