/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.util.StringIndexer;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.actions.ActionVerifyFirmware;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.DataPowerSSHClient;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSystemActionPanel;
import java.awt.Dimension;

public class VerifyFirmwarePanel
extends AbstractSystemActionPanel<ActionVerifyFirmware> {
    public VerifyFirmwarePanel() {
        super("Verify Firmware");
    }

    @Override
    protected Dimension getButtonSize() {
        return new Dimension(200, 25);
    }

    @Override
    protected int getSpacerHeight() {
        return 10;
    }

    @Override
    protected String getCommandResultsDialogTitle() {
        return "Verify Firmware";
    }

    @Override
    protected ActionVerifyFirmware setupActionObjectType() {
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        ActionVerifyFirmware actionObject = new ActionVerifyFirmware();
        return actionObject;
    }

    @Override
    protected void performAction(Appliance appliance) {
        DataPowerSSHClient dpSSHClient = new DataPowerSSHClient(appliance);
        String prompt = dpSSHClient.getPromptString();
        Domain domain = appliance.getDomain("default");
        Object matchingString = "(Verifying manifest signature|Examining Files\\.\\.\\.|Examined \\d+, |Verification complete\\. Examined \\d+ files|Checked \\d+ files, \\d+ changed|Firmware verification completed|" + prompt + ")";
        if (!dpSSHClient.connect()) {
            logger.severe(() -> LMG.log("(appliance=%s):  Error Connecting to SSH", () -> appliance.getName()));
            this.showMessage("Error Connecting to the " + appliance.getName(), "The connection to the appliance via SSH could not be made.  Check the credientials for your appliance.");
            return;
        }
        try {
            dpSSHClient.sendToDataPower("co\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("flash\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("verify-firmware\n");
            String actualResponse = dpSSHClient.waitFor((String)matchingString);
            String examinedPrefix = "";
            while (!actualResponse.matches(prompt)) {
                if (!StringUtility.isEmpty(actualResponse)) {
                    if (actualResponse.matches("Examined \\d+,\\s")) {
                        examinedPrefix = actualResponse;
                        int digits = StringIndexer.countPattern(actualResponse, "\\d");
                        String checkedPhrase = String.format("|checked \\d{%d}", digits);
                        if (!((String)matchingString).contains(checkedPhrase)) {
                            matchingString = StringUtility.insertInto(checkedPhrase, (String)matchingString, ((String)matchingString).lastIndexOf(")"));
                        }
                    } else if (actualResponse.matches("checked \\d+")) {
                        String response = String.format("%s %s", examinedPrefix, actualResponse);
                        ManagementCommandStatus result = new ManagementCommandStatus(appliance, domain, "Test Hardware", null, response);
                        this.commandResultsDialog.commandSucceeded(result);
                    } else {
                        ManagementCommandStatus result = new ManagementCommandStatus(appliance, domain, "Test Hardware", null, actualResponse);
                        this.commandResultsDialog.commandSucceeded(result);
                    }
                }
                actualResponse = dpSSHClient.waitFor((String)matchingString);
            }
            dpSSHClient.sendToDataPower("exit\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("exit\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("exit\n");
            dpSSHClient.waitFor("Goodbye.");
            dpSSHClient.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }
}

