/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.troubleshooting;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.FileSelectorComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.CellLayout;
import com.jmorgan.swing.layout.CellLayoutConstraints;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanRowSorter;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.DynamicClassLoader;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ErrorReportInfo;
import com.kumbasoft.core.beans.actions.ActionErrorReport;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.parsers.errorreport.AbstractErrorReportParser;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ErrorReportDownloader;
import com.kumbasoft.core.tools.ErrorReportProcessor;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.dialogs.ErrorReportDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;

public class ErrorReportPanel<AbstractErrorReportProcessor>
extends AbstractPanel {
    private static final String APPLIANCE_PROPERTY_NAME = "appliance";
    private static final String DOMAIN_PROPERTY_NAME = "domain";
    private static final String ERROR_REPORT_NAME = "errorReport";
    private static final String SECTION_PROPERTY_NAME = "sectionName";
    private static final String SECTION_FILE_PROPERTY_NAME = "sectionFile";
    private static final String SOURCE_ERROR_REPORT_FILE_PROPERTY_NAME = "errorReportFileName";
    private static final String ERROR_REPORT_PACKAGE_NAME = "com.kumbasoft.core.parsers.errorreport.";
    private static final String[] SECTION_SORT_PROPERTIES = new String[]{"sectionName", "appliance", "domain"};
    private FileSelectorComponent fileSelectorComponent = new FileSelectorComponent("Load from External File:", "Open");
    private JMButton btnGenErrorReport;
    private JMButton btnDownloadErrorReport;
    private JMCheckBox cbxRemoveFilesAfterDownload;
    private JMButton btnOpenErrorSection;
    private DynamicBeanTableModel errorReportsTableModel;
    private DynamicBeanColumnModel errorReportsColumnModel;
    private JMTable errorReportsTable;
    private DynamicBeanTableModel downloadedErrorReportsTableModel;
    private DynamicBeanColumnModel downloadedErrorReportsColumnModel;
    private JMTable downloadedErrorReportsTable;
    private DynamicBeanTableModel sectionTableModel;
    private DynamicBeanColumnModel sectionColumnModel;
    private JMTable sectionsTable;
    private JMPanel errorReportViewPanel;
    private MultiThreadInvocationListener mtil;
    private boolean isReloading;

    public ErrorReportPanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        new ActionEventInvoker(this.fileSelectorComponent, this, "externalFileOpen");
        this.add((Component)this.fileSelectorComponent, "North");
        this.errorReportViewPanel = this.createMainPanel();
        this.add((Component)this.errorReportViewPanel, "Center");
        ApplianceDomainChangeMonitor.getInstance().addApplianceChangeSubscriber(this, "loadModels");
    }

    @Reflected
    private void loadModels(UniqueArrayList<Appliance> selectedAppliances) {
        logger.finer(() -> LMG.log("(selectedAppliances):  Starting:  isReloading=%b", () -> this.isReloading));
        if (this.isReloading) {
            logger.finer("(selectedAppliances):  Actively reloading.  Attempting recall.");
            new AsynchMethodInvoker((Object)this, "loadModels", (Object)selectedAppliances, KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        this.isReloading = true;
        logger.finer("(selectedAppliances):  Loading existing reports.");
        if (this.sectionsTable.getRowCount() > 0) {
            this.sectionsTable.clearSelection();
            this.sectionTableModel.reset();
        }
        this.loadErrorReports(selectedAppliances);
        this.loadDownloadedErrorReports(selectedAppliances);
        this.isReloading = false;
        logger.finer("(selectedAppliances):  Ending.");
    }

    private void loadErrorReports(UniqueArrayList<Appliance> selectedAppliances) {
        logger.finer("(selectedAppliances): Starting");
        if (this.errorReportsTable.getRowCount() > 0) {
            logger.finer("(selectedAppliances): Resetting errorReportsTableModel.");
            this.errorReportsTable.clearSelection();
            this.errorReportsTableModel.reset();
        }
        for (Appliance appliance : selectedAppliances) {
            logger.finer(() -> LMG.log("(selectedAppliances): Getting error report from %s", () -> appliance.getName()));
            ErrorReportInfo errorReportInfo = new ErrorReportInfo(appliance);
            Vector<DataPowerFileInfo> dpFileInfo = errorReportInfo.getErrorReportFiles();
            if (!CollectionUtility.isNotEmpty(dpFileInfo)) continue;
            logger.finer(() -> LMG.log("(selectedAppliances): Processing %d error reports from %s", () -> dpFileInfo.size(), () -> appliance.getName()));
            for (DataPowerFileInfo dpFile : dpFileInfo) {
                DynamicBean row = new DynamicBean();
                row.setProperty(APPLIANCE_PROPERTY_NAME, appliance);
                row.setProperty(ERROR_REPORT_NAME, dpFile);
                logger.finer(() -> LMG.log("(selectedAppliances): Adding error report %s from %s to table", () -> dpFile.getName(), () -> appliance.getName()));
                this.errorReportsTableModel.addRow(row);
            }
            logger.finer("(selectedAppliances): Optimizing column widths of error reports table.");
            this.errorReportsTable.optimizeColumnWidths();
            this.errorReportsTable.repaint();
        }
        this.btnDownloadErrorReport.setEnabled(this.errorReportsTableModel.getRowCount() > 0);
        logger.finer("(selectedAppliances): Done");
    }

    private void loadDownloadedErrorReports(UniqueArrayList<Appliance> selectedAppliances) {
        logger.finer("(selectedAppliances): Starting");
        if (this.downloadedErrorReportsTable.getRowCount() > 0) {
            this.downloadedErrorReportsTable.clearSelection();
            this.downloadedErrorReportsTableModel.reset();
        }
        for (Appliance appliance : selectedAppliances) {
            Object[] fileList;
            logger.finer(() -> LMG.log("(selectedAppliances): Downloading error report from %s", () -> appliance.getName()));
            String baseDirName = String.format("%s%s%s", applicationProperties.getErrorReportsDirectory(), File.separator, appliance.getName());
            File baseDir = new File(baseDirName);
            if (!baseDir.exists() || ArrayUtility.isEmpty(fileList = baseDir.listFiles())) continue;
            Object[] objectArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (!((File)file).isDirectory()) {
                    DynamicBean row = new DynamicBean();
                    row.setProperty(APPLIANCE_PROPERTY_NAME, appliance);
                    row.setProperty(ERROR_REPORT_NAME, file);
                    logger.finer(() -> LMG.log("(selectedAppliances): Adding downloaded error report info from %s into the table", () -> appliance.getName()));
                    this.downloadedErrorReportsTableModel.addRow(row);
                }
                ++n2;
            }
            logger.finer("(selectedAppliances): Optimizing column widths of downloaded error reports table.");
            this.downloadedErrorReportsTable.optimizeColumnWidths();
            this.downloadedErrorReportsTable.repaint();
        }
        logger.finer("(selectedAppliances): Done");
    }

    private JMPanel createMainPanel() {
        JMPanel errorReportsTablePanel = this.createErrorReportsTablePanel();
        JMPanel downloadedErrorReportsTablePanel = this.createDownloadedErrorReportsTablePanel();
        JMPanel sectionsPanel = this.createSectionsPanel();
        JMPanel panel = new JMPanel(new CellLayout(2, 2, 10, 10));
        panel.add((Component)errorReportsTablePanel, new CellLayoutConstraints(0, 0, 1, 1));
        panel.add((Component)downloadedErrorReportsTablePanel, new CellLayoutConstraints(1, 0, 1, 1));
        panel.add((Component)sectionsPanel, new CellLayoutConstraints(0, 1, 1, 2));
        return panel;
    }

    private JMPanel createErrorReportsTablePanel() {
        this.btnGenErrorReport = new JMButton(KumbaCoreUIConstants.ERROR_REPORT_ICON, "Generate error report(s) for all selected appliances.");
        new ActionEventInvoker(this.btnGenErrorReport, this, "performErrorReportProcess", "generateErrorReport", "Generate Error Reports", "Generating an error report");
        JMLabel label = new JMLabel("Error Reports On Selected Appliances:");
        label.setPreferredSize(300, 20);
        JMPanel labelPanel = new JMPanel(new BorderLayout(1, 1));
        labelPanel.add((Component)label, "Center");
        labelPanel.add((Component)this.btnGenErrorReport, "East");
        this.errorReportsTableModel = new DynamicBeanTableModel();
        this.errorReportsTableModel.addComputedExpression(APPLIANCE_PROPERTY_NAME, "name");
        this.errorReportsTableModel.addComputedExpression(ERROR_REPORT_NAME, "name");
        this.errorReportsColumnModel = new DynamicBeanColumnModel(this.errorReportsTableModel);
        DynamicBeanRowSorter rowSorter = new DynamicBeanRowSorter(this.errorReportsTableModel);
        this.errorReportsTable = new JMTable(this.errorReportsTableModel, this.errorReportsColumnModel);
        this.errorReportsTable.setAutoCreateRowSorter(false);
        this.errorReportsTable.setRowSorter(rowSorter);
        JMScrollPane errorReportScroller = new JMScrollPane(this.errorReportsTable);
        JMPanel panel = new JMPanel(new BorderLayout(1, 1));
        panel.add((Component)labelPanel, "North");
        panel.add((Component)errorReportScroller, "Center");
        return panel;
    }

    private JMPanel createDownloadedErrorReportsTablePanel() {
        this.btnDownloadErrorReport = new JMButton(KumbaCoreUIConstants.DOWNLOAD_ICON, "Download the error report(s) to your local system.");
        this.btnDownloadErrorReport.setEnabled(false);
        new ActionEventInvoker(this.btnDownloadErrorReport, this, "performErrorReportProcess", "downloadErrorReport", "Download Error Reports", "Downloading an error report");
        this.cbxRemoveFilesAfterDownload = new JMCheckBox("Remove after Download");
        this.cbxRemoveFilesAfterDownload.setToolTipText(LabelUtility.wrapInHTML("Remove the error report(s) from the appliances\nafter they are successfully downloaded."));
        JMLabel label = new JMLabel("Currently Downloaded Error Reports:");
        JMPanel labelPanel = new JMPanel(new BorderLayout(1, 1));
        labelPanel.add((Component)label, "West");
        JMPanel rightPanel = new JMPanel(new FlowLayout(2, 1, 0));
        rightPanel.add(this.btnDownloadErrorReport);
        rightPanel.add(this.cbxRemoveFilesAfterDownload);
        labelPanel.add((Component)rightPanel, "Center");
        this.downloadedErrorReportsTableModel = new DynamicBeanTableModel();
        this.downloadedErrorReportsTableModel.addComputedExpression(APPLIANCE_PROPERTY_NAME, "name");
        this.downloadedErrorReportsTableModel.addComputedExpression(ERROR_REPORT_NAME, "name");
        this.downloadedErrorReportsColumnModel = new DynamicBeanColumnModel(this.downloadedErrorReportsTableModel);
        DynamicBeanRowSorter rowSorter = new DynamicBeanRowSorter(this.downloadedErrorReportsTableModel);
        this.downloadedErrorReportsTable = new JMTable(this.downloadedErrorReportsTableModel, this.downloadedErrorReportsColumnModel);
        this.downloadedErrorReportsTable.setAutoCreateRowSorter(false);
        this.downloadedErrorReportsTable.setRowSorter(rowSorter);
        this.downloadedErrorReportsTable.addRowFocusListener(e -> this.downloadedErrorReportChanged());
        JMScrollPane errorReportScroller = new JMScrollPane(this.downloadedErrorReportsTable);
        JMPanel panel = new JMPanel(new BorderLayout(1, 1));
        panel.add((Component)labelPanel, "North");
        panel.add((Component)errorReportScroller, "Center");
        return panel;
    }

    private JMPanel createSectionsPanel() {
        this.sectionTableModel = new DynamicBeanTableModel();
        this.sectionTableModel.addComputedExpression(APPLIANCE_PROPERTY_NAME, "name");
        this.sectionTableModel.addComputedExpression(DOMAIN_PROPERTY_NAME, "name");
        this.sectionColumnModel = new DynamicBeanColumnModel(this.sectionTableModel);
        this.sectionColumnModel.setColumnOrder(APPLIANCE_PROPERTY_NAME, DOMAIN_PROPERTY_NAME, SECTION_PROPERTY_NAME);
        this.sectionColumnModel.hideColumn(SECTION_FILE_PROPERTY_NAME);
        this.sectionColumnModel.hideColumn(SOURCE_ERROR_REPORT_FILE_PROPERTY_NAME);
        DynamicBeanRowSorter sorter = new DynamicBeanRowSorter(this.sectionTableModel);
        this.sectionsTable = new JMTable(this.sectionTableModel, this.sectionColumnModel);
        this.sectionsTable.setAutoCreateRowSorter(false);
        this.sectionsTable.setRowSorter(sorter);
        JMScrollPane sectionsScroller = new JMScrollPane(this.sectionsTable);
        this.btnOpenErrorSection = new JMButton(KumbaCoreUIConstants.OPEN_ICON, "Open Selected Error Report Section");
        new ActionEventInvoker(this.btnOpenErrorSection, this, "fileOpen");
        JMPanel panel = new JMPanel(new BorderLayout(1, 1));
        JMPanel buttonPanel = new JMPanel(new BorderLayout(1, 1));
        buttonPanel.add((Component)new JMLabel("Error Report Captures"), "Center");
        buttonPanel.add((Component)this.btnOpenErrorSection, "East");
        panel.add((Component)buttonPanel, "North");
        panel.add((Component)sectionsScroller, "Center");
        return panel;
    }

    @Reflected
    private void fileSave() {
        this.performErrorReportProcess("downloadErrorReport", "Download Error Reports", "Downloading error reports");
    }

    @Reflected
    private boolean fileOpenEnabled() {
        return this.sectionsTable.getRowCount() > 0;
    }

    @Reflected
    private void fileOpen() {
        AbstractPanel.logger.finer("(): Starting");
        int[] selectedRows = this.sectionsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            AbstractPanel.logger.finer("(): Nothing selected.  Returning.");
            return;
        }
        AbstractPanel.logger.finer(() -> LMG.log("(): Number of selected error report sections: %d.", () -> selectedRows.length));
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        String errorReportsDirectoryName = applicationProperties.getErrorReportsDirectory();
        ErrorReportDialog dialog = new ErrorReportDialog((JFrame)frame, new Object[]{false});
        int[] selectedDownloadRows = this.downloadedErrorReportsTable.getSelectedRows();
        HashMap<String, Appliance> selectedAppliances = new HashMap<String, Appliance>();
        AbstractPanel.logger.finer(() -> LMG.log("(): Number of selected error reports: %d.", () -> selectedDownloadRows.length));
        int[] nArray = selectedDownloadRows;
        int n = selectedDownloadRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selectedDownloadRow = nArray[n2];
            DynamicBean selectedErrorReport = this.downloadedErrorReportsTableModel.getValue(selectedDownloadRow);
            Appliance appliance = (Appliance)selectedErrorReport.getProperty(APPLIANCE_PROPERTY_NAME);
            selectedAppliances.put(appliance.getName(), appliance);
            ++n2;
        }
        nArray = selectedRows;
        n = selectedRows.length;
        n2 = 0;
        while (n2 < n) {
            int selectedRow = nArray[n2];
            DynamicBean selectedSection = this.sectionTableModel.getValue(selectedRow);
            String sectionName = (String)selectedSection.getProperty(SECTION_PROPERTY_NAME);
            boolean isStatus = Comparison.isIn(sectionName, DPEnumerations.STATUS_ENUM);
            boolean isLog = sectionName.toLowerCase().contains("log");
            String dynamicParserClassName = String.format("%s%sParser", ERROR_REPORT_PACKAGE_NAME, sectionName);
            AbstractErrorReportParser processor = null;
            try {
                AbstractPanel.logger.finer(() -> LMG.log("(): Determining if %s is dynamically parsed.  Checking for class %s.", () -> sectionName, () -> dynamicParserClassName));
                processor = (AbstractErrorReportParser)DynamicClassLoader.createObjectFromClass(dynamicParserClassName);
            }
            catch (ClassNotFoundException | IllegalAccessException | NullPointerException e) {
                AbstractPanel.logger.finer(() -> LMG.log("(): %s is not dynamically parsed.  Class %s doesn't exist.", () -> sectionName, () -> dynamicParserClassName));
            }
            boolean isSpecial = processor != null;
            Appliance appliance = (Appliance)selectedSection.getProperty(APPLIANCE_PROPERTY_NAME);
            Domain sourceDomain = (Domain)selectedSection.getProperty(DOMAIN_PROPERTY_NAME);
            File sectionFile = (File)selectedSection.getProperty(SECTION_FILE_PROPERTY_NAME);
            File sourceErrorReportFile = (File)selectedSection.getProperty(SOURCE_ERROR_REPORT_FILE_PROPERTY_NAME);
            AbstractPanel.logger.finer(() -> LMG.log("(): Processing %s that is a %s for %s int %s.", () -> sectionName, () -> isStatus ? "status" : (isLog ? "log" : (isSpecial ? "custom" : "file")), () -> appliance.getName(), () -> sourceDomain.getName()));
            if (isStatus) {
                dialog.addStatus(appliance, sourceDomain, sectionName, sectionFile);
            } else if (isLog) {
                dialog.addLog(appliance, sourceDomain, sectionName, sectionFile);
            } else if (isSpecial) {
                dialog.addCustom(appliance, sourceDomain, sectionName, sectionFile, processor);
            } else {
                String fileURI = StringUtility.substringAfter(sourceErrorReportFile.getAbsolutePath(), errorReportsDirectoryName);
                fileURI = fileURI.substring(1);
                Object splitDelimiter = File.separator;
                if (File.separator.equals("\\")) {
                    splitDelimiter = (String)splitDelimiter + File.separator;
                }
                String[] fileIdentifiers = fileURI.split((String)splitDelimiter);
                String errorReportFileName = fileIdentifiers[1];
                String displayName = String.format("[%s]!%s", errorReportFileName, sectionFile.getName());
                dialog.addFile(appliance, sourceDomain, sectionName, sectionFile, displayName);
            }
            ++n2;
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        dialog.setVisible(true);
        dialog.dispose();
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void performErrorReportProcess(String methodName, String dialogTitle, String loggerPrefix) {
        this.setButtonState(false);
        this.openResultsDialogAndSetWaitCursor(dialogTitle);
        this.mtil = new MultiThreadInvocationListener();
        logger.finer(() -> LMG.log("(methodName=%s, dialogTitle, loggerPrefix):  %s for all selected appliances.", () -> methodName, () -> loggerPrefix));
        MethodInvoker methodInvoker = new MethodInvoker((Object)this, methodName, new Object[0]);
        methodInvoker.invoke();
        logger.finer(() -> LMG.log("(methodName=%s, dialogTitle, loggerPrefix):  Waiting for threads to Complete: %d.", () -> methodName, () -> System.currentTimeMillis()));
        ThreadManager.monitorAsynchThreadLifeCycle("Error Report Panel.performErrorReportProcess(...)", this.mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.mtil.resetThreadCount();
        this.mtil = null;
        this.waitForResultsDialogToCloseAndResetCursor();
        this.setButtonState(true);
        this.loadModels(ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection());
    }

    @Reflected
    private void generateErrorReport() {
        logger.finer("():  Starting");
        UniqueArrayList<Appliance> selectedAppliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        for (Appliance appliance : selectedAppliances) {
            logger.finer(() -> LMG.log("():  Generating error report for %s", () -> appliance.getName()));
            ActionErrorReport actionErrorReport = new ActionErrorReport();
            ActionTool actionTool = new ActionTool(appliance, (JMBean)actionErrorReport);
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
            this.mtil.addThread(actionTool.getProcessThread());
        }
        logger.finer("():  Done");
    }

    @Reflected
    private void downloadErrorReport() {
        logger.finer("():  Starting");
        int[] selectedRows = this.errorReportsTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            logger.finer("():  Aborting due to no rows selected");
            return;
        }
        boolean removeAfterDownload = this.cbxRemoveFilesAfterDownload.isSelected();
        int r = 0;
        while (r < selectedRows.length) {
            int selectedRow = selectedRows[r];
            DynamicBean row = this.errorReportsTableModel.getValue(selectedRow);
            DataPowerFileInfo dpFile = (DataPowerFileInfo)row.getProperty(ERROR_REPORT_NAME);
            logger.finer(() -> LMG.log("(): Downloading Error Report %s", () -> dpFile.getName()));
            ErrorReportDownloader downloader = new ErrorReportDownloader(dpFile, removeAfterDownload);
            this.mtil.addThread(downloader.getProcessThread());
            downloader.addManagementCommandSubscriber(this.commandResultsDialog);
            ++r;
        }
        logger.finer("():  Done");
    }

    @Reflected
    private void downloadedErrorReportChanged() {
        int[] selectedRows;
        ArrayList<DynamicBean> sectionTableRows = this.prepareSectionsTable();
        int[] nArray = selectedRows = this.downloadedErrorReportsTable.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            DynamicBean row = this.downloadedErrorReportsTableModel.getValue(r);
            Appliance appliance = (Appliance)row.getProperty(APPLIANCE_PROPERTY_NAME);
            File errorReportFile = (File)row.getProperty(ERROR_REPORT_NAME);
            this.processErrorReport(appliance, errorReportFile, sectionTableRows);
            ++n2;
        }
        this.finalizeSectionsTable(sectionTableRows);
    }

    @Reflected
    private void externalFileOpen() {
        ArrayList<DynamicBean> sectionTableRows = this.prepareSectionsTable();
        File errorReportFile = this.fileSelectorComponent.getSelectedFile();
        if (errorReportFile != null && errorReportFile.exists()) {
            this.processErrorReport(null, errorReportFile, sectionTableRows);
        }
        this.finalizeSectionsTable(sectionTableRows);
    }

    private ArrayList<DynamicBean> prepareSectionsTable() {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.sectionsTable.clearSelection();
        this.sectionTableModel.reset();
        ArrayList<DynamicBean> sectionTableRows = new ArrayList<DynamicBean>();
        return sectionTableRows;
    }

    private void processErrorReport(Appliance appliance, File errorReportFile, ArrayList<DynamicBean> sectionTableRows) {
        ErrorReportProcessor errorReportProcessor = new ErrorReportProcessor(appliance, errorReportFile);
        if (appliance == null) {
            appliance = errorReportProcessor.getAppliance();
        }
        HashMap<Pair<Domain, String>, File> sectionFileMap = errorReportProcessor.getSectionFileMap();
        ArrayList<Pair<Domain, String>> sectionKeys = new ArrayList<Pair<Domain, String>>(sectionFileMap.keySet());
        for (Pair<Domain, String> sectionKey : sectionKeys) {
            Domain domain = sectionKey.getFirst();
            String sectionName = sectionKey.getSecond();
            File sectionFile = sectionFileMap.get(sectionKey);
            DynamicBean sectionRow = new DynamicBean();
            sectionRow.setProperty(APPLIANCE_PROPERTY_NAME, appliance);
            sectionRow.setProperty(DOMAIN_PROPERTY_NAME, domain);
            sectionRow.setProperty(SECTION_PROPERTY_NAME, sectionName);
            sectionRow.setProperty(SECTION_FILE_PROPERTY_NAME, sectionFile);
            sectionRow.setProperty(SOURCE_ERROR_REPORT_FILE_PROPERTY_NAME, errorReportFile);
            sectionTableRows.add(sectionRow);
        }
    }

    private void finalizeSectionsTable(ArrayList<DynamicBean> sectionTableRows) {
        BeanComparator comparator = new BeanComparator(SECTION_SORT_PROPERTIES);
        Collections.sort(sectionTableRows, comparator);
        this.sectionTableModel.addAll(sectionTableRows);
        this.sectionsTable.optimizeColumnWidths();
        this.sectionsTable.repaint();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    private void setButtonState(boolean state) {
        String loggerPrefix = String.format("(state=%b): ", state);
        logger.finer(() -> LMG.log("%sStarting", () -> loggerPrefix));
        this.btnDownloadErrorReport.setEnabled(state);
        if (!state) {
            this.btnDownloadErrorReport.setEnabled(state);
        }
        logger.finer(() -> LMG.log("%sDone", () -> loggerPrefix));
    }
}

