/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.troubleshooting;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.util.Index;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.DataPowerSSHClient;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Vector;

public class TestPasswordMapPanel
extends AbstractPanel {
    private ListComboBox cbxPassMapAliases = new ListComboBox();
    private Index<String, StatusObjectStatus> passMapAliases;
    private String selectedPasswordMap;
    private JMRadioButton rbCert;
    private JMRadioButton rbKey;
    private ListComboBox cbxCryptoFiles;
    private Index<String, DataPowerFileInfo> dataPowerFiles;
    private DataPowerFileInfo selectedFile;
    private JMButton btnTestPasswordMap;
    private String cliCommand;
    private String commandDescription;

    public TestPasswordMapPanel() {
        super(new VerticalFlowLayout(0));
        LabeledComponent passMapAliases = new LabeledComponent("Alias:", (Component)this.cbxPassMapAliases, 70, 300);
        this.rbCert = new JMRadioButton("Certificate");
        this.rbCert.setPreferredSize(new Dimension(125, 25));
        this.rbKey = new JMRadioButton("Key", true);
        this.rbKey.setPreferredSize(new Dimension(125, 25));
        new JMButtonGroup(this.rbCert, this.rbKey);
        JMPanel panel = new JMPanel(new FlowLayout(0));
        panel.addAll(this.rbCert, this.rbKey);
        LabeledComponent fileType = new LabeledComponent("File Type:", (Component)panel, 70, 300);
        this.cbxCryptoFiles = new ListComboBox();
        LabeledComponent cryptoFiles = new LabeledComponent("Files:", (Component)this.cbxCryptoFiles, 70, 300);
        this.btnTestPasswordMap = ComponentFactory.createButton(null, "Test Password Map", "Test the Password Map Configuration", true, this, "testPasswordMap", new Object[0]);
        Component spacer1 = ComponentFactory.createSpacer(10, 30);
        this.addAll(passMapAliases, fileType, cryptoFiles, spacer1, this.btnTestPasswordMap);
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    @Reflected
    private void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.cbxPassMapAliases.clearListModel();
        if (this.passMapAliases != null) {
            this.passMapAliases.clear();
        } else {
            this.passMapAliases = new Index();
        }
        this.cbxCryptoFiles.clearListModel();
        if (this.dataPowerFiles != null) {
            this.dataPowerFiles.clear();
        } else {
            this.dataPowerFiles = new Index();
        }
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ListFiles.list(selectedDomains, CollectionUtility.createListFrom("cert:"), ".*", mtil);
        ListFiles.addConfigObjectSubscriber(fileCache);
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> passMaps = configurationManager.listObjects(selectedDomains, "PasswordAlias", ".*");
        UniqueArrayList<String> passMapNames = new UniqueArrayList<String>();
        for (StatusObjectStatus passMap : passMaps) {
            passMapNames.add(passMap.getName());
            this.passMapAliases.put(passMap.getName(), passMap);
        }
        passMapNames.sort();
        for (String passMapName : passMapNames) {
            this.cbxPassMapAliases.addItem(passMapName);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("TestPasswordMapPanel.domainsChanged(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        while (!fileCache.isComplete()) {
            AbstractPanel.logger.info("(...): The file cache isn't complete even after waiting on threads to complete.");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        Vector<DataPowerFileInfo> files = fileCache.getObjectCache();
        UniqueArrayList<String> dpFileNames = new UniqueArrayList<String>();
        for (DataPowerFileInfo file : files) {
            if (file == null) continue;
            String fileName = file.getFileName();
            dpFileNames.add(fileName);
            this.dataPowerFiles.put(fileName, file);
        }
        dpFileNames.sort();
        for (String dpFileName : dpFileNames) {
            this.cbxCryptoFiles.addItem(dpFileName);
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void testPasswordMap() {
        this.selectedPasswordMap = (String)this.cbxPassMapAliases.getSelectedValue();
        String fileName = (String)this.cbxCryptoFiles.getSelectedValue();
        ArrayList selectedFiles = (ArrayList)this.dataPowerFiles.get(fileName);
        if (CollectionUtility.isEmpty(selectedFiles)) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Test Password Map");
        this.selectedFile = (DataPowerFileInfo)selectedFiles.get(0);
        String type = this.rbCert.isSelected() ? "cert" : "key";
        String typeDescription = this.rbCert.isSelected() ? "Certificate" : "Key";
        this.commandDescription = String.format("Test Password Map %s with %s in file %s", this.selectedPasswordMap, typeDescription, this.selectedFile.getFileName());
        this.cliCommand = String.format("test password-map %s %s %s\n", this.selectedPasswordMap, type, this.selectedFile.getFileName());
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "testPasswordMap", false);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void testPasswordMap(Appliance appliance, Domain domain) {
        DataPowerSSHClient dpSSHClient = new DataPowerSSHClient(appliance);
        if (!dpSSHClient.connect()) {
            logger.severe(() -> LMG.log("(appliance=%s, Domain=%s):  Error Connecting to SSH", () -> appliance.getName(), () -> domain.getName()));
            this.showMessage("Error Connecting to the " + appliance.getName(), "The connection to the appliance via SSH could not be made.  Check the credientials for your appliance.");
            return;
        }
        try {
            dpSSHClient.sendToDataPower(String.format("switch domain %s\n", domain.getName()));
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("co\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("crypto\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower(this.cliCommand);
            String actualResponse = dpSSHClient.waitFor("(Password-map is empty.*|Alias.+?with file.+?(OK|FAIL))");
            if (actualResponse.contains("empty")) {
                String errorMessage = String.format("Password Map %s is invalid or mis-configured", this.selectedPasswordMap);
                ManagementCommandError error = new ManagementCommandError(appliance, domain, this.commandDescription, null, errorMessage);
                this.commandResultsDialog.commandFailed(error);
            } else if (actualResponse.contains("FAIL")) {
                String errorMessage = String.format("Password Map %s Failed", this.selectedPasswordMap);
                ManagementCommandError error = new ManagementCommandError(appliance, domain, this.commandDescription, null, errorMessage);
                this.commandResultsDialog.commandFailed(error);
            } else {
                String successMessage = String.format("Password Map %s Succeeded", this.selectedPasswordMap);
                ManagementCommandStatus result = new ManagementCommandStatus(appliance, domain, this.commandDescription, null, successMessage);
                this.commandResultsDialog.commandSucceeded(result);
            }
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("exit\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("exit\n");
            dpSSHClient.waitForPrompt();
            dpSSHClient.sendToDataPower("exit\n");
            dpSSHClient.waitFor("Goodbye.");
            dpSSHClient.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }
}

